/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.Inet4AddressImpl;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetAddressImpl;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;

class Inet6AddressImpl
implements InetAddressImpl {
    private InetAddress anyLocalAddress;
    private InetAddress loopbackAddress;

    Inet6AddressImpl() {
    }

    @Override
    public native String getLocalHostName() throws UnknownHostException;

    @Override
    public native InetAddress[] lookupAllHostAddr(String var1) throws UnknownHostException;

    @Override
    public native String getHostByAddr(byte[] var1) throws UnknownHostException;

    private native boolean isReachable0(byte[] var1, int var2, int var3, byte[] var4, int var5, int var6) throws IOException;

    @Override
    public boolean isReachable(InetAddress addr, int timeout, NetworkInterface netif, int ttl) throws IOException {
        byte[] ifaddr = null;
        int scope = -1;
        int netif_scope = -1;
        if (netif != null) {
            Enumeration<InetAddress> it = netif.getInetAddresses();
            InetAddress inetaddr = null;
            while (it.hasMoreElements()) {
                inetaddr = it.nextElement();
                if (!inetaddr.getClass().isInstance(addr)) continue;
                ifaddr = inetaddr.getAddress();
                if (!(inetaddr instanceof Inet6Address)) break;
                netif_scope = ((Inet6Address)inetaddr).getScopeId();
                break;
            }
            if (ifaddr == null) {
                return false;
            }
        }
        if (addr instanceof Inet6Address) {
            scope = ((Inet6Address)addr).getScopeId();
        }
        return this.isReachable0(addr.getAddress(), scope, timeout, ifaddr, ttl, netif_scope);
    }

    @Override
    public synchronized InetAddress anyLocalAddress() {
        if (this.anyLocalAddress == null) {
            if (InetAddress.preferIPv6Address) {
                this.anyLocalAddress = new Inet6Address();
                this.anyLocalAddress.hostName = "::";
            } else {
                this.anyLocalAddress = new Inet4AddressImpl().anyLocalAddress();
            }
        }
        return this.anyLocalAddress;
    }

    @Override
    public synchronized InetAddress loopbackAddress() {
        if (this.loopbackAddress == null) {
            if (InetAddress.preferIPv6Address) {
                byte[] loopback = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
                this.loopbackAddress = new Inet6Address("localhost", loopback);
            } else {
                this.loopbackAddress = new Inet4AddressImpl().loopbackAddress();
            }
        }
        return this.loopbackAddress;
    }
}

