/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import sun.misc.ProxyGenerator;

public class Proxy
implements Serializable {
    private static final long serialVersionUID = -2222568056686623797L;
    private static final String proxyClassNamePrefix = "$Proxy";
    private static final Class[] constructorParams = new Class[]{InvocationHandler.class};
    private static Map<ClassLoader, Map<List<String>, Object>> loaderToCache = new WeakHashMap<ClassLoader, Map<List<String>, Object>>();
    private static Object pendingGenerationMarker = new Object();
    private static long nextUniqueNumber = 0L;
    private static Object nextUniqueNumberLock = new Object();
    private static Map<Class<?>, Void> proxyClasses = Collections.synchronizedMap(new WeakHashMap());
    protected InvocationHandler h;

    private Proxy() {
    }

    protected Proxy(InvocationHandler h) {
        this.h = h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class<?> getProxyClass(ClassLoader loader, Class<?> ... interfaces) throws IllegalArgumentException {
        Map<List<String>, Object> cache;
        Map<List<String>, Object> interfaceClass;
        if (interfaces.length > 65535) {
            throw new IllegalArgumentException("interface limit exceeded");
        }
        Class proxyClass = null;
        String[] interfaceNames = new String[interfaces.length];
        HashSet<Map<List<String>, Object>> interfaceSet = new HashSet<Map<List<String>, Object>>();
        for (int i = 0; i < interfaces.length; ++i) {
            String interfaceName = interfaces[i].getName();
            interfaceClass = null;
            try {
                interfaceClass = Class.forName(interfaceName, false, loader);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            if (interfaceClass != interfaces[i]) {
                throw new IllegalArgumentException(interfaces[i] + " is not visible from class loader");
            }
            if (!((Class)((Object)interfaceClass)).isInterface()) {
                throw new IllegalArgumentException(((Class)((Object)interfaceClass)).getName() + " is not an interface");
            }
            if (interfaceSet.contains(interfaceClass)) {
                throw new IllegalArgumentException("repeated interface: " + ((Class)((Object)interfaceClass)).getName());
            }
            interfaceSet.add(interfaceClass);
            interfaceNames[i] = interfaceName;
        }
        List<String> key = Arrays.asList(interfaceNames);
        interfaceClass = loaderToCache;
        synchronized (interfaceClass) {
            cache = loaderToCache.get(loader);
            if (cache == null) {
                cache = new HashMap<List<String>, Object>();
                loaderToCache.put(loader, cache);
            }
        }
        interfaceClass = cache;
        synchronized (interfaceClass) {
            while (true) {
                Object value;
                if ((value = cache.get(key)) instanceof Reference) {
                    proxyClass = (Class)((Reference)value).get();
                }
                if (proxyClass != null) {
                    return proxyClass;
                }
                if (value != pendingGenerationMarker) break;
                try {
                    cache.wait();
                }
                catch (InterruptedException e) {}
            }
            cache.put(key, pendingGenerationMarker);
        }
        try {
            long num;
            Object name;
            String proxyPkg = null;
            for (int i = 0; i < interfaces.length; ++i) {
                String pkg;
                int flags = interfaces[i].getModifiers();
                if (Modifier.isPublic(flags)) continue;
                name = interfaces[i].getName();
                int n = ((String)name).lastIndexOf(46);
                String string = pkg = n == -1 ? "" : ((String)name).substring(0, n + 1);
                if (proxyPkg == null) {
                    proxyPkg = pkg;
                    continue;
                }
                if (pkg.equals(proxyPkg)) continue;
                throw new IllegalArgumentException("non-public interfaces from different packages");
            }
            if (proxyPkg == null) {
                proxyPkg = "";
            }
            name = nextUniqueNumberLock;
            synchronized (name) {
                num = nextUniqueNumber++;
            }
            String proxyName = proxyPkg + proxyClassNamePrefix + num;
            byte[] proxyClassFile = ProxyGenerator.generateProxyClass(proxyName, interfaces);
            try {
                proxyClass = Proxy.defineClass0(loader, proxyName, proxyClassFile, 0, proxyClassFile.length);
            }
            catch (ClassFormatError e) {
                throw new IllegalArgumentException(e.toString());
            }
            proxyClasses.put(proxyClass, null);
        }
        finally {
            Map<List<String>, Object> map = cache;
            synchronized (map) {
                if (proxyClass != null) {
                    cache.put(key, new WeakReference<Class>(proxyClass));
                } else {
                    cache.remove(key);
                }
                cache.notifyAll();
            }
        }
        return proxyClass;
    }

    public static Object newProxyInstance(ClassLoader loader, Class<?>[] interfaces, InvocationHandler h) throws IllegalArgumentException {
        if (h == null) {
            throw new NullPointerException();
        }
        Class<?> cl = Proxy.getProxyClass(loader, interfaces);
        try {
            Constructor<?> cons = cl.getConstructor(constructorParams);
            return cons.newInstance(h);
        }
        catch (NoSuchMethodException e) {
            throw new InternalError(e.toString());
        }
        catch (IllegalAccessException e) {
            throw new InternalError(e.toString());
        }
        catch (InstantiationException e) {
            throw new InternalError(e.toString());
        }
        catch (InvocationTargetException e) {
            throw new InternalError(e.toString());
        }
    }

    public static boolean isProxyClass(Class<?> cl) {
        if (cl == null) {
            throw new NullPointerException();
        }
        return proxyClasses.containsKey(cl);
    }

    public static InvocationHandler getInvocationHandler(Object proxy) throws IllegalArgumentException {
        if (!Proxy.isProxyClass(proxy.getClass())) {
            throw new IllegalArgumentException("not a proxy instance");
        }
        Proxy p = (Proxy)proxy;
        return p.h;
    }

    private static native Class defineClass0(ClassLoader var0, String var1, byte[] var2, int var3, int var4);
}

