/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.AdapterMethodHandle;
import java.lang.invoke.BoundMethodHandle;
import java.lang.invoke.CallSite;
import java.lang.invoke.DirectMethodHandle;
import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.sql.DriverManager;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import sun.misc.Unsafe;
import sun.reflect.Reflection;

class MethodHandleNatives {
    static final int JVM_PUSH_LIMIT;
    static final int JVM_STACK_MOVE_UNIT;
    static final int CONV_OP_IMPLEMENTED_MASK;
    static final boolean HAVE_RICOCHET_FRAMES;
    static final int OP_ROT_ARGS_DOWN_LIMIT_BIAS;
    static final boolean COUNT_GWT;

    private MethodHandleNatives() {
    }

    static native void init(MemberName var0, Object var1);

    static native void expand(MemberName var0);

    static native void resolve(MemberName var0, Class<?> var1);

    static native int getMembers(Class<?> var0, String var1, String var2, int var3, Class<?> var4, int var5, MemberName[] var6);

    static native void init(AdapterMethodHandle var0, MethodHandle var1, int var2);

    static native void init(BoundMethodHandle var0, Object var1, int var2);

    static native void init(DirectMethodHandle var0, Object var1, boolean var2, Class<?> var3);

    static native void init(MethodType var0);

    static native Object getTarget(MethodHandle var0, int var1);

    static MemberName getMethodName(MethodHandle self) {
        return (MemberName)MethodHandleNatives.getTarget(self, 2);
    }

    static AccessibleObject getTargetMethod(MethodHandle self) {
        return (AccessibleObject)MethodHandleNatives.getTarget(self, 3);
    }

    static Object getTargetInfo(MethodHandle self) {
        return MethodHandleNatives.getTarget(self, 0);
    }

    static Object[] makeTarget(Class<?> defc, String name, String sig, int mods, Class<?> refc) {
        return new Object[]{defc, name, sig, mods, refc};
    }

    static native int getConstant(int var0);

    static native void setCallSiteTargetNormal(CallSite var0, MethodHandle var1);

    static native void setCallSiteTargetVolatile(CallSite var0, MethodHandle var1);

    private static native void registerNatives();

    private static native int getNamedCon(int var0, Object[] var1);

    static boolean verifyConstants() {
        Object[] box = new Object[]{null};
        int i = 0;
        while (true) {
            block6: {
                box[0] = null;
                int vmval = MethodHandleNatives.getNamedCon(i, box);
                if (box[0] == null) break;
                String name = (String)box[0];
                try {
                    Field con = Constants.class.getDeclaredField(name);
                    int jval = con.getInt(null);
                    if (jval == vmval) break block6;
                    String err = name + ": JVM has " + vmval + " while Java has " + jval;
                    if (name.equals("CONV_OP_LIMIT")) {
                        System.err.println("warning: " + err);
                        break block6;
                    }
                    throw new InternalError(err);
                }
                catch (Exception ex) {
                    if (ex instanceof NoSuchFieldException) {
                        String err = name + ": JVM has " + vmval + " which Java does not define";
                        if (name.startsWith("OP_") || name.startsWith("GC_")) {
                            System.err.println("warning: " + err);
                        }
                    }
                    throw new InternalError(name + ": access failed, got " + ex);
                }
            }
            ++i;
        }
        return true;
    }

    static CallSite makeDynamicCallSite(MethodHandle bootstrapMethod, String name, MethodType type, Object info, MemberName callerMethod, int callerBCI) {
        return CallSite.makeSite(bootstrapMethod, name, type, info, callerMethod, callerBCI);
    }

    static void checkSpreadArgument(Object av, int n) {
        MethodHandleStatics.checkSpreadArgument(av, n);
    }

    static MethodType findMethodHandleType(Class<?> rtype, Class<?>[] ptypes) {
        return MethodType.makeImpl(rtype, ptypes, true);
    }

    static void notifyGenericMethodType(MethodType type) {
        type.form().notifyGenericMethodType();
    }

    static void raiseException(int code, Object actual, Object required) {
        String message = null;
        switch (code) {
            case 190: {
                try {
                    String reqLength = "";
                    if (required instanceof AdapterMethodHandle) {
                        int conv = ((AdapterMethodHandle)((Object)required)).getConversion();
                        int spChange = AdapterMethodHandle.extractStackMove(conv);
                        reqLength = " of length " + (spChange + 1);
                    }
                    int actualLength = actual == null ? 0 : Array.getLength(actual);
                    message = "required array" + reqLength + ", but encountered wrong length " + actualLength;
                }
                catch (IllegalArgumentException ex) {
                    required = Object[].class;
                    code = 192;
                }
                break;
            }
            case 191: {
                if (required != BootstrapMethodError.class) break;
                throw new BootstrapMethodError((Throwable)((Object)actual));
            }
        }
        if (message == null) {
            if (!(actual instanceof Class) && !(actual instanceof MethodType)) {
                actual = actual.getClass();
            }
            message = actual != null ? "required " + required + " but encountered " + actual : "required " + required;
        }
        switch (code) {
            case 190: {
                throw new ArrayIndexOutOfBoundsException(message);
            }
            case 50: {
                throw new ClassCastException(message);
            }
            case 192: {
                throw new ClassCastException(message);
            }
        }
        throw new InternalError("unexpected code " + code + ": " + message);
    }

    static MethodHandle linkMethodHandleConstant(Class<?> callerClass, int refKind, Class<?> defc, String name, Object type) {
        try {
            MethodHandles.Lookup lookup = MethodHandles.Lookup.IMPL_LOOKUP.in(callerClass);
            return lookup.linkMethodHandleConstant(refKind, defc, name, type);
        }
        catch (ReflectiveOperationException ex) {
            IncompatibleClassChangeError err = new IncompatibleClassChangeError();
            err.initCause(ex);
            throw err;
        }
    }

    static boolean workaroundWithoutRicochetFrames() {
        assert (!HAVE_RICOCHET_FRAMES) : "this code should not be executed if `-XX:+UseRicochetFrames is enabled";
        return true;
    }

    static boolean isCallerSensitive(MemberName mem) {
        assert (mem.isInvocable());
        Class<?> defc = mem.getDeclaringClass();
        switch (mem.getName()) {
            case "doPrivileged": {
                return defc == AccessController.class;
            }
            case "getUnsafe": {
                return defc == Unsafe.class;
            }
            case "lookup": {
                return defc == MethodHandles.class;
            }
            case "invoke": {
                return defc == Method.class;
            }
            case "get": 
            case "getBoolean": 
            case "getByte": 
            case "getChar": 
            case "getShort": 
            case "getInt": 
            case "getLong": 
            case "getFloat": 
            case "getDouble": 
            case "set": 
            case "setBoolean": 
            case "setByte": 
            case "setChar": 
            case "setShort": 
            case "setInt": 
            case "setLong": 
            case "setFloat": 
            case "setDouble": {
                return defc == Field.class;
            }
            case "newInstance": {
                if (defc == Constructor.class) {
                    return true;
                }
                if (defc != Class.class) break;
                return true;
            }
            case "forName": 
            case "getClassLoader": 
            case "getClasses": 
            case "getFields": 
            case "getMethods": 
            case "getConstructors": 
            case "getDeclaredClasses": 
            case "getDeclaredFields": 
            case "getDeclaredMethods": 
            case "getDeclaredConstructors": 
            case "getField": 
            case "getMethod": 
            case "getConstructor": 
            case "getDeclaredField": 
            case "getDeclaredMethod": 
            case "getDeclaredConstructor": {
                return defc == Class.class;
            }
            case "getConnection": 
            case "getDriver": 
            case "getDrivers": 
            case "deregisterDriver": {
                return defc == DriverManager.class;
            }
            case "newUpdater": {
                if (defc == AtomicIntegerFieldUpdater.class) {
                    return true;
                }
                if (defc == AtomicLongFieldUpdater.class) {
                    return true;
                }
                if (defc != AtomicReferenceFieldUpdater.class) break;
                return true;
            }
            case "getContextClassLoader": {
                return defc == Thread.class;
            }
            case "getPackage": 
            case "getPackages": {
                return defc == Package.class;
            }
            case "getParent": 
            case "getSystemClassLoader": {
                return defc == ClassLoader.class;
            }
            case "load": 
            case "loadLibrary": {
                if (defc == Runtime.class) {
                    return true;
                }
                if (defc != System.class) break;
                return true;
            }
            case "getCallerClass": {
                if (defc == Reflection.class) {
                    return true;
                }
                if (defc != System.class) break;
                return true;
            }
            case "getCallerClassLoader": {
                return defc == ClassLoader.class;
            }
            case "getProxyClass": 
            case "newProxyInstance": {
                return defc == Proxy.class;
            }
            case "getBundle": 
            case "clearCache": {
                return defc == ResourceBundle.class;
            }
        }
        return false;
    }

    static {
        MethodHandleNatives.registerNatives();
        JVM_PUSH_LIMIT = MethodHandleNatives.getConstant(0);
        JVM_STACK_MOVE_UNIT = MethodHandleNatives.getConstant(1);
        int k = MethodHandleNatives.getConstant(2);
        CONV_OP_IMPLEMENTED_MASK = k != 0 ? k : 991;
        k = MethodHandleNatives.getConstant(3);
        OP_ROT_ARGS_DOWN_LIMIT_BIAS = k != 0 ? (int)k : -1;
        HAVE_RICOCHET_FRAMES = (CONV_OP_IMPLEMENTED_MASK & 0x400) != 0;
        boolean bl = COUNT_GWT = MethodHandleNatives.getConstant(4) != 0;
        assert (MethodHandleNatives.verifyConstants());
    }

    static class Constants {
        static final int GC_JVM_PUSH_LIMIT = 0;
        static final int GC_JVM_STACK_MOVE_UNIT = 1;
        static final int GC_CONV_OP_IMPLEMENTED_MASK = 2;
        static final int GC_OP_ROT_ARGS_DOWN_LIMIT_BIAS = 3;
        static final int GC_COUNT_GWT = 4;
        static final int ETF_HANDLE_OR_METHOD_NAME = 0;
        static final int ETF_DIRECT_HANDLE = 1;
        static final int ETF_METHOD_NAME = 2;
        static final int ETF_REFLECT_METHOD = 3;
        static final int MN_IS_METHOD = 65536;
        static final int MN_IS_CONSTRUCTOR = 131072;
        static final int MN_IS_FIELD = 262144;
        static final int MN_IS_TYPE = 524288;
        static final int MN_SEARCH_SUPERCLASSES = 0x100000;
        static final int MN_SEARCH_INTERFACES = 0x200000;
        static final int VM_INDEX_UNINITIALIZED = -99;
        static final int ARG_SLOT_PUSH_SHIFT = 16;
        static final int ARG_SLOT_MASK = 65535;
        static final int OP_RETYPE_ONLY = 0;
        static final int OP_RETYPE_RAW = 1;
        static final int OP_CHECK_CAST = 2;
        static final int OP_PRIM_TO_PRIM = 3;
        static final int OP_REF_TO_PRIM = 4;
        static final int OP_PRIM_TO_REF = 5;
        static final int OP_SWAP_ARGS = 6;
        static final int OP_ROT_ARGS = 7;
        static final int OP_DUP_ARGS = 8;
        static final int OP_DROP_ARGS = 9;
        static final int OP_COLLECT_ARGS = 10;
        static final int OP_SPREAD_ARGS = 11;
        static final int OP_FOLD_ARGS = 12;
        static final int CONV_OP_LIMIT = 14;
        static final int CONV_OP_MASK = 3840;
        static final int CONV_TYPE_MASK = 15;
        static final int CONV_VMINFO_MASK = 255;
        static final int CONV_VMINFO_SHIFT = 0;
        static final int CONV_OP_SHIFT = 8;
        static final int CONV_DEST_TYPE_SHIFT = 12;
        static final int CONV_SRC_TYPE_SHIFT = 16;
        static final int CONV_STACK_MOVE_SHIFT = 20;
        static final int CONV_STACK_MOVE_MASK = 4095;
        static final int DEFAULT_CONV_OP_IMPLEMENTED_MASK = 991;
        static final int T_BOOLEAN = 4;
        static final int T_CHAR = 5;
        static final int T_FLOAT = 6;
        static final int T_DOUBLE = 7;
        static final int T_BYTE = 8;
        static final int T_SHORT = 9;
        static final int T_INT = 10;
        static final int T_LONG = 11;
        static final int T_OBJECT = 12;
        static final int T_VOID = 14;
        static final int T_ILLEGAL = 99;
        static final int REF_getField = 1;
        static final int REF_getStatic = 2;
        static final int REF_putField = 3;
        static final int REF_putStatic = 4;
        static final int REF_invokeVirtual = 5;
        static final int REF_invokeStatic = 6;
        static final int REF_invokeSpecial = 7;
        static final int REF_newInvokeSpecial = 8;
        static final int REF_invokeInterface = 9;

        Constants() {
        }
    }
}

