/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.MethodHandleNatives;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import sun.invoke.util.BytecodeDescriptor;

final class MemberName
implements Member,
Cloneable {
    private Class<?> clazz;
    private String name;
    private Object type;
    private int flags;
    private Object vmtarget;
    private int vmindex = -99;
    static final int BRIDGE = 64;
    static final int VARARGS = 128;
    static final int SYNTHETIC = 4096;
    static final int ANNOTATION = 8192;
    static final int ENUM = 16384;
    static final String CONSTRUCTOR_NAME = "<init>";
    static final int RECOGNIZED_MODIFIERS = 65535;
    static final int IS_METHOD = 65536;
    static final int IS_CONSTRUCTOR = 131072;
    static final int IS_FIELD = 262144;
    static final int IS_TYPE = 524288;
    static final int SEARCH_SUPERCLASSES = 0x100000;
    static final int SEARCH_INTERFACES = 0x200000;
    static final int ALL_ACCESS = 7;
    static final int ALL_KINDS = 983040;
    static final int IS_INVOCABLE = 196608;
    static final int IS_FIELD_OR_METHOD = 327680;
    static final int SEARCH_ALL_SUPERS = 0x300000;

    @Override
    public Class<?> getDeclaringClass() {
        if (this.clazz == null && this.isResolved()) {
            this.expandFromVM();
        }
        return this.clazz;
    }

    public ClassLoader getClassLoader() {
        return this.clazz.getClassLoader();
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.expandFromVM();
            if (this.name == null) {
                return null;
            }
        }
        return this.name;
    }

    public MethodType getMethodType() {
        if (this.type == null) {
            this.expandFromVM();
            if (this.type == null) {
                return null;
            }
        }
        if (!this.isInvocable()) {
            throw MethodHandleStatics.newIllegalArgumentException("not invocable, no method type");
        }
        if (this.type instanceof MethodType) {
            return (MethodType)this.type;
        }
        if (this.type instanceof String) {
            String sig = (String)this.type;
            MethodType res = MethodType.fromMethodDescriptorString(sig, this.getClassLoader());
            this.type = res;
            return res;
        }
        if (this.type instanceof Object[]) {
            Object[] typeInfo = (Object[])this.type;
            Class[] ptypes = (Class[])typeInfo[1];
            Class rtype = (Class)typeInfo[0];
            MethodType res = MethodType.methodType(rtype, ptypes);
            this.type = res;
            return res;
        }
        throw new InternalError("bad method type " + this.type);
    }

    public MethodType getInvocationType() {
        MethodType itype = this.getMethodType();
        if (!this.isStatic()) {
            itype = itype.insertParameterTypes(0, this.clazz);
        }
        return itype;
    }

    public Class<?>[] getParameterTypes() {
        return this.getMethodType().parameterArray();
    }

    public Class<?> getReturnType() {
        return this.getMethodType().returnType();
    }

    public Class<?> getFieldType() {
        if (this.type == null) {
            this.expandFromVM();
            if (this.type == null) {
                return null;
            }
        }
        if (this.isInvocable()) {
            throw MethodHandleStatics.newIllegalArgumentException("not a field or nested class, no simple type");
        }
        if (this.type instanceof Class) {
            return (Class)this.type;
        }
        if (this.type instanceof String) {
            Class<?> res;
            String sig = (String)this.type;
            MethodType mtype = MethodType.fromMethodDescriptorString("()" + sig, this.getClassLoader());
            this.type = res = mtype.returnType();
            return res;
        }
        throw new InternalError("bad field type " + this.type);
    }

    public Object getType() {
        return this.isInvocable() ? this.getMethodType() : this.getFieldType();
    }

    public String getSignature() {
        if (this.type == null) {
            this.expandFromVM();
            if (this.type == null) {
                return null;
            }
        }
        if (this.type instanceof String) {
            return (String)this.type;
        }
        if (this.isInvocable()) {
            return BytecodeDescriptor.unparse(this.getMethodType());
        }
        return BytecodeDescriptor.unparse(this.getFieldType());
    }

    @Override
    public int getModifiers() {
        return this.flags & 0xFFFF;
    }

    private void setFlags(int flags) {
        this.flags = flags;
        assert (this.testAnyFlags(983040));
    }

    private boolean testFlags(int mask, int value) {
        return (this.flags & mask) == value;
    }

    private boolean testAllFlags(int mask) {
        return this.testFlags(mask, mask);
    }

    private boolean testAnyFlags(int mask) {
        return !this.testFlags(mask, 0);
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.flags);
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.flags);
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.flags);
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.flags);
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.flags);
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.flags);
    }

    public boolean isBridge() {
        return this.testAllFlags(65600);
    }

    public boolean isVarargs() {
        return this.testAllFlags(128) && this.isInvocable();
    }

    @Override
    public boolean isSynthetic() {
        return this.testAllFlags(4096);
    }

    public boolean isInvocable() {
        return this.testAnyFlags(196608);
    }

    public boolean isFieldOrMethod() {
        return this.testAnyFlags(327680);
    }

    public boolean isMethod() {
        return this.testAllFlags(65536);
    }

    public boolean isConstructor() {
        return this.testAllFlags(131072);
    }

    public boolean isField() {
        return this.testAllFlags(262144);
    }

    public boolean isType() {
        return this.testAllFlags(524288);
    }

    public boolean isPackage() {
        return !this.testAnyFlags(7);
    }

    private void init(Class<?> defClass, String name, Object type, int flags) {
        this.clazz = defClass;
        this.name = name;
        this.type = type;
        this.setFlags(flags);
        assert (!this.isResolved());
    }

    private void expandFromVM() {
        if (!this.isResolved()) {
            return;
        }
        if (this.type instanceof Object[]) {
            this.type = null;
        }
        MethodHandleNatives.expand(this);
    }

    private static int flagsMods(int flags, int mods) {
        assert ((flags & 0xFFFF) == 0);
        assert ((mods & 0xFFFF0000) == 0);
        return flags | mods;
    }

    public MemberName(Method m) {
        Object[] typeInfo = new Object[]{m.getReturnType(), m.getParameterTypes()};
        this.init(m.getDeclaringClass(), m.getName(), typeInfo, MemberName.flagsMods(65536, m.getModifiers()));
        MethodHandleNatives.init(this, m);
        assert (this.isResolved());
    }

    public MemberName(Constructor ctor) {
        Object[] typeInfo = new Object[]{Void.TYPE, ctor.getParameterTypes()};
        this.init(ctor.getDeclaringClass(), CONSTRUCTOR_NAME, typeInfo, MemberName.flagsMods(131072, ctor.getModifiers()));
        MethodHandleNatives.init(this, ctor);
        assert (this.isResolved());
    }

    public MemberName(Field fld) {
        this.init(fld.getDeclaringClass(), fld.getName(), fld.getType(), MemberName.flagsMods(262144, fld.getModifiers()));
        MethodHandleNatives.init(this, fld);
        assert (this.isResolved());
    }

    public MemberName(Class<?> type) {
        this.init(type.getDeclaringClass(), type.getSimpleName(), type, MemberName.flagsMods(524288, type.getModifiers()));
        this.vmindex = 0;
        assert (this.isResolved());
    }

    MemberName() {
    }

    protected MemberName clone() {
        try {
            return (MemberName)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    public MemberName(Class<?> defClass, String name, Class<?> type, int modifiers) {
        this.init(defClass, name, type, 0x40000 | modifiers & 0xFFFF);
    }

    public MemberName(Class<?> defClass, String name, Class<?> type) {
        this(defClass, name, type, 0);
    }

    public MemberName(Class<?> defClass, String name, MethodType type, int modifiers) {
        int flagBit = name.equals(CONSTRUCTOR_NAME) ? 131072 : 65536;
        this.init(defClass, name, type, flagBit | modifiers & 0xFFFF);
    }

    public MemberName(Class<?> defClass, String name, MethodType type) {
        this(defClass, name, type, 0);
    }

    public boolean isResolved() {
        return this.vmindex != -99;
    }

    public boolean hasReceiverTypeDispatch() {
        return this.isMethod() && this.getVMIndex() >= 0;
    }

    public String toString() {
        String name;
        if (this.isType()) {
            return this.type.toString();
        }
        StringBuilder buf = new StringBuilder();
        if (this.getDeclaringClass() != null) {
            buf.append(MemberName.getName(this.clazz));
            buf.append('.');
        }
        buf.append((name = this.getName()) == null ? "*" : name);
        Object type = this.getType();
        if (!this.isInvocable()) {
            buf.append('/');
            buf.append(type == null ? "*" : MemberName.getName(type));
        } else {
            buf.append(type == null ? "(*)*" : MemberName.getName(type));
        }
        return buf.toString();
    }

    private static String getName(Object obj) {
        if (obj instanceof Class) {
            return ((Class)obj).getName();
        }
        return String.valueOf(obj);
    }

    int getVMIndex() {
        if (!this.isResolved()) {
            throw MethodHandleStatics.newIllegalStateException("not resolved", this);
        }
        return this.vmindex;
    }

    public IllegalAccessException makeAccessException(String message, Object from) {
        message = message + ": " + this.toString();
        if (from != null) {
            message = message + ", from " + from;
        }
        return new IllegalAccessException(message);
    }

    private String message() {
        if (this.isResolved()) {
            return "no access";
        }
        if (this.isConstructor()) {
            return "no such constructor";
        }
        if (this.isMethod()) {
            return "no such method";
        }
        return "no such field";
    }

    public ReflectiveOperationException makeAccessException() {
        String message = this.message() + ": " + this.toString();
        if (this.isResolved()) {
            return new IllegalAccessException(message);
        }
        if (this.isConstructor()) {
            return new NoSuchMethodException(message);
        }
        if (this.isMethod()) {
            return new NoSuchMethodException(message);
        }
        return new NoSuchFieldException(message);
    }

    static Factory getFactory() {
        return Factory.INSTANCE;
    }

    static class Factory {
        static Factory INSTANCE = new Factory();
        private static int ALLOWED_FLAGS = 0x3F0000;

        private Factory() {
        }

        List<MemberName> getMembers(Class<?> defc, String matchName, Object matchType, int matchFlags, Class<?> lookupClass) {
            matchFlags &= ALLOWED_FLAGS;
            String matchSig = null;
            if (matchType != null) {
                matchSig = BytecodeDescriptor.unparse(matchType);
                matchFlags = matchSig.startsWith("(") ? (matchFlags &= 0xFFF3FFFF) : (matchFlags &= 0xFFF4FFFF);
            }
            int BUF_MAX = 8192;
            int len1 = matchName == null ? 10 : (matchType == null ? 4 : 1);
            MemberName[] buf = Factory.newMemberBuffer(len1);
            int totalCount = 0;
            ArrayList<MemberName[]> bufs = null;
            int bufCount = 0;
            while (true) {
                if ((bufCount = MethodHandleNatives.getMembers(defc, matchName, matchSig, matchFlags, lookupClass, totalCount, buf)) <= buf.length) {
                    if (bufCount < 0) {
                        bufCount = 0;
                    }
                    break;
                }
                totalCount += buf.length;
                int excess = bufCount - buf.length;
                if (bufs == null) {
                    bufs = new ArrayList<MemberName[]>(1);
                }
                bufs.add(buf);
                int len2 = buf.length;
                len2 = Math.max(len2, excess);
                len2 = Math.max(len2, totalCount / 4);
                buf = Factory.newMemberBuffer(Math.min(8192, len2));
            }
            ArrayList<MemberName> result = new ArrayList<MemberName>(totalCount += bufCount);
            if (bufs != null) {
                for (MemberName[] buf0 : bufs) {
                    Collections.addAll(result, buf0);
                }
            }
            result.addAll(Arrays.asList(buf).subList(0, bufCount));
            if (matchType != null && matchType != matchSig) {
                Iterator<MemberName> it = result.iterator();
                while (it.hasNext()) {
                    MemberName m = it.next();
                    if (matchType.equals(m.getType())) continue;
                    it.remove();
                }
            }
            return result;
        }

        boolean resolveInPlace(MemberName m, boolean searchSupers, Class<?> lookupClass) {
            if (m.name == null || m.type == null) {
                Class<?> defc = m.getDeclaringClass();
                List<MemberName> choices = null;
                if (m.isMethod()) {
                    choices = this.getMethods(defc, searchSupers, m.name, (MethodType)m.type, lookupClass);
                } else if (m.isConstructor()) {
                    choices = this.getConstructors(defc, lookupClass);
                } else if (m.isField()) {
                    choices = this.getFields(defc, searchSupers, m.name, (Class)m.type, lookupClass);
                }
                if (choices == null || choices.size() != 1) {
                    return false;
                }
                if (m.name == null) {
                    m.name = choices.get(0).name;
                }
                if (m.type == null) {
                    m.type = choices.get(0).type;
                }
            }
            MethodHandleNatives.resolve(m, lookupClass);
            if (m.isResolved()) {
                return true;
            }
            int matchFlags = m.flags | (searchSupers ? 0x300000 : 0);
            String matchSig = m.getSignature();
            MemberName[] buf = new MemberName[]{m};
            int n = MethodHandleNatives.getMembers(m.getDeclaringClass(), m.getName(), matchSig, matchFlags, lookupClass, 0, buf);
            if (n != 1) {
                return false;
            }
            return m.isResolved();
        }

        public MemberName resolveOrNull(MemberName m, boolean searchSupers, Class<?> lookupClass) {
            MemberName result = m.clone();
            if (this.resolveInPlace(result, searchSupers, lookupClass)) {
                return result;
            }
            return null;
        }

        public <NoSuchMemberException extends ReflectiveOperationException> MemberName resolveOrFail(MemberName m, boolean searchSupers, Class<?> lookupClass, Class<NoSuchMemberException> nsmClass) throws IllegalAccessException, NoSuchMemberException {
            MemberName result = this.resolveOrNull(m, searchSupers, lookupClass);
            if (result != null) {
                return result;
            }
            ReflectiveOperationException ex = m.makeAccessException();
            if (ex instanceof IllegalAccessException) {
                throw (IllegalAccessException)ex;
            }
            throw (ReflectiveOperationException)nsmClass.cast(ex);
        }

        public List<MemberName> getMethods(Class<?> defc, boolean searchSupers, Class<?> lookupClass) {
            return this.getMethods(defc, searchSupers, null, null, lookupClass);
        }

        public List<MemberName> getMethods(Class<?> defc, boolean searchSupers, String name, MethodType type, Class<?> lookupClass) {
            int matchFlags = 0x10000 | (searchSupers ? 0x300000 : 0);
            return this.getMembers(defc, name, type, matchFlags, lookupClass);
        }

        public List<MemberName> getConstructors(Class<?> defc, Class<?> lookupClass) {
            return this.getMembers(defc, null, null, 131072, lookupClass);
        }

        public List<MemberName> getFields(Class<?> defc, boolean searchSupers, Class<?> lookupClass) {
            return this.getFields(defc, searchSupers, null, null, lookupClass);
        }

        public List<MemberName> getFields(Class<?> defc, boolean searchSupers, String name, Class<?> type, Class<?> lookupClass) {
            int matchFlags = 0x40000 | (searchSupers ? 0x300000 : 0);
            return this.getMembers(defc, name, type, matchFlags, lookupClass);
        }

        public List<MemberName> getNestedTypes(Class<?> defc, boolean searchSupers, Class<?> lookupClass) {
            int matchFlags = 0x80000 | (searchSupers ? 0x300000 : 0);
            return this.getMembers(defc, null, null, matchFlags, lookupClass);
        }

        private static MemberName[] newMemberBuffer(int length) {
            MemberName[] buf = new MemberName[length];
            for (int i = 0; i < length; ++i) {
                buf[i] = new MemberName();
            }
            return buf;
        }
    }
}

