/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleImpl;
import java.lang.invoke.MethodHandleNatives;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.WrongMethodTypeException;
import sun.invoke.empty.Empty;
import sun.misc.Unsafe;

public abstract class CallSite {
    private MemberName vmmethod;
    private int vmindex;
    MethodHandle target;
    private static final MethodHandle GET_TARGET;
    private static final Unsafe unsafe;
    private static final long TARGET_OFFSET;

    CallSite(MethodType type) {
        this.target = type.invokers().uninitializedCallSite();
    }

    CallSite(MethodHandle target) {
        target.type();
        this.target = target;
    }

    CallSite(MethodType targetType, MethodHandle createTargetHook) throws Throwable {
        this(targetType);
        ConstantCallSite selfCCS = (ConstantCallSite)this;
        MethodHandle boundTarget = (MethodHandle)createTargetHook.invokeWithArguments(selfCCS);
        this.checkTargetChange(this.target, boundTarget);
        this.target = boundTarget;
    }

    public MethodType type() {
        return this.target.type();
    }

    void initializeFromJVM(String name, MethodType type, MemberName callerMethod, int callerBCI) {
        if (this.vmmethod != null) {
            throw new BootstrapMethodError("call site has already been linked to an invokedynamic instruction");
        }
        if (!this.type().equals((Object)type)) {
            throw CallSite.wrongTargetType(this.target, type);
        }
        this.vmindex = callerBCI;
        this.vmmethod = callerMethod;
    }

    public abstract MethodHandle getTarget();

    public abstract void setTarget(MethodHandle var1);

    void checkTargetChange(MethodHandle oldTarget, MethodHandle newTarget) {
        MethodType oldType = oldTarget.type();
        MethodType newType = newTarget.type();
        if (!newType.equals((Object)oldType)) {
            throw CallSite.wrongTargetType(newTarget, oldType);
        }
    }

    private static WrongMethodTypeException wrongTargetType(MethodHandle target, MethodType type) {
        return new WrongMethodTypeException(String.valueOf(target) + " should be of type " + type);
    }

    public abstract MethodHandle dynamicInvoker();

    MethodHandle makeDynamicInvoker() {
        MethodHandle getTarget = MethodHandleImpl.bindReceiver(GET_TARGET, this);
        MethodHandle invoker = MethodHandles.exactInvoker(this.type());
        return MethodHandles.foldArguments(invoker, getTarget);
    }

    static Empty uninitializedCallSite() {
        throw new IllegalStateException("uninitialized call site");
    }

    void setTargetNormal(MethodHandle newTarget) {
        MethodHandleNatives.setCallSiteTargetNormal(this, newTarget);
    }

    MethodHandle getTargetVolatile() {
        return (MethodHandle)unsafe.getObjectVolatile(this, TARGET_OFFSET);
    }

    void setTargetVolatile(MethodHandle newTarget) {
        MethodHandleNatives.setCallSiteTargetVolatile(this, newTarget);
    }

    static CallSite makeSite(MethodHandle bootstrapMethod, String name, MethodType type, Object info, MemberName callerMethod, int callerBCI) {
        CallSite site;
        Class<?> callerClass = callerMethod.getDeclaringClass();
        MethodHandles.Lookup caller = MethodHandles.Lookup.IMPL_LOOKUP.in(callerClass);
        try {
            Object binding;
            info = CallSite.maybeReBox(info);
            if (info == null) {
                binding = bootstrapMethod.invoke(caller, name, type);
            } else if (!info.getClass().isArray()) {
                binding = bootstrapMethod.invoke(caller, name, type, info);
            } else {
                Object[] argv = (Object[])info;
                CallSite.maybeReBoxElements(argv);
                if (3 + argv.length > 255) {
                    throw new BootstrapMethodError("too many bootstrap method arguments");
                }
                MethodType bsmType = bootstrapMethod.type();
                binding = bsmType.parameterCount() == 4 && bsmType.parameterType(3) == Object[].class ? bootstrapMethod.invoke(caller, name, type, argv) : MethodHandles.spreadInvoker(bsmType, 3).invoke(bootstrapMethod, caller, name, type, argv);
            }
            if (!(binding instanceof CallSite)) {
                throw new ClassCastException("bootstrap method failed to produce a CallSite");
            }
            site = (CallSite)binding;
            if (!site.getTarget().type().equals((Object)type)) {
                throw new WrongMethodTypeException("wrong type: " + site.getTarget());
            }
        }
        catch (Throwable ex) {
            BootstrapMethodError bex = ex instanceof BootstrapMethodError ? (BootstrapMethodError)ex : new BootstrapMethodError("call site initialization exception", ex);
            throw bex;
        }
        return site;
    }

    private static Object maybeReBox(Object x) {
        int xi;
        if (x instanceof Integer && (xi = ((Integer)x).intValue()) == (byte)xi) {
            x = xi;
        }
        return x;
    }

    private static void maybeReBoxElements(Object[] xa) {
        for (int i = 0; i < xa.length; ++i) {
            xa[i] = CallSite.maybeReBox(xa[i]);
        }
    }

    static {
        MethodHandleImpl.initStatics();
        try {
            GET_TARGET = MethodHandles.Lookup.IMPL_LOOKUP.findVirtual(CallSite.class, "getTarget", MethodType.methodType(MethodHandle.class));
        }
        catch (ReflectiveOperationException ignore) {
            throw new InternalError();
        }
        unsafe = Unsafe.getUnsafe();
        try {
            TARGET_OFFSET = unsafe.objectFieldOffset(CallSite.class.getDeclaredField("target"));
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }
}

