/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.AdapterMethodHandle;
import java.lang.invoke.DirectMethodHandle;
import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleNatives;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import sun.invoke.util.VerifyType;
import sun.invoke.util.Wrapper;

class BoundMethodHandle
extends MethodHandle {
    private final Object argument;
    private final int vmargslot;

    BoundMethodHandle(DirectMethodHandle mh, Object argument) {
        super(mh.type().dropParameterTypes(0, 1));
        this.argument = BoundMethodHandle.checkReferenceArgument(argument, mh, 0);
        this.vmargslot = this.type().parameterSlotCount();
        this.initTarget(mh, 0);
    }

    BoundMethodHandle(MethodHandle mh, Object argument, int argnum) {
        this(mh.type().dropParameterTypes(argnum, argnum + 1), mh, argument, argnum);
    }

    BoundMethodHandle(MethodType type, MethodHandle mh, Object argument, int argnum) {
        super(type);
        this.argument = mh.type().parameterType(argnum).isPrimitive() ? BoundMethodHandle.bindPrimitiveArgument(argument, mh, argnum) : BoundMethodHandle.checkReferenceArgument(argument, mh, argnum);
        this.vmargslot = type.parameterSlotDepth(argnum);
        this.initTarget(mh, argnum);
    }

    private void initTarget(MethodHandle mh, int argnum) {
        MethodHandleNatives.init(this, (Object)mh, argnum);
    }

    BoundMethodHandle(MethodType type, Object argument, int vmargslot) {
        super(type);
        this.argument = argument;
        this.vmargslot = vmargslot;
        assert (this instanceof AdapterMethodHandle);
    }

    BoundMethodHandle(MethodHandle entryPoint) {
        super(entryPoint.type().dropParameterTypes(0, 1));
        this.argument = this;
        this.vmargslot = this.type().parameterSlotDepth(0);
        this.initTarget(entryPoint, 0);
    }

    static final Object checkReferenceArgument(Object argument, MethodHandle mh, int argnum) {
        Class<?> ptype = mh.type().parameterType(argnum);
        if (!ptype.isPrimitive()) {
            if (argument == null) {
                return null;
            }
            if (VerifyType.isNullReferenceConversion(argument.getClass(), ptype)) {
                return argument;
            }
        }
        throw BoundMethodHandle.badBoundArgumentException(argument, mh, argnum);
    }

    static final Object bindPrimitiveArgument(Object argument, MethodHandle mh, int argnum) {
        Class<?> ptype = mh.type().parameterType(argnum);
        Wrapper wrap = Wrapper.forPrimitiveType(ptype);
        Object zero = wrap.zero();
        if (zero != null) {
            if (argument == null) {
                if (ptype != Integer.TYPE && wrap.isSubwordOrInt()) {
                    return 0;
                }
                return zero;
            }
            if (VerifyType.isNullReferenceConversion(argument.getClass(), zero.getClass())) {
                if (ptype != Integer.TYPE && wrap.isSubwordOrInt()) {
                    return Wrapper.INT.wrap(argument);
                }
                return argument;
            }
        }
        throw BoundMethodHandle.badBoundArgumentException(argument, mh, argnum);
    }

    static final RuntimeException badBoundArgumentException(Object argument, MethodHandle mh, int argnum) {
        String atype = argument == null ? "null" : argument.getClass().toString();
        return new ClassCastException("cannot bind " + atype + " argument to parameter #" + argnum + " of " + mh.type());
    }

    @Override
    String debugString() {
        return MethodHandleStatics.addTypeString(this.baseName(), this);
    }

    protected String baseName() {
        MethodHandle mh = this;
        while (mh instanceof BoundMethodHandle) {
            Object info = MethodHandleNatives.getTargetInfo(mh);
            if (!(info instanceof MethodHandle)) {
                String name = null;
                if (info instanceof MemberName) {
                    name = ((MemberName)info).getName();
                }
                if (name != null) {
                    return name;
                }
                return BoundMethodHandle.noParens(super.toString());
            }
            mh = (MethodHandle)info;
            assert (mh != this);
        }
        return BoundMethodHandle.noParens(mh.toString());
    }

    private static String noParens(String str) {
        int paren = str.indexOf(40);
        if (paren >= 0) {
            str = str.substring(0, paren);
        }
        return str;
    }
}

