/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import sun.misc.ClassFileTransformer;
import sun.misc.CompoundEnumeration;
import sun.misc.Launcher;
import sun.misc.PerfCounter;
import sun.misc.Resource;
import sun.misc.URLClassPath;
import sun.misc.VM;
import sun.reflect.Reflection;
import sun.security.util.SecurityConstants;

public abstract class ClassLoader {
    private final ClassLoader parent;
    private final ConcurrentHashMap<String, Object> parallelLockMap;
    private final Map<String, Certificate[]> package2certs;
    private static final Certificate[] nocerts;
    private final Vector<Class<?>> classes = new Vector();
    private final ProtectionDomain defaultDomain = new ProtectionDomain(new CodeSource(null, (Certificate[])null), null, this, null);
    private final Set<ProtectionDomain> domains;
    private final HashMap<String, Package> packages = new HashMap();
    private static ClassLoader scl;
    private static boolean sclSet;
    private static Vector<String> loadedLibraryNames;
    private static Vector<NativeLibrary> systemNativeLibraries;
    private Vector<NativeLibrary> nativeLibraries = new Vector();
    private static Stack<NativeLibrary> nativeLibraryContext;
    private static String[] usr_paths;
    private static String[] sys_paths;
    final Object assertionLock;
    private boolean defaultAssertionStatus = false;
    private Map<String, Boolean> packageAssertionStatus = null;
    Map<String, Boolean> classAssertionStatus = null;

    private static native void registerNatives();

    void addClass(Class c) {
        this.classes.addElement(c);
    }

    private static Void checkCreateClassLoader() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkCreateClassLoader();
        }
        return null;
    }

    private ClassLoader(Void unused, ClassLoader parent) {
        this.parent = parent;
        if (ParallelLoaders.isRegistered(this.getClass())) {
            this.parallelLockMap = new ConcurrentHashMap();
            this.package2certs = new ConcurrentHashMap<String, Certificate[]>();
            this.domains = Collections.synchronizedSet(new HashSet());
            this.assertionLock = new Object();
        } else {
            this.parallelLockMap = null;
            this.package2certs = new Hashtable<String, Certificate[]>();
            this.domains = new HashSet<ProtectionDomain>();
            this.assertionLock = this;
        }
    }

    protected ClassLoader(ClassLoader parent) {
        this(ClassLoader.checkCreateClassLoader(), parent);
    }

    protected ClassLoader() {
        this(ClassLoader.checkCreateClassLoader(), ClassLoader.getSystemClassLoader());
    }

    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> c = this.findLoadedClass(name);
            if (c == null) {
                long t0 = System.nanoTime();
                try {
                    c = this.parent != null ? this.parent.loadClass(name, false) : this.findBootstrapClassOrNull(name);
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
                if (c == null) {
                    long t1 = System.nanoTime();
                    c = this.findClass(name);
                    PerfCounter.getParentDelegationTime().addTime(t1 - t0);
                    PerfCounter.getFindClassTime().addElapsedTimeFrom(t1);
                    PerfCounter.getFindClasses().increment();
                }
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
    }

    protected Object getClassLoadingLock(String className) {
        Object newLock;
        Object lock = this;
        if (this.parallelLockMap != null && (lock = this.parallelLockMap.putIfAbsent(className, newLock = new Object())) == null) {
            lock = newLock;
        }
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class loadClassInternal(String name) throws ClassNotFoundException {
        if (this.parallelLockMap == null) {
            ClassLoader classLoader = this;
            synchronized (classLoader) {
                return this.loadClass(name);
            }
        }
        return this.loadClass(name);
    }

    private void checkPackageAccess(Class cls, ProtectionDomain pd) {
        String name;
        int i;
        final SecurityManager sm = System.getSecurityManager();
        if (sm != null && (i = (name = cls.getName()).lastIndexOf(46)) != -1) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    sm.checkPackageAccess(name.substring(0, i));
                    return null;
                }
            }, new AccessControlContext(new ProtectionDomain[]{pd}));
        }
        this.domains.add(pd);
    }

    protected Class<?> findClass(String name) throws ClassNotFoundException {
        throw new ClassNotFoundException(name);
    }

    @Deprecated
    protected final Class<?> defineClass(byte[] b, int off, int len) throws ClassFormatError {
        return this.defineClass(null, b, off, len, null);
    }

    protected final Class<?> defineClass(String name, byte[] b, int off, int len) throws ClassFormatError {
        return this.defineClass(name, b, off, len, null);
    }

    private ProtectionDomain preDefineClass(String name, ProtectionDomain pd) {
        if (!this.checkName(name)) {
            throw new NoClassDefFoundError("IllegalName: " + name);
        }
        if (name != null && name.startsWith("java.")) {
            throw new SecurityException("Prohibited package name: " + name.substring(0, name.lastIndexOf(46)));
        }
        if (pd == null) {
            pd = this.defaultDomain;
        }
        if (name != null) {
            this.checkCerts(name, pd.getCodeSource());
        }
        return pd;
    }

    private String defineClassSourceLocation(ProtectionDomain pd) {
        CodeSource cs = pd.getCodeSource();
        String source = null;
        if (cs != null && cs.getLocation() != null) {
            source = cs.getLocation().toString();
        }
        return source;
    }

    private Class defineTransformedClass(String name, byte[] b, int off, int len, ProtectionDomain pd, ClassFormatError cfe, String source) throws ClassFormatError {
        ClassFileTransformer[] transformers = ClassFileTransformer.getTransformers();
        Class c = null;
        if (transformers != null) {
            for (ClassFileTransformer transformer : transformers) {
                try {
                    byte[] tb = transformer.transform(b, off, len);
                    c = this.defineClass1(name, tb, 0, tb.length, pd, source);
                    break;
                }
                catch (ClassFormatError cfe2) {
                }
            }
        }
        if (c == null) {
            throw cfe;
        }
        return c;
    }

    private void postDefineClass(Class c, ProtectionDomain pd) {
        Object[] certs;
        if (pd.getCodeSource() != null && (certs = pd.getCodeSource().getCertificates()) != null) {
            this.setSigners(c, certs);
        }
    }

    protected final Class<?> defineClass(String name, byte[] b, int off, int len, ProtectionDomain protectionDomain) throws ClassFormatError {
        protectionDomain = this.preDefineClass(name, protectionDomain);
        Class c = null;
        String source = this.defineClassSourceLocation(protectionDomain);
        try {
            c = this.defineClass1(name, b, off, len, protectionDomain, source);
        }
        catch (ClassFormatError cfe) {
            c = this.defineTransformedClass(name, b, off, len, protectionDomain, cfe, source);
        }
        this.postDefineClass(c, protectionDomain);
        return c;
    }

    protected final Class<?> defineClass(String name, ByteBuffer b, ProtectionDomain protectionDomain) throws ClassFormatError {
        int len = b.remaining();
        if (!b.isDirect()) {
            if (b.hasArray()) {
                return this.defineClass(name, b.array(), b.position() + b.arrayOffset(), len, protectionDomain);
            }
            byte[] tb = new byte[len];
            b.get(tb);
            return this.defineClass(name, tb, 0, len, protectionDomain);
        }
        protectionDomain = this.preDefineClass(name, protectionDomain);
        Class c = null;
        String source = this.defineClassSourceLocation(protectionDomain);
        try {
            c = this.defineClass2(name, b, b.position(), len, protectionDomain, source);
        }
        catch (ClassFormatError cfe) {
            byte[] tb = new byte[len];
            b.get(tb);
            c = this.defineTransformedClass(name, tb, 0, len, protectionDomain, cfe, source);
        }
        this.postDefineClass(c, protectionDomain);
        return c;
    }

    private native Class defineClass0(String var1, byte[] var2, int var3, int var4, ProtectionDomain var5);

    private native Class defineClass1(String var1, byte[] var2, int var3, int var4, ProtectionDomain var5, String var6);

    private native Class defineClass2(String var1, ByteBuffer var2, int var3, int var4, ProtectionDomain var5, String var6);

    private boolean checkName(String name) {
        if (name == null || name.length() == 0) {
            return true;
        }
        return name.indexOf(47) == -1 && (VM.allowArraySyntax() || name.charAt(0) != '[');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkCerts(String name, CodeSource cs) {
        int i = name.lastIndexOf(46);
        String pname = i == -1 ? "" : name.substring(0, i);
        Certificate[] certs = null;
        if (cs != null) {
            certs = cs.getCertificates();
        }
        Certificate[] pcerts = null;
        if (this.parallelLockMap == null) {
            ClassLoader classLoader = this;
            synchronized (classLoader) {
                pcerts = this.package2certs.get(pname);
                if (pcerts == null) {
                    this.package2certs.put(pname, certs == null ? nocerts : certs);
                }
            }
        } else {
            pcerts = ((ConcurrentHashMap)this.package2certs).putIfAbsent(pname, certs == null ? nocerts : certs);
        }
        if (pcerts != null && !this.compareCerts(pcerts, certs)) {
            throw new SecurityException("class \"" + name + "\"'s signer information does not match signer information of other classes in the same package");
        }
    }

    private boolean compareCerts(Certificate[] pcerts, Certificate[] certs) {
        int j;
        boolean match;
        int i;
        if (certs == null || certs.length == 0) {
            return pcerts.length == 0;
        }
        if (certs.length != pcerts.length) {
            return false;
        }
        for (i = 0; i < certs.length; ++i) {
            match = false;
            for (j = 0; j < pcerts.length; ++j) {
                if (!certs[i].equals(pcerts[j])) continue;
                match = true;
                break;
            }
            if (match) continue;
            return false;
        }
        for (i = 0; i < pcerts.length; ++i) {
            match = false;
            for (j = 0; j < certs.length; ++j) {
                if (!pcerts[i].equals(certs[j])) continue;
                match = true;
                break;
            }
            if (match) continue;
            return false;
        }
        return true;
    }

    protected final void resolveClass(Class<?> c) {
        this.resolveClass0(c);
    }

    private native void resolveClass0(Class var1);

    protected final Class<?> findSystemClass(String name) throws ClassNotFoundException {
        ClassLoader system = ClassLoader.getSystemClassLoader();
        if (system == null) {
            if (!this.checkName(name)) {
                throw new ClassNotFoundException(name);
            }
            Class cls = this.findBootstrapClass(name);
            if (cls == null) {
                throw new ClassNotFoundException(name);
            }
            return cls;
        }
        return system.loadClass(name);
    }

    private Class findBootstrapClassOrNull(String name) {
        if (!this.checkName(name)) {
            return null;
        }
        return this.findBootstrapClass(name);
    }

    private native Class findBootstrapClass(String var1);

    protected final Class<?> findLoadedClass(String name) {
        if (!this.checkName(name)) {
            return null;
        }
        return this.findLoadedClass0(name);
    }

    private final native Class findLoadedClass0(String var1);

    protected final void setSigners(Class<?> c, Object[] signers) {
        c.setSigners(signers);
    }

    public URL getResource(String name) {
        URL url = this.parent != null ? this.parent.getResource(name) : ClassLoader.getBootstrapResource(name);
        if (url == null) {
            url = this.findResource(name);
        }
        return url;
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration[] tmp = new Enumeration[]{this.parent != null ? this.parent.getResources(name) : ClassLoader.getBootstrapResources(name), this.findResources(name)};
        return new CompoundEnumeration<URL>(tmp);
    }

    protected URL findResource(String name) {
        return null;
    }

    protected Enumeration<URL> findResources(String name) throws IOException {
        return Collections.emptyEnumeration();
    }

    private static native Class<? extends ClassLoader> getCaller(int var0);

    protected static boolean registerAsParallelCapable() {
        return ParallelLoaders.register(ClassLoader.getCaller(1));
    }

    public static URL getSystemResource(String name) {
        ClassLoader system = ClassLoader.getSystemClassLoader();
        if (system == null) {
            return ClassLoader.getBootstrapResource(name);
        }
        return system.getResource(name);
    }

    public static Enumeration<URL> getSystemResources(String name) throws IOException {
        ClassLoader system = ClassLoader.getSystemClassLoader();
        if (system == null) {
            return ClassLoader.getBootstrapResources(name);
        }
        return system.getResources(name);
    }

    private static URL getBootstrapResource(String name) {
        URLClassPath ucp = ClassLoader.getBootstrapClassPath();
        Resource res = ucp.getResource(name);
        return res != null ? res.getURL() : null;
    }

    private static Enumeration<URL> getBootstrapResources(String name) throws IOException {
        final Enumeration<Resource> e = ClassLoader.getBootstrapClassPath().getResources(name);
        return new Enumeration<URL>(){

            @Override
            public URL nextElement() {
                return ((Resource)e.nextElement()).getURL();
            }

            @Override
            public boolean hasMoreElements() {
                return e.hasMoreElements();
            }
        };
    }

    static URLClassPath getBootstrapClassPath() {
        return Launcher.getBootstrapClassPath();
    }

    public InputStream getResourceAsStream(String name) {
        URL url = this.getResource(name);
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static InputStream getSystemResourceAsStream(String name) {
        URL url = ClassLoader.getSystemResource(name);
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public final ClassLoader getParent() {
        ClassLoader ccl;
        if (this.parent == null) {
            return null;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && (ccl = ClassLoader.getCallerClassLoader()) != null && !this.isAncestor(ccl)) {
            sm.checkPermission(SecurityConstants.GET_CLASSLOADER_PERMISSION);
        }
        return this.parent;
    }

    public static ClassLoader getSystemClassLoader() {
        ClassLoader ccl;
        ClassLoader.initSystemClassLoader();
        if (scl == null) {
            return null;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && (ccl = ClassLoader.getCallerClassLoader()) != null && ccl != scl && !scl.isAncestor(ccl)) {
            sm.checkPermission(SecurityConstants.GET_CLASSLOADER_PERMISSION);
        }
        return scl;
    }

    private static synchronized void initSystemClassLoader() {
        if (!sclSet) {
            if (scl != null) {
                throw new IllegalStateException("recursive invocation");
            }
            Launcher l = Launcher.getLauncher();
            if (l != null) {
                Throwable oops;
                block7: {
                    oops = null;
                    scl = l.getClassLoader();
                    try {
                        scl = AccessController.doPrivileged(new SystemClassLoaderAction(scl));
                    }
                    catch (PrivilegedActionException pae) {
                        oops = pae.getCause();
                        if (!(oops instanceof InvocationTargetException)) break block7;
                        oops = oops.getCause();
                    }
                }
                if (oops != null) {
                    if (oops instanceof Error) {
                        throw (Error)oops;
                    }
                    throw new Error(oops);
                }
            }
            sclSet = true;
        }
    }

    boolean isAncestor(ClassLoader cl) {
        ClassLoader acl = this;
        do {
            if (cl != (acl = acl.parent)) continue;
            return true;
        } while (acl != null);
        return false;
    }

    static ClassLoader getCallerClassLoader() {
        Class caller = Reflection.getCallerClass(3);
        if (caller == null) {
            return null;
        }
        return caller.getClassLoader0();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Package definePackage(String name, String specTitle, String specVersion, String specVendor, String implTitle, String implVersion, String implVendor, URL sealBase) throws IllegalArgumentException {
        HashMap<String, Package> hashMap = this.packages;
        synchronized (hashMap) {
            Package pkg = this.getPackage(name);
            if (pkg != null) {
                throw new IllegalArgumentException(name);
            }
            pkg = new Package(name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase, this);
            this.packages.put(name, pkg);
            return pkg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Package getPackage(String name) {
        Package pkg;
        HashMap<String, Package> hashMap = this.packages;
        synchronized (hashMap) {
            pkg = this.packages.get(name);
        }
        if (pkg == null && (pkg = this.parent != null ? this.parent.getPackage(name) : Package.getSystemPackage(name)) != null) {
            hashMap = this.packages;
            synchronized (hashMap) {
                Package pkg2 = this.packages.get(name);
                if (pkg2 == null) {
                    this.packages.put(name, pkg);
                } else {
                    pkg = pkg2;
                }
            }
        }
        return pkg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Package[] getPackages() {
        HashMap<String, Package> map;
        HashMap<String, Package> hashMap = this.packages;
        synchronized (hashMap) {
            map = new HashMap<String, Package>(this.packages);
        }
        Package[] pkgs = this.parent != null ? this.parent.getPackages() : Package.getSystemPackages();
        if (pkgs != null) {
            for (int i = 0; i < pkgs.length; ++i) {
                String pkgName = pkgs[i].getName();
                if (map.get(pkgName) != null) continue;
                map.put(pkgName, pkgs[i]);
            }
        }
        return map.values().toArray(new Package[map.size()]);
    }

    protected String findLibrary(String libname) {
        return null;
    }

    private static String[] initializePath(String propname) {
        String ldpath = System.getProperty(propname, "");
        String ps = File.pathSeparator;
        int ldlen = ldpath.length();
        int i = ldpath.indexOf(ps);
        int n = 0;
        while (i >= 0) {
            ++n;
            i = ldpath.indexOf(ps, i + 1);
        }
        String[] paths = new String[n + 1];
        i = 0;
        n = 0;
        int j = ldpath.indexOf(ps);
        while (j >= 0) {
            if (j - i > 0) {
                paths[n++] = ldpath.substring(i, j);
            } else if (j - i == 0) {
                paths[n++] = ".";
            }
            i = j + 1;
            j = ldpath.indexOf(ps, i);
        }
        paths[n] = ldpath.substring(i, ldlen);
        return paths;
    }

    static void loadLibrary(Class fromClass, String name, boolean isAbsolute) {
        File libfile;
        int i;
        String libfilename;
        ClassLoader loader;
        ClassLoader classLoader = loader = fromClass == null ? null : fromClass.getClassLoader();
        if (sys_paths == null) {
            usr_paths = ClassLoader.initializePath("java.library.path");
            sys_paths = ClassLoader.initializePath("sun.boot.library.path");
        }
        if (isAbsolute) {
            if (ClassLoader.loadLibrary0(fromClass, new File(name))) {
                return;
            }
            throw new UnsatisfiedLinkError("Can't load library: " + name);
        }
        if (loader != null && (libfilename = loader.findLibrary(name)) != null) {
            File libfile2 = new File(libfilename);
            if (!libfile2.isAbsolute()) {
                throw new UnsatisfiedLinkError("ClassLoader.findLibrary failed to return an absolute path: " + libfilename);
            }
            if (ClassLoader.loadLibrary0(fromClass, libfile2)) {
                return;
            }
            throw new UnsatisfiedLinkError("Can't load " + libfilename);
        }
        for (i = 0; i < sys_paths.length; ++i) {
            libfile = new File(sys_paths[i], System.mapLibraryName(name));
            if (!ClassLoader.loadLibrary0(fromClass, libfile)) continue;
            return;
        }
        if (loader != null) {
            for (i = 0; i < usr_paths.length; ++i) {
                libfile = new File(usr_paths[i], System.mapLibraryName(name));
                if (!ClassLoader.loadLibrary0(fromClass, libfile)) continue;
                return;
            }
        }
        throw new UnsatisfiedLinkError("no " + name + " in java.library.path");
    }

    private static boolean loadLibrary0(Class fromClass, File file) {
        if (ClassLoader.loadLibrary1(fromClass, file)) {
            return true;
        }
        File libfile = ClassLoaderHelper.mapAlternativeName(file);
        return libfile != null && ClassLoader.loadLibrary1(fromClass, libfile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean loadLibrary1(Class fromClass, final File file) {
        Vector<NativeLibrary> libs;
        String name;
        boolean exists;
        boolean bl = exists = AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return file.exists() ? Boolean.TRUE : null;
            }
        }) != null;
        if (!exists) {
            return false;
        }
        try {
            name = file.getCanonicalPath();
        }
        catch (IOException e) {
            return false;
        }
        ClassLoader loader = fromClass == null ? null : fromClass.getClassLoader();
        Vector<NativeLibrary> vector = libs = loader != null ? loader.nativeLibraries : systemNativeLibraries;
        synchronized (vector) {
            int size = libs.size();
            for (int i = 0; i < size; ++i) {
                NativeLibrary lib = libs.elementAt(i);
                if (!name.equals(lib.name)) continue;
                return true;
            }
            Vector<String> vector2 = loadedLibraryNames;
            synchronized (vector2) {
                if (loadedLibraryNames.contains(name)) {
                    throw new UnsatisfiedLinkError("Native Library " + name + " already loaded in another classloader");
                }
                int n = nativeLibraryContext.size();
                for (int i = 0; i < n; ++i) {
                    NativeLibrary lib = (NativeLibrary)nativeLibraryContext.elementAt(i);
                    if (!name.equals(lib.name)) continue;
                    if (loader == lib.fromClass.getClassLoader()) {
                        return true;
                    }
                    throw new UnsatisfiedLinkError("Native Library " + name + " is being loaded in another classloader");
                }
                NativeLibrary lib = new NativeLibrary(fromClass, name);
                nativeLibraryContext.push(lib);
                try {
                    lib.load(name);
                }
                finally {
                    nativeLibraryContext.pop();
                }
                if (lib.handle != 0L) {
                    loadedLibraryNames.addElement(name);
                    libs.addElement(lib);
                    return true;
                }
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long findNative(ClassLoader loader, String name) {
        Vector<NativeLibrary> libs;
        Vector<NativeLibrary> vector = libs = loader != null ? loader.nativeLibraries : systemNativeLibraries;
        synchronized (vector) {
            int size = libs.size();
            for (int i = 0; i < size; ++i) {
                NativeLibrary lib = libs.elementAt(i);
                long entry = lib.find(name);
                if (entry == 0L) continue;
                return entry;
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultAssertionStatus(boolean enabled) {
        Object object = this.assertionLock;
        synchronized (object) {
            if (this.classAssertionStatus == null) {
                this.initializeJavaAssertionMaps();
            }
            this.defaultAssertionStatus = enabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPackageAssertionStatus(String packageName, boolean enabled) {
        Object object = this.assertionLock;
        synchronized (object) {
            if (this.packageAssertionStatus == null) {
                this.initializeJavaAssertionMaps();
            }
            this.packageAssertionStatus.put(packageName, enabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClassAssertionStatus(String className, boolean enabled) {
        Object object = this.assertionLock;
        synchronized (object) {
            if (this.classAssertionStatus == null) {
                this.initializeJavaAssertionMaps();
            }
            this.classAssertionStatus.put(className, enabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAssertionStatus() {
        Object object = this.assertionLock;
        synchronized (object) {
            this.classAssertionStatus = new HashMap<String, Boolean>();
            this.packageAssertionStatus = new HashMap<String, Boolean>();
            this.defaultAssertionStatus = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean desiredAssertionStatus(String className) {
        Object object = this.assertionLock;
        synchronized (object) {
            Boolean result = this.classAssertionStatus.get(className);
            if (result != null) {
                return result;
            }
            int dotIndex = className.lastIndexOf(".");
            if (dotIndex < 0 && (result = this.packageAssertionStatus.get(null)) != null) {
                return result;
            }
            while (dotIndex > 0) {
                result = this.packageAssertionStatus.get(className = className.substring(0, dotIndex));
                if (result != null) {
                    return result;
                }
                dotIndex = className.lastIndexOf(".", dotIndex - 1);
            }
            return this.defaultAssertionStatus;
        }
    }

    private void initializeJavaAssertionMaps() {
        int i;
        this.classAssertionStatus = new HashMap<String, Boolean>();
        this.packageAssertionStatus = new HashMap<String, Boolean>();
        AssertionStatusDirectives directives = ClassLoader.retrieveDirectives();
        for (i = 0; i < directives.classes.length; ++i) {
            this.classAssertionStatus.put(directives.classes[i], directives.classEnabled[i]);
        }
        for (i = 0; i < directives.packages.length; ++i) {
            this.packageAssertionStatus.put(directives.packages[i], directives.packageEnabled[i]);
        }
        this.defaultAssertionStatus = directives.deflt;
    }

    private static native AssertionStatusDirectives retrieveDirectives();

    static {
        ClassLoader.registerNatives();
        nocerts = new Certificate[0];
        loadedLibraryNames = new Vector();
        systemNativeLibraries = new Vector();
        nativeLibraryContext = new Stack();
    }

    static class NativeLibrary {
        long handle;
        private int jniVersion;
        private Class fromClass;
        String name;

        native void load(String var1);

        native long find(String var1);

        native void unload();

        public NativeLibrary(Class fromClass, String name) {
            this.name = name;
            this.fromClass = fromClass;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() {
            Vector vector = loadedLibraryNames;
            synchronized (vector) {
                if (this.fromClass.getClassLoader() != null && this.handle != 0L) {
                    int size = loadedLibraryNames.size();
                    for (int i = 0; i < size; ++i) {
                        if (!this.name.equals(loadedLibraryNames.elementAt(i))) continue;
                        loadedLibraryNames.removeElementAt(i);
                        break;
                    }
                    nativeLibraryContext.push(this);
                    try {
                        this.unload();
                    }
                    finally {
                        nativeLibraryContext.pop();
                    }
                }
            }
        }

        static Class getFromClass() {
            return ((NativeLibrary)nativeLibraryContext.peek()).fromClass;
        }
    }

    private static class ParallelLoaders {
        private static final Set<Class<? extends ClassLoader>> loaderTypes;

        private ParallelLoaders() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static boolean register(Class<? extends ClassLoader> c) {
            Set<Class<? extends ClassLoader>> set = loaderTypes;
            synchronized (set) {
                if (loaderTypes.contains(c.getSuperclass())) {
                    loaderTypes.add(c);
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static boolean isRegistered(Class<? extends ClassLoader> c) {
            Set<Class<? extends ClassLoader>> set = loaderTypes;
            synchronized (set) {
                return loaderTypes.contains(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static {
            Set<Class<? extends ClassLoader>> set = loaderTypes = Collections.newSetFromMap(new WeakHashMap());
            synchronized (set) {
                loaderTypes.add(ClassLoader.class);
            }
        }
    }
}

