/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.DefaultPersistenceDelegate;
import java.beans.Encoder;
import java.beans.Expression;
import java.beans.PersistenceDelegate;
import java.lang.reflect.Array;
import java.util.Objects;

class ArrayPersistenceDelegate
extends PersistenceDelegate {
    ArrayPersistenceDelegate() {
    }

    @Override
    protected boolean mutatesTo(Object oldInstance, Object newInstance) {
        return newInstance != null && oldInstance.getClass() == newInstance.getClass() && Array.getLength(oldInstance) == Array.getLength(newInstance);
    }

    @Override
    protected Expression instantiate(Object oldInstance, Encoder out) {
        Class<?> oldClass = oldInstance.getClass();
        return new Expression(oldInstance, Array.class, "newInstance", new Object[]{oldClass.getComponentType(), new Integer(Array.getLength(oldInstance))});
    }

    @Override
    protected void initialize(Class<?> type, Object oldInstance, Object newInstance, Encoder out) {
        int n = Array.getLength(oldInstance);
        for (int i = 0; i < n; ++i) {
            Integer index = new Integer(i);
            Expression oldGetExp = new Expression(oldInstance, "get", new Object[]{index});
            Expression newGetExp = new Expression(newInstance, "get", new Object[]{index});
            try {
                Object oldValue = oldGetExp.getValue();
                Object newValue = newGetExp.getValue();
                out.writeExpression(oldGetExp);
                if (Objects.equals(newValue, out.get(oldValue))) continue;
                DefaultPersistenceDelegate.invokeStatement(oldInstance, "set", new Object[]{index, oldValue}, out);
                continue;
            }
            catch (Exception e) {
                out.getExceptionListener().exceptionThrown(e);
            }
        }
    }
}

