/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.Conditional;
import java.awt.EventDispatchThread;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.awt.SentEvent;
import java.awt.Toolkit;
import java.util.LinkedList;
import sun.awt.AppContext;
import sun.awt.SunToolkit;

class SequencedEvent
extends AWTEvent
implements ActiveEvent {
    private static final long serialVersionUID = 547742659238625067L;
    private static final int ID = 1006;
    private static final LinkedList list = new LinkedList();
    private final AWTEvent nested;
    private AppContext appContext;
    private boolean disposed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SequencedEvent(AWTEvent nested) {
        super(nested.getSource(), 1006);
        this.nested = nested;
        SunToolkit.setSystemGenerated(nested);
        Class<SequencedEvent> clazz = SequencedEvent.class;
        synchronized (SequencedEvent.class) {
            list.add(this);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public final void dispatch() {
        try {
            this.appContext = AppContext.getAppContext();
            if (SequencedEvent.getFirst() != this) {
                if (EventQueue.isDispatchThread()) {
                    EventDispatchThread edt = (EventDispatchThread)Thread.currentThread();
                    edt.pumpEvents(1007, new Conditional(){

                        @Override
                        public boolean evaluate() {
                            return !SequencedEvent.this.isFirstOrDisposed();
                        }
                    });
                } else {
                    while (!this.isFirstOrDisposed()) {
                        Class<SequencedEvent> clazz = SequencedEvent.class;
                        // MONITORENTER : java.awt.SequencedEvent.class
                        try {
                            SequencedEvent.class.wait(1000L);
                        }
                        catch (InterruptedException e) {
                            // MONITOREXIT : clazz
                            break;
                        }
                    }
                }
            }
            if (this.disposed) return;
            KeyboardFocusManager.getCurrentKeyboardFocusManager().setCurrentSequencedEvent(this);
            Toolkit.getEventQueue().dispatchEvent(this.nested);
            return;
        }
        finally {
            this.dispose();
        }
    }

    private static final boolean isOwnerAppContextDisposed(SequencedEvent se) {
        Object target;
        if (se != null && (target = se.nested.getSource()) instanceof Component) {
            return ((Component)target).appContext.isDisposed();
        }
        return false;
    }

    public final boolean isFirstOrDisposed() {
        if (this.disposed) {
            return true;
        }
        return this == SequencedEvent.getFirstWithContext() || this.disposed;
    }

    private static final synchronized SequencedEvent getFirst() {
        return (SequencedEvent)list.getFirst();
    }

    private static final SequencedEvent getFirstWithContext() {
        SequencedEvent first = SequencedEvent.getFirst();
        while (SequencedEvent.isOwnerAppContextDisposed(first)) {
            first.dispose();
            first = SequencedEvent.getFirst();
        }
        return first;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void dispose() {
        Class<SequencedEvent> clazz = SequencedEvent.class;
        synchronized (SequencedEvent.class) {
            if (this.disposed) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            if (KeyboardFocusManager.getCurrentKeyboardFocusManager().getCurrentSequencedEvent() == this) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().setCurrentSequencedEvent(null);
            }
            this.disposed = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (this.appContext != null) {
                SunToolkit.postEvent(this.appContext, new SentEvent());
            }
            SequencedEvent next = null;
            Class<SequencedEvent> clazz2 = SequencedEvent.class;
            synchronized (SequencedEvent.class) {
                SequencedEvent.class.notifyAll();
                if (list.getFirst() == this) {
                    list.removeFirst();
                    if (!list.isEmpty()) {
                        next = (SequencedEvent)list.getFirst();
                    }
                } else {
                    list.remove(this);
                }
                // ** MonitorExit[var2_3] (shouldn't be in output)
                if (next != null && next.appContext != null) {
                    SunToolkit.postEvent(next.appContext, new SentEvent());
                }
                return;
            }
        }
    }
}

