/*
 * Decompiled with CFR 0.152.
 */
package com.sun.servicetag;

import com.sun.servicetag.RegistrationData;
import com.sun.servicetag.ServiceTag;
import com.sun.servicetag.Util;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class RegistrationDocument {
    private static final String REGISTRATION_DATA_SCHEMA = "/com/sun/servicetag/resources/product_registration.xsd";
    private static final String REGISTRATION_DATA_VERSION = "1.0";
    private static final String SERVICE_TAG_VERSION = "1.0";
    static final String ST_NODE_REGISTRATION_DATA = "registration_data";
    static final String ST_ATTR_REGISTRATION_VERSION = "version";
    static final String ST_NODE_ENVIRONMENT = "environment";
    static final String ST_NODE_HOSTNAME = "hostname";
    static final String ST_NODE_HOST_ID = "hostId";
    static final String ST_NODE_OS_NAME = "osName";
    static final String ST_NODE_OS_VERSION = "osVersion";
    static final String ST_NODE_OS_ARCH = "osArchitecture";
    static final String ST_NODE_SYSTEM_MODEL = "systemModel";
    static final String ST_NODE_SYSTEM_MANUFACTURER = "systemManufacturer";
    static final String ST_NODE_CPU_MANUFACTURER = "cpuManufacturer";
    static final String ST_NODE_SERIAL_NUMBER = "serialNumber";
    static final String ST_NODE_REGISTRY = "registry";
    static final String ST_ATTR_REGISTRY_URN = "urn";
    static final String ST_ATTR_REGISTRY_VERSION = "version";
    static final String ST_NODE_SERVICE_TAG = "service_tag";
    static final String ST_NODE_INSTANCE_URN = "instance_urn";
    static final String ST_NODE_PRODUCT_NAME = "product_name";
    static final String ST_NODE_PRODUCT_VERSION = "product_version";
    static final String ST_NODE_PRODUCT_URN = "product_urn";
    static final String ST_NODE_PRODUCT_PARENT_URN = "product_parent_urn";
    static final String ST_NODE_PRODUCT_PARENT = "product_parent";
    static final String ST_NODE_PRODUCT_DEFINED_INST_ID = "product_defined_inst_id";
    static final String ST_NODE_PRODUCT_VENDOR = "product_vendor";
    static final String ST_NODE_PLATFORM_ARCH = "platform_arch";
    static final String ST_NODE_TIMESTAMP = "timestamp";
    static final String ST_NODE_CONTAINER = "container";
    static final String ST_NODE_SOURCE = "source";
    static final String ST_NODE_INSTALLER_UID = "installer_uid";

    RegistrationDocument() {
    }

    static RegistrationData load(InputStream in) throws IOException {
        Document document = RegistrationDocument.initializeDocument(in);
        Element root = RegistrationDocument.getRegistrationDataRoot(document);
        Element registryRoot = RegistrationDocument.getSingletonElementFromRoot(root, ST_NODE_REGISTRY);
        String urn = registryRoot.getAttribute(ST_ATTR_REGISTRY_URN);
        RegistrationData regData = new RegistrationData(urn);
        RegistrationDocument.addServiceTags(registryRoot, regData);
        Element envRoot = RegistrationDocument.getSingletonElementFromRoot(root, ST_NODE_ENVIRONMENT);
        RegistrationDocument.buildEnvironmentMap(envRoot, regData);
        return regData;
    }

    static void store(OutputStream os, RegistrationData registration) throws IOException {
        Document document = RegistrationDocument.initializeDocument();
        RegistrationDocument.addEnvironmentNodes(document, registration.getEnvironmentMap());
        RegistrationDocument.addServiceTagRegistry(document, registration.getRegistrationURN(), registration.getServiceTags());
        RegistrationDocument.transform(document, os);
    }

    private static Document initializeDocument(InputStream in) throws IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            URL xsdUrl = RegistrationDocument.class.getResource(REGISTRATION_DATA_SCHEMA);
            Schema schema = sf.newSchema(xsdUrl);
            Validator validator = schema.newValidator();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(in));
            validator.validate(new DOMSource(doc));
            return doc;
        }
        catch (SAXException sxe) {
            IllegalArgumentException e = new IllegalArgumentException("Error generated in parsing");
            e.initCause(sxe);
            throw e;
        }
        catch (ParserConfigurationException pce) {
            InternalError x = new InternalError("Error in creating the new document");
            x.initCause(pce);
            throw x;
        }
    }

    private static Document initializeDocument() throws IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.newDocument();
            Element root = doc.createElement(ST_NODE_REGISTRATION_DATA);
            doc.appendChild(root);
            root.setAttribute("version", "1.0");
            return doc;
        }
        catch (ParserConfigurationException pce) {
            InternalError x = new InternalError("Error in creating the new document");
            x.initCause(pce);
            throw x;
        }
    }

    private static void transform(Document document, OutputStream os) {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            tFactory.setAttribute("indent-number", new Integer(3));
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("standalone", "yes");
            transformer.transform(new DOMSource(document), new StreamResult(new BufferedWriter(new OutputStreamWriter(os, "UTF-8"))));
        }
        catch (UnsupportedEncodingException ue) {
            InternalError x = new InternalError("Error generated during transformation");
            x.initCause(ue);
            throw x;
        }
        catch (TransformerConfigurationException tce) {
            InternalError x = new InternalError("Error in creating the new document");
            x.initCause(tce);
            throw x;
        }
        catch (TransformerException te) {
            InternalError x = new InternalError("Error generated during transformation");
            x.initCause(te);
            throw x;
        }
    }

    private static void addServiceTagRegistry(Document document, String registryURN, Set<ServiceTag> svcTags) {
        Element reg = document.createElement(ST_NODE_REGISTRY);
        reg.setAttribute(ST_ATTR_REGISTRY_URN, registryURN);
        reg.setAttribute("version", "1.0");
        Element root = RegistrationDocument.getRegistrationDataRoot(document);
        root.appendChild(reg);
        for (ServiceTag st : svcTags) {
            RegistrationDocument.addServiceTagElement(document, reg, st);
        }
    }

    private static void addServiceTagElement(Document document, Element registryRoot, ServiceTag st) {
        Element svcTag = document.createElement(ST_NODE_SERVICE_TAG);
        registryRoot.appendChild(svcTag);
        RegistrationDocument.addChildElement(document, svcTag, ST_NODE_INSTANCE_URN, st.getInstanceURN());
        RegistrationDocument.addChildElement(document, svcTag, ST_NODE_PRODUCT_NAME, st.getProductName());
        RegistrationDocument.addChildElement(document, svcTag, ST_NODE_PRODUCT_VERSION, st.getProductVersion());
        RegistrationDocument.addChildElement(document, svcTag, ST_NODE_PRODUCT_URN, st.getProductURN());
        RegistrationDocument.addChildElement(document, svcTag, ST_NODE_PRODUCT_PARENT_URN, st.getProductParentURN());
        RegistrationDocument.addChildElement(document, svcTag, ST_NODE_PRODUCT_PARENT, st.getProductParent());
        RegistrationDocument.addChildElement(document, svcTag, ST_NODE_PRODUCT_DEFINED_INST_ID, st.getProductDefinedInstanceID());
        RegistrationDocument.addChildElement(document, svcTag, ST_NODE_PRODUCT_VENDOR, st.getProductVendor());
        RegistrationDocument.addChildElement(document, svcTag, ST_NODE_PLATFORM_ARCH, st.getPlatformArch());
        RegistrationDocument.addChildElement(document, svcTag, ST_NODE_TIMESTAMP, Util.formatTimestamp(st.getTimestamp()));
        RegistrationDocument.addChildElement(document, svcTag, ST_NODE_CONTAINER, st.getContainer());
        RegistrationDocument.addChildElement(document, svcTag, ST_NODE_SOURCE, st.getSource());
        RegistrationDocument.addChildElement(document, svcTag, ST_NODE_INSTALLER_UID, String.valueOf(st.getInstallerUID()));
    }

    private static void addChildElement(Document document, Element root, String element, String text) {
        Element node = document.createElement(element);
        node.appendChild(document.createTextNode(text));
        root.appendChild(node);
    }

    private static void addServiceTags(Element registryRoot, RegistrationData registration) {
        NodeList children = registryRoot.getElementsByTagName(ST_NODE_SERVICE_TAG);
        int length = children == null ? 0 : children.getLength();
        for (int i = 0; i < length; ++i) {
            Element svcTagElement = (Element)children.item(i);
            ServiceTag st = RegistrationDocument.getServiceTag(svcTagElement);
            registration.addServiceTag(st);
        }
    }

    private static void buildEnvironmentMap(Element envRoot, RegistrationData registration) {
        registration.setEnvironment(ST_NODE_HOSTNAME, RegistrationDocument.getTextValue(envRoot, ST_NODE_HOSTNAME));
        registration.setEnvironment(ST_NODE_HOST_ID, RegistrationDocument.getTextValue(envRoot, ST_NODE_HOST_ID));
        registration.setEnvironment(ST_NODE_OS_NAME, RegistrationDocument.getTextValue(envRoot, ST_NODE_OS_NAME));
        registration.setEnvironment(ST_NODE_OS_VERSION, RegistrationDocument.getTextValue(envRoot, ST_NODE_OS_VERSION));
        registration.setEnvironment(ST_NODE_OS_ARCH, RegistrationDocument.getTextValue(envRoot, ST_NODE_OS_ARCH));
        registration.setEnvironment(ST_NODE_SYSTEM_MODEL, RegistrationDocument.getTextValue(envRoot, ST_NODE_SYSTEM_MODEL));
        registration.setEnvironment(ST_NODE_SYSTEM_MANUFACTURER, RegistrationDocument.getTextValue(envRoot, ST_NODE_SYSTEM_MANUFACTURER));
        registration.setEnvironment(ST_NODE_CPU_MANUFACTURER, RegistrationDocument.getTextValue(envRoot, ST_NODE_CPU_MANUFACTURER));
        registration.setEnvironment(ST_NODE_SERIAL_NUMBER, RegistrationDocument.getTextValue(envRoot, ST_NODE_SERIAL_NUMBER));
    }

    private static void addEnvironmentNodes(Document document, Map<String, String> envMap) {
        Element root = RegistrationDocument.getRegistrationDataRoot(document);
        Element env = document.createElement(ST_NODE_ENVIRONMENT);
        root.appendChild(env);
        Set<Map.Entry<String, String>> keys = envMap.entrySet();
        for (Map.Entry<String, String> entry : keys) {
            RegistrationDocument.addChildElement(document, env, entry.getKey(), entry.getValue());
        }
    }

    private static Element getRegistrationDataRoot(Document doc) {
        Element root = doc.getDocumentElement();
        if (!root.getNodeName().equals(ST_NODE_REGISTRATION_DATA)) {
            throw new IllegalArgumentException("Not a registration_data node \"" + root.getNodeName() + "\"");
        }
        return root;
    }

    private static Element getSingletonElementFromRoot(Element root, String name) {
        int length;
        NodeList children = root.getElementsByTagName(name);
        int n = length = children == null ? 0 : children.getLength();
        if (length != 1) {
            throw new IllegalArgumentException("Invalid number of " + name + " nodes = " + length);
        }
        Element e = (Element)children.item(0);
        if (!e.getNodeName().equals(name)) {
            throw new IllegalArgumentException("Not a  " + name + " node \"" + e.getNodeName() + "\"");
        }
        return e;
    }

    private static ServiceTag getServiceTag(Element svcTagElement) {
        return new ServiceTag(RegistrationDocument.getTextValue(svcTagElement, ST_NODE_INSTANCE_URN), RegistrationDocument.getTextValue(svcTagElement, ST_NODE_PRODUCT_NAME), RegistrationDocument.getTextValue(svcTagElement, ST_NODE_PRODUCT_VERSION), RegistrationDocument.getTextValue(svcTagElement, ST_NODE_PRODUCT_URN), RegistrationDocument.getTextValue(svcTagElement, ST_NODE_PRODUCT_PARENT), RegistrationDocument.getTextValue(svcTagElement, ST_NODE_PRODUCT_PARENT_URN), RegistrationDocument.getTextValue(svcTagElement, ST_NODE_PRODUCT_DEFINED_INST_ID), RegistrationDocument.getTextValue(svcTagElement, ST_NODE_PRODUCT_VENDOR), RegistrationDocument.getTextValue(svcTagElement, ST_NODE_PLATFORM_ARCH), RegistrationDocument.getTextValue(svcTagElement, ST_NODE_CONTAINER), RegistrationDocument.getTextValue(svcTagElement, ST_NODE_SOURCE), Util.getIntValue(RegistrationDocument.getTextValue(svcTagElement, ST_NODE_INSTALLER_UID)), Util.parseTimestamp(RegistrationDocument.getTextValue(svcTagElement, ST_NODE_TIMESTAMP)));
    }

    private static String getTextValue(Element e, String tagName) {
        Element el;
        Node node;
        String value = "";
        NodeList nl = e.getElementsByTagName(tagName);
        if (nl != null && nl.getLength() > 0 && (node = (el = (Element)nl.item(0)).getFirstChild()) != null) {
            value = node.getNodeValue();
        }
        return value;
    }
}

