/*
 * Decompiled with CFR 0.152.
 */
package com.sun.servicetag;

import com.sun.servicetag.Util;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;

class BrowserSupport {
    private static boolean isBrowseSupported = false;
    private static Method browseMethod = null;
    private static Object desktop = null;
    private static volatile Boolean result = false;

    BrowserSupport() {
    }

    private static void initX() {
        Object desktopObj;
        Method browseM;
        boolean supported;
        block13: {
            if (desktop != null) {
                return;
            }
            supported = false;
            browseM = null;
            desktopObj = null;
            try {
                Class<?> desktopCls = Class.forName("java.awt.Desktop", true, null);
                Method getDesktopM = desktopCls.getMethod("getDesktop", new Class[0]);
                browseM = desktopCls.getMethod("browse", URI.class);
                Class<?> actionCls = Class.forName("java.awt.Desktop$Action", true, null);
                final Method isDesktopSupportedMethod = desktopCls.getMethod("isDesktopSupported", new Class[0]);
                Method isSupportedMethod = desktopCls.getMethod("isSupported", actionCls);
                Field browseField = actionCls.getField("BROWSE");
                Thread xthread = new Thread(){

                    @Override
                    public void run() {
                        block3: {
                            try {
                                result = (Boolean)isDesktopSupportedMethod.invoke(null, new Object[0]);
                            }
                            catch (IllegalAccessException e) {
                                InternalError x = new InternalError("Desktop.getDesktop() method not found");
                                x.initCause(e);
                            }
                            catch (InvocationTargetException e) {
                                if (!Util.isVerbose()) break block3;
                                e.printStackTrace();
                            }
                        }
                    }
                };
                xthread.setDaemon(true);
                xthread.start();
                try {
                    xthread.join(5000L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                if (result.booleanValue()) {
                    desktopObj = getDesktopM.invoke(null, new Object[0]);
                    result = (Boolean)isSupportedMethod.invoke(desktopObj, browseField.get(null));
                    supported = result;
                }
            }
            catch (ClassNotFoundException e) {
                if (Util.isVerbose()) {
                    e.printStackTrace();
                }
            }
            catch (NoSuchMethodException e) {
                if (Util.isVerbose()) {
                    e.printStackTrace();
                }
            }
            catch (NoSuchFieldException e) {
                if (Util.isVerbose()) {
                    e.printStackTrace();
                }
            }
            catch (IllegalAccessException e) {
                InternalError x = new InternalError("Desktop.getDesktop() method not found");
                x.initCause(e);
                throw x;
            }
            catch (InvocationTargetException e) {
                if (!Util.isVerbose()) break block13;
                e.printStackTrace();
            }
        }
        isBrowseSupported = supported;
        browseMethod = browseM;
        desktop = desktopObj;
    }

    static boolean isSupported() {
        BrowserSupport.initX();
        return isBrowseSupported;
    }

    static void browse(URI uri) throws IOException {
        block9: {
            if (uri == null) {
                throw new NullPointerException("null uri");
            }
            if (!BrowserSupport.isSupported()) {
                throw new UnsupportedOperationException("Browse operation is not supported");
            }
            try {
                if (Util.isVerbose()) {
                    System.out.println("desktop: " + desktop + ":browsing..." + uri);
                }
                browseMethod.invoke(desktop, uri);
            }
            catch (IllegalAccessException e) {
                InternalError x = new InternalError("Desktop.getDesktop() method not found");
                x.initCause(e);
                throw x;
            }
            catch (InvocationTargetException e) {
                Throwable x = e.getCause();
                if (x == null) break block9;
                if (x instanceof UnsupportedOperationException) {
                    throw (UnsupportedOperationException)x;
                }
                if (x instanceof IllegalArgumentException) {
                    throw (IllegalArgumentException)x;
                }
                if (x instanceof IOException) {
                    throw (IOException)x;
                }
                if (!(x instanceof SecurityException)) break block9;
                throw (SecurityException)x;
            }
        }
    }
}

