/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations;

import com.sun.org.apache.xml.internal.security.c14n.CanonicalizationException;
import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.content.RetrievalMethod;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolver;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverException;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverSpi;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolver;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.transforms.Transforms;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolver;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class RetrievalMethodResolver
extends KeyResolverSpi {
    static Logger log = Logger.getLogger(RetrievalMethodResolver.class.getName());

    @Override
    public PublicKey engineLookupAndResolvePublicKey(Element element, String BaseURI, StorageResolver storage) {
        if (!XMLUtils.elementIsInSignatureSpace(element, "RetrievalMethod")) {
            return null;
        }
        try {
            RetrievalMethod rm = new RetrievalMethod(element, BaseURI);
            String type = rm.getType();
            XMLSignatureInput resource = RetrievalMethodResolver.resolveInput(rm, BaseURI);
            if ("http://www.w3.org/2000/09/xmldsig#rawX509Certificate".equals(type)) {
                X509Certificate cert = RetrievalMethodResolver.getRawCertificate(resource);
                if (cert != null) {
                    return cert.getPublicKey();
                }
                return null;
            }
            Element e = RetrievalMethodResolver.obtainRefrenceElement(resource);
            return RetrievalMethodResolver.resolveKey(e, BaseURI, storage);
        }
        catch (XMLSecurityException ex) {
            log.log(Level.FINE, "XMLSecurityException", ex);
        }
        catch (CertificateException ex) {
            log.log(Level.FINE, "CertificateException", ex);
        }
        catch (IOException ex) {
            log.log(Level.FINE, "IOException", ex);
        }
        catch (ParserConfigurationException e) {
            log.log(Level.FINE, "ParserConfigurationException", e);
        }
        catch (SAXException e) {
            log.log(Level.FINE, "SAXException", e);
        }
        return null;
    }

    private static Element obtainRefrenceElement(XMLSignatureInput resource) throws CanonicalizationException, ParserConfigurationException, IOException, SAXException, KeyResolverException {
        Element e;
        if (resource.isElement()) {
            e = (Element)resource.getSubNode();
        } else if (resource.isNodeSet()) {
            e = RetrievalMethodResolver.getDocumentElement(resource.getNodeSet());
        } else {
            byte[] inputBytes = resource.getBytes();
            e = RetrievalMethodResolver.getDocFromBytes(inputBytes);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "we have to parse " + inputBytes.length + " bytes");
            }
        }
        return e;
    }

    @Override
    public X509Certificate engineLookupResolveX509Certificate(Element element, String BaseURI, StorageResolver storage) {
        if (!XMLUtils.elementIsInSignatureSpace(element, "RetrievalMethod")) {
            return null;
        }
        try {
            RetrievalMethod rm = new RetrievalMethod(element, BaseURI);
            String type = rm.getType();
            XMLSignatureInput resource = RetrievalMethodResolver.resolveInput(rm, BaseURI);
            if ("http://www.w3.org/2000/09/xmldsig#rawX509Certificate".equals(type)) {
                X509Certificate cert = RetrievalMethodResolver.getRawCertificate(resource);
                return cert;
            }
            Element e = RetrievalMethodResolver.obtainRefrenceElement(resource);
            return RetrievalMethodResolver.resolveCertificate(e, BaseURI, storage);
        }
        catch (XMLSecurityException ex) {
            log.log(Level.FINE, "XMLSecurityException", ex);
        }
        catch (CertificateException ex) {
            log.log(Level.FINE, "CertificateException", ex);
        }
        catch (IOException ex) {
            log.log(Level.FINE, "IOException", ex);
        }
        catch (ParserConfigurationException e) {
            log.log(Level.FINE, "ParserConfigurationException", e);
        }
        catch (SAXException e) {
            log.log(Level.FINE, "SAXException", e);
        }
        return null;
    }

    private static X509Certificate resolveCertificate(Element e, String BaseURI, StorageResolver storage) throws KeyResolverException {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Now we have a {" + e.getNamespaceURI() + "}" + e.getLocalName() + " Element");
        }
        if (e != null) {
            return KeyResolver.getX509Certificate(e, BaseURI, storage);
        }
        return null;
    }

    private static PublicKey resolveKey(Element e, String BaseURI, StorageResolver storage) throws KeyResolverException {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Now we have a {" + e.getNamespaceURI() + "}" + e.getLocalName() + " Element");
        }
        if (e != null) {
            return KeyResolver.getPublicKey(e, BaseURI, storage);
        }
        return null;
    }

    private static X509Certificate getRawCertificate(XMLSignatureInput resource) throws CanonicalizationException, IOException, CertificateException {
        byte[] inputBytes = resource.getBytes();
        CertificateFactory certFact = CertificateFactory.getInstance("X.509");
        X509Certificate cert = (X509Certificate)certFact.generateCertificate(new ByteArrayInputStream(inputBytes));
        return cert;
    }

    private static XMLSignatureInput resolveInput(RetrievalMethod rm, String BaseURI) throws XMLSecurityException {
        Attr uri = rm.getURIAttr();
        Transforms transforms = rm.getTransforms();
        ResourceResolver resRes = ResourceResolver.getInstance(uri, BaseURI);
        if (resRes != null) {
            XMLSignatureInput resource = resRes.resolve(uri, BaseURI);
            if (transforms != null) {
                log.log(Level.FINE, "We have Transforms");
                resource = transforms.performTransforms(resource);
            }
            return resource;
        }
        return null;
    }

    static Element getDocFromBytes(byte[] bytes) throws KeyResolverException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new ByteArrayInputStream(bytes));
            return doc.getDocumentElement();
        }
        catch (SAXException ex) {
            throw new KeyResolverException("empty", ex);
        }
        catch (IOException ex) {
            throw new KeyResolverException("empty", ex);
        }
        catch (ParserConfigurationException ex) {
            throw new KeyResolverException("empty", ex);
        }
    }

    @Override
    public SecretKey engineLookupAndResolveSecretKey(Element element, String BaseURI, StorageResolver storage) {
        return null;
    }

    static Element getDocumentElement(Set set) {
        Node n;
        Iterator it = set.iterator();
        Element e = null;
        while (it.hasNext()) {
            Node currentNode = (Node)it.next();
            if (!(currentNode instanceof Element)) continue;
            e = (Element)currentNode;
            break;
        }
        ArrayList<Element> parents = new ArrayList<Element>(10);
        do {
            parents.add(e);
        } while ((n = e.getParentNode()) instanceof Element && (e = (Element)n) != null);
        ListIterator it2 = parents.listIterator(parents.size() - 1);
        Element ele = null;
        while (it2.hasPrevious()) {
            ele = (Element)it2.previous();
            if (!set.contains(ele)) continue;
            return ele;
        }
        return null;
    }
}

