/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.keyresolver;

import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverException;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverSpi;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolver;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import org.w3c.dom.Element;

public class KeyResolver {
    static Logger log = Logger.getLogger(KeyResolver.class.getName());
    static boolean _alreadyInitialized = false;
    static List _resolverVector = null;
    protected KeyResolverSpi _resolverSpi = null;
    protected StorageResolver _storage = null;

    private KeyResolver(String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        this._resolverSpi = (KeyResolverSpi)Class.forName(className).newInstance();
        this._resolverSpi.setGlobalResolver(true);
    }

    public static int length() {
        return _resolverVector.size();
    }

    public static void hit(Iterator hintI) {
        ResolverIterator hint = (ResolverIterator)hintI;
        int i = hint.i;
        if (i != 1 && hint.res == _resolverVector) {
            List resolverVector = (List)((ArrayList)_resolverVector).clone();
            Object ob = resolverVector.remove(i - 1);
            resolverVector.add(0, ob);
            _resolverVector = resolverVector;
        }
    }

    public static final X509Certificate getX509Certificate(Element element, String BaseURI, StorageResolver storage) throws KeyResolverException {
        List resolverVector = _resolverVector;
        for (int i = 0; i < resolverVector.size(); ++i) {
            X509Certificate cert;
            KeyResolver resolver = (KeyResolver)resolverVector.get(i);
            if (resolver == null) {
                Object[] exArgs = new Object[]{element != null && element.getNodeType() == 1 ? element.getTagName() : "null"};
                throw new KeyResolverException("utils.resolver.noClass", exArgs);
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "check resolvability by class " + resolver.getClass());
            }
            if ((cert = resolver.resolveX509Certificate(element, BaseURI, storage)) == null) continue;
            return cert;
        }
        Object[] exArgs = new Object[]{element != null && element.getNodeType() == 1 ? element.getTagName() : "null"};
        throw new KeyResolverException("utils.resolver.noClass", exArgs);
    }

    public static final PublicKey getPublicKey(Element element, String BaseURI, StorageResolver storage) throws KeyResolverException {
        List resolverVector = _resolverVector;
        for (int i = 0; i < resolverVector.size(); ++i) {
            PublicKey cert;
            KeyResolver resolver = (KeyResolver)resolverVector.get(i);
            if (resolver == null) {
                Object[] exArgs = new Object[]{element != null && element.getNodeType() == 1 ? element.getTagName() : "null"};
                throw new KeyResolverException("utils.resolver.noClass", exArgs);
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "check resolvability by class " + resolver.getClass());
            }
            if ((cert = resolver.resolvePublicKey(element, BaseURI, storage)) == null) continue;
            if (i != 0 && resolverVector == _resolverVector) {
                resolverVector = (List)((ArrayList)_resolverVector).clone();
                Object ob = resolverVector.remove(i);
                resolverVector.add(0, ob);
                _resolverVector = resolverVector;
            }
            return cert;
        }
        Object[] exArgs = new Object[]{element != null && element.getNodeType() == 1 ? element.getTagName() : "null"};
        throw new KeyResolverException("utils.resolver.noClass", exArgs);
    }

    public static void init() {
        if (!_alreadyInitialized) {
            _resolverVector = new ArrayList(10);
            _alreadyInitialized = true;
        }
    }

    public static void register(String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        _resolverVector.add(new KeyResolver(className));
    }

    public static void registerAtStart(String className) {
        _resolverVector.add(0, className);
    }

    public PublicKey resolvePublicKey(Element element, String BaseURI, StorageResolver storage) throws KeyResolverException {
        return this._resolverSpi.engineLookupAndResolvePublicKey(element, BaseURI, storage);
    }

    public X509Certificate resolveX509Certificate(Element element, String BaseURI, StorageResolver storage) throws KeyResolverException {
        return this._resolverSpi.engineLookupResolveX509Certificate(element, BaseURI, storage);
    }

    public SecretKey resolveSecretKey(Element element, String BaseURI, StorageResolver storage) throws KeyResolverException {
        return this._resolverSpi.engineLookupAndResolveSecretKey(element, BaseURI, storage);
    }

    public void setProperty(String key, String value) {
        this._resolverSpi.engineSetProperty(key, value);
    }

    public String getProperty(String key) {
        return this._resolverSpi.engineGetProperty(key);
    }

    public boolean understandsProperty(String propertyToTest) {
        return this._resolverSpi.understandsProperty(propertyToTest);
    }

    public String resolverClassName() {
        return this._resolverSpi.getClass().getName();
    }

    public static Iterator iterator() {
        return new ResolverIterator(_resolverVector);
    }

    static class ResolverIterator
    implements Iterator {
        List res;
        Iterator it;
        int i;

        public ResolverIterator(List list) {
            this.res = list;
            this.it = this.res.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        public Object next() {
            ++this.i;
            KeyResolver resolver = (KeyResolver)this.it.next();
            if (resolver == null) {
                throw new RuntimeException("utils.resolver.noClass");
            }
            return resolver._resolverSpi;
        }

        @Override
        public void remove() {
        }
    }
}

