/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.SoftAudioPusher;
import com.sun.media.sound.SoftJitterCorrector;
import com.sun.media.sound.SoftMixingClip;
import com.sun.media.sound.SoftMixingDataLine;
import com.sun.media.sound.SoftMixingMainMixer;
import com.sun.media.sound.SoftMixingMixerProvider;
import com.sun.media.sound.SoftMixingSourceDataLine;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;

public class SoftMixingMixer
implements Mixer {
    protected static final String INFO_NAME = "Gervill Sound Mixer";
    protected static final String INFO_VENDOR = "OpenJDK Proposal";
    protected static final String INFO_DESCRIPTION = "Software Sound Mixer";
    protected static final String INFO_VERSION = "1.0";
    protected static final Mixer.Info info = new Info();
    protected Object control_mutex = this;
    protected boolean implicitOpen = false;
    private boolean open = false;
    private SoftMixingMainMixer mainmixer = null;
    private AudioFormat format = new AudioFormat(44100.0f, 16, 2, true, false);
    private SourceDataLine sourceDataLine = null;
    private SoftAudioPusher pusher = null;
    private AudioInputStream pusher_stream = null;
    private float controlrate = 147.0f;
    private long latency = 100000L;
    private boolean jitter_correction = false;
    private List<LineListener> listeners = new ArrayList<LineListener>();
    private Line.Info[] sourceLineInfo = new Line.Info[2];

    public SoftMixingMixer() {
        ArrayList<AudioFormat> formats = new ArrayList<AudioFormat>();
        for (int channels = 1; channels <= 2; ++channels) {
            formats.add(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 8, channels, channels, -1.0f, false));
            formats.add(new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, -1.0f, 8, channels, channels, -1.0f, false));
            for (int bits = 16; bits < 32; bits += 8) {
                formats.add(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, bits, channels, channels * bits / 8, -1.0f, false));
                formats.add(new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, -1.0f, bits, channels, channels * bits / 8, -1.0f, false));
                formats.add(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, bits, channels, channels * bits / 8, -1.0f, true));
                formats.add(new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, -1.0f, bits, channels, channels * bits / 8, -1.0f, true));
            }
            formats.add(new AudioFormat(AudioFormat.Encoding.PCM_FLOAT, -1.0f, 32, channels, channels * 4, -1.0f, false));
            formats.add(new AudioFormat(AudioFormat.Encoding.PCM_FLOAT, -1.0f, 32, channels, channels * 4, -1.0f, true));
            formats.add(new AudioFormat(AudioFormat.Encoding.PCM_FLOAT, -1.0f, 64, channels, channels * 8, -1.0f, false));
            formats.add(new AudioFormat(AudioFormat.Encoding.PCM_FLOAT, -1.0f, 64, channels, channels * 8, -1.0f, true));
        }
        AudioFormat[] formats_array = formats.toArray(new AudioFormat[formats.size()]);
        this.sourceLineInfo[0] = new DataLine.Info(SourceDataLine.class, formats_array, -1, -1);
        this.sourceLineInfo[1] = new DataLine.Info(Clip.class, formats_array, -1, -1);
    }

    @Override
    public Line getLine(Line.Info info) throws LineUnavailableException {
        if (!this.isLineSupported(info)) {
            throw new IllegalArgumentException("Line unsupported: " + info);
        }
        if (info.getLineClass() == SourceDataLine.class) {
            return new SoftMixingSourceDataLine(this, (DataLine.Info)info);
        }
        if (info.getLineClass() == Clip.class) {
            return new SoftMixingClip(this, (DataLine.Info)info);
        }
        throw new IllegalArgumentException("Line unsupported: " + info);
    }

    @Override
    public int getMaxLines(Line.Info info) {
        if (info.getLineClass() == SourceDataLine.class) {
            return -1;
        }
        if (info.getLineClass() == Clip.class) {
            return -1;
        }
        return 0;
    }

    @Override
    public Mixer.Info getMixerInfo() {
        return info;
    }

    @Override
    public Line.Info[] getSourceLineInfo() {
        Line.Info[] localArray = new Line.Info[this.sourceLineInfo.length];
        System.arraycopy(this.sourceLineInfo, 0, localArray, 0, this.sourceLineInfo.length);
        return localArray;
    }

    @Override
    public Line.Info[] getSourceLineInfo(Line.Info info) {
        ArrayList<Line.Info> infos = new ArrayList<Line.Info>();
        for (int i = 0; i < this.sourceLineInfo.length; ++i) {
            if (!info.matches(this.sourceLineInfo[i])) continue;
            infos.add(this.sourceLineInfo[i]);
        }
        return infos.toArray(new Line.Info[infos.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Line[] getSourceLines() {
        Line[] localLines;
        Object object = this.control_mutex;
        synchronized (object) {
            if (this.mainmixer == null) {
                return new Line[0];
            }
            SoftMixingDataLine[] sourceLines = this.mainmixer.getOpenLines();
            localLines = new Line[sourceLines.length];
            for (int i = 0; i < localLines.length; ++i) {
                localLines[i] = sourceLines[i];
            }
        }
        return localLines;
    }

    @Override
    public Line.Info[] getTargetLineInfo() {
        return new Line.Info[0];
    }

    @Override
    public Line.Info[] getTargetLineInfo(Line.Info info) {
        return new Line.Info[0];
    }

    @Override
    public Line[] getTargetLines() {
        return new Line[0];
    }

    @Override
    public boolean isLineSupported(Line.Info info) {
        if (info != null) {
            for (int i = 0; i < this.sourceLineInfo.length; ++i) {
                if (!info.matches(this.sourceLineInfo[i])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isSynchronizationSupported(Line[] lines, boolean maintainSync) {
        return false;
    }

    @Override
    public void synchronize(Line[] lines, boolean maintainSync) {
        throw new IllegalArgumentException("Synchronization not supported by this mixer.");
    }

    @Override
    public void unsynchronize(Line[] lines) {
        throw new IllegalArgumentException("Synchronization not supported by this mixer.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLineListener(LineListener listener) {
        Object object = this.control_mutex;
        synchronized (object) {
            this.listeners.add(listener);
        }
    }

    private void sendEvent(LineEvent event) {
        LineListener[] listener_array;
        if (this.listeners.size() == 0) {
            return;
        }
        for (LineListener listener : listener_array = this.listeners.toArray(new LineListener[this.listeners.size()])) {
            listener.update(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.isOpen()) {
            return;
        }
        this.sendEvent(new LineEvent(this, LineEvent.Type.CLOSE, -1L));
        SoftAudioPusher pusher_to_be_closed = null;
        AudioInputStream pusher_stream_to_be_closed = null;
        Object object = this.control_mutex;
        synchronized (object) {
            if (this.pusher != null) {
                pusher_to_be_closed = this.pusher;
                pusher_stream_to_be_closed = this.pusher_stream;
                this.pusher = null;
                this.pusher_stream = null;
            }
        }
        if (pusher_to_be_closed != null) {
            pusher_to_be_closed.stop();
            try {
                pusher_stream_to_be_closed.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        object = this.control_mutex;
        synchronized (object) {
            if (this.mainmixer != null) {
                this.mainmixer.close();
            }
            this.open = false;
            if (this.sourceDataLine != null) {
                this.sourceDataLine.drain();
                this.sourceDataLine.close();
                this.sourceDataLine = null;
            }
        }
    }

    @Override
    public Control getControl(Control.Type control) {
        throw new IllegalArgumentException("Unsupported control type : " + control);
    }

    @Override
    public Control[] getControls() {
        return new Control[0];
    }

    @Override
    public Line.Info getLineInfo() {
        return new Line.Info(Mixer.class);
    }

    @Override
    public boolean isControlSupported(Control.Type control) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOpen() {
        Object object = this.control_mutex;
        synchronized (object) {
            return this.open;
        }
    }

    @Override
    public void open() throws LineUnavailableException {
        if (this.isOpen()) {
            this.implicitOpen = false;
            return;
        }
        this.open(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(SourceDataLine line) throws LineUnavailableException {
        if (this.isOpen()) {
            this.implicitOpen = false;
            return;
        }
        Object object = this.control_mutex;
        synchronized (object) {
            try {
                if (line != null) {
                    this.format = line.getFormat();
                }
                AudioInputStream ais = this.openStream(this.getFormat());
                if (line == null) {
                    Object defaultmixer;
                    Object object2 = SoftMixingMixerProvider.mutex;
                    synchronized (object2) {
                        SoftMixingMixerProvider.lockthread = Thread.currentThread();
                    }
                    try {
                        defaultmixer = AudioSystem.getMixer(null);
                        if (defaultmixer != null) {
                            DataLine.Info idealinfo = null;
                            AudioFormat idealformat = null;
                            Line.Info[] lineinfos = defaultmixer.getSourceLineInfo();
                            block19: for (int i = 0; i < lineinfos.length; ++i) {
                                if (lineinfos[i].getLineClass() != SourceDataLine.class) continue;
                                DataLine.Info info = (DataLine.Info)lineinfos[i];
                                AudioFormat[] formats = info.getFormats();
                                for (int j = 0; j < formats.length; ++j) {
                                    AudioFormat format = formats[j];
                                    if (format.getChannels() != 2 && format.getChannels() != -1 || !format.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED) && !format.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED) || format.getSampleRate() != -1.0f && (double)format.getSampleRate() != 48000.0 || format.getSampleSizeInBits() != -1 && format.getSampleSizeInBits() != 16) continue;
                                    idealinfo = info;
                                    int ideal_channels = format.getChannels();
                                    boolean ideal_signed = format.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED);
                                    float ideal_rate = format.getSampleRate();
                                    boolean ideal_endian = format.isBigEndian();
                                    int ideal_bits = format.getSampleSizeInBits();
                                    if (ideal_bits == -1) {
                                        ideal_bits = 16;
                                    }
                                    if (ideal_channels == -1) {
                                        ideal_channels = 2;
                                    }
                                    if (ideal_rate == -1.0f) {
                                        ideal_rate = 48000.0f;
                                    }
                                    idealformat = new AudioFormat(ideal_rate, ideal_bits, ideal_channels, ideal_signed, ideal_endian);
                                    break block19;
                                }
                            }
                            if (idealformat != null) {
                                this.format = idealformat;
                                line = (SourceDataLine)defaultmixer.getLine(idealinfo);
                            }
                        }
                        if (line == null) {
                            line = AudioSystem.getSourceDataLine(this.format);
                        }
                    }
                    finally {
                        defaultmixer = SoftMixingMixerProvider.mutex;
                        synchronized (defaultmixer) {
                            SoftMixingMixerProvider.lockthread = null;
                        }
                    }
                    if (line == null) {
                        throw new IllegalArgumentException("No line matching " + info.toString() + " is supported.");
                    }
                }
                double latency = this.latency;
                if (!line.isOpen()) {
                    int bufferSize = this.getFormat().getFrameSize() * (int)((double)this.getFormat().getFrameRate() * (latency / 1000000.0));
                    line.open(this.getFormat(), bufferSize);
                    this.sourceDataLine = line;
                }
                if (!line.isActive()) {
                    line.start();
                }
                int controlbuffersize = 512;
                try {
                    controlbuffersize = ais.available();
                }
                catch (IOException e) {
                    // empty catch block
                }
                int buffersize = line.getBufferSize();
                buffersize -= buffersize % controlbuffersize;
                if (buffersize < 3 * controlbuffersize) {
                    buffersize = 3 * controlbuffersize;
                }
                if (this.jitter_correction) {
                    ais = new SoftJitterCorrector(ais, buffersize, controlbuffersize);
                }
                this.pusher = new SoftAudioPusher(line, ais, controlbuffersize);
                this.pusher_stream = ais;
                this.pusher.start();
            }
            catch (LineUnavailableException e) {
                if (this.isOpen()) {
                    this.close();
                }
                throw new LineUnavailableException(e.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioInputStream openStream(AudioFormat targetFormat) throws LineUnavailableException {
        if (this.isOpen()) {
            throw new LineUnavailableException("Mixer is already open");
        }
        Object object = this.control_mutex;
        synchronized (object) {
            this.open = true;
            this.implicitOpen = false;
            if (targetFormat != null) {
                this.format = targetFormat;
            }
            this.mainmixer = new SoftMixingMainMixer(this);
            this.sendEvent(new LineEvent(this, LineEvent.Type.OPEN, -1L));
            return this.mainmixer.getInputStream();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLineListener(LineListener listener) {
        Object object = this.control_mutex;
        synchronized (object) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLatency() {
        Object object = this.control_mutex;
        synchronized (object) {
            return this.latency;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioFormat getFormat() {
        Object object = this.control_mutex;
        synchronized (object) {
            return this.format;
        }
    }

    protected float getControlRate() {
        return this.controlrate;
    }

    protected SoftMixingMainMixer getMainMixer() {
        if (!this.isOpen()) {
            return null;
        }
        return this.mainmixer;
    }

    private static class Info
    extends Mixer.Info {
        public Info() {
            super(SoftMixingMixer.INFO_NAME, SoftMixingMixer.INFO_VENDOR, SoftMixingMixer.INFO_DESCRIPTION, SoftMixingMixer.INFO_VERSION);
        }
    }
}

