/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.SoftAudioBuffer;
import com.sun.media.sound.SoftAudioProcessor;
import com.sun.media.sound.SoftChorus;
import com.sun.media.sound.SoftLimiter;
import com.sun.media.sound.SoftMixingDataLine;
import com.sun.media.sound.SoftMixingMixer;
import com.sun.media.sound.SoftReverb;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.AudioInputStream;

public class SoftMixingMainMixer {
    public static final int CHANNEL_LEFT = 0;
    public static final int CHANNEL_RIGHT = 1;
    public static final int CHANNEL_EFFECT1 = 2;
    public static final int CHANNEL_EFFECT2 = 3;
    public static final int CHANNEL_EFFECT3 = 4;
    public static final int CHANNEL_EFFECT4 = 5;
    public static final int CHANNEL_LEFT_DRY = 10;
    public static final int CHANNEL_RIGHT_DRY = 11;
    public static final int CHANNEL_SCRATCH1 = 12;
    public static final int CHANNEL_SCRATCH2 = 13;
    public static final int CHANNEL_CHANNELMIXER_LEFT = 14;
    public static final int CHANNEL_CHANNELMIXER_RIGHT = 15;
    private SoftMixingMixer mixer;
    private AudioInputStream ais;
    private SoftAudioBuffer[] buffers;
    private SoftAudioProcessor reverb;
    private SoftAudioProcessor chorus;
    private SoftAudioProcessor agc;
    private int nrofchannels;
    private Object control_mutex;
    private List<SoftMixingDataLine> openLinesList = new ArrayList<SoftMixingDataLine>();
    private SoftMixingDataLine[] openLines = new SoftMixingDataLine[0];

    public AudioInputStream getInputStream() {
        return this.ais;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processAudioBuffers() {
        SoftMixingDataLine[] openLines;
        for (int i = 0; i < this.buffers.length; ++i) {
            this.buffers[i].clear();
        }
        Object object = this.control_mutex;
        synchronized (object) {
            openLines = this.openLines;
            for (int i = 0; i < openLines.length; ++i) {
                openLines[i].processControlLogic();
            }
            this.chorus.processControlLogic();
            this.reverb.processControlLogic();
            this.agc.processControlLogic();
        }
        for (int i = 0; i < openLines.length; ++i) {
            openLines[i].processAudioLogic(this.buffers);
        }
        this.chorus.processAudio();
        this.reverb.processAudio();
        this.agc.processAudio();
    }

    public SoftMixingMainMixer(SoftMixingMixer mixer) {
        this.mixer = mixer;
        this.nrofchannels = mixer.getFormat().getChannels();
        int buffersize = (int)(mixer.getFormat().getSampleRate() / mixer.getControlRate());
        this.control_mutex = mixer.control_mutex;
        this.buffers = new SoftAudioBuffer[16];
        for (int i = 0; i < this.buffers.length; ++i) {
            this.buffers[i] = new SoftAudioBuffer(buffersize, mixer.getFormat());
        }
        this.reverb = new SoftReverb();
        this.chorus = new SoftChorus();
        this.agc = new SoftLimiter();
        float samplerate = mixer.getFormat().getSampleRate();
        float controlrate = mixer.getControlRate();
        this.reverb.init(samplerate, controlrate);
        this.chorus.init(samplerate, controlrate);
        this.agc.init(samplerate, controlrate);
        this.reverb.setMixMode(true);
        this.chorus.setMixMode(true);
        this.agc.setMixMode(false);
        this.chorus.setInput(0, this.buffers[3]);
        this.chorus.setOutput(0, this.buffers[0]);
        if (this.nrofchannels != 1) {
            this.chorus.setOutput(1, this.buffers[1]);
        }
        this.chorus.setOutput(2, this.buffers[2]);
        this.reverb.setInput(0, this.buffers[2]);
        this.reverb.setOutput(0, this.buffers[0]);
        if (this.nrofchannels != 1) {
            this.reverb.setOutput(1, this.buffers[1]);
        }
        this.agc.setInput(0, this.buffers[0]);
        if (this.nrofchannels != 1) {
            this.agc.setInput(1, this.buffers[1]);
        }
        this.agc.setOutput(0, this.buffers[0]);
        if (this.nrofchannels != 1) {
            this.agc.setOutput(1, this.buffers[1]);
        }
        InputStream in = new InputStream(){
            private SoftAudioBuffer[] buffers;
            private int nrofchannels;
            private int buffersize;
            private byte[] bbuffer;
            private int bbuffer_pos;
            private byte[] single;
            {
                this.buffers = SoftMixingMainMixer.this.buffers;
                this.nrofchannels = SoftMixingMainMixer.this.mixer.getFormat().getChannels();
                this.buffersize = this.buffers[0].getSize();
                this.bbuffer = new byte[this.buffersize * (SoftMixingMainMixer.this.mixer.getFormat().getSampleSizeInBits() / 8) * this.nrofchannels];
                this.bbuffer_pos = 0;
                this.single = new byte[1];
            }

            public void fillBuffer() {
                SoftMixingMainMixer.this.processAudioBuffers();
                for (int i = 0; i < this.nrofchannels; ++i) {
                    this.buffers[i].get(this.bbuffer, i);
                }
                this.bbuffer_pos = 0;
            }

            @Override
            public int read(byte[] b, int off, int len) {
                int bbuffer_len = this.bbuffer.length;
                int offlen = off + len;
                byte[] bbuffer = this.bbuffer;
                while (off < offlen) {
                    if (this.available() == 0) {
                        this.fillBuffer();
                        continue;
                    }
                    int bbuffer_pos = this.bbuffer_pos;
                    while (off < offlen && bbuffer_pos < bbuffer_len) {
                        b[off++] = bbuffer[bbuffer_pos++];
                    }
                    this.bbuffer_pos = bbuffer_pos;
                }
                return len;
            }

            @Override
            public int read() throws IOException {
                int ret = this.read(this.single);
                if (ret == -1) {
                    return -1;
                }
                return this.single[0] & 0xFF;
            }

            @Override
            public int available() {
                return this.bbuffer.length - this.bbuffer_pos;
            }

            @Override
            public void close() {
                SoftMixingMainMixer.this.mixer.close();
            }
        };
        this.ais = new AudioInputStream(in, mixer.getFormat(), -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openLine(SoftMixingDataLine line) {
        Object object = this.control_mutex;
        synchronized (object) {
            this.openLinesList.add(line);
            this.openLines = this.openLinesList.toArray(new SoftMixingDataLine[this.openLinesList.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeLine(SoftMixingDataLine line) {
        Object object = this.control_mutex;
        synchronized (object) {
            this.openLinesList.remove(line);
            this.openLines = this.openLinesList.toArray(new SoftMixingDataLine[this.openLinesList.size()]);
            if (this.openLines.length == 0 && this.mixer.implicitOpen) {
                this.mixer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SoftMixingDataLine[] getOpenLines() {
        Object object = this.control_mutex;
        synchronized (object) {
            return this.openLines;
        }
    }

    public void close() {
        SoftMixingDataLine[] openLines = this.openLines;
        for (int i = 0; i < openLines.length; ++i) {
            openLines[i].close();
        }
    }
}

