/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.DirectAudioDevice;
import com.sun.media.sound.Platform;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.spi.MixerProvider;

public class DirectAudioDeviceProvider
extends MixerProvider {
    private static DirectAudioDeviceInfo[] infos;
    private static DirectAudioDevice[] devices;

    public DirectAudioDeviceProvider() {
        if (Platform.isDirectAudioEnabled()) {
            DirectAudioDeviceProvider.init();
        } else {
            infos = new DirectAudioDeviceInfo[0];
            devices = new DirectAudioDevice[0];
        }
    }

    private static synchronized void init() {
        int numDevices = DirectAudioDeviceProvider.nGetNumDevices();
        if (infos == null || infos.length != numDevices) {
            infos = new DirectAudioDeviceInfo[numDevices];
            devices = new DirectAudioDevice[numDevices];
            for (int i = 0; i < infos.length; ++i) {
                DirectAudioDeviceProvider.infos[i] = DirectAudioDeviceProvider.nNewDirectAudioDeviceInfo(i);
            }
        }
    }

    @Override
    public Mixer.Info[] getMixerInfo() {
        Mixer.Info[] localArray = new Mixer.Info[infos.length];
        System.arraycopy(infos, 0, localArray, 0, infos.length);
        return localArray;
    }

    @Override
    public Mixer getMixer(Mixer.Info info) {
        int i;
        if (info == null) {
            for (i = 0; i < infos.length; ++i) {
                Mixer mixer = this.getDevice(infos[i]);
                if (mixer.getSourceLineInfo().length <= 0) continue;
                return mixer;
            }
        }
        for (i = 0; i < infos.length; ++i) {
            if (!infos[i].equals(info)) continue;
            return this.getDevice(infos[i]);
        }
        throw new IllegalArgumentException("Mixer " + info.toString() + " not supported by this provider.");
    }

    private Mixer getDevice(DirectAudioDeviceInfo info) {
        int index = info.getIndex();
        if (devices[index] == null) {
            DirectAudioDeviceProvider.devices[index] = new DirectAudioDevice(info);
        }
        return devices[index];
    }

    private static native int nGetNumDevices();

    private static native DirectAudioDeviceInfo nNewDirectAudioDeviceInfo(int var0);

    static {
        Platform.initialize();
    }

    static class DirectAudioDeviceInfo
    extends Mixer.Info {
        private int index;
        private int maxSimulLines;
        private int deviceID;

        private DirectAudioDeviceInfo(int index, int deviceID, int maxSimulLines, String name, String vendor, String description, String version) {
            super(name, vendor, "Direct Audio Device: " + description, version);
            this.index = index;
            this.maxSimulLines = maxSimulLines;
            this.deviceID = deviceID;
        }

        int getIndex() {
            return this.index;
        }

        int getMaxSimulLines() {
            return this.maxSimulLines;
        }

        int getDeviceID() {
            return this.deviceID;
        }
    }
}

