/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.DLSInfo;
import com.sun.media.sound.DLSSampleOptions;
import com.sun.media.sound.ModelByteBuffer;
import java.io.InputStream;
import java.util.Arrays;
import javax.sound.midi.Soundbank;
import javax.sound.midi.SoundbankResource;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;

public class DLSSample
extends SoundbankResource {
    protected byte[] guid = null;
    protected DLSInfo info = new DLSInfo();
    protected DLSSampleOptions sampleoptions;
    protected ModelByteBuffer data;
    protected AudioFormat format;

    public DLSSample(Soundbank soundBank) {
        super(soundBank, null, AudioInputStream.class);
    }

    public DLSSample() {
        super(null, null, AudioInputStream.class);
    }

    public DLSInfo getInfo() {
        return this.info;
    }

    @Override
    public Object getData() {
        AudioFormat format = this.getFormat();
        InputStream is = this.data.getInputStream();
        if (is == null) {
            return null;
        }
        return new AudioInputStream(is, format, this.data.capacity());
    }

    public ModelByteBuffer getDataBuffer() {
        return this.data;
    }

    public AudioFormat getFormat() {
        return this.format;
    }

    public void setFormat(AudioFormat format) {
        this.format = format;
    }

    public void setData(ModelByteBuffer data) {
        this.data = data;
    }

    public void setData(byte[] data) {
        this.data = new ModelByteBuffer(data);
    }

    public void setData(byte[] data, int offset, int length) {
        this.data = new ModelByteBuffer(data, offset, length);
    }

    @Override
    public String getName() {
        return this.info.name;
    }

    public void setName(String name) {
        this.info.name = name;
    }

    public DLSSampleOptions getSampleoptions() {
        return this.sampleoptions;
    }

    public void setSampleoptions(DLSSampleOptions sampleOptions) {
        this.sampleoptions = sampleOptions;
    }

    public String toString() {
        return "Sample: " + this.info.name;
    }

    public byte[] getGuid() {
        return this.guid == null ? null : Arrays.copyOf(this.guid, this.guid.length);
    }

    public void setGuid(byte[] guid) {
        this.guid = guid == null ? null : Arrays.copyOf(guid, guid.length);
    }
}

