/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AiffFileFormat;
import com.sun.media.sound.SunFileReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;

public class AiffFileReader
extends SunFileReader {
    private static final int MAX_READ_LENGTH = 8;
    public static final AudioFileFormat.Type[] types = new AudioFileFormat.Type[]{AudioFileFormat.Type.AIFF};

    @Override
    public AudioFileFormat getAudioFileFormat(InputStream stream) throws UnsupportedAudioFileException, IOException {
        AudioFileFormat aff = this.getCOMM(stream, true);
        stream.reset();
        return aff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AudioFileFormat getAudioFileFormat(URL url) throws UnsupportedAudioFileException, IOException {
        AudioFileFormat fileFormat = null;
        try (InputStream urlStream = url.openStream();){
            fileFormat = this.getCOMM(urlStream, false);
        }
        return fileFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        AudioFileFormat fileFormat = null;
        try (FileInputStream fis = new FileInputStream(file);){
            fileFormat = this.getCOMM(fis, false);
        }
        return fileFormat;
    }

    @Override
    public AudioInputStream getAudioInputStream(InputStream stream) throws UnsupportedAudioFileException, IOException {
        AudioFileFormat fileFormat = this.getCOMM(stream, true);
        return new AudioInputStream(stream, fileFormat.getFormat(), fileFormat.getFrameLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AudioInputStream getAudioInputStream(URL url) throws UnsupportedAudioFileException, IOException {
        InputStream urlStream = url.openStream();
        AudioFileFormat fileFormat = null;
        try {
            fileFormat = this.getCOMM(urlStream, false);
        }
        finally {
            if (fileFormat == null) {
                urlStream.close();
            }
        }
        return new AudioInputStream(urlStream, fileFormat.getFormat(), fileFormat.getFrameLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        FileInputStream fis = new FileInputStream(file);
        AudioFileFormat fileFormat = null;
        try {
            fileFormat = this.getCOMM(fis, false);
        }
        finally {
            if (fileFormat == null) {
                fis.close();
            }
        }
        return new AudioInputStream(fis, fileFormat.getFormat(), fileFormat.getFrameLength());
    }

    private AudioFileFormat getCOMM(InputStream is, boolean doReset) throws UnsupportedAudioFileException, IOException {
        int totallength;
        DataInputStream dis = new DataInputStream(is);
        if (doReset) {
            dis.mark(8);
        }
        int fileRead = 0;
        int dataLength = 0;
        AudioFormat format = null;
        int magic = dis.readInt();
        if (magic != 1179603533) {
            if (doReset) {
                dis.reset();
            }
            throw new UnsupportedAudioFileException("not an AIFF file");
        }
        int length = dis.readInt();
        int iffType = dis.readInt();
        fileRead += 12;
        if (length <= 0) {
            length = -1;
            totallength = -1;
        } else {
            totallength = length + 8;
        }
        boolean aifc = false;
        if (iffType == 1095321155) {
            aifc = true;
        }
        boolean ssndFound = false;
        while (!ssndFound) {
            int toSkip;
            int chunkName = dis.readInt();
            int chunkLen = dis.readInt();
            fileRead += 8;
            int chunkRead = 0;
            switch (chunkName) {
                case 1180058962: {
                    break;
                }
                case 1129270605: {
                    if (!aifc && chunkLen < 18 || aifc && chunkLen < 22) {
                        throw new UnsupportedAudioFileException("Invalid AIFF/COMM chunksize");
                    }
                    short channels = dis.readShort();
                    dis.readInt();
                    int sampleSizeInBits = dis.readShort();
                    float sampleRate = (float)this.read_ieee_extended(dis);
                    chunkRead += 18;
                    AudioFormat.Encoding encoding = AudioFormat.Encoding.PCM_SIGNED;
                    if (aifc) {
                        int enc = dis.readInt();
                        chunkRead += 4;
                        switch (enc) {
                            case 1313820229: {
                                encoding = AudioFormat.Encoding.PCM_SIGNED;
                                break;
                            }
                            case 1970037111: {
                                encoding = AudioFormat.Encoding.ULAW;
                                sampleSizeInBits = 8;
                                break;
                            }
                            default: {
                                throw new UnsupportedAudioFileException("Invalid AIFF encoding");
                            }
                        }
                    }
                    int frameSize = AiffFileReader.calculatePCMFrameSize(sampleSizeInBits, channels);
                    format = new AudioFormat(encoding, sampleRate, sampleSizeInBits, channels, frameSize, sampleRate, true);
                    break;
                }
                case 1397968452: {
                    int dataOffset = dis.readInt();
                    int blocksize = dis.readInt();
                    dataLength = chunkLen < length ? chunkLen - chunkRead : length - (fileRead + (chunkRead += 8));
                    ssndFound = true;
                }
            }
            fileRead += chunkRead;
            if (ssndFound || (toSkip = chunkLen - chunkRead) <= 0) continue;
            fileRead += dis.skipBytes(toSkip);
        }
        if (format == null) {
            throw new UnsupportedAudioFileException("missing COMM chunk");
        }
        AudioFileFormat.Type type = aifc ? AudioFileFormat.Type.AIFC : AudioFileFormat.Type.AIFF;
        return new AiffFileFormat(type, totallength, format, dataLength / format.getFrameSize());
    }

    private void write_ieee_extended(DataOutputStream dos, double f) throws IOException {
        int exponent = 16398;
        double highMantissa = f;
        while (highMantissa < 44000.0) {
            highMantissa *= 2.0;
            --exponent;
        }
        dos.writeShort(exponent);
        dos.writeInt((int)highMantissa << 16);
        dos.writeInt(0);
    }

    private double read_ieee_extended(DataInputStream dis) throws IOException {
        double f = 0.0;
        int expon = 0;
        long hiMant = 0L;
        long loMant = 0L;
        double HUGE = 3.4028234663852886E38;
        expon = dis.readUnsignedShort();
        long t1 = dis.readUnsignedShort();
        long t2 = dis.readUnsignedShort();
        hiMant = t1 << 16 | t2;
        t1 = dis.readUnsignedShort();
        t2 = dis.readUnsignedShort();
        loMant = t1 << 16 | t2;
        if (expon == 0 && hiMant == 0L && loMant == 0L) {
            f = 0.0;
        } else if (expon == Short.MAX_VALUE) {
            f = HUGE;
        } else {
            expon -= 16383;
            f = (double)hiMant * Math.pow(2.0, expon -= 31);
            f += (double)loMant * Math.pow(2.0, expon -= 32);
        }
        return f;
    }
}

