/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.VersionHelper;
import java.net.MalformedURLException;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;

final class VersionHelper12
extends VersionHelper {
    private static final String TRUST_URL_CODEBASE_PROPERTY = "com.sun.jndi.ldap.object.trustURLCodebase";
    private static final String trustURLCodebase = AccessController.doPrivileged(new PrivilegedAction<String>(){

        @Override
        public String run() {
            return System.getProperty(VersionHelper12.TRUST_URL_CODEBASE_PROPERTY, "false");
        }
    });

    VersionHelper12() {
    }

    @Override
    ClassLoader getURLClassLoader(String[] url) throws MalformedURLException {
        ClassLoader parent = this.getContextClassLoader();
        if (url != null && "true".equalsIgnoreCase(trustURLCodebase)) {
            return URLClassLoader.newInstance(VersionHelper12.getUrlArray(url), parent);
        }
        return parent;
    }

    @Override
    Class loadClass(String className) throws ClassNotFoundException {
        ClassLoader cl = this.getContextClassLoader();
        return Class.forName(className, true, cl);
    }

    private ClassLoader getContextClassLoader() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    @Override
    Thread createThread(final Runnable r) {
        return (Thread)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Thread(r);
            }
        });
    }
}

