/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.BindingWithControls;
import com.sun.jndi.ldap.LdapCtx;
import com.sun.jndi.ldap.LdapNamingEnumeration;
import com.sun.jndi.ldap.LdapReferralContext;
import com.sun.jndi.ldap.LdapResult;
import com.sun.jndi.ldap.Obj;
import com.sun.jndi.toolkit.ctx.Continuation;
import java.util.Vector;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.spi.DirectoryManager;

final class LdapBindingEnumeration
extends LdapNamingEnumeration {
    LdapBindingEnumeration(LdapCtx homeCtx, LdapResult answer, Name remain, Continuation cont) throws NamingException {
        super(homeCtx, answer, remain, cont);
    }

    @Override
    protected NameClassPair createItem(String dn, Attributes attrs, Vector respCtls) throws NamingException {
        Object obj = null;
        String atom = this.getAtom(dn);
        if (attrs.get(Obj.JAVA_ATTRIBUTES[2]) != null) {
            obj = Obj.decodeObject(attrs);
        }
        if (obj == null) {
            obj = new LdapCtx(this.homeCtx, dn);
        }
        CompositeName cn = new CompositeName();
        cn.add(atom);
        try {
            obj = DirectoryManager.getObjectInstance(obj, cn, this.homeCtx, this.homeCtx.envprops, attrs);
        }
        catch (NamingException e) {
            throw e;
        }
        catch (Exception e) {
            NamingException ne = new NamingException("problem generating object using object factory");
            ne.setRootCause(e);
            throw ne;
        }
        Binding binding = respCtls != null ? new BindingWithControls(cn.toString(), obj, this.homeCtx.convertControls(respCtls)) : new Binding(cn.toString(), obj);
        binding.setNameInNamespace(dn);
        return binding;
    }

    @Override
    protected LdapNamingEnumeration getReferredResults(LdapReferralContext refCtx) throws NamingException {
        return (LdapNamingEnumeration)refCtx.listBindings(this.listArg);
    }
}

