/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.internal;

import com.sun.jmx.remote.internal.ArrayQueue;
import com.sun.jmx.remote.internal.NotificationBuffer;
import com.sun.jmx.remote.internal.NotificationBufferFilter;
import com.sun.jmx.remote.util.ClassLogger;
import com.sun.jmx.remote.util.EnvHelp;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.QueryEval;
import javax.management.QueryExp;
import javax.management.remote.NotificationResult;
import javax.management.remote.TargetedNotification;

public class ArrayNotificationBuffer
implements NotificationBuffer {
    private boolean disposed = false;
    private static final Object globalLock = new Object();
    private static final HashMap<MBeanServer, ArrayNotificationBuffer> mbsToBuffer = new HashMap(1);
    private final Collection<ShareBuffer> sharers = new HashSet<ShareBuffer>(1);
    private final NotificationListener bufferListener = new BufferListener();
    private static final QueryExp broadcasterQuery = new BroadcasterQuery();
    private static final NotificationFilter creationFilter;
    private final NotificationListener creationListener = new NotificationListener(){

        @Override
        public void handleNotification(Notification notif, Object handback) {
            logger.debug("creationListener", "handleNotification called");
            ArrayNotificationBuffer.this.createdNotification((MBeanServerNotification)notif);
        }
    };
    private static final ClassLogger logger;
    private final MBeanServer mBeanServer;
    private final ArrayQueue<NamedNotification> queue;
    private int queueSize;
    private long earliestSequenceNumber;
    private long nextSequenceNumber;
    private Set<ObjectName> createdDuringQuery;
    static final String broadcasterClass;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NotificationBuffer getNotificationBuffer(MBeanServer mbs, Map<String, ?> env) {
        ShareBuffer sharer;
        boolean create;
        ArrayNotificationBuffer buf;
        if (env == null) {
            env = Collections.emptyMap();
        }
        int queueSize = EnvHelp.getNotifBufferSize(env);
        Object object = globalLock;
        synchronized (object) {
            buf = mbsToBuffer.get(mbs);
            boolean bl = create = buf == null;
            if (create) {
                buf = new ArrayNotificationBuffer(mbs, queueSize);
                mbsToBuffer.put(mbs, buf);
            }
            ArrayNotificationBuffer arrayNotificationBuffer = buf;
            arrayNotificationBuffer.getClass();
            sharer = arrayNotificationBuffer.new ShareBuffer(queueSize);
        }
        if (create) {
            buf.createListeners();
        }
        return sharer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeNotificationBuffer(MBeanServer mbs) {
        Object object = globalLock;
        synchronized (object) {
            mbsToBuffer.remove(mbs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSharer(ShareBuffer sharer) {
        Object object = globalLock;
        synchronized (object) {
            ArrayNotificationBuffer arrayNotificationBuffer = this;
            synchronized (arrayNotificationBuffer) {
                if (sharer.getSize() > this.queueSize) {
                    this.resize(sharer.getSize());
                }
            }
            this.sharers.add(sharer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSharer(ShareBuffer sharer) {
        boolean empty;
        Object object = globalLock;
        synchronized (object) {
            this.sharers.remove(sharer);
            empty = this.sharers.isEmpty();
            if (empty) {
                ArrayNotificationBuffer.removeNotificationBuffer(this.mBeanServer);
            } else {
                int max = 0;
                for (ShareBuffer buf : this.sharers) {
                    int bufsize = buf.getSize();
                    if (bufsize <= max) continue;
                    max = bufsize;
                }
                if (max < this.queueSize) {
                    this.resize(max);
                }
            }
        }
        if (empty) {
            object = this;
            synchronized (object) {
                this.disposed = true;
                this.notifyAll();
            }
            this.destroyListeners();
        }
    }

    private synchronized void resize(int newSize) {
        if (newSize == this.queueSize) {
            return;
        }
        while (this.queue.size() > newSize) {
            this.dropNotification();
        }
        this.queue.resize(newSize);
        this.queueSize = newSize;
    }

    private ArrayNotificationBuffer(MBeanServer mbs, int queueSize) {
        if (logger.traceOn()) {
            logger.trace("Constructor", "queueSize=" + queueSize);
        }
        if (mbs == null || queueSize < 1) {
            throw new IllegalArgumentException("Bad args");
        }
        this.mBeanServer = mbs;
        this.queueSize = queueSize;
        this.queue = new ArrayQueue(queueSize);
        this.nextSequenceNumber = this.earliestSequenceNumber = System.currentTimeMillis();
        logger.trace("Constructor", "ends");
    }

    private synchronized boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public void dispose() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NotificationResult fetchNotifications(NotificationBufferFilter filter, long startSequenceNumber, long timeout, int maxNotifications) throws InterruptedException {
        logger.trace("fetchNotifications", "starts");
        if (startSequenceNumber < 0L || this.isDisposed()) {
            ArrayNotificationBuffer arrayNotificationBuffer = this;
            synchronized (arrayNotificationBuffer) {
                return new NotificationResult(this.earliestSequenceNumber(), this.nextSequenceNumber(), new TargetedNotification[0]);
            }
        }
        if (filter == null || startSequenceNumber < 0L || timeout < 0L || maxNotifications < 0) {
            logger.trace("fetchNotifications", "Bad args");
            throw new IllegalArgumentException("Bad args to fetch");
        }
        if (logger.debugOn()) {
            logger.trace("fetchNotifications", "filter=" + filter + "; startSeq=" + startSequenceNumber + "; timeout=" + timeout + "; max=" + maxNotifications);
        }
        if (startSequenceNumber > this.nextSequenceNumber()) {
            String msg = "Start sequence number too big: " + startSequenceNumber + " > " + this.nextSequenceNumber();
            logger.trace("fetchNotifications", msg);
            throw new IllegalArgumentException(msg);
        }
        long endTime = System.currentTimeMillis() + timeout;
        if (endTime < 0L) {
            endTime = Long.MAX_VALUE;
        }
        if (logger.debugOn()) {
            logger.debug("fetchNotifications", "endTime=" + endTime);
        }
        long earliestSeq = -1L;
        long nextSeq = startSequenceNumber;
        ArrayList<TargetedNotification> notifs = new ArrayList<TargetedNotification>();
        while (true) {
            NamedNotification candidate;
            logger.debug("fetchNotifications", "main loop starts");
            ArrayNotificationBuffer arrayNotificationBuffer = this;
            synchronized (arrayNotificationBuffer) {
                if (earliestSeq < 0L) {
                    earliestSeq = this.earliestSequenceNumber();
                    if (logger.debugOn()) {
                        logger.debug("fetchNotifications", "earliestSeq=" + earliestSeq);
                    }
                    if (nextSeq < earliestSeq) {
                        nextSeq = earliestSeq;
                        logger.debug("fetchNotifications", "nextSeq=earliestSeq");
                    }
                } else {
                    earliestSeq = this.earliestSequenceNumber();
                }
                if (nextSeq < earliestSeq) {
                    logger.trace("fetchNotifications", "nextSeq=" + nextSeq + " < " + "earliestSeq=" + earliestSeq + " so may have lost notifs");
                    break;
                }
                if (nextSeq < this.nextSequenceNumber()) {
                    candidate = this.notificationAt(nextSeq);
                    if (logger.debugOn()) {
                        logger.debug("fetchNotifications", "candidate: " + candidate);
                        logger.debug("fetchNotifications", "nextSeq now " + nextSeq);
                    }
                } else {
                    if (notifs.size() > 0) {
                        logger.debug("fetchNotifications", "no more notifs but have some so don't wait");
                        break;
                    }
                    long toWait = endTime - System.currentTimeMillis();
                    if (toWait <= 0L) {
                        logger.debug("fetchNotifications", "timeout");
                        break;
                    }
                    if (this.isDisposed()) {
                        if (logger.debugOn()) {
                            logger.debug("fetchNotifications", "dispose callled, no wait");
                        }
                        return new NotificationResult(this.earliestSequenceNumber(), this.nextSequenceNumber(), new TargetedNotification[0]);
                    }
                    if (logger.debugOn()) {
                        logger.debug("fetchNotifications", "wait(" + toWait + ")");
                    }
                    this.wait(toWait);
                    continue;
                }
            }
            ObjectName name = candidate.getObjectName();
            Notification notif = candidate.getNotification();
            ArrayList<TargetedNotification> matchedNotifs = new ArrayList<TargetedNotification>();
            logger.debug("fetchNotifications", "applying filter to candidate");
            filter.apply(matchedNotifs, name, notif);
            if (matchedNotifs.size() > 0) {
                if (maxNotifications <= 0) {
                    logger.debug("fetchNotifications", "reached maxNotifications");
                    break;
                }
                --maxNotifications;
                if (logger.debugOn()) {
                    logger.debug("fetchNotifications", "add: " + matchedNotifs);
                }
                notifs.addAll(matchedNotifs);
            }
            ++nextSeq;
        }
        int nnotifs = notifs.size();
        TargetedNotification[] resultNotifs = new TargetedNotification[nnotifs];
        notifs.toArray(resultNotifs);
        NotificationResult nr = new NotificationResult(earliestSeq, nextSeq, resultNotifs);
        if (logger.debugOn()) {
            logger.debug("fetchNotifications", nr.toString());
        }
        logger.trace("fetchNotifications", "ends");
        return nr;
    }

    synchronized long earliestSequenceNumber() {
        return this.earliestSequenceNumber;
    }

    synchronized long nextSequenceNumber() {
        return this.nextSequenceNumber;
    }

    synchronized void addNotification(NamedNotification notif) {
        if (logger.traceOn()) {
            logger.trace("addNotification", notif.toString());
        }
        while (this.queue.size() >= this.queueSize) {
            this.dropNotification();
            if (!logger.debugOn()) continue;
            logger.debug("addNotification", "dropped oldest notif, earliestSeq=" + this.earliestSequenceNumber);
        }
        this.queue.add(notif);
        ++this.nextSequenceNumber;
        if (logger.debugOn()) {
            logger.debug("addNotification", "nextSeq=" + this.nextSequenceNumber);
        }
        this.notifyAll();
    }

    private void dropNotification() {
        this.queue.remove(0);
        ++this.earliestSequenceNumber;
    }

    synchronized NamedNotification notificationAt(long seqNo) {
        long index = seqNo - this.earliestSequenceNumber;
        if (index < 0L || index > Integer.MAX_VALUE) {
            String msg = "Bad sequence number: " + seqNo + " (earliest " + this.earliestSequenceNumber + ")";
            logger.trace("notificationAt", msg);
            throw new IllegalArgumentException(msg);
        }
        return this.queue.get((int)index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createListeners() {
        logger.debug("createListeners", "starts");
        ArrayNotificationBuffer arrayNotificationBuffer = this;
        synchronized (arrayNotificationBuffer) {
            this.createdDuringQuery = new HashSet<ObjectName>();
        }
        try {
            this.addNotificationListener(MBeanServerDelegate.DELEGATE_NAME, this.creationListener, creationFilter, null);
            logger.debug("createListeners", "added creationListener");
        }
        catch (Exception e) {
            String msg = "Can't add listener to MBean server delegate: ";
            IllegalArgumentException re = new IllegalArgumentException("Can't add listener to MBean server delegate: " + e);
            EnvHelp.initCause(re, e);
            logger.fine("createListeners", "Can't add listener to MBean server delegate: " + e);
            logger.debug("createListeners", e);
            throw re;
        }
        Set<ObjectName> names = this.queryNames(null, broadcasterQuery);
        names = new HashSet<ObjectName>(names);
        ArrayNotificationBuffer msg = this;
        synchronized (msg) {
            names.addAll(this.createdDuringQuery);
            this.createdDuringQuery = null;
        }
        for (ObjectName name : names) {
            this.addBufferListener(name);
        }
        logger.debug("createListeners", "ends");
    }

    private void addBufferListener(ObjectName name) {
        this.checkNoLocks();
        if (logger.debugOn()) {
            logger.debug("addBufferListener", name.toString());
        }
        try {
            this.addNotificationListener(name, this.bufferListener, null, name);
        }
        catch (Exception e) {
            logger.trace("addBufferListener", e);
        }
    }

    private void removeBufferListener(ObjectName name) {
        this.checkNoLocks();
        if (logger.debugOn()) {
            logger.debug("removeBufferListener", name.toString());
        }
        try {
            this.removeNotificationListener(name, this.bufferListener);
        }
        catch (Exception e) {
            logger.trace("removeBufferListener", e);
        }
    }

    private void addNotificationListener(final ObjectName name, final NotificationListener listener, final NotificationFilter filter, final Object handback) throws Exception {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws InstanceNotFoundException {
                    ArrayNotificationBuffer.this.mBeanServer.addNotificationListener(name, listener, filter, handback);
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw ArrayNotificationBuffer.extractException(e);
        }
    }

    private void removeNotificationListener(final ObjectName name, final NotificationListener listener) throws Exception {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    ArrayNotificationBuffer.this.mBeanServer.removeNotificationListener(name, listener);
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw ArrayNotificationBuffer.extractException(e);
        }
    }

    private Set<ObjectName> queryNames(final ObjectName name, final QueryExp query) {
        PrivilegedAction<Set<ObjectName>> act = new PrivilegedAction<Set<ObjectName>>(){

            @Override
            public Set<ObjectName> run() {
                return ArrayNotificationBuffer.this.mBeanServer.queryNames(name, query);
            }
        };
        try {
            return AccessController.doPrivileged(act);
        }
        catch (RuntimeException e) {
            logger.fine("queryNames", "Failed to query names: " + e);
            logger.debug("queryNames", e);
            throw e;
        }
    }

    private static boolean isInstanceOf(final MBeanServer mbs, final ObjectName name, final String className) {
        PrivilegedExceptionAction<Boolean> act = new PrivilegedExceptionAction<Boolean>(){

            @Override
            public Boolean run() throws InstanceNotFoundException {
                return mbs.isInstanceOf(name, className);
            }
        };
        try {
            return AccessController.doPrivileged(act);
        }
        catch (Exception e) {
            logger.fine("isInstanceOf", "failed: " + e);
            logger.debug("isInstanceOf", e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createdNotification(MBeanServerNotification n) {
        String shouldEqual = "JMX.mbean.registered";
        if (!n.getType().equals("JMX.mbean.registered")) {
            logger.warning("createNotification", "bad type: " + n.getType());
            return;
        }
        ObjectName name = n.getMBeanName();
        if (logger.debugOn()) {
            logger.debug("createdNotification", "for: " + name);
        }
        ArrayNotificationBuffer arrayNotificationBuffer = this;
        synchronized (arrayNotificationBuffer) {
            if (this.createdDuringQuery != null) {
                this.createdDuringQuery.add(name);
                return;
            }
        }
        if (ArrayNotificationBuffer.isInstanceOf(this.mBeanServer, name, broadcasterClass)) {
            this.addBufferListener(name);
            if (this.isDisposed()) {
                this.removeBufferListener(name);
            }
        }
    }

    private void destroyListeners() {
        this.checkNoLocks();
        logger.debug("destroyListeners", "starts");
        try {
            this.removeNotificationListener(MBeanServerDelegate.DELEGATE_NAME, this.creationListener);
        }
        catch (Exception e) {
            logger.warning("remove listener from MBeanServer delegate", e);
        }
        Set<ObjectName> names = this.queryNames(null, broadcasterQuery);
        for (ObjectName name : names) {
            if (logger.debugOn()) {
                logger.debug("destroyListeners", "remove listener from " + name);
            }
            this.removeBufferListener(name);
        }
        logger.debug("destroyListeners", "ends");
    }

    private void checkNoLocks() {
        if (Thread.holdsLock(this) || Thread.holdsLock(globalLock)) {
            logger.warning("checkNoLocks", "lock protocol violation");
        }
    }

    private static Exception extractException(Exception e) {
        while (e instanceof PrivilegedActionException) {
            e = ((PrivilegedActionException)e).getException();
        }
        return e;
    }

    static {
        NotificationFilterSupport nfs = new NotificationFilterSupport();
        nfs.enableType("JMX.mbean.registered");
        creationFilter = nfs;
        logger = new ClassLogger("javax.management.remote.misc", "ArrayNotificationBuffer");
        broadcasterClass = NotificationBroadcaster.class.getName();
    }

    private static class BroadcasterQuery
    extends QueryEval
    implements QueryExp {
        private static final long serialVersionUID = 7378487660587592048L;

        private BroadcasterQuery() {
        }

        @Override
        public boolean apply(ObjectName name) {
            MBeanServer mbs = QueryEval.getMBeanServer();
            return ArrayNotificationBuffer.isInstanceOf(mbs, name, broadcasterClass);
        }
    }

    private class BufferListener
    implements NotificationListener {
        private BufferListener() {
        }

        @Override
        public void handleNotification(Notification notif, Object handback) {
            if (logger.debugOn()) {
                logger.debug("BufferListener.handleNotification", "notif=" + notif + "; handback=" + handback);
            }
            ObjectName name = (ObjectName)handback;
            ArrayNotificationBuffer.this.addNotification(new NamedNotification(name, notif));
        }
    }

    private static class NamedNotification {
        private final ObjectName sender;
        private final Notification notification;

        NamedNotification(ObjectName sender, Notification notif) {
            this.sender = sender;
            this.notification = notif;
        }

        ObjectName getObjectName() {
            return this.sender;
        }

        Notification getNotification() {
            return this.notification;
        }

        public String toString() {
            return "NamedNotification(" + this.sender + ", " + this.notification + ")";
        }
    }

    private class ShareBuffer
    implements NotificationBuffer {
        private final int size;

        ShareBuffer(int size) {
            this.size = size;
            ArrayNotificationBuffer.this.addSharer(this);
        }

        @Override
        public NotificationResult fetchNotifications(NotificationBufferFilter filter, long startSequenceNumber, long timeout, int maxNotifications) throws InterruptedException {
            ArrayNotificationBuffer buf = ArrayNotificationBuffer.this;
            return buf.fetchNotifications(filter, startSequenceNumber, timeout, maxNotifications);
        }

        @Override
        public void dispose() {
            ArrayNotificationBuffer.this.removeSharer(this);
        }

        int getSize() {
            return this.size;
        }
    }
}

