/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.interceptor.DefaultMBeanServerInterceptor;
import com.sun.jmx.mbeanserver.ClassLoaderRepositorySupport;
import com.sun.jmx.mbeanserver.MBeanInstantiator;
import com.sun.jmx.mbeanserver.MBeanServerDelegateImpl;
import com.sun.jmx.mbeanserver.ModifiableClassLoaderRepository;
import com.sun.jmx.mbeanserver.Repository;
import com.sun.jmx.mbeanserver.SecureClassLoaderRepository;
import com.sun.jmx.mbeanserver.SunJmxMBeanServer;
import java.io.ObjectInputStream;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanPermission;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import javax.management.loading.ClassLoaderRepository;

public final class JmxMBeanServer
implements SunJmxMBeanServer {
    public static final boolean DEFAULT_FAIR_LOCK_POLICY = true;
    private final MBeanInstantiator instantiator;
    private final SecureClassLoaderRepository secureClr;
    private final boolean interceptorsEnabled;
    private final MBeanServer outerShell;
    private volatile MBeanServer mbsInterceptor = null;
    private final MBeanServerDelegate mBeanServerDelegateObject;

    JmxMBeanServer(String domain, MBeanServer outer, MBeanServerDelegate delegate) {
        this(domain, outer, delegate, null, false);
    }

    JmxMBeanServer(String domain, MBeanServer outer, MBeanServerDelegate delegate, boolean interceptors) {
        this(domain, outer, delegate, null, false);
    }

    JmxMBeanServer(String domain, MBeanServer outer, MBeanServerDelegate delegate, MBeanInstantiator instantiator, boolean interceptors) {
        this(domain, outer, delegate, instantiator, interceptors, true);
    }

    JmxMBeanServer(String domain, MBeanServer outer, MBeanServerDelegate delegate, MBeanInstantiator instantiator, boolean interceptors, boolean fairLock) {
        if (instantiator == null) {
            ClassLoaderRepositorySupport clr = new ClassLoaderRepositorySupport();
            instantiator = new MBeanInstantiator(clr);
        }
        this.secureClr = new SecureClassLoaderRepository(instantiator.getClassLoaderRepository());
        if (delegate == null) {
            delegate = new MBeanServerDelegateImpl();
        }
        if (outer == null) {
            outer = this;
        }
        this.instantiator = instantiator;
        this.mBeanServerDelegateObject = delegate;
        this.outerShell = outer;
        Repository repository = new Repository(domain);
        this.mbsInterceptor = new DefaultMBeanServerInterceptor(outer, delegate, instantiator, repository);
        this.interceptorsEnabled = interceptors;
        this.initialize();
    }

    @Override
    public boolean interceptorsEnabled() {
        return this.interceptorsEnabled;
    }

    @Override
    public MBeanInstantiator getMBeanInstantiator() {
        if (this.interceptorsEnabled) {
            return this.instantiator;
        }
        throw new UnsupportedOperationException("MBeanServerInterceptors are disabled.");
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        return this.mbsInterceptor.createMBean(className, this.cloneObjectName(name), null, null);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.mbsInterceptor.createMBean(className, this.cloneObjectName(name), loaderName, null, null);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        return this.mbsInterceptor.createMBean(className, this.cloneObjectName(name), params, signature);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.mbsInterceptor.createMBean(className, this.cloneObjectName(name), loaderName, params, signature);
    }

    @Override
    public ObjectInstance registerMBean(Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        return this.mbsInterceptor.registerMBean(object, this.cloneObjectName(name));
    }

    @Override
    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        this.mbsInterceptor.unregisterMBean(this.cloneObjectName(name));
    }

    @Override
    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        return this.mbsInterceptor.getObjectInstance(this.cloneObjectName(name));
    }

    @Override
    public Set<ObjectInstance> queryMBeans(ObjectName name, QueryExp query) {
        return this.mbsInterceptor.queryMBeans(this.cloneObjectName(name), query);
    }

    @Override
    public Set<ObjectName> queryNames(ObjectName name, QueryExp query) {
        return this.mbsInterceptor.queryNames(this.cloneObjectName(name), query);
    }

    @Override
    public boolean isRegistered(ObjectName name) {
        return this.mbsInterceptor.isRegistered(name);
    }

    @Override
    public Integer getMBeanCount() {
        return this.mbsInterceptor.getMBeanCount();
    }

    @Override
    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        return this.mbsInterceptor.getAttribute(this.cloneObjectName(name), attribute);
    }

    @Override
    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        return this.mbsInterceptor.getAttributes(this.cloneObjectName(name), attributes);
    }

    @Override
    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.mbsInterceptor.setAttribute(this.cloneObjectName(name), this.cloneAttribute(attribute));
    }

    @Override
    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        return this.mbsInterceptor.setAttributes(this.cloneObjectName(name), this.cloneAttributeList(attributes));
    }

    @Override
    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        return this.mbsInterceptor.invoke(this.cloneObjectName(name), operationName, params, signature);
    }

    @Override
    public String getDefaultDomain() {
        return this.mbsInterceptor.getDefaultDomain();
    }

    @Override
    public String[] getDomains() {
        return this.mbsInterceptor.getDomains();
    }

    @Override
    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        this.mbsInterceptor.addNotificationListener(this.cloneObjectName(name), listener, filter, handback);
    }

    @Override
    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        this.mbsInterceptor.addNotificationListener(this.cloneObjectName(name), listener, filter, handback);
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.mbsInterceptor.removeNotificationListener(this.cloneObjectName(name), listener);
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        this.mbsInterceptor.removeNotificationListener(this.cloneObjectName(name), listener, filter, handback);
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.mbsInterceptor.removeNotificationListener(this.cloneObjectName(name), listener);
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        this.mbsInterceptor.removeNotificationListener(this.cloneObjectName(name), listener, filter, handback);
    }

    @Override
    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        return this.mbsInterceptor.getMBeanInfo(this.cloneObjectName(name));
    }

    @Override
    public Object instantiate(String className) throws ReflectionException, MBeanException {
        JmxMBeanServer.checkMBeanPermission(className, null, null, "instantiate");
        return this.instantiator.instantiate(className);
    }

    @Override
    public Object instantiate(String className, ObjectName loaderName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        JmxMBeanServer.checkMBeanPermission(className, null, null, "instantiate");
        ClassLoader myLoader = this.outerShell.getClass().getClassLoader();
        return this.instantiator.instantiate(className, loaderName, myLoader);
    }

    @Override
    public Object instantiate(String className, Object[] params, String[] signature) throws ReflectionException, MBeanException {
        JmxMBeanServer.checkMBeanPermission(className, null, null, "instantiate");
        ClassLoader myLoader = this.outerShell.getClass().getClassLoader();
        return this.instantiator.instantiate(className, params, signature, myLoader);
    }

    @Override
    public Object instantiate(String className, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, MBeanException, InstanceNotFoundException {
        JmxMBeanServer.checkMBeanPermission(className, null, null, "instantiate");
        ClassLoader myLoader = this.outerShell.getClass().getClassLoader();
        return this.instantiator.instantiate(className, loaderName, params, signature, myLoader);
    }

    @Override
    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException {
        return this.mbsInterceptor.isInstanceOf(this.cloneObjectName(name), className);
    }

    @Override
    @Deprecated
    public ObjectInputStream deserialize(ObjectName name, byte[] data) throws InstanceNotFoundException, OperationsException {
        ClassLoader loader = this.getClassLoaderFor(name);
        return this.instantiator.deserialize(loader, data);
    }

    @Override
    @Deprecated
    public ObjectInputStream deserialize(String className, byte[] data) throws OperationsException, ReflectionException {
        Class<?> theClass;
        if (className == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(), "Null className passed in parameter");
        }
        ClassLoaderRepository clr = this.getClassLoaderRepository();
        try {
            if (clr == null) {
                throw new ClassNotFoundException(className);
            }
            theClass = clr.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new ReflectionException(e, "The given class could not be loaded by the default loader repository");
        }
        return this.instantiator.deserialize(theClass.getClassLoader(), data);
    }

    @Override
    @Deprecated
    public ObjectInputStream deserialize(String className, ObjectName loaderName, byte[] data) throws InstanceNotFoundException, OperationsException, ReflectionException {
        loaderName = this.cloneObjectName(loaderName);
        try {
            this.getClassLoader(loaderName);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception e) {
            // empty catch block
        }
        ClassLoader myLoader = this.outerShell.getClass().getClassLoader();
        return this.instantiator.deserialize(className, loaderName, data, myLoader);
    }

    private void initialize() {
        if (this.instantiator == null) {
            throw new IllegalStateException("instantiator must not be null.");
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    JmxMBeanServer.this.mbsInterceptor.registerMBean(JmxMBeanServer.this.mBeanServerDelegateObject, MBeanServerDelegate.DELEGATE_NAME);
                    return null;
                }
            });
        }
        catch (SecurityException e) {
            if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINEST, JmxMBeanServer.class.getName(), "initialize", "Unexpected security exception occurred", e);
            }
            throw e;
        }
        catch (Exception e) {
            if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINEST, JmxMBeanServer.class.getName(), "initialize", "Unexpected exception occurred", e);
            }
            throw new IllegalStateException("Can't register delegate.", e);
        }
        ClassLoader myLoader = this.outerShell.getClass().getClassLoader();
        ModifiableClassLoaderRepository loaders = this.instantiator.getClassLoaderRepository();
        if (loaders != null) {
            loaders.addClassLoader(myLoader);
            ClassLoader systemLoader = ClassLoader.getSystemClassLoader();
            if (systemLoader != myLoader) {
                loaders.addClassLoader(systemLoader);
            }
        }
    }

    @Override
    public synchronized MBeanServer getMBeanServerInterceptor() {
        if (this.interceptorsEnabled) {
            return this.mbsInterceptor;
        }
        throw new UnsupportedOperationException("MBeanServerInterceptors are disabled.");
    }

    @Override
    public synchronized void setMBeanServerInterceptor(MBeanServer interceptor) {
        if (!this.interceptorsEnabled) {
            throw new UnsupportedOperationException("MBeanServerInterceptors are disabled.");
        }
        if (interceptor == null) {
            throw new IllegalArgumentException("MBeanServerInterceptor is null");
        }
        this.mbsInterceptor = interceptor;
    }

    @Override
    public ClassLoader getClassLoaderFor(ObjectName mbeanName) throws InstanceNotFoundException {
        return this.mbsInterceptor.getClassLoaderFor(this.cloneObjectName(mbeanName));
    }

    @Override
    public ClassLoader getClassLoader(ObjectName loaderName) throws InstanceNotFoundException {
        return this.mbsInterceptor.getClassLoader(this.cloneObjectName(loaderName));
    }

    @Override
    public ClassLoaderRepository getClassLoaderRepository() {
        JmxMBeanServer.checkMBeanPermission(null, null, null, "getClassLoaderRepository");
        return this.secureClr;
    }

    @Override
    public MBeanServerDelegate getMBeanServerDelegate() {
        if (!this.interceptorsEnabled) {
            throw new UnsupportedOperationException("MBeanServerInterceptors are disabled.");
        }
        return this.mBeanServerDelegateObject;
    }

    public static MBeanServerDelegate newMBeanServerDelegate() {
        return new MBeanServerDelegateImpl();
    }

    public static MBeanServer newMBeanServer(String defaultDomain, MBeanServer outer, MBeanServerDelegate delegate, boolean interceptors) {
        boolean fairLock = true;
        return new JmxMBeanServer(defaultDomain, outer, delegate, null, interceptors, true);
    }

    private ObjectName cloneObjectName(ObjectName name) {
        if (name != null) {
            return ObjectName.getInstance(name);
        }
        return name;
    }

    private Attribute cloneAttribute(Attribute attribute) {
        if (attribute != null && !attribute.getClass().equals(Attribute.class)) {
            return new Attribute(attribute.getName(), attribute.getValue());
        }
        return attribute;
    }

    private AttributeList cloneAttributeList(AttributeList list) {
        if (list != null) {
            List<Attribute> alist = list.asList();
            if (!list.getClass().equals(AttributeList.class)) {
                AttributeList newList = new AttributeList(alist.size());
                for (Attribute attribute : alist) {
                    newList.add(this.cloneAttribute(attribute));
                }
                return newList;
            }
            for (int i = 0; i < alist.size(); ++i) {
                Attribute attribute = alist.get(i);
                if (attribute.getClass().equals(Attribute.class)) continue;
                list.set(i, this.cloneAttribute(attribute));
            }
            return list;
        }
        return list;
    }

    private static void checkMBeanPermission(String classname, String member, ObjectName objectName, String actions2) throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            MBeanPermission perm = new MBeanPermission(classname, member, objectName, actions2);
            sm.checkPermission(perm);
        }
    }
}

