/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.mbeanserver.MBeanAnalyzer;
import com.sun.jmx.mbeanserver.MBeanIntrospector;
import com.sun.jmx.mbeanserver.MXBeanIntrospector;
import com.sun.jmx.mbeanserver.MXBeanSupport;
import com.sun.jmx.mbeanserver.PerInterface;
import com.sun.jmx.mbeanserver.StandardMBeanIntrospector;
import com.sun.jmx.mbeanserver.StandardMBeanSupport;
import com.sun.jmx.mbeanserver.Util;
import com.sun.jmx.remote.util.EnvHelp;
import java.lang.annotation.Annotation;
import java.lang.ref.SoftReference;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import javax.management.AttributeNotFoundException;
import javax.management.Descriptor;
import javax.management.DescriptorKey;
import javax.management.DynamicMBean;
import javax.management.ImmutableDescriptor;
import javax.management.MBeanInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.openmbean.CompositeData;

public class Introspector {
    private Introspector() {
    }

    public static final boolean isDynamic(Class<?> c) {
        return DynamicMBean.class.isAssignableFrom(c);
    }

    public static void testCreation(Class<?> c) throws NotCompliantMBeanException {
        int mods = c.getModifiers();
        if (Modifier.isAbstract(mods) || Modifier.isInterface(mods)) {
            throw new NotCompliantMBeanException("MBean class must be concrete");
        }
        Constructor<?>[] consList = c.getConstructors();
        if (consList.length == 0) {
            throw new NotCompliantMBeanException("MBean class must have public constructor");
        }
    }

    public static void checkCompliance(Class<?> mbeanClass) throws NotCompliantMBeanException {
        if (DynamicMBean.class.isAssignableFrom(mbeanClass)) {
            return;
        }
        try {
            Introspector.getStandardMBeanInterface(mbeanClass);
            return;
        }
        catch (NotCompliantMBeanException e) {
            NotCompliantMBeanException mbeanException = e;
            try {
                Introspector.getMXBeanInterface(mbeanClass);
                return;
            }
            catch (NotCompliantMBeanException e2) {
                NotCompliantMBeanException mxbeanException = e2;
                String msg = "MBean class " + mbeanClass.getName() + " does not implement " + "DynamicMBean, and neither follows the Standard MBean conventions (" + mbeanException.toString() + ") nor the MXBean conventions (" + mxbeanException.toString() + ")";
                throw new NotCompliantMBeanException(msg);
            }
        }
    }

    public static <T> DynamicMBean makeDynamicMBean(T mbean) throws NotCompliantMBeanException {
        if (mbean instanceof DynamicMBean) {
            return (DynamicMBean)mbean;
        }
        Class<?> mbeanClass = mbean.getClass();
        Class c = null;
        try {
            c = (Class)Util.cast(Introspector.getStandardMBeanInterface(mbeanClass));
        }
        catch (NotCompliantMBeanException e) {
            // empty catch block
        }
        if (c != null) {
            return new StandardMBeanSupport(mbean, c);
        }
        try {
            c = (Class)Util.cast(Introspector.getMXBeanInterface(mbeanClass));
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            // empty catch block
        }
        if (c != null) {
            return new MXBeanSupport(mbean, c);
        }
        Introspector.checkCompliance(mbeanClass);
        throw new NotCompliantMBeanException("Not compliant");
    }

    public static MBeanInfo testCompliance(Class<?> baseClass) throws NotCompliantMBeanException {
        if (Introspector.isDynamic(baseClass)) {
            return null;
        }
        return Introspector.testCompliance(baseClass, null);
    }

    public static void testComplianceMXBeanInterface(Class<?> interfaceClass) throws NotCompliantMBeanException {
        MXBeanIntrospector.getInstance().getAnalyzer(interfaceClass);
    }

    public static synchronized MBeanInfo testCompliance(Class<?> baseClass, Class<?> mbeanInterface) throws NotCompliantMBeanException {
        if (mbeanInterface == null) {
            mbeanInterface = Introspector.getStandardMBeanInterface(baseClass);
        }
        StandardMBeanIntrospector introspector = StandardMBeanIntrospector.getInstance();
        return Introspector.getClassMBeanInfo(introspector, baseClass, mbeanInterface);
    }

    private static <M> MBeanInfo getClassMBeanInfo(MBeanIntrospector<M> introspector, Class<?> baseClass, Class<?> mbeanInterface) throws NotCompliantMBeanException {
        PerInterface<M> perInterface = introspector.getPerInterface(mbeanInterface);
        return introspector.getClassMBeanInfo(baseClass, perInterface);
    }

    public static Class<?> getMBeanInterface(Class<?> baseClass) {
        if (Introspector.isDynamic(baseClass)) {
            return null;
        }
        try {
            return Introspector.getStandardMBeanInterface(baseClass);
        }
        catch (NotCompliantMBeanException e) {
            return null;
        }
    }

    public static <T> Class<? super T> getStandardMBeanInterface(Class<T> baseClass) throws NotCompliantMBeanException {
        Class<T> mbeanInterface = null;
        for (Class<T> current = baseClass; current != null && (mbeanInterface = Introspector.findMBeanInterface(current, current.getName())) == null; current = current.getSuperclass()) {
        }
        if (mbeanInterface != null) {
            return mbeanInterface;
        }
        String msg = "Class " + baseClass.getName() + " is not a JMX compliant Standard MBean";
        throw new NotCompliantMBeanException(msg);
    }

    public static <T> Class<? super T> getMXBeanInterface(Class<T> baseClass) throws NotCompliantMBeanException {
        try {
            return MXBeanSupport.findMXBeanInterface(baseClass);
        }
        catch (Exception e) {
            throw Introspector.throwException(baseClass, e);
        }
    }

    private static <T> Class<? super T> findMBeanInterface(Class<T> aClass, String aName) {
        for (Class<T> current = aClass; current != null; current = current.getSuperclass()) {
            Class<?>[] interfaces = current.getInterfaces();
            int len = interfaces.length;
            for (int i = 0; i < len; ++i) {
                Class<T> inter = (Class<T>)Util.cast(interfaces[i]);
                if ((inter = Introspector.implementsMBean(inter, aName)) == null) continue;
                return inter;
            }
        }
        return null;
    }

    public static Descriptor descriptorForElement(AnnotatedElement elmt) {
        if (elmt == null) {
            return ImmutableDescriptor.EMPTY_DESCRIPTOR;
        }
        Annotation[] annots = elmt.getAnnotations();
        return Introspector.descriptorForAnnotations(annots);
    }

    public static Descriptor descriptorForAnnotations(Annotation[] annots) {
        if (annots.length == 0) {
            return ImmutableDescriptor.EMPTY_DESCRIPTOR;
        }
        HashMap<String, Object> descriptorMap = new HashMap<String, Object>();
        for (Annotation a : annots) {
            Method[] elements;
            Class<? extends Annotation> c = a.annotationType();
            for (Method element : elements = c.getMethods()) {
                Object value;
                DescriptorKey key = element.getAnnotation(DescriptorKey.class);
                if (key == null) continue;
                String name = key.value();
                try {
                    value = element.invoke(a, new Object[0]);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new UndeclaredThrowableException(e);
                }
                value = Introspector.annotationToField(value);
                Object oldValue = descriptorMap.put(name, value);
                if (oldValue == null || Introspector.equals(oldValue, value)) continue;
                String msg = "Inconsistent values for descriptor field " + name + " from annotations: " + value + " :: " + oldValue;
                throw new IllegalArgumentException(msg);
            }
        }
        if (descriptorMap.isEmpty()) {
            return ImmutableDescriptor.EMPTY_DESCRIPTOR;
        }
        return new ImmutableDescriptor(descriptorMap);
    }

    static NotCompliantMBeanException throwException(Class<?> notCompliant, Throwable cause) throws NotCompliantMBeanException, SecurityException {
        if (cause instanceof SecurityException) {
            throw (SecurityException)cause;
        }
        if (cause instanceof NotCompliantMBeanException) {
            throw (NotCompliantMBeanException)cause;
        }
        String classname = notCompliant == null ? "null class" : notCompliant.getName();
        String reason = cause == null ? "Not compliant" : cause.getMessage();
        NotCompliantMBeanException res = new NotCompliantMBeanException(classname + ": " + reason);
        res.initCause(cause);
        throw res;
    }

    private static Object annotationToField(Object x) {
        if (x == null) {
            return null;
        }
        if (x instanceof Number || x instanceof String || x instanceof Character || x instanceof Boolean || x instanceof String[]) {
            return x;
        }
        Class<?> c = x.getClass();
        if (c.isArray()) {
            if (c.getComponentType().isPrimitive()) {
                return x;
            }
            Object[] xx = (Object[])x;
            String[] ss = new String[xx.length];
            for (int i = 0; i < xx.length; ++i) {
                ss[i] = (String)Introspector.annotationToField(xx[i]);
            }
            return ss;
        }
        if (x instanceof Class) {
            return ((Class)x).getName();
        }
        if (x instanceof Enum) {
            return ((Enum)x).name();
        }
        if (Proxy.isProxyClass(c)) {
            c = c.getInterfaces()[0];
        }
        throw new IllegalArgumentException("Illegal type for annotation element using @DescriptorKey: " + c.getName());
    }

    private static boolean equals(Object x, Object y) {
        return Arrays.deepEquals(new Object[]{x}, new Object[]{y});
    }

    private static <T> Class<? super T> implementsMBean(Class<T> c, String clName) {
        String clMBeanName = clName + "MBean";
        if (c.getName().equals(clMBeanName)) {
            return c;
        }
        Class<?>[] interfaces = c.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!interfaces[i].getName().equals(clMBeanName)) continue;
            return (Class)Util.cast(interfaces[i]);
        }
        return null;
    }

    public static Object elementFromComplex(Object complex, String element) throws AttributeNotFoundException {
        try {
            if (complex.getClass().isArray() && element.equals("length")) {
                return Array.getLength(complex);
            }
            if (complex instanceof CompositeData) {
                return ((CompositeData)complex).get(element);
            }
            Class<?> clazz = complex.getClass();
            Method readMethod = null;
            if (BeansHelper.isAvailable()) {
                Object[] pds;
                Object bi = BeansHelper.getBeanInfo(clazz);
                for (Object pd : pds = BeansHelper.getPropertyDescriptors(bi)) {
                    if (!BeansHelper.getPropertyName(pd).equals(element)) continue;
                    readMethod = BeansHelper.getReadMethod(pd);
                    break;
                }
            } else {
                readMethod = SimpleIntrospector.getReadMethod(clazz, element);
            }
            if (readMethod != null) {
                return readMethod.invoke(complex, new Object[0]);
            }
            throw new AttributeNotFoundException("Could not find the getter method for the property " + element + " using the Java Beans introspector");
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
        catch (AttributeNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw EnvHelp.initCause(new AttributeNotFoundException(e.getMessage()), e);
        }
    }

    private static class BeansHelper {
        private static final Class<?> introspectorClass = BeansHelper.getClass("java.beans.Introspector");
        private static final Class<?> beanInfoClass = introspectorClass == null ? null : BeansHelper.getClass("java.beans.BeanInfo");
        private static final Class<?> getPropertyDescriptorClass = beanInfoClass == null ? null : BeansHelper.getClass("java.beans.PropertyDescriptor");
        private static final Method getBeanInfo = BeansHelper.getMethod(introspectorClass, "getBeanInfo", Class.class);
        private static final Method getPropertyDescriptors = BeansHelper.getMethod(beanInfoClass, "getPropertyDescriptors", new Class[0]);
        private static final Method getPropertyName = BeansHelper.getMethod(getPropertyDescriptorClass, "getName", new Class[0]);
        private static final Method getReadMethod = BeansHelper.getMethod(getPropertyDescriptorClass, "getReadMethod", new Class[0]);

        private static Class<?> getClass(String name) {
            try {
                return Class.forName(name, true, null);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }

        private static Method getMethod(Class<?> clazz, String name, Class<?> ... paramTypes) {
            if (clazz != null) {
                try {
                    return clazz.getMethod(name, paramTypes);
                }
                catch (NoSuchMethodException e) {
                    throw new AssertionError((Object)e);
                }
            }
            return null;
        }

        private BeansHelper() {
        }

        static boolean isAvailable() {
            return introspectorClass != null;
        }

        static Object getBeanInfo(Class<?> clazz) throws Exception {
            try {
                return getBeanInfo.invoke(null, clazz);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof Exception) {
                    throw (Exception)cause;
                }
                throw new AssertionError((Object)e);
            }
            catch (IllegalAccessException iae) {
                throw new AssertionError((Object)iae);
            }
        }

        static Object[] getPropertyDescriptors(Object bi) {
            try {
                return (Object[])getPropertyDescriptors.invoke(bi, new Object[0]);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new AssertionError((Object)e);
            }
            catch (IllegalAccessException iae) {
                throw new AssertionError((Object)iae);
            }
        }

        static String getPropertyName(Object pd) {
            try {
                return (String)getPropertyName.invoke(pd, new Object[0]);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new AssertionError((Object)e);
            }
            catch (IllegalAccessException iae) {
                throw new AssertionError((Object)iae);
            }
        }

        static Method getReadMethod(Object pd) {
            try {
                return (Method)getReadMethod.invoke(pd, new Object[0]);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new AssertionError((Object)e);
            }
            catch (IllegalAccessException iae) {
                throw new AssertionError((Object)iae);
            }
        }
    }

    private static class SimpleIntrospector {
        private static final String GET_METHOD_PREFIX = "get";
        private static final String IS_METHOD_PREFIX = "is";
        private static final Map<Class<?>, SoftReference<List<Method>>> cache = Collections.synchronizedMap(new WeakHashMap());

        private SimpleIntrospector() {
        }

        private static List<Method> getCachedMethods(Class<?> clazz) {
            List<Method> cached;
            SoftReference<List<Method>> ref = cache.get(clazz);
            if (ref != null && (cached = ref.get()) != null) {
                return cached;
            }
            return null;
        }

        static boolean isReadMethod(Method method) {
            int modifiers = method.getModifiers();
            if (Modifier.isStatic(modifiers)) {
                return false;
            }
            String name = method.getName();
            Class<?>[] paramTypes = method.getParameterTypes();
            int paramCount = paramTypes.length;
            if (paramCount == 0 && name.length() > 2) {
                if (name.startsWith(IS_METHOD_PREFIX)) {
                    return method.getReturnType() == Boolean.TYPE;
                }
                if (name.length() > 3 && name.startsWith(GET_METHOD_PREFIX)) {
                    return method.getReturnType() != Void.TYPE;
                }
            }
            return false;
        }

        static List<Method> getReadMethods(Class<?> clazz) {
            List<Method> cachedResult = SimpleIntrospector.getCachedMethods(clazz);
            if (cachedResult != null) {
                return cachedResult;
            }
            List<Method> methods = StandardMBeanIntrospector.getInstance().getMethods(clazz);
            methods = MBeanAnalyzer.eliminateCovariantMethods(methods);
            LinkedList<Method> result = new LinkedList<Method>();
            for (Method m : methods) {
                if (!SimpleIntrospector.isReadMethod(m)) continue;
                if (m.getName().startsWith(IS_METHOD_PREFIX)) {
                    result.add(0, m);
                    continue;
                }
                result.add(m);
            }
            cache.put(clazz, new SoftReference(result));
            return result;
        }

        static Method getReadMethod(Class<?> clazz, String property) {
            property = property.substring(0, 1).toUpperCase(Locale.ENGLISH) + property.substring(1);
            String getMethod = GET_METHOD_PREFIX + property;
            String isMethod = IS_METHOD_PREFIX + property;
            for (Method m : SimpleIntrospector.getReadMethods(clazz)) {
                String name = m.getName();
                if (!name.equals(isMethod) && !name.equals(getMethod)) continue;
                return m;
            }
            return null;
        }
    }
}

