/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.mbeanserver.MBeanAnalyzer;
import com.sun.jmx.mbeanserver.MXBeanIntrospector;
import com.sun.jmx.mbeanserver.MXBeanLookup;
import com.sun.jmx.mbeanserver.MXBeanMapping;
import com.sun.jmx.mbeanserver.MXBeanMappingFactory;
import com.sun.jmx.mbeanserver.Util;
import com.sun.jmx.remote.util.EnvHelp;
import java.beans.ConstructorProperties;
import java.io.InvalidObjectException;
import java.lang.annotation.ElementType;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.WeakHashMap;
import javax.management.JMX;
import javax.management.ObjectName;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataInvocationHandler;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeDataView;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;

public class DefaultMXBeanMappingFactory
extends MXBeanMappingFactory {
    private static final Mappings mappings = new Mappings();
    private static final List<MXBeanMapping> permanentMappings = Util.newList();
    private static final String[] keyArray;
    private static final String[] keyValueArray;
    private static final Map<Type, Type> inProgress;

    static boolean isIdentity(MXBeanMapping mapping) {
        return mapping instanceof NonNullMXBeanMapping && ((NonNullMXBeanMapping)mapping).isIdentity();
    }

    private static synchronized MXBeanMapping getMapping(Type type) {
        WeakReference wr = (WeakReference)mappings.get(type);
        return wr == null ? null : (MXBeanMapping)wr.get();
    }

    private static synchronized void putMapping(Type type, MXBeanMapping mapping) {
        WeakReference<MXBeanMapping> wr = new WeakReference<MXBeanMapping>(mapping);
        mappings.put(type, wr);
    }

    private static synchronized void putPermanentMapping(Type type, MXBeanMapping mapping) {
        DefaultMXBeanMappingFactory.putMapping(type, mapping);
        permanentMappings.add(mapping);
    }

    @Override
    public synchronized MXBeanMapping mappingForType(Type objType, MXBeanMappingFactory factory) throws OpenDataException {
        if (inProgress.containsKey(objType)) {
            throw new OpenDataException("Recursive data structure, including " + MXBeanIntrospector.typeName(objType));
        }
        MXBeanMapping mapping = DefaultMXBeanMappingFactory.getMapping(objType);
        if (mapping != null) {
            return mapping;
        }
        inProgress.put(objType, objType);
        try {
            mapping = this.makeMapping(objType, factory);
        }
        catch (OpenDataException e) {
            throw DefaultMXBeanMappingFactory.openDataException("Cannot convert type: " + MXBeanIntrospector.typeName(objType), e);
        }
        finally {
            inProgress.remove(objType);
        }
        DefaultMXBeanMappingFactory.putMapping(objType, mapping);
        return mapping;
    }

    private MXBeanMapping makeMapping(Type objType, MXBeanMappingFactory factory) throws OpenDataException {
        if (objType instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)objType).getGenericComponentType();
            return this.makeArrayOrCollectionMapping(objType, componentType, factory);
        }
        if (objType instanceof Class) {
            Class objClass = (Class)objType;
            if (objClass.isEnum()) {
                return DefaultMXBeanMappingFactory.makeEnumMapping(objClass, ElementType.class);
            }
            if (objClass.isArray()) {
                Class<?> componentType = objClass.getComponentType();
                return this.makeArrayOrCollectionMapping(objClass, componentType, factory);
            }
            if (JMX.isMXBeanInterface(objClass)) {
                return DefaultMXBeanMappingFactory.makeMXBeanRefMapping(objClass);
            }
            return this.makeCompositeMapping(objClass, factory);
        }
        if (objType instanceof ParameterizedType) {
            return this.makeParameterizedTypeMapping((ParameterizedType)objType, factory);
        }
        throw new OpenDataException("Cannot map type: " + objType);
    }

    private static <T extends Enum<T>> MXBeanMapping makeEnumMapping(Class<?> enumClass, Class<T> fake) {
        return new EnumMapping((Class)Util.cast(enumClass));
    }

    private MXBeanMapping makeArrayOrCollectionMapping(Type collectionType, Type elementType, MXBeanMappingFactory factory) throws OpenDataException {
        Class<?> openArrayClass;
        MXBeanMapping elementMapping = factory.mappingForType(elementType, factory);
        OpenType<?> elementOpenType = elementMapping.getOpenType();
        ArrayType<?[]> openType = ArrayType.getArrayType(elementOpenType);
        Class<?> elementOpenClass = elementMapping.getOpenClass();
        String openArrayClassName = elementOpenClass.isArray() ? "[" + elementOpenClass.getName() : "[L" + elementOpenClass.getName() + ";";
        try {
            openArrayClass = Class.forName(openArrayClassName);
        }
        catch (ClassNotFoundException e) {
            throw DefaultMXBeanMappingFactory.openDataException("Cannot obtain array class", e);
        }
        if (collectionType instanceof ParameterizedType) {
            return new CollectionMapping(collectionType, openType, openArrayClass, elementMapping);
        }
        if (DefaultMXBeanMappingFactory.isIdentity(elementMapping)) {
            return new IdentityMapping(collectionType, openType);
        }
        return new ArrayMapping(collectionType, openType, openArrayClass, elementMapping);
    }

    private MXBeanMapping makeTabularMapping(Type objType, boolean sortedMap, Type keyType, Type valueType, MXBeanMappingFactory factory) throws OpenDataException {
        String objTypeName = MXBeanIntrospector.typeName(objType);
        MXBeanMapping keyMapping = factory.mappingForType(keyType, factory);
        MXBeanMapping valueMapping = factory.mappingForType(valueType, factory);
        OpenType<?> keyOpenType = keyMapping.getOpenType();
        OpenType<?> valueOpenType = valueMapping.getOpenType();
        CompositeType rowType = new CompositeType(objTypeName, objTypeName, keyValueArray, keyValueArray, new OpenType[]{keyOpenType, valueOpenType});
        TabularType tabularType = new TabularType(objTypeName, objTypeName, rowType, keyArray);
        return new TabularMapping(objType, sortedMap, tabularType, keyMapping, valueMapping);
    }

    private MXBeanMapping makeParameterizedTypeMapping(ParameterizedType objType, MXBeanMappingFactory factory) throws OpenDataException {
        Type rawType = objType.getRawType();
        if (rawType instanceof Class) {
            boolean sortedMap;
            Class c = (Class)rawType;
            if (c == List.class || c == Set.class || c == SortedSet.class) {
                Type[] actuals = objType.getActualTypeArguments();
                assert (actuals.length == 1);
                if (c == SortedSet.class) {
                    DefaultMXBeanMappingFactory.mustBeComparable(c, actuals[0]);
                }
                return this.makeArrayOrCollectionMapping(objType, actuals[0], factory);
            }
            boolean bl = sortedMap = c == SortedMap.class;
            if (c == Map.class || sortedMap) {
                Type[] actuals = objType.getActualTypeArguments();
                assert (actuals.length == 2);
                if (sortedMap) {
                    DefaultMXBeanMappingFactory.mustBeComparable(c, actuals[0]);
                }
                return this.makeTabularMapping(objType, sortedMap, actuals[0], actuals[1], factory);
            }
        }
        throw new OpenDataException("Cannot convert type: " + objType);
    }

    private static MXBeanMapping makeMXBeanRefMapping(Type t) throws OpenDataException {
        return new MXBeanRefMapping(t);
    }

    private MXBeanMapping makeCompositeMapping(Class<?> c, MXBeanMappingFactory factory) throws OpenDataException {
        boolean gcInfoHack = c.getName().equals("com.sun.management.GcInfo") && c.getClassLoader() == null;
        List<Method> methods = MBeanAnalyzer.eliminateCovariantMethods(Arrays.asList(c.getMethods()));
        SortedMap<String, Method> getterMap = Util.newSortedMap();
        for (Method method : methods) {
            Method old;
            String propertyName = DefaultMXBeanMappingFactory.propertyName(method);
            if (propertyName == null || gcInfoHack && propertyName.equals("CompositeType") || (old = getterMap.put(DefaultMXBeanMappingFactory.decapitalize(propertyName), method)) == null) continue;
            String msg = "Class " + c.getName() + " has method name clash: " + old.getName() + ", " + method.getName();
            throw new OpenDataException(msg);
        }
        int nitems = getterMap.size();
        if (nitems == 0) {
            throw new OpenDataException("Can't map " + c.getName() + " to an open data type");
        }
        Method[] getters = new Method[nitems];
        String[] itemNames = new String[nitems];
        OpenType[] openTypes = new OpenType[nitems];
        int i = 0;
        for (Map.Entry entry : getterMap.entrySet()) {
            Method getter;
            itemNames[i] = (String)entry.getKey();
            getters[i] = getter = (Method)entry.getValue();
            Type retType = getter.getGenericReturnType();
            openTypes[i] = factory.mappingForType(retType, factory).getOpenType();
            ++i;
        }
        CompositeType compositeType = new CompositeType(c.getName(), c.getName(), itemNames, itemNames, openTypes);
        return new CompositeMapping(c, compositeType, itemNames, getters, factory);
    }

    static InvalidObjectException invalidObjectException(String msg, Throwable cause) {
        return EnvHelp.initCause(new InvalidObjectException(msg), cause);
    }

    static InvalidObjectException invalidObjectException(Throwable cause) {
        return DefaultMXBeanMappingFactory.invalidObjectException(cause.getMessage(), cause);
    }

    static OpenDataException openDataException(String msg, Throwable cause) {
        return EnvHelp.initCause(new OpenDataException(msg), cause);
    }

    static OpenDataException openDataException(Throwable cause) {
        return DefaultMXBeanMappingFactory.openDataException(cause.getMessage(), cause);
    }

    static void mustBeComparable(Class<?> collection, Type element) throws OpenDataException {
        if (!(element instanceof Class) || !Comparable.class.isAssignableFrom((Class)element)) {
            String msg = "Parameter class " + element + " of " + collection.getName() + " does not implement " + Comparable.class.getName();
            throw new OpenDataException(msg);
        }
    }

    public static String decapitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        int offset1 = Character.offsetByCodePoints(name, 0, 1);
        if (offset1 < name.length() && Character.isUpperCase(name.codePointAt(offset1))) {
            return name;
        }
        return name.substring(0, offset1).toLowerCase() + name.substring(offset1);
    }

    static String capitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        int offset1 = name.offsetByCodePoints(0, 1);
        return name.substring(0, offset1).toUpperCase() + name.substring(offset1);
    }

    public static String propertyName(Method m) {
        String rest = null;
        String name = m.getName();
        if (name.startsWith("get")) {
            rest = name.substring(3);
        } else if (name.startsWith("is") && m.getReturnType() == Boolean.TYPE) {
            rest = name.substring(2);
        }
        if (rest == null || rest.length() == 0 || m.getParameterTypes().length > 0 || m.getReturnType() == Void.TYPE || name.equals("getClass")) {
            return null;
        }
        return rest;
    }

    static {
        OpenType[] simpleTypes = new OpenType[]{SimpleType.BIGDECIMAL, SimpleType.BIGINTEGER, SimpleType.BOOLEAN, SimpleType.BYTE, SimpleType.CHARACTER, SimpleType.DATE, SimpleType.DOUBLE, SimpleType.FLOAT, SimpleType.INTEGER, SimpleType.LONG, SimpleType.OBJECTNAME, SimpleType.SHORT, SimpleType.STRING, SimpleType.VOID};
        for (int i = 0; i < simpleTypes.length; ++i) {
            Class<?> c;
            OpenType t = simpleTypes[i];
            try {
                c = Class.forName(t.getClassName(), false, ObjectName.class.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new Error(e);
            }
            IdentityMapping mapping = new IdentityMapping(c, t);
            DefaultMXBeanMappingFactory.putPermanentMapping(c, mapping);
            if (!c.getName().startsWith("java.lang.")) continue;
            try {
                Field typeField = c.getField("TYPE");
                Class primitiveType = (Class)typeField.get(null);
                IdentityMapping primitiveMapping = new IdentityMapping(primitiveType, t);
                DefaultMXBeanMappingFactory.putPermanentMapping(primitiveType, primitiveMapping);
                if (primitiveType == Void.TYPE) continue;
                Class<?> primitiveArrayType = Array.newInstance(primitiveType, 0).getClass();
                ArrayType<?> primitiveArrayOpenType = ArrayType.getPrimitiveArrayType(primitiveArrayType);
                IdentityMapping primitiveArrayMapping = new IdentityMapping(primitiveArrayType, primitiveArrayOpenType);
                DefaultMXBeanMappingFactory.putPermanentMapping(primitiveArrayType, primitiveArrayMapping);
                continue;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
            catch (IllegalAccessException e) {
                assert (false);
                continue;
            }
        }
        keyArray = new String[]{"key"};
        keyValueArray = new String[]{"key", "value"};
        inProgress = Util.newIdentityHashMap();
    }

    private static final class CompositeBuilderViaProxy
    extends CompositeBuilder {
        CompositeBuilderViaProxy(Class<?> targetClass, String[] itemNames) {
            super(targetClass, itemNames);
        }

        @Override
        String applicable(Method[] getters) {
            Class<?> targetClass = this.getTargetClass();
            if (!targetClass.isInterface()) {
                return "not an interface";
            }
            Set<Method> methods = Util.newSet(Arrays.asList(targetClass.getMethods()));
            methods.removeAll(Arrays.asList(getters));
            String bad = null;
            for (Method m : methods) {
                String mname = m.getName();
                Class<?>[] mparams = m.getParameterTypes();
                try {
                    Method om = Object.class.getMethod(mname, mparams);
                    if (Modifier.isPublic(om.getModifiers())) continue;
                    bad = mname;
                }
                catch (NoSuchMethodException e) {
                    bad = mname;
                }
            }
            if (bad != null) {
                return "contains methods other than getters (" + bad + ")";
            }
            return null;
        }

        @Override
        final Object fromCompositeData(CompositeData cd, String[] itemNames, MXBeanMapping[] converters) {
            Class<?> targetClass = this.getTargetClass();
            return Proxy.newProxyInstance(targetClass.getClassLoader(), new Class[]{targetClass}, new CompositeDataInvocationHandler(cd));
        }
    }

    private static final class CompositeBuilderViaConstructor
    extends CompositeBuilder {
        private List<Constr> annotatedConstructors;

        CompositeBuilderViaConstructor(Class<?> targetClass, String[] itemNames) {
            super(targetClass, itemNames);
        }

        @Override
        String applicable(Method[] getters) throws InvalidObjectException {
            Class<ConstructorProperties> propertyNamesClass = ConstructorProperties.class;
            Class<?> targetClass = this.getTargetClass();
            Constructor<?>[] constrs = targetClass.getConstructors();
            List<Constructor<?>> annotatedConstrList = Util.newList();
            for (Constructor<?> constr : constrs) {
                if (!Modifier.isPublic(constr.getModifiers()) || constr.getAnnotation(propertyNamesClass) == null) continue;
                annotatedConstrList.add(constr);
            }
            if (annotatedConstrList.isEmpty()) {
                return "no constructor has @ConstructorProperties annotation";
            }
            this.annotatedConstructors = Util.newList();
            Map<String, Integer> getterMap = Util.newMap();
            String[] itemNames = this.getItemNames();
            for (int i = 0; i < itemNames.length; ++i) {
                getterMap.put(itemNames[i], i);
            }
            Set<BitSet> getterIndexSets = Util.newSet();
            for (Constructor constructor : annotatedConstrList) {
                Object[] propertyNames = constructor.getAnnotation(propertyNamesClass).value();
                Type[] paramTypes = constructor.getGenericParameterTypes();
                if (paramTypes.length != propertyNames.length) {
                    String msg = "Number of constructor params does not match @ConstructorProperties annotation: " + constructor;
                    throw new InvalidObjectException(msg);
                }
                int[] paramIndexes = new int[getters.length];
                for (int i = 0; i < getters.length; ++i) {
                    paramIndexes[i] = -1;
                }
                BitSet present = new BitSet();
                for (int i = 0; i < propertyNames.length; ++i) {
                    String propertyName = propertyNames[i];
                    if (!getterMap.containsKey(propertyName)) {
                        String msg = "@ConstructorProperties includes name " + propertyName + " which does not correspond to a property";
                        for (String getterName : getterMap.keySet()) {
                            if (!getterName.equalsIgnoreCase(propertyName)) continue;
                            msg = msg + " (differs only in case from property " + getterName + ")";
                        }
                        msg = msg + ": " + constructor;
                        throw new InvalidObjectException(msg);
                    }
                    int getterIndex = (Integer)getterMap.get(propertyName);
                    paramIndexes[getterIndex] = i;
                    if (present.get(getterIndex)) {
                        String msg = "@ConstructorProperties contains property " + propertyName + " more than once: " + constructor;
                        throw new InvalidObjectException(msg);
                    }
                    present.set(getterIndex);
                    Method getter = getters[getterIndex];
                    Type propertyType = getter.getGenericReturnType();
                    if (propertyType.equals(paramTypes[i])) continue;
                    String msg = "@ConstructorProperties gives property " + propertyName + " of type " + propertyType + " for parameter " + " of type " + paramTypes[i] + ": " + constructor;
                    throw new InvalidObjectException(msg);
                }
                if (!getterIndexSets.add(present)) {
                    String msg = "More than one constructor has a @ConstructorProperties annotation with this set of names: " + Arrays.toString(propertyNames);
                    throw new InvalidObjectException(msg);
                }
                Constr c = new Constr(constructor, paramIndexes, present);
                this.annotatedConstructors.add(c);
            }
            for (BitSet bitSet : getterIndexSets) {
                boolean seen = false;
                for (BitSet b : getterIndexSets) {
                    if (bitSet == b) {
                        seen = true;
                        continue;
                    }
                    if (!seen) continue;
                    BitSet u = new BitSet();
                    u.or(bitSet);
                    u.or(b);
                    if (getterIndexSets.contains(u)) continue;
                    TreeSet<String> names = new TreeSet<String>();
                    int i = u.nextSetBit(0);
                    while (i >= 0) {
                        names.add(itemNames[i]);
                        i = u.nextSetBit(i + 1);
                    }
                    String msg = "Constructors with @ConstructorProperties annotation  would be ambiguous for these items: " + names;
                    throw new InvalidObjectException(msg);
                }
            }
            return null;
        }

        @Override
        final Object fromCompositeData(CompositeData cd, String[] itemNames, MXBeanMapping[] mappings) throws InvalidObjectException {
            CompositeType ct = cd.getCompositeType();
            BitSet present = new BitSet();
            for (int i = 0; i < itemNames.length; ++i) {
                if (ct.getType(itemNames[i]) == null) continue;
                present.set(i);
            }
            Constr max = null;
            for (Constr constr : this.annotatedConstructors) {
                if (!CompositeBuilderViaConstructor.subset(constr.presentParams, present) || max != null && !CompositeBuilderViaConstructor.subset(max.presentParams, constr.presentParams)) continue;
                max = constr;
            }
            if (max == null) {
                String msg = "No constructor has a @ConstructorProperties for this set of items: " + ct.keySet();
                throw new InvalidObjectException(msg);
            }
            Object[] params = new Object[max.presentParams.cardinality()];
            for (int i = 0; i < itemNames.length; ++i) {
                if (!max.presentParams.get(i)) continue;
                Object openItem = cd.get(itemNames[i]);
                Object javaItem = mappings[i].fromOpenValue(openItem);
                int index = max.paramIndexes[i];
                if (index < 0) continue;
                params[index] = javaItem;
            }
            try {
                return max.constructor.newInstance(params);
            }
            catch (Exception e) {
                String msg = "Exception constructing " + this.getTargetClass().getName();
                throw DefaultMXBeanMappingFactory.invalidObjectException(msg, e);
            }
        }

        private static boolean subset(BitSet sub, BitSet sup) {
            BitSet subcopy = (BitSet)sub.clone();
            subcopy.andNot(sup);
            return subcopy.isEmpty();
        }

        private static class Constr {
            final Constructor<?> constructor;
            final int[] paramIndexes;
            final BitSet presentParams;

            Constr(Constructor<?> constructor, int[] paramIndexes, BitSet presentParams) {
                this.constructor = constructor;
                this.paramIndexes = paramIndexes;
                this.presentParams = presentParams;
            }
        }
    }

    private static class CompositeBuilderViaSetters
    extends CompositeBuilder {
        private Method[] setters;

        CompositeBuilderViaSetters(Class<?> targetClass, String[] itemNames) {
            super(targetClass, itemNames);
        }

        @Override
        String applicable(Method[] getters) {
            try {
                Constructor<?> c = this.getTargetClass().getConstructor(new Class[0]);
            }
            catch (Exception e) {
                return "does not have a public no-arg constructor";
            }
            Method[] setters = new Method[getters.length];
            for (int i = 0; i < getters.length; ++i) {
                Method setter;
                Method getter = getters[i];
                Class<?> returnType = getter.getReturnType();
                String name = DefaultMXBeanMappingFactory.propertyName(getter);
                String setterName = "set" + name;
                try {
                    setter = this.getTargetClass().getMethod(setterName, returnType);
                    if (setter.getReturnType() != Void.TYPE) {
                        throw new Exception();
                    }
                }
                catch (Exception e) {
                    return "not all getters have corresponding setters (" + getter + ")";
                }
                setters[i] = setter;
            }
            this.setters = setters;
            return null;
        }

        @Override
        Object fromCompositeData(CompositeData cd, String[] itemNames, MXBeanMapping[] converters) throws InvalidObjectException {
            Object o;
            try {
                o = this.getTargetClass().newInstance();
                for (int i = 0; i < itemNames.length; ++i) {
                    if (!cd.containsKey(itemNames[i])) continue;
                    Object openItem = cd.get(itemNames[i]);
                    Object javaItem = converters[i].fromOpenValue(openItem);
                    this.setters[i].invoke(o, javaItem);
                }
            }
            catch (Exception e) {
                throw DefaultMXBeanMappingFactory.invalidObjectException(e);
            }
            return o;
        }
    }

    private static class CompositeBuilderCheckGetters
    extends CompositeBuilder {
        private final MXBeanMapping[] getterConverters;
        private Throwable possibleCause;

        CompositeBuilderCheckGetters(Class<?> targetClass, String[] itemNames, MXBeanMapping[] getterConverters) {
            super(targetClass, itemNames);
            this.getterConverters = getterConverters;
        }

        @Override
        String applicable(Method[] getters) {
            for (int i = 0; i < getters.length; ++i) {
                try {
                    this.getterConverters[i].checkReconstructible();
                    continue;
                }
                catch (InvalidObjectException e) {
                    this.possibleCause = e;
                    return "method " + getters[i].getName() + " returns type " + "that cannot be mapped back from OpenData";
                }
            }
            return "";
        }

        @Override
        Throwable possibleCause() {
            return this.possibleCause;
        }

        @Override
        final Object fromCompositeData(CompositeData cd, String[] itemNames, MXBeanMapping[] converters) {
            throw new Error();
        }
    }

    private static final class CompositeBuilderViaFrom
    extends CompositeBuilder {
        private Method fromMethod;

        CompositeBuilderViaFrom(Class<?> targetClass, String[] itemNames) {
            super(targetClass, itemNames);
        }

        @Override
        String applicable(Method[] getters) throws InvalidObjectException {
            Class<?> targetClass = this.getTargetClass();
            try {
                Method fromMethod = targetClass.getMethod("from", CompositeData.class);
                if (!Modifier.isStatic(fromMethod.getModifiers())) {
                    String msg = "Method from(CompositeData) is not static";
                    throw new InvalidObjectException("Method from(CompositeData) is not static");
                }
                if (fromMethod.getReturnType() != this.getTargetClass()) {
                    String msg = "Method from(CompositeData) returns " + MXBeanIntrospector.typeName(fromMethod.getReturnType()) + " not " + MXBeanIntrospector.typeName(targetClass);
                    throw new InvalidObjectException(msg);
                }
                this.fromMethod = fromMethod;
                return null;
            }
            catch (InvalidObjectException e) {
                throw e;
            }
            catch (Exception e) {
                return "no method from(CompositeData)";
            }
        }

        @Override
        final Object fromCompositeData(CompositeData cd, String[] itemNames, MXBeanMapping[] converters) throws InvalidObjectException {
            try {
                return this.fromMethod.invoke(null, cd);
            }
            catch (Exception e) {
                String msg = "Failed to invoke from(CompositeData)";
                throw DefaultMXBeanMappingFactory.invalidObjectException("Failed to invoke from(CompositeData)", e);
            }
        }
    }

    private static abstract class CompositeBuilder {
        private final Class<?> targetClass;
        private final String[] itemNames;

        CompositeBuilder(Class<?> targetClass, String[] itemNames) {
            this.targetClass = targetClass;
            this.itemNames = itemNames;
        }

        Class<?> getTargetClass() {
            return this.targetClass;
        }

        String[] getItemNames() {
            return this.itemNames;
        }

        abstract String applicable(Method[] var1) throws InvalidObjectException;

        Throwable possibleCause() {
            return null;
        }

        abstract Object fromCompositeData(CompositeData var1, String[] var2, MXBeanMapping[] var3) throws InvalidObjectException;
    }

    private final class CompositeMapping
    extends NonNullMXBeanMapping {
        private final String[] itemNames;
        private final Method[] getters;
        private final MXBeanMapping[] getterMappings;
        private CompositeBuilder compositeBuilder;

        CompositeMapping(Class<?> targetClass, CompositeType compositeType, String[] itemNames, Method[] getters, MXBeanMappingFactory factory) throws OpenDataException {
            super(targetClass, compositeType);
            assert (itemNames.length == getters.length);
            this.itemNames = itemNames;
            this.getters = getters;
            this.getterMappings = new MXBeanMapping[getters.length];
            for (int i = 0; i < getters.length; ++i) {
                Type retType = getters[i].getGenericReturnType();
                this.getterMappings[i] = factory.mappingForType(retType, factory);
            }
        }

        @Override
        final Object toNonNullOpenValue(Object value) throws OpenDataException {
            CompositeType ct = (CompositeType)this.getOpenType();
            if (value instanceof CompositeDataView) {
                return ((CompositeDataView)value).toCompositeData(ct);
            }
            if (value == null) {
                return null;
            }
            Object[] values = new Object[this.getters.length];
            for (int i = 0; i < this.getters.length; ++i) {
                try {
                    Object got = this.getters[i].invoke(value, null);
                    values[i] = this.getterMappings[i].toOpenValue(got);
                    continue;
                }
                catch (Exception e) {
                    throw DefaultMXBeanMappingFactory.openDataException("Error calling getter for " + this.itemNames[i] + ": " + e, e);
                }
            }
            return new CompositeDataSupport(ct, this.itemNames, values);
        }

        private synchronized void makeCompositeBuilder() throws InvalidObjectException {
            if (this.compositeBuilder != null) {
                return;
            }
            Class targetClass = (Class)this.getJavaType();
            CompositeBuilder[][] builders = new CompositeBuilder[][]{{new CompositeBuilderViaFrom(targetClass, this.itemNames)}, {new CompositeBuilderViaConstructor(targetClass, this.itemNames)}, {new CompositeBuilderCheckGetters(targetClass, this.itemNames, this.getterMappings), new CompositeBuilderViaSetters(targetClass, this.itemNames), new CompositeBuilderViaProxy(targetClass, this.itemNames)}};
            CompositeBuilder foundBuilder = null;
            StringBuilder whyNots = new StringBuilder();
            Throwable possibleCause = null;
            block0: for (CompositeBuilder[] relatedBuilders : builders) {
                for (int i = 0; i < relatedBuilders.length; ++i) {
                    CompositeBuilder builder = relatedBuilders[i];
                    String whyNot = builder.applicable(this.getters);
                    if (whyNot == null) {
                        foundBuilder = builder;
                        break block0;
                    }
                    Throwable cause = builder.possibleCause();
                    if (cause != null) {
                        possibleCause = cause;
                    }
                    if (whyNot.length() <= 0) continue;
                    if (whyNots.length() > 0) {
                        whyNots.append("; ");
                    }
                    whyNots.append(whyNot);
                    if (i == 0) continue block0;
                }
            }
            if (foundBuilder == null) {
                String msg = "Do not know how to make a " + targetClass.getName() + " from a CompositeData: " + whyNots;
                if (possibleCause != null) {
                    msg = msg + ". Remaining exceptions show a POSSIBLE cause.";
                }
                throw DefaultMXBeanMappingFactory.invalidObjectException(msg, possibleCause);
            }
            this.compositeBuilder = foundBuilder;
        }

        @Override
        public void checkReconstructible() throws InvalidObjectException {
            this.makeCompositeBuilder();
        }

        @Override
        final Object fromNonNullOpenValue(Object value) throws InvalidObjectException {
            this.makeCompositeBuilder();
            return this.compositeBuilder.fromCompositeData((CompositeData)value, this.itemNames, this.getterMappings);
        }
    }

    private static final class TabularMapping
    extends NonNullMXBeanMapping {
        private final boolean sortedMap;
        private final MXBeanMapping keyMapping;
        private final MXBeanMapping valueMapping;

        TabularMapping(Type targetType, boolean sortedMap, TabularType tabularType, MXBeanMapping keyConverter, MXBeanMapping valueConverter) {
            super(targetType, tabularType);
            this.sortedMap = sortedMap;
            this.keyMapping = keyConverter;
            this.valueMapping = valueConverter;
        }

        @Override
        final Object toNonNullOpenValue(Object value) throws OpenDataException {
            Comparator comparator;
            Map valueMap = (Map)Util.cast(value);
            if (valueMap instanceof SortedMap && (comparator = ((SortedMap)valueMap).comparator()) != null) {
                String msg = "Cannot convert SortedMap with non-null comparator: " + comparator;
                throw DefaultMXBeanMappingFactory.openDataException(msg, new IllegalArgumentException(msg));
            }
            TabularType tabularType = (TabularType)this.getOpenType();
            TabularDataSupport table = new TabularDataSupport(tabularType);
            CompositeType rowType = tabularType.getRowType();
            for (Map.Entry entry : valueMap.entrySet()) {
                Object openKey = this.keyMapping.toOpenValue(entry.getKey());
                Object openValue = this.valueMapping.toOpenValue(entry.getValue());
                CompositeDataSupport row = new CompositeDataSupport(rowType, keyValueArray, new Object[]{openKey, openValue});
                table.put(row);
            }
            return table;
        }

        @Override
        final Object fromNonNullOpenValue(Object openValue) throws InvalidObjectException {
            TabularData table = (TabularData)openValue;
            Collection rows = (Collection)Util.cast(table.values());
            Map<Object, Object> valueMap = this.sortedMap ? Util.newSortedMap() : Util.newInsertionOrderMap();
            for (CompositeData row : rows) {
                Object value;
                Object key = this.keyMapping.fromOpenValue(row.get("key"));
                if (valueMap.put(key, value = this.valueMapping.fromOpenValue(row.get("value"))) == null) continue;
                String msg = "Duplicate entry in TabularData: key=" + key;
                throw new InvalidObjectException(msg);
            }
            return valueMap;
        }

        @Override
        public void checkReconstructible() throws InvalidObjectException {
            this.keyMapping.checkReconstructible();
            this.valueMapping.checkReconstructible();
        }
    }

    private static final class MXBeanRefMapping
    extends NonNullMXBeanMapping {
        MXBeanRefMapping(Type intf) {
            super(intf, SimpleType.OBJECTNAME);
        }

        @Override
        final Object toNonNullOpenValue(Object javaValue) throws OpenDataException {
            MXBeanLookup lookup = this.lookupNotNull(OpenDataException.class);
            ObjectName name = lookup.mxbeanToObjectName(javaValue);
            if (name == null) {
                throw new OpenDataException("No name for object: " + javaValue);
            }
            return name;
        }

        @Override
        final Object fromNonNullOpenValue(Object openValue) throws InvalidObjectException {
            ObjectName name;
            MXBeanLookup lookup = this.lookupNotNull(InvalidObjectException.class);
            Object mxbean = lookup.objectNameToMXBean(name = (ObjectName)openValue, (Class)this.getJavaType());
            if (mxbean == null) {
                String msg = "No MXBean for name: " + name;
                throw new InvalidObjectException(msg);
            }
            return mxbean;
        }

        private <T extends Exception> MXBeanLookup lookupNotNull(Class<T> excClass) throws T {
            MXBeanLookup lookup = MXBeanLookup.getLookup();
            if (lookup == null) {
                Exception exc;
                String msg = "Cannot convert MXBean interface in this context";
                try {
                    Constructor<T> con = excClass.getConstructor(String.class);
                    exc = (Exception)con.newInstance("Cannot convert MXBean interface in this context");
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                throw exc;
            }
            return lookup;
        }
    }

    private static final class CollectionMapping
    extends NonNullMXBeanMapping {
        private final Class<? extends Collection<?>> collectionClass;
        private final MXBeanMapping elementMapping;

        CollectionMapping(Type targetType, ArrayType<?> openArrayType, Class<?> openArrayClass, MXBeanMapping elementMapping) {
            super(targetType, openArrayType);
            Class collC;
            this.elementMapping = elementMapping;
            Type raw = ((ParameterizedType)targetType).getRawType();
            Class c = (Class)raw;
            if (c == List.class) {
                collC = ArrayList.class;
            } else if (c == Set.class) {
                collC = HashSet.class;
            } else if (c == SortedSet.class) {
                collC = TreeSet.class;
            } else {
                assert (false);
                collC = null;
            }
            this.collectionClass = (Class)Util.cast(collC);
        }

        @Override
        final Object toNonNullOpenValue(Object value) throws OpenDataException {
            Comparator comparator;
            Collection valueCollection = (Collection)value;
            if (valueCollection instanceof SortedSet && (comparator = ((SortedSet)valueCollection).comparator()) != null) {
                String msg = "Cannot convert SortedSet with non-null comparator: " + comparator;
                throw DefaultMXBeanMappingFactory.openDataException(msg, new IllegalArgumentException(msg));
            }
            Object[] openArray = (Object[])Array.newInstance(this.getOpenClass().getComponentType(), valueCollection.size());
            int i = 0;
            for (Object o : valueCollection) {
                openArray[i++] = this.elementMapping.toOpenValue(o);
            }
            return openArray;
        }

        @Override
        final Object fromNonNullOpenValue(Object openValue) throws InvalidObjectException {
            Collection valueCollection;
            Object[] openArray = (Object[])openValue;
            try {
                valueCollection = (Collection)Util.cast(this.collectionClass.newInstance());
            }
            catch (Exception e) {
                throw DefaultMXBeanMappingFactory.invalidObjectException("Cannot create collection", e);
            }
            for (Object o : openArray) {
                Object value = this.elementMapping.fromOpenValue(o);
                if (valueCollection.add(value)) continue;
                String msg = "Could not add " + o + " to " + this.collectionClass.getName() + " (duplicate set element?)";
                throw new InvalidObjectException(msg);
            }
            return valueCollection;
        }

        @Override
        public void checkReconstructible() throws InvalidObjectException {
            this.elementMapping.checkReconstructible();
        }
    }

    private static final class ArrayMapping
    extends NonNullMXBeanMapping {
        private final MXBeanMapping elementMapping;

        ArrayMapping(Type targetType, ArrayType<?> openArrayType, Class<?> openArrayClass, MXBeanMapping elementMapping) {
            super(targetType, openArrayType);
            this.elementMapping = elementMapping;
        }

        @Override
        final Object toNonNullOpenValue(Object value) throws OpenDataException {
            Object[] valueArray = (Object[])value;
            int len = valueArray.length;
            Object[] openArray = (Object[])Array.newInstance(this.getOpenClass().getComponentType(), len);
            for (int i = 0; i < len; ++i) {
                openArray[i] = this.elementMapping.toOpenValue(valueArray[i]);
            }
            return openArray;
        }

        @Override
        final Object fromNonNullOpenValue(Object openValue) throws InvalidObjectException {
            Class<?> componentType;
            Object[] openArray = (Object[])openValue;
            Type javaType = this.getJavaType();
            if (javaType instanceof GenericArrayType) {
                componentType = ((GenericArrayType)javaType).getGenericComponentType();
            } else if (javaType instanceof Class && ((Class)javaType).isArray()) {
                componentType = ((Class)javaType).getComponentType();
            } else {
                throw new IllegalArgumentException("Not an array: " + javaType);
            }
            Object[] valueArray = (Object[])Array.newInstance(componentType, openArray.length);
            for (int i = 0; i < openArray.length; ++i) {
                valueArray[i] = this.elementMapping.fromOpenValue(openArray[i]);
            }
            return valueArray;
        }

        @Override
        public void checkReconstructible() throws InvalidObjectException {
            this.elementMapping.checkReconstructible();
        }
    }

    private static final class EnumMapping<T extends Enum<T>>
    extends NonNullMXBeanMapping {
        private final Class<T> enumClass;

        EnumMapping(Class<T> enumClass) {
            super(enumClass, SimpleType.STRING);
            this.enumClass = enumClass;
        }

        @Override
        final Object toNonNullOpenValue(Object value) {
            return ((Enum)value).name();
        }

        final T fromNonNullOpenValue(Object value) throws InvalidObjectException {
            try {
                return Enum.valueOf(this.enumClass, (String)value);
            }
            catch (Exception e) {
                throw DefaultMXBeanMappingFactory.invalidObjectException("Cannot convert to enum: " + value, e);
            }
        }
    }

    private static final class IdentityMapping
    extends NonNullMXBeanMapping {
        IdentityMapping(Type targetType, OpenType<?> openType) {
            super(targetType, openType);
        }

        @Override
        boolean isIdentity() {
            return true;
        }

        @Override
        Object fromNonNullOpenValue(Object openValue) throws InvalidObjectException {
            return openValue;
        }

        @Override
        Object toNonNullOpenValue(Object javaValue) throws OpenDataException {
            return javaValue;
        }
    }

    private static final class Mappings
    extends WeakHashMap<Type, WeakReference<MXBeanMapping>> {
        private Mappings() {
        }
    }

    static abstract class NonNullMXBeanMapping
    extends MXBeanMapping {
        NonNullMXBeanMapping(Type javaType, OpenType<?> openType) {
            super(javaType, openType);
        }

        @Override
        public final Object fromOpenValue(Object openValue) throws InvalidObjectException {
            if (openValue == null) {
                return null;
            }
            return this.fromNonNullOpenValue(openValue);
        }

        @Override
        public final Object toOpenValue(Object javaValue) throws OpenDataException {
            if (javaValue == null) {
                return null;
            }
            return this.toNonNullOpenValue(javaValue);
        }

        abstract Object fromNonNullOpenValue(Object var1) throws InvalidObjectException;

        abstract Object toNonNullOpenValue(Object var1) throws OpenDataException;

        boolean isIdentity() {
            return false;
        }
    }
}

