/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.TMSchema;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;

public class WindowsTreeUI
extends BasicTreeUI {
    protected static final int HALF_SIZE = 4;
    protected static final int SIZE = 9;

    public static ComponentUI createUI(JComponent c) {
        return new WindowsTreeUI();
    }

    @Override
    protected void ensureRowsAreVisible(int beginRow, int endRow) {
        if (this.tree != null && beginRow >= 0 && endRow < this.getRowCount(this.tree)) {
            Rectangle visRect = this.tree.getVisibleRect();
            if (beginRow == endRow) {
                Rectangle scrollBounds = this.getPathBounds(this.tree, this.getPathForRow(this.tree, beginRow));
                if (scrollBounds != null) {
                    scrollBounds.x = visRect.x;
                    scrollBounds.width = visRect.width;
                    this.tree.scrollRectToVisible(scrollBounds);
                }
            } else {
                Rectangle beginRect = this.getPathBounds(this.tree, this.getPathForRow(this.tree, beginRow));
                if (beginRect != null) {
                    Rectangle testRect = beginRect;
                    int beginY = beginRect.y;
                    int maxY = beginY + visRect.height;
                    for (int counter = beginRow + 1; counter <= endRow; ++counter) {
                        testRect = this.getPathBounds(this.tree, this.getPathForRow(this.tree, counter));
                        if (testRect == null || testRect.y + testRect.height <= maxY) continue;
                        counter = endRow;
                    }
                    this.tree.scrollRectToVisible(new Rectangle(visRect.x, beginY, 1, testRect.y + testRect.height - beginY));
                }
            }
        }
    }

    @Override
    protected TreeCellRenderer createDefaultCellRenderer() {
        return new WindowsTreeCellRenderer();
    }

    public class WindowsTreeCellRenderer
    extends DefaultTreeCellRenderer {
        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (!tree.isEnabled()) {
                this.setEnabled(false);
                if (leaf) {
                    this.setDisabledIcon(this.getLeafIcon());
                } else if (sel) {
                    this.setDisabledIcon(this.getOpenIcon());
                } else {
                    this.setDisabledIcon(this.getClosedIcon());
                }
            } else {
                this.setEnabled(true);
                if (leaf) {
                    this.setIcon(this.getLeafIcon());
                } else if (sel) {
                    this.setIcon(this.getOpenIcon());
                } else {
                    this.setIcon(this.getClosedIcon());
                }
            }
            return this;
        }
    }

    public static class CollapsedIcon
    extends ExpandedIcon {
        public static Icon createCollapsedIcon() {
            return new CollapsedIcon();
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            XPStyle.Skin skin = this.getSkin(c);
            if (skin != null) {
                skin.paintSkin(g, x, y, TMSchema.State.CLOSED);
            } else {
                super.paintIcon(c, g, x, y);
                g.drawLine(x + 4, y + 2, x + 4, y + 6);
            }
        }
    }

    public static class ExpandedIcon
    implements Icon,
    Serializable {
        public static Icon createExpandedIcon() {
            return new ExpandedIcon();
        }

        XPStyle.Skin getSkin(Component c) {
            XPStyle xp = XPStyle.getXP();
            return xp != null ? xp.getSkin(c, TMSchema.Part.TVP_GLYPH) : null;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            XPStyle.Skin skin = this.getSkin(c);
            if (skin != null) {
                skin.paintSkin(g, x, y, TMSchema.State.OPENED);
                return;
            }
            Color backgroundColor = c.getBackground();
            if (backgroundColor != null) {
                g.setColor(backgroundColor);
            } else {
                g.setColor(Color.white);
            }
            g.fillRect(x, y, 8, 8);
            g.setColor(Color.gray);
            g.drawRect(x, y, 8, 8);
            g.setColor(Color.black);
            g.drawLine(x + 2, y + 4, x + 6, y + 4);
        }

        @Override
        public int getIconWidth() {
            XPStyle.Skin skin = this.getSkin(null);
            return skin != null ? skin.getWidth() : 9;
        }

        @Override
        public int getIconHeight() {
            XPStyle.Skin skin = this.getSkin(null);
            return skin != null ? skin.getHeight() : 9;
        }
    }
}

