/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.TMSchema;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicSpinnerUI;

public class WindowsSpinnerUI
extends BasicSpinnerUI {
    public static ComponentUI createUI(JComponent c) {
        return new WindowsSpinnerUI();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (XPStyle.getXP() != null) {
            this.paintXPBackground(g, c);
        }
        super.paint(g, c);
    }

    private TMSchema.State getXPState(JComponent c) {
        TMSchema.State state = TMSchema.State.NORMAL;
        if (!c.isEnabled()) {
            state = TMSchema.State.DISABLED;
        }
        return state;
    }

    private void paintXPBackground(Graphics g, JComponent c) {
        XPStyle xp = XPStyle.getXP();
        XPStyle.Skin skin = xp.getSkin(c, TMSchema.Part.EP_EDIT);
        TMSchema.State state = this.getXPState(c);
        skin.paintSkin(g, 0, 0, c.getWidth(), c.getHeight(), state);
    }

    @Override
    protected Component createPreviousButton() {
        if (XPStyle.getXP() != null) {
            XPStyle.GlyphButton xpButton = new XPStyle.GlyphButton(this.spinner, TMSchema.Part.SPNP_DOWN);
            Dimension size = UIManager.getDimension("Spinner.arrowButtonSize");
            xpButton.setPreferredSize(size);
            xpButton.setRequestFocusEnabled(false);
            this.installPreviousButtonListeners(xpButton);
            return xpButton;
        }
        return super.createPreviousButton();
    }

    @Override
    protected Component createNextButton() {
        if (XPStyle.getXP() != null) {
            XPStyle.GlyphButton xpButton = new XPStyle.GlyphButton(this.spinner, TMSchema.Part.SPNP_UP);
            Dimension size = UIManager.getDimension("Spinner.arrowButtonSize");
            xpButton.setPreferredSize(size);
            xpButton.setRequestFocusEnabled(false);
            this.installNextButtonListeners(xpButton);
            return xpButton;
        }
        return super.createNextButton();
    }

    private UIResource getUIResource(Object[] listeners) {
        for (int counter = 0; counter < listeners.length; ++counter) {
            if (!(listeners[counter] instanceof UIResource)) continue;
            return (UIResource)listeners[counter];
        }
        return null;
    }
}

