/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.TMSchema;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import com.sun.java.swing.plaf.windows.WindowsMenuItemUI;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuBarUI;

public class WindowsMenuBarUI
extends BasicMenuBarUI {
    private WindowListener windowListener = null;
    private HierarchyListener hierarchyListener = null;
    private Window window = null;

    public static ComponentUI createUI(JComponent x) {
        return new WindowsMenuBarUI();
    }

    @Override
    protected void uninstallListeners() {
        this.uninstallWindowListener();
        if (this.hierarchyListener != null) {
            this.menuBar.removeHierarchyListener(this.hierarchyListener);
            this.hierarchyListener = null;
        }
        super.uninstallListeners();
    }

    private void installWindowListener() {
        Container component;
        if (this.windowListener == null && (component = this.menuBar.getTopLevelAncestor()) instanceof Window) {
            this.window = (Window)component;
            this.windowListener = new WindowAdapter(){

                @Override
                public void windowActivated(WindowEvent e) {
                    WindowsMenuBarUI.this.menuBar.repaint();
                }

                @Override
                public void windowDeactivated(WindowEvent e) {
                    WindowsMenuBarUI.this.menuBar.repaint();
                }
            };
            ((Window)component).addWindowListener(this.windowListener);
        }
    }

    private void uninstallWindowListener() {
        if (this.windowListener != null && this.window != null) {
            this.window.removeWindowListener(this.windowListener);
        }
        this.window = null;
        this.windowListener = null;
    }

    @Override
    protected void installListeners() {
        if (WindowsLookAndFeel.isOnVista()) {
            this.installWindowListener();
            this.hierarchyListener = new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent e) {
                    if ((e.getChangeFlags() & 2L) != 0L) {
                        if (WindowsMenuBarUI.this.menuBar.isDisplayable()) {
                            WindowsMenuBarUI.this.installWindowListener();
                        } else {
                            WindowsMenuBarUI.this.uninstallWindowListener();
                        }
                    }
                }
            };
            this.menuBar.addHierarchyListener(this.hierarchyListener);
        }
        super.installListeners();
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        ActionMap map = SwingUtilities.getUIActionMap(this.menuBar);
        if (map == null) {
            map = new ActionMapUIResource();
            SwingUtilities.replaceUIActionMap(this.menuBar, map);
        }
        map.put("takeFocus", new TakeFocus());
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (WindowsMenuItemUI.isVistaPainting()) {
            XPStyle xp = XPStyle.getXP();
            XPStyle.Skin skin = xp.getSkin(c, TMSchema.Part.MP_BARBACKGROUND);
            int width = c.getWidth();
            int height = c.getHeight();
            TMSchema.State state = WindowsMenuBarUI.isActive(c) ? TMSchema.State.ACTIVE : TMSchema.State.INACTIVE;
            skin.paintSkin(g, 0, 0, width, height, state);
        } else {
            super.paint(g, c);
        }
    }

    static boolean isActive(JComponent c) {
        Container component;
        JRootPane rootPane = c.getRootPane();
        if (rootPane != null && (component = rootPane.getParent()) instanceof Window) {
            return ((Window)component).isActive();
        }
        return true;
    }

    private static class TakeFocus
    extends AbstractAction {
        private TakeFocus() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JMenuBar menuBar = (JMenuBar)e.getSource();
            JMenu menu = menuBar.getMenu(0);
            if (menu != null) {
                MenuSelectionManager msm = MenuSelectionManager.defaultManager();
                MenuElement[] path = new MenuElement[]{menuBar, menu};
                msm.setSelectedPath(path);
                WindowsLookAndFeel.setMnemonicHidden(false);
                WindowsLookAndFeel.repaintRootPane(menuBar);
            }
        }
    }
}

