/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.TMSchema;
import com.sun.java.swing.plaf.windows.WindowsGraphicsUtils;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;
import sun.swing.SwingUtilities2;

public class WindowsInternalFrameTitlePane
extends BasicInternalFrameTitlePane {
    private Color selectedTitleGradientColor;
    private Color notSelectedTitleGradientColor;
    private JPopupMenu systemPopupMenu;
    private JLabel systemLabel;
    private Font titleFont;
    private int titlePaneHeight;
    private int buttonWidth;
    private int buttonHeight;
    private boolean hotTrackingOn;

    public WindowsInternalFrameTitlePane(JInternalFrame f) {
        super(f);
    }

    @Override
    protected void addSubComponents() {
        this.add(this.systemLabel);
        this.add(this.iconButton);
        this.add(this.maxButton);
        this.add(this.closeButton);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.titlePaneHeight = UIManager.getInt("InternalFrame.titlePaneHeight");
        this.buttonWidth = UIManager.getInt("InternalFrame.titleButtonWidth") - 4;
        this.buttonHeight = UIManager.getInt("InternalFrame.titleButtonHeight") - 4;
        Object obj = UIManager.get("InternalFrame.titleButtonToolTipsOn");
        boolean bl = this.hotTrackingOn = obj instanceof Boolean ? (Boolean)obj : true;
        if (XPStyle.getXP() != null) {
            this.buttonWidth = this.buttonHeight;
            Dimension d = XPStyle.getPartSize(TMSchema.Part.WP_CLOSEBUTTON, TMSchema.State.NORMAL);
            if (d != null && d.width != 0 && d.height != 0) {
                this.buttonWidth = (int)((float)this.buttonWidth * (float)d.width / (float)d.height);
            }
        } else {
            this.buttonWidth += 2;
            this.selectedTitleGradientColor = UIManager.getColor("InternalFrame.activeTitleGradient");
            this.notSelectedTitleGradientColor = UIManager.getColor("InternalFrame.inactiveTitleGradient");
            Color activeBorderColor = UIManager.getColor("InternalFrame.activeBorderColor");
            this.setBorder(BorderFactory.createLineBorder(activeBorderColor, 1));
        }
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
    }

    @Override
    protected void createButtons() {
        super.createButtons();
        if (XPStyle.getXP() != null) {
            this.iconButton.setContentAreaFilled(false);
            this.maxButton.setContentAreaFilled(false);
            this.closeButton.setContentAreaFilled(false);
        }
    }

    @Override
    protected void setButtonIcons() {
        super.setButtonIcons();
        if (!this.hotTrackingOn) {
            this.iconButton.setToolTipText(null);
            this.maxButton.setToolTipText(null);
            this.closeButton.setToolTipText(null);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        XPStyle xp = XPStyle.getXP();
        this.paintTitleBackground(g);
        String title = this.frame.getTitle();
        if (title != null) {
            int titleW;
            int titleX;
            boolean isSelected = this.frame.isSelected();
            Font oldFont = g.getFont();
            Font newFont = this.titleFont != null ? this.titleFont : this.getFont();
            g.setFont(newFont);
            FontMetrics fm = SwingUtilities2.getFontMetrics(this.frame, g, newFont);
            int baseline = (this.getHeight() + fm.getAscent() - fm.getLeading() - fm.getDescent()) / 2;
            Rectangle lastIconBounds = new Rectangle(0, 0, 0, 0);
            if (this.frame.isIconifiable()) {
                lastIconBounds = this.iconButton.getBounds();
            } else if (this.frame.isMaximizable()) {
                lastIconBounds = this.maxButton.getBounds();
            } else if (this.frame.isClosable()) {
                lastIconBounds = this.closeButton.getBounds();
            }
            int gap = 2;
            if (WindowsGraphicsUtils.isLeftToRight(this.frame)) {
                if (lastIconBounds.x == 0) {
                    lastIconBounds.x = this.frame.getWidth() - this.frame.getInsets().right;
                }
                titleX = this.systemLabel.getX() + this.systemLabel.getWidth() + gap;
                if (xp != null) {
                    titleX += 2;
                }
                titleW = lastIconBounds.x - titleX - gap;
            } else {
                int availableWidth;
                if (lastIconBounds.x == 0) {
                    lastIconBounds.x = this.frame.getInsets().left;
                }
                titleW = SwingUtilities2.stringWidth(this.frame, fm, title);
                int minTitleX = lastIconBounds.x + lastIconBounds.width + gap;
                if (xp != null) {
                    minTitleX += 2;
                }
                if ((availableWidth = this.systemLabel.getX() - gap - minTitleX) > titleW) {
                    titleX = this.systemLabel.getX() - gap - titleW;
                } else {
                    titleX = minTitleX;
                    titleW = availableWidth;
                }
            }
            title = this.getTitle(this.frame.getTitle(), fm, titleW);
            if (xp != null) {
                String shadowType = null;
                if (isSelected) {
                    shadowType = xp.getString(this, TMSchema.Part.WP_CAPTION, TMSchema.State.ACTIVE, TMSchema.Prop.TEXTSHADOWTYPE);
                }
                if ("single".equalsIgnoreCase(shadowType)) {
                    Point shadowOffset = xp.getPoint(this, TMSchema.Part.WP_WINDOW, TMSchema.State.ACTIVE, TMSchema.Prop.TEXTSHADOWOFFSET);
                    Color shadowColor = xp.getColor(this, TMSchema.Part.WP_WINDOW, TMSchema.State.ACTIVE, TMSchema.Prop.TEXTSHADOWCOLOR, null);
                    if (shadowOffset != null && shadowColor != null) {
                        g.setColor(shadowColor);
                        SwingUtilities2.drawString((JComponent)this.frame, g, title, titleX + shadowOffset.x, baseline + shadowOffset.y);
                    }
                }
            }
            g.setColor(isSelected ? this.selectedTextColor : this.notSelectedTextColor);
            SwingUtilities2.drawString((JComponent)this.frame, g, title, titleX, baseline);
            g.setFont(oldFont);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension d = new Dimension(super.getMinimumSize());
        d.height = this.titlePaneHeight + 2;
        XPStyle xp = XPStyle.getXP();
        if (xp != null) {
            d.height = this.frame.isMaximum() ? --d.height : (d.height += 3);
        }
        return d;
    }

    @Override
    protected void paintTitleBackground(Graphics g) {
        XPStyle xp = XPStyle.getXP();
        if (xp != null) {
            TMSchema.Part part = this.frame.isIcon() ? TMSchema.Part.WP_MINCAPTION : (this.frame.isMaximum() ? TMSchema.Part.WP_MAXCAPTION : TMSchema.Part.WP_CAPTION);
            TMSchema.State state = this.frame.isSelected() ? TMSchema.State.ACTIVE : TMSchema.State.INACTIVE;
            XPStyle.Skin skin = xp.getSkin(this, part);
            skin.paintSkin(g, 0, 0, this.getWidth(), this.getHeight(), state);
        } else {
            Boolean gradientsOn = (Boolean)LookAndFeel.getDesktopPropertyValue("win.frame.captionGradientsOn", false);
            if (gradientsOn.booleanValue() && g instanceof Graphics2D) {
                Graphics2D g2 = (Graphics2D)g;
                Paint savePaint = g2.getPaint();
                boolean isSelected = this.frame.isSelected();
                int w = this.getWidth();
                if (isSelected) {
                    GradientPaint titleGradient = new GradientPaint(0.0f, 0.0f, this.selectedTitleColor, (int)((double)w * 0.75), 0.0f, this.selectedTitleGradientColor);
                    g2.setPaint(titleGradient);
                } else {
                    GradientPaint titleGradient = new GradientPaint(0.0f, 0.0f, this.notSelectedTitleColor, (int)((double)w * 0.75), 0.0f, this.notSelectedTitleGradientColor);
                    g2.setPaint(titleGradient);
                }
                g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                g2.setPaint(savePaint);
            } else {
                super.paintTitleBackground(g);
            }
        }
    }

    @Override
    protected void assembleSystemMenu() {
        this.systemPopupMenu = new JPopupMenu();
        this.addSystemMenuItems(this.systemPopupMenu);
        this.enableActions();
        this.systemLabel = new JLabel(this.frame.getFrameIcon()){

            @Override
            protected void paintComponent(Graphics g) {
                int iconHeight;
                int iconWidth;
                Icon icon;
                int x = 0;
                int y = 0;
                int w = this.getWidth();
                int h = this.getHeight();
                g = g.create();
                if (this.isOpaque()) {
                    g.setColor(this.getBackground());
                    g.fillRect(0, 0, w, h);
                }
                if ((icon = this.getIcon()) != null && (iconWidth = icon.getIconWidth()) > 0 && (iconHeight = icon.getIconHeight()) > 0) {
                    double drawScale;
                    if (iconWidth > iconHeight) {
                        y = (h - w * iconHeight / iconWidth) / 2;
                        drawScale = (double)w / (double)iconWidth;
                    } else {
                        x = (w - h * iconWidth / iconHeight) / 2;
                        drawScale = (double)h / (double)iconHeight;
                    }
                    ((Graphics2D)g).translate(x, y);
                    ((Graphics2D)g).scale(drawScale, drawScale);
                    icon.paintIcon(this, g, 0, 0);
                }
                g.dispose();
            }
        };
        this.systemLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && WindowsInternalFrameTitlePane.this.frame.isClosable() && !WindowsInternalFrameTitlePane.this.frame.isIcon()) {
                    WindowsInternalFrameTitlePane.this.systemPopupMenu.setVisible(false);
                    WindowsInternalFrameTitlePane.this.frame.doDefaultCloseAction();
                } else {
                    super.mouseClicked(e);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                try {
                    WindowsInternalFrameTitlePane.this.frame.setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                WindowsInternalFrameTitlePane.this.showSystemPopupMenu(e.getComponent());
            }
        });
    }

    protected void addSystemMenuItems(JPopupMenu menu) {
        JMenuItem mi = menu.add(this.restoreAction);
        mi.setMnemonic('R');
        mi = menu.add(this.moveAction);
        mi.setMnemonic('M');
        mi = menu.add(this.sizeAction);
        mi.setMnemonic('S');
        mi = menu.add(this.iconifyAction);
        mi.setMnemonic('n');
        mi = menu.add(this.maximizeAction);
        mi.setMnemonic('x');
        this.systemPopupMenu.add(new JSeparator());
        mi = menu.add(this.closeAction);
        mi.setMnemonic('C');
    }

    @Override
    protected void showSystemMenu() {
        this.showSystemPopupMenu(this.systemLabel);
    }

    private void showSystemPopupMenu(Component invoker) {
        Dimension dim = new Dimension();
        Border border = this.frame.getBorder();
        if (border != null) {
            dim.width += border.getBorderInsets((Component)this.frame).left + border.getBorderInsets((Component)this.frame).right;
            dim.height += border.getBorderInsets((Component)this.frame).bottom + border.getBorderInsets((Component)this.frame).top;
        }
        if (!this.frame.isIcon()) {
            this.systemPopupMenu.show(invoker, this.getX() - dim.width, this.getY() + this.getHeight() - dim.height);
        } else {
            this.systemPopupMenu.show(invoker, this.getX() - dim.width, this.getY() - this.systemPopupMenu.getPreferredSize().height - dim.height);
        }
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        return new WindowsPropertyChangeHandler();
    }

    @Override
    protected LayoutManager createLayout() {
        return new WindowsTitlePaneLayout();
    }

    public static class ScalableIconUIResource
    implements Icon,
    UIResource {
        private static final int SIZE = 16;
        private Icon[] icons;

        public ScalableIconUIResource(Object[] objects) {
            this.icons = new Icon[objects.length];
            for (int i = 0; i < objects.length; ++i) {
                this.icons[i] = objects[i] instanceof UIDefaults.LazyValue ? (Icon)((UIDefaults.LazyValue)objects[i]).createValue(null) : (Icon)objects[i];
            }
        }

        protected Icon getBestIcon(int size) {
            if (this.icons != null && this.icons.length > 0) {
                int bestIndex = 0;
                int minDiff = Integer.MAX_VALUE;
                for (int i = 0; i < this.icons.length; ++i) {
                    int diff;
                    int iconSize;
                    Icon icon = this.icons[i];
                    if (icon == null || (iconSize = icon.getIconWidth()) <= 0 || (diff = Math.abs(iconSize - size)) >= minDiff) continue;
                    minDiff = diff;
                    bestIndex = i;
                }
                return this.icons[bestIndex];
            }
            return null;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            int iconSize;
            double scale;
            Graphics2D g2d = (Graphics2D)g.create();
            int size = this.getIconWidth();
            Icon icon = this.getBestIcon((int)((double)size * (scale = g2d.getTransform().getScaleX())));
            if (icon != null && (iconSize = icon.getIconWidth()) > 0) {
                double drawScale = (double)size / (double)iconSize;
                g2d.translate(x, y);
                g2d.scale(drawScale, drawScale);
                icon.paintIcon(c, g2d, 0, 0);
            }
            g2d.dispose();
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }
    }

    public class WindowsPropertyChangeHandler
    extends BasicInternalFrameTitlePane.PropertyChangeHandler {
        public WindowsPropertyChangeHandler() {
            super(WindowsInternalFrameTitlePane.this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String prop = evt.getPropertyName();
            if ("frameIcon".equals(prop) && WindowsInternalFrameTitlePane.this.systemLabel != null) {
                WindowsInternalFrameTitlePane.this.systemLabel.setIcon(WindowsInternalFrameTitlePane.this.frame.getFrameIcon());
            }
            super.propertyChange(evt);
        }
    }

    public class WindowsTitlePaneLayout
    extends BasicInternalFrameTitlePane.TitlePaneLayout {
        private Insets captionMargin;
        private Insets contentMargin;
        private XPStyle xp;

        WindowsTitlePaneLayout() {
            super(WindowsInternalFrameTitlePane.this);
            this.captionMargin = null;
            this.contentMargin = null;
            this.xp = XPStyle.getXP();
            if (this.xp != null) {
                WindowsInternalFrameTitlePane c = WindowsInternalFrameTitlePane.this;
                this.captionMargin = this.xp.getMargin(c, TMSchema.Part.WP_CAPTION, null, TMSchema.Prop.CAPTIONMARGINS);
                this.contentMargin = this.xp.getMargin(c, TMSchema.Part.WP_CAPTION, null, TMSchema.Prop.CONTENTMARGINS);
            }
            if (this.captionMargin == null) {
                this.captionMargin = new Insets(0, 2, 0, 2);
            }
            if (this.contentMargin == null) {
                this.contentMargin = new Insets(0, 0, 0, 0);
            }
        }

        private int layoutButton(JComponent button, TMSchema.Part part, int x, int y, int w, int h, int gap, boolean leftToRight) {
            if (!leftToRight) {
                x -= w;
            }
            button.setBounds(x, y, w, h);
            x = leftToRight ? (x += w + 2) : (x -= 2);
            return x;
        }

        @Override
        public void layoutContainer(Container c) {
            int iconSize;
            boolean leftToRight = WindowsGraphicsUtils.isLeftToRight(WindowsInternalFrameTitlePane.this.frame);
            int w = WindowsInternalFrameTitlePane.this.getWidth();
            int h = WindowsInternalFrameTitlePane.this.getHeight();
            int n = iconSize = this.xp != null ? (h - 2) * 6 / 10 : h - 4;
            int x = this.xp != null ? (leftToRight ? this.captionMargin.left + 2 : w - this.captionMargin.right - 2) : (leftToRight ? this.captionMargin.left : w - this.captionMargin.right);
            int y = (h - iconSize) / 2;
            this.layoutButton(WindowsInternalFrameTitlePane.this.systemLabel, TMSchema.Part.WP_SYSBUTTON, x, y, iconSize, iconSize, 0, leftToRight);
            if (this.xp != null) {
                x = leftToRight ? w - this.captionMargin.right - 2 : this.captionMargin.left + 2;
                y = 1;
                y = WindowsInternalFrameTitlePane.this.frame.isMaximum() ? ++y : (y += 5);
            } else {
                x = leftToRight ? w - this.captionMargin.right : this.captionMargin.left;
                y = (h - WindowsInternalFrameTitlePane.this.buttonHeight) / 2;
            }
            if (WindowsInternalFrameTitlePane.this.frame.isClosable()) {
                x = this.layoutButton(WindowsInternalFrameTitlePane.this.closeButton, TMSchema.Part.WP_CLOSEBUTTON, x, y, WindowsInternalFrameTitlePane.this.buttonWidth, WindowsInternalFrameTitlePane.this.buttonHeight, 2, !leftToRight);
            }
            if (WindowsInternalFrameTitlePane.this.frame.isMaximizable()) {
                x = this.layoutButton(WindowsInternalFrameTitlePane.this.maxButton, TMSchema.Part.WP_MAXBUTTON, x, y, WindowsInternalFrameTitlePane.this.buttonWidth, WindowsInternalFrameTitlePane.this.buttonHeight, this.xp != null ? 2 : 0, !leftToRight);
            }
            if (WindowsInternalFrameTitlePane.this.frame.isIconifiable()) {
                this.layoutButton(WindowsInternalFrameTitlePane.this.iconButton, TMSchema.Part.WP_MINBUTTON, x, y, WindowsInternalFrameTitlePane.this.buttonWidth, WindowsInternalFrameTitlePane.this.buttonHeight, 0, !leftToRight);
            }
        }
    }
}

