/*
 * Decompiled with CFR 0.152.
 */
package com.sun.beans;

import com.sun.beans.WeakCache;
import com.sun.beans.WildcardTypeImpl;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.Map;
import sun.reflect.generics.reflectiveObjects.GenericArrayTypeImpl;
import sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl;

public final class TypeResolver {
    private static final WeakCache<Type, TypeResolver> CACHE = new WeakCache();
    private final Map<TypeVariable<?>, Type> map = new HashMap();

    public static Type resolveInClass(Class<?> inClass, Type type) {
        return TypeResolver.resolve(TypeResolver.getActualType(inClass), type);
    }

    public static Type[] resolveInClass(Class<?> inClass, Type[] types) {
        return TypeResolver.resolve(TypeResolver.getActualType(inClass), types);
    }

    public static Type resolve(Type actual, Type formal) {
        return TypeResolver.getTypeResolver(actual).resolve(formal);
    }

    public static Type[] resolve(Type actual, Type[] formals) {
        return TypeResolver.getTypeResolver(actual).resolve(formals);
    }

    public static Class<?> erase(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            return (Class)pt.getRawType();
        }
        if (type instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)type;
            Type[] bounds = tv.getBounds();
            return 0 < bounds.length ? TypeResolver.erase(bounds[0]) : Object.class;
        }
        if (type instanceof WildcardType) {
            WildcardType wt = (WildcardType)type;
            Type[] bounds = wt.getUpperBounds();
            return 0 < bounds.length ? TypeResolver.erase(bounds[0]) : Object.class;
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType gat = (GenericArrayType)type;
            return Array.newInstance(TypeResolver.erase(gat.getGenericComponentType()), 0).getClass();
        }
        throw new IllegalArgumentException("Unknown Type kind: " + type.getClass());
    }

    public static Class[] erase(Type[] types) {
        int length = types.length;
        Class[] classes = new Class[length];
        for (int i = 0; i < length; ++i) {
            classes[i] = TypeResolver.erase(types[i]);
        }
        return classes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TypeResolver getTypeResolver(Type type) {
        WeakCache<Type, TypeResolver> weakCache = CACHE;
        synchronized (weakCache) {
            TypeResolver resolver = CACHE.get(type);
            if (resolver == null) {
                resolver = new TypeResolver(type);
                CACHE.put(type, resolver);
            }
            return resolver;
        }
    }

    private TypeResolver(Type actual) {
        this.prepare(actual);
    }

    private void prepare(Type type) {
        TypeVariable<Class<T>>[] actuals;
        Class raw = (Class)(type instanceof Class ? type : ((ParameterizedType)type).getRawType());
        TypeVariable<Class<T>>[] formals = raw.getTypeParameters();
        Type[] typeArray = actuals = type instanceof Class ? formals : ((ParameterizedType)type).getActualTypeArguments();
        assert (formals.length == actuals.length);
        for (int i = 0; i < formals.length; ++i) {
            this.map.put(formals[i], actuals[i]);
        }
        Type gSuperclass = raw.getGenericSuperclass();
        if (gSuperclass != null) {
            this.prepare(gSuperclass);
        }
        for (Type gInterface : raw.getGenericInterfaces()) {
            this.prepare(gInterface);
        }
        if (type instanceof Class && formals.length > 0) {
            for (Map.Entry<TypeVariable<?>, Type> entry : this.map.entrySet()) {
                entry.setValue(TypeResolver.erase(entry.getValue()));
            }
        }
    }

    private Type resolve(Type formal) {
        if (formal instanceof Class) {
            return formal;
        }
        if (formal instanceof GenericArrayType) {
            Type comp = ((GenericArrayType)formal).getGenericComponentType();
            return (comp = this.resolve(comp)) instanceof Class ? Array.newInstance((Class)comp, 0).getClass() : GenericArrayTypeImpl.make(comp);
        }
        if (formal instanceof ParameterizedType) {
            ParameterizedType fpt = (ParameterizedType)formal;
            Type[] actuals = this.resolve(fpt.getActualTypeArguments());
            return ParameterizedTypeImpl.make((Class)fpt.getRawType(), actuals, fpt.getOwnerType());
        }
        if (formal instanceof WildcardType) {
            WildcardType fwt = (WildcardType)formal;
            Type[] upper = this.resolve(fwt.getUpperBounds());
            Type[] lower = this.resolve(fwt.getLowerBounds());
            return new WildcardTypeImpl(upper, lower);
        }
        if (!(formal instanceof TypeVariable)) {
            throw new IllegalArgumentException("Bad Type kind: " + formal.getClass());
        }
        Type actual = this.map.get((TypeVariable)formal);
        if (actual == null || actual.equals(formal)) {
            return formal;
        }
        actual = TypeResolver.fixGenericArray(actual);
        return this.resolve(actual);
    }

    private Type[] resolve(Type[] formals) {
        int length = formals.length;
        Type[] actuals = new Type[length];
        for (int i = 0; i < length; ++i) {
            actuals[i] = this.resolve(formals[i]);
        }
        return actuals;
    }

    private static Type fixGenericArray(Type type) {
        if (type instanceof GenericArrayType) {
            Type comp = ((GenericArrayType)type).getGenericComponentType();
            if ((comp = TypeResolver.fixGenericArray(comp)) instanceof Class) {
                return Array.newInstance((Class)comp, 0).getClass();
            }
        }
        return type;
    }

    private static Type getActualType(Class<?> inClass) {
        Type[] params = inClass.getTypeParameters();
        return params.length == 0 ? inClass : ParameterizedTypeImpl.make(inClass, params, inClass.getEnclosingClass());
    }
}

