/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime.sparc;

import sun.jvm.hotspot.asm.sparc.SPARCArgument;
import sun.jvm.hotspot.asm.sparc.SPARCRegisters;
import sun.jvm.hotspot.code.CodeBlob;
import sun.jvm.hotspot.code.NMethod;
import sun.jvm.hotspot.compiler.OopMapSet;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.debugger.cdbg.CDebugger;
import sun.jvm.hotspot.debugger.cdbg.ClosestSymbol;
import sun.jvm.hotspot.debugger.cdbg.LoadObject;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.oops.UnknownOopException;
import sun.jvm.hotspot.runtime.BasicObjectLock;
import sun.jvm.hotspot.runtime.Frame;
import sun.jvm.hotspot.runtime.JavaCallWrapper;
import sun.jvm.hotspot.runtime.RegisterMap;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObjectFactory;
import sun.jvm.hotspot.runtime.posix.POSIXSignals;
import sun.jvm.hotspot.runtime.sparc.SPARCRegisterMap;
import sun.jvm.hotspot.utilities.AddressOps;
import sun.jvm.hotspot.utilities.Assert;
import sun.jvm.hotspot.utilities.Bits;

public class SPARCFrame
extends Frame {
    private Address raw_youngerSP;
    private long interpreterSPAdjustmentOffset;
    private static final int WORDS_PER_LONG = 2;
    public static final int PC_RETURN_OFFSET = 8;
    public static final int REGISTER_SAVE_WORDS = 16;
    public static final int CALLEE_AGGREGATE_RETURN_POINTER_WORDS = 1;
    public static final int CALLEE_REGISTER_ARGUMENT_SAVE_AREA_WORDS = 6;
    public static final int REGISTER_SAVE_WORDS_SP_OFFSET = 0;
    public static final int CALLEE_AGGREGATE_RETURN_POINTER_SP_OFFSET = 16;
    public static final int CALLEE_REGISTER_ARGUMENT_SAVE_AREA_SP_OFFSET = 17;
    public static final int MEMORY_PARAMETER_WORD_SP_OFFSET = 23;
    public static final int VARARGS_OFFSET = 23;
    private static final boolean DEBUG = System.getProperty("sun.jvm.hotspot.runtime.sparc.SPARCFrame.DEBUG") != null;
    public static final int INTERPRETER_FRAME_D_SCRATCH_FP_OFFSET = -2;
    public static final int INTERPRETER_FRAME_L_SCRATCH_FP_OFFSET = -4;
    public static final int INTERPRETER_FRAME_PADDING_OFFSET = -5;
    public static final int INTERPRETER_FRAME_MIRROR_OFFSET = -6;
    public static final int INTERPRETER_FRAME_VM_LOCALS_FP_OFFSET = -6;
    public static final int INTERPRETER_FRAME_VM_LOCAL_WORDS = 6;
    public static final int INTERPRETER_FRAME_EXTRA_OUTGOING_ARGUMENT_WORDS = 2;

    public static Address unBiasSP(Address raw_sp) {
        if (raw_sp != null) {
            return raw_sp.addOffsetTo(VM.getVM().getStackBias());
        }
        return null;
    }

    public static Address biasSP(Address real_sp) {
        if (real_sp != null) {
            if (DEBUG) {
                System.out.println("biasing realsp: " + real_sp + " biased: " + real_sp.addOffsetTo(-VM.getVM().getStackBias()));
            }
            return real_sp.addOffsetTo(-VM.getVM().getStackBias());
        }
        if (DEBUG) {
            System.out.println("biasing null realsp");
        }
        return null;
    }

    public static Address findYoungerSP(Address top, Address find) {
        Address findRaw = SPARCFrame.biasSP(find);
        if (top == null || find == null || findRaw == null) {
            throw new RuntimeException("bad values for findYoungerSP top: " + top + " find: " + find);
        }
        int maxFrames = 20;
        int count = 0;
        Address search = top;
        if (DEBUG) {
            System.out.println("findYoungerSP top: " + top + " find: " + find + " findRaw: " + findRaw);
        }
        while (count != 20 && search != null) {
            Address next = search.getAddressAt(SPARCRegisters.I6.spOffsetInSavedWindow());
            Address pc = search.getAddressAt(SPARCRegisters.I7.spOffsetInSavedWindow());
            if (DEBUG) {
                System.out.println("findYoungerSP next: " + next + " pc: " + pc);
            }
            if (next.equals(findRaw)) {
                return search;
            }
            search = SPARCFrame.unBiasSP(next);
        }
        if (DEBUG) {
            System.out.println("findYoungerSP: never found younger, top: " + top + " find: " + find);
        }
        return null;
    }

    @Override
    public Address getSP() {
        if (DEBUG) {
            System.out.println("getSP raw: " + this.raw_sp + " unbiased: " + SPARCFrame.unBiasSP(this.raw_sp));
        }
        return SPARCFrame.unBiasSP(this.raw_sp);
    }

    @Override
    public Address getID() {
        return this.getSP();
    }

    public Address getYoungerSP() {
        if (DEBUG) {
            System.out.println("getYoungerSP: " + this.raw_youngerSP + " unbiased: " + SPARCFrame.unBiasSP(this.raw_youngerSP));
        }
        return SPARCFrame.unBiasSP(this.raw_youngerSP);
    }

    public SPARCFrame(Address raw_sp, Address raw_youngerSP, boolean youngerFrameIsInterpreted) {
        NMethod nm;
        CodeBlob cb;
        if (DEBUG) {
            System.out.println("Constructing frame(1) raw_sp: " + raw_sp + " raw_youngerSP: " + raw_youngerSP);
        }
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(SPARCFrame.unBiasSP(raw_sp).andWithMask(VM.getVM().getAddressSize() - 1L) == null, "Expected raw sp likely got real sp, value was " + raw_sp);
            if (raw_youngerSP != null) {
                Assert.that(SPARCFrame.unBiasSP(raw_youngerSP).andWithMask(VM.getVM().getAddressSize() - 1L) == null, "Expected raw youngerSP likely got real youngerSP, value was " + raw_youngerSP);
            }
        }
        this.raw_sp = raw_sp;
        this.raw_youngerSP = raw_youngerSP;
        if (raw_youngerSP == null) {
            this.pc = null;
        } else {
            Address youngerSP = SPARCFrame.unBiasSP(raw_youngerSP);
            this.pc = youngerSP.getAddressAt(SPARCRegisters.I7.spOffsetInSavedWindow()).addOffsetTo(8L);
            if (Assert.ASSERTS_ENABLED) {
                Assert.that(youngerSP.getAddressAt(SPARCRegisters.FP.spOffsetInSavedWindow()).equals(raw_sp), "youngerSP must be valid");
            }
        }
        if (youngerFrameIsInterpreted) {
            long IsavedSP = SPARCRegisters.IsavedSP.spOffsetInSavedWindow();
            this.interpreterSPAdjustmentOffset = 0L;
            Address savedSP = SPARCFrame.unBiasSP(this.getYoungerSP().getAddressAt(IsavedSP));
            if (savedSP == null) {
                if (DEBUG) {
                    System.out.println("WARNING: IsavedSP was null for frame " + this);
                }
            } else {
                this.interpreterSPAdjustmentOffset = savedSP.minus(this.getSP());
            }
        } else {
            this.interpreterSPAdjustmentOffset = 0L;
        }
        if (this.pc != null && (cb = VM.getVM().getCodeCache().findBlob(this.pc)) != null && cb.isJavaMethod() && this.pc.equals((nm = (NMethod)cb).deoptHandlerBegin())) {
            this.pc = this.getUnextendedSP().getAddressAt(nm.origPCOffset());
            this.deoptimized = true;
        }
    }

    public SPARCFrame(Address raw_sp, Address pc) {
        if (DEBUG) {
            System.out.println("Constructing frame(2) raw_sp: " + raw_sp);
        }
        this.raw_sp = raw_sp;
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(SPARCFrame.unBiasSP(raw_sp).andWithMask(VM.getVM().getAddressSize() - 1L) == null, "Expected raw sp likely got real sp, value was " + raw_sp);
        }
        this.raw_youngerSP = null;
        this.pc = pc;
        this.interpreterSPAdjustmentOffset = 0L;
    }

    private SPARCFrame() {
    }

    @Override
    public Object clone() {
        SPARCFrame frame = new SPARCFrame();
        frame.raw_sp = this.raw_sp;
        frame.pc = this.pc;
        frame.raw_youngerSP = this.raw_youngerSP;
        frame.interpreterSPAdjustmentOffset = this.interpreterSPAdjustmentOffset;
        frame.deoptimized = this.deoptimized;
        return frame;
    }

    @Override
    public boolean equals(Object arg) {
        if (arg == null) {
            return false;
        }
        if (!(arg instanceof SPARCFrame)) {
            return false;
        }
        SPARCFrame other = (SPARCFrame)arg;
        return AddressOps.equal(this.getSP(), other.getSP()) && AddressOps.equal(this.getFP(), other.getFP()) && AddressOps.equal(this.getPC(), other.getPC());
    }

    public int hashCode() {
        if (this.raw_sp == null) {
            return 0;
        }
        return this.raw_sp.hashCode();
    }

    public String toString() {
        Address fp = this.getFP();
        Address sp = this.getSP();
        Address youngerSP = this.getYoungerSP();
        return "sp: " + (sp == null ? "null" : sp.toString()) + ", younger_sp: " + (youngerSP == null ? "null" : youngerSP.toString()) + ", fp: " + (fp == null ? "null" : fp.toString()) + ", pc: " + (this.pc == null ? "null" : this.pc.toString());
    }

    @Override
    public boolean isSignalHandlerFrameDbg() {
        Address sigInfoAddr;
        CDebugger cdbg = VM.getVM().getDebugger().getCDebugger();
        if (cdbg != null) {
            LoadObject dso = cdbg.loadObjectContainingPC(this.getPC());
            if (dso != null) {
                ClosestSymbol cs = dso.closestSymbolToPC(this.getPC());
                return cs != null && cs.getName().equals("__sighndlr");
            }
            return false;
        }
        if (this.getYoungerSP() == null) {
            return false;
        }
        Address i2 = this.getSP().getAddressAt(SPARCRegisters.I2.spOffsetInSavedWindow());
        if (i2 == null) {
            return false;
        }
        Address fp = this.getFP();
        int MAJOR_HACK_OFFSET = 8;
        boolean res = i2.equals(fp.addOffsetTo(VM.getVM().getAddressSize() * (long)(16 + MAJOR_HACK_OFFSET)));
        if (res && (sigInfoAddr = this.getSP().getAddressAt(SPARCRegisters.I5.spOffsetInSavedWindow())) == null) {
            System.err.println("Frame with fp = " + fp + " looked like a signal handler frame but wasn't");
            res = false;
        }
        return res;
    }

    @Override
    public int getSignalNumberDbg() {
        Address sigInfoAddr = this.getSP().getAddressAt(SPARCRegisters.I5.spOffsetInSavedWindow());
        return (int)sigInfoAddr.getCIntegerAt(0L, 4L, false);
    }

    @Override
    public String getSignalNameDbg() {
        return POSIXSignals.getSignalName(this.getSignalNumberDbg());
    }

    @Override
    public boolean isInterpretedFrameValid() {
        Method method;
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.isInterpretedFrame(), "Not an interpreted frame");
        }
        if (this.getFP() == null || this.getFP().andWithMask(2L * VM.getVM().getAddressSize() - 1L) != null) {
            return false;
        }
        if (this.getSP() == null || this.getSP().andWithMask(2L * VM.getVM().getAddressSize() - 1L) != null) {
            return false;
        }
        if (this.getFP().addOffsetTo(6L * VM.getVM().getAddressSize()).lessThan(this.getSP())) {
            return false;
        }
        OopHandle methodHandle = this.addressOfInterpreterFrameMethod().getOopHandleAt(0L);
        if (!VM.getVM().getObjectHeap().isValidMethod(methodHandle)) {
            return false;
        }
        if (this.getFP().lessThanOrEqual(this.getSP())) {
            return false;
        }
        if (this.getFP().minus(this.getSP()) > 4096L * VM.getVM().getAddressSize()) {
            return false;
        }
        Address bcx = this.addressOfInterpreterFrameBCX().getAddressAt(0L);
        try {
            method = (Method)VM.getVM().getObjectHeap().newOop(methodHandle);
        }
        catch (UnknownOopException ex) {
            return false;
        }
        int bci = this.bcpToBci(bcx, method);
        return bci >= 0;
    }

    @Override
    public long frameSize() {
        return this.getSenderSP().minus(this.getSP()) / VM.getVM().getAddressSize();
    }

    @Override
    public Address getLink() {
        return SPARCFrame.unBiasSP(this.getFP().getAddressAt(SPARCRegisters.FP.spOffsetInSavedWindow()));
    }

    @Override
    public Frame sender(RegisterMap regMap, CodeBlob cb) {
        SPARCRegisterMap map = (SPARCRegisterMap)regMap;
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(map != null, "map must be set");
        }
        map.setIncludeArgumentOops(false);
        if (this.isEntryFrame()) {
            return this.senderForEntryFrame(map);
        }
        Address youngerSP = this.getSP();
        Address sp = this.getSenderSP();
        boolean isInterpreted = false;
        if (VM.getVM().isDebugging() && this.isSignalHandlerFrameDbg()) {
            if (DEBUG) {
                System.out.println("SPARCFrame.sender: found signal handler frame");
            }
            long offset = this.getMContextAreaOffsetInUContext();
            Address fp = sp;
            fp = fp.addOffsetTo(this.getUContextOffset() + this.getMContextAreaOffsetInUContext());
            int PC_OFFSET_IN_GREGSET = 1;
            int SP_OFFSET_IN_GREGSET = 17;
            this.raw_sp = fp.getAddressAt(VM.getVM().getAddressSize() * (long)SP_OFFSET_IN_GREGSET);
            Address pc = fp.getAddressAt(VM.getVM().getAddressSize() * (long)PC_OFFSET_IN_GREGSET);
            return new SPARCFrame(this.raw_sp, pc);
        }
        if (this.isRicochetFrame()) {
            return this.senderForRicochetFrame(map);
        }
        if (VM.getVM().getInterpreter().contains(this.pc)) {
            isInterpreted = true;
            map.makeIntegerRegsUnsaved();
            map.shiftWindow(sp, youngerSP);
        } else {
            cb = VM.getVM().getCodeCache().findBlob(this.pc);
            if (cb != null) {
                map.shiftWindow(sp, youngerSP);
                if (map.getUpdateMap()) {
                    if (cb.callerMustGCArguments()) {
                        map.setIncludeArgumentOops(true);
                    }
                    if (cb.getOopMaps() != null) {
                        OopMapSet.updateRegisterMap(this, cb, map, VM.getVM().isDebugging());
                    }
                }
            }
        }
        return new SPARCFrame(SPARCFrame.biasSP(sp), SPARCFrame.biasSP(youngerSP), isInterpreted);
    }

    @Override
    protected boolean hasSenderPD() {
        try {
            if (this.getSP() == null) {
                return false;
            }
            return SPARCFrame.unBiasSP(this.getSP().getAddressAt(SPARCRegisters.FP.spOffsetInSavedWindow())) != null;
        }
        catch (RuntimeException e) {
            if (DEBUG) {
                System.out.println("Bad frame " + this);
            }
            throw e;
        }
    }

    @Override
    public Address getSenderPC() {
        return this.addressOfI7().getAddressAt(0L).addOffsetTo(8L);
    }

    @Override
    public Address getUnextendedSP() {
        return this.getSP().addOffsetTo(this.interpreterSPAdjustmentOffset);
    }

    @Override
    public Address getSenderSP() {
        return this.getFP();
    }

    public SPARCFrame afterSave() {
        return new SPARCFrame(SPARCFrame.biasSP(this.getYoungerSP()), null);
    }

    @Override
    public Address getFP() {
        Address sp = this.getSP();
        if (sp == null) {
            System.out.println("SPARCFrame.getFP(): sp == null");
        }
        Address fpAddr = sp.addOffsetTo(SPARCRegisters.FP.spOffsetInSavedWindow());
        try {
            Address fp = SPARCFrame.unBiasSP(fpAddr.getAddressAt(0L));
            if (fp == null) {
                System.out.println("SPARCFrame.getFP(): fp == null (&fp == " + fpAddr + ")");
            }
            return fp;
        }
        catch (RuntimeException e) {
            System.out.println("SPARCFrame.getFP(): is bad (&fp == " + fpAddr + " sp = " + sp + ")");
            return null;
        }
    }

    private Address addressOfFPSlot(int index) {
        return this.getFP().addOffsetTo((long)index * VM.getVM().getAddressSize());
    }

    @Override
    public Address addressOfInterpreterFrameLocals() {
        return this.getSP().addOffsetTo(SPARCRegisters.Llocals.spOffsetInSavedWindow());
    }

    private Address addressOfInterpreterFrameBCX() {
        return this.getSP().addOffsetTo(SPARCRegisters.Lbcp.spOffsetInSavedWindow());
    }

    @Override
    public int getInterpreterFrameBCI() {
        Address bcp = this.addressOfInterpreterFrameBCX().getAddressAt(0L);
        OopHandle methodHandle = this.addressOfInterpreterFrameMethod().getOopHandleAt(0L);
        Method method = (Method)VM.getVM().getObjectHeap().newOop(methodHandle);
        return this.bcpToBci(bcp, method);
    }

    @Override
    public Address addressOfInterpreterFrameExpressionStack() {
        return this.addressOfInterpreterFrameMonitors().addOffsetTo(-1L * VM.getVM().getAddressSize());
    }

    @Override
    public int getInterpreterFrameExpressionStackDirection() {
        return -1;
    }

    @Override
    public Address addressOfInterpreterFrameTOS() {
        return this.getSP().getAddressAt(SPARCRegisters.Lesp.spOffsetInSavedWindow()).addOffsetTo(VM.getVM().getAddressSize());
    }

    @Override
    public Address addressOfInterpreterFrameTOSAt(int slot) {
        return this.addressOfInterpreterFrameTOS().addOffsetTo((long)slot * VM.getVM().getAddressSize());
    }

    @Override
    public Address getInterpreterFrameSenderSP() {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.isInterpretedFrame(), "interpreted frame expected");
        }
        return this.getFP();
    }

    private Address addressOfInterpreterFrameMonitors() {
        return this.getSP().addOffsetTo(SPARCRegisters.Lmonitors.spOffsetInSavedWindow()).getAddressAt(0L);
    }

    @Override
    public BasicObjectLock interpreterFrameMonitorBegin() {
        int roundedVMLocalWords = Bits.roundTo(6, 2);
        return new BasicObjectLock(this.addressOfFPSlot(-1 * roundedVMLocalWords));
    }

    @Override
    public BasicObjectLock interpreterFrameMonitorEnd() {
        return new BasicObjectLock(this.addressOfInterpreterFrameMonitors());
    }

    @Override
    public int interpreterFrameMonitorSize() {
        return Bits.roundTo(BasicObjectLock.size(), 2 * (int)VM.getVM().getAddressSize());
    }

    @Override
    public Address addressOfInterpreterFrameMethod() {
        return this.getSP().addOffsetTo(SPARCRegisters.Lmethod.spOffsetInSavedWindow());
    }

    @Override
    public Address addressOfInterpreterFrameCPCache() {
        return this.getSP().addOffsetTo(SPARCRegisters.LcpoolCache.spOffsetInSavedWindow());
    }

    @Override
    public JavaCallWrapper getEntryFrameCallWrapper() {
        SPARCArgument link = new SPARCArgument(0, false);
        return (JavaCallWrapper)VMObjectFactory.newObject(JavaCallWrapper.class, this.getSP().getAddressAt(link.asIn().asRegister().spOffsetInSavedWindow()));
    }

    @Override
    protected Address addressOfSavedOopResult() {
        return this.addressOfO0();
    }

    @Override
    protected Address addressOfSavedReceiver() {
        return this.addressOfO0();
    }

    private Address addressOfI7() {
        return this.getSP().addOffsetTo(SPARCRegisters.I7.spOffsetInSavedWindow());
    }

    private Address addressOfO7() {
        return this.afterSave().addressOfI7();
    }

    private Address addressOfI0() {
        return this.getSP().addOffsetTo(SPARCRegisters.I0.spOffsetInSavedWindow());
    }

    private Address addressOfO0() {
        return this.afterSave().addressOfI0();
    }

    private static boolean addressesEqual(Address a1, Address a2) {
        if (a1 == null && a2 == null) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        return a1.equals(a2);
    }

    private Frame senderForRicochetFrame(SPARCRegisterMap map) {
        if (DEBUG) {
            System.out.println("senderForRicochetFrame");
        }
        Address youngerSP = this.getSP();
        Address sp = this.getSenderSP();
        map.makeIntegerRegsUnsaved();
        map.shiftWindow(sp, youngerSP);
        boolean thisFrameAdjustedStack = true;
        return new SPARCFrame(SPARCFrame.biasSP(sp), SPARCFrame.biasSP(youngerSP), thisFrameAdjustedStack);
    }

    private Frame senderForEntryFrame(RegisterMap regMap) {
        SPARCRegisterMap map = (SPARCRegisterMap)regMap;
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(map != null, "map must be set");
        }
        JavaCallWrapper jcw = this.getEntryFrameCallWrapper();
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(!this.entryFrameIsFirst(), "next Java fp must be non zero");
            Assert.that(jcw.getLastJavaSP().greaterThan(this.getSP()), "must be above this frame on stack");
        }
        Address lastJavaSP = jcw.getLastJavaSP();
        Address lastJavaPC = jcw.getLastJavaPC();
        map.clear();
        map.makeIntegerRegsUnsaved();
        map.shiftWindow(lastJavaSP, null);
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(map.getIncludeArgumentOops(), "should be set by clear");
        }
        if (lastJavaPC != null) {
            return new SPARCFrame(SPARCFrame.biasSP(lastJavaSP), lastJavaPC);
        }
        Address youngerSP = SPARCFrame.getNextYoungerSP(lastJavaSP, this.getSP());
        return new SPARCFrame(SPARCFrame.biasSP(lastJavaSP), SPARCFrame.biasSP(youngerSP), false);
    }

    private static Address getNextYoungerSP(Address oldSP, Address youngSP) {
        Address sp = SPARCFrame.getNextYoungerSPOrNull(oldSP, youngSP, null);
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(sp != null, "missed the SP");
        }
        return sp;
    }

    private static Address getNextYoungerSPOrNull(Address oldSP, Address youngSP, Address sp) {
        if (youngSP == null) {
            throw new RuntimeException("can not handle null youngSP in debugging system (seems to require register window flush)");
        }
        if (sp == null) {
            sp = youngSP;
        }
        Address previousSP = null;
        int maxFrames = (int)(oldSP.minus(sp) / (16L * VM.getVM().getAddressSize()));
        while (!sp.equals(oldSP) && SPARCFrame.spIsValid(oldSP, youngSP, sp) && maxFrames-- > 0) {
            previousSP = sp;
            sp = SPARCFrame.unBiasSP(sp.getAddressAt(SPARCRegisters.FP.spOffsetInSavedWindow()));
        }
        return sp.equals(oldSP) ? previousSP : null;
    }

    private static boolean spIsValid(Address oldSP, Address youngSP, Address sp) {
        long mask = VM.getVM().getAddressSize();
        return sp.andWithMask(mask = 2L * mask - 1L) == null && sp.lessThanOrEqual(oldSP) && sp.greaterThanOrEqual(youngSP);
    }

    public long getUContextOffset() {
        int MAJOR_HACK_OFFSET = 8;
        return VM.getVM().getAddressSize() * (long)(16 + MAJOR_HACK_OFFSET);
    }

    public long getMContextAreaOffsetInUContext() {
        long offset = VM.getVM().alignUp(4L, VM.getVM().getAddressSize());
        offset = VM.getVM().alignUp(offset + VM.getVM().getAddressSize(), 8L);
        offset += 16L + 2L * VM.getVM().getAddressSize() + 4L;
        offset = VM.getVM().alignUp(offset + VM.getVM().getAddressSize(), 8L);
        return offset;
    }
}

