/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole.inspector;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import sun.tools.jconsole.inspector.TableSorter;
import sun.tools.jconsole.inspector.Utils;

public abstract class XTable
extends JTable {
    static final int NAME_COLUMN = 0;
    static final int VALUE_COLUMN = 1;
    private Color defaultColor;
    private Color editableColor;
    private Color droppableColor;
    private Color errorColor;
    private Font normalFont;
    private Font boldFont;

    public XTable() {
        TableSorter sorter = new TableSorter();
        this.setModel(sorter);
        sorter.addMouseListenerToHeaderInTable(this);
        this.setRowSelectionAllowed(false);
        this.setColumnSelectionAllowed(false);
        this.setAutoResizeMode(3);
    }

    Color getDefaultColor() {
        return this.defaultColor;
    }

    Color getEditableColor() {
        return this.editableColor;
    }

    void sortRequested(int column) {
    }

    public int getSelectedIndex() {
        return this.convertRowToIndex(this.getSelectedRow());
    }

    public int convertRowToIndex(int row) {
        if (row == -1) {
            return row;
        }
        if (this.getModel() instanceof TableSorter) {
            return ((TableSorter)this.getModel()).getIndexOfRow(row);
        }
        return row;
    }

    public void emptyTable() {
        DefaultTableModel model = (DefaultTableModel)this.getModel();
        while (model.getRowCount() > 0) {
            model.removeRow(0);
        }
    }

    public abstract boolean isTableEditable();

    public abstract boolean isColumnEditable(int var1);

    public abstract boolean isReadable(int var1);

    public abstract boolean isWritable(int var1);

    public abstract boolean isCellError(int var1, int var2);

    public abstract boolean isAttributeViewable(int var1, int var2);

    public abstract void setTableValue(Object var1, int var2);

    public abstract Object getValue(int var1);

    public abstract String getClassName(int var1);

    public abstract String getValueName(int var1);

    public boolean isReadWrite(int row) {
        return this.isReadable(row) && this.isWritable(row);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return this.isTableEditable() && this.isColumnEditable(col) && this.isWritable(row) && Utils.isEditableType(this.getClassName(row));
    }

    public boolean isCellDroppable(int row, int col) {
        return this.isTableEditable() && this.isColumnEditable(col) && this.isWritable(row);
    }

    public String getToolTip(int row, int column) {
        return null;
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        DefaultTableCellRenderer tcr = (DefaultTableCellRenderer)super.getCellRenderer(row, column);
        tcr.setToolTipText(this.getToolTip(row, column));
        if (this.defaultColor == null) {
            this.defaultColor = tcr.getForeground();
            this.editableColor = Color.blue;
            this.droppableColor = Color.green;
            this.errorColor = Color.red;
            if (this.defaultColor == null) {
                return tcr;
            }
        }
        if (column != 1) {
            tcr.setForeground(this.defaultColor);
            return tcr;
        }
        if (this.isCellError(row, column)) {
            tcr.setForeground(this.errorColor);
        } else if (this.isCellEditable(row, column)) {
            tcr.setForeground(this.editableColor);
        } else {
            tcr.setForeground(this.defaultColor);
        }
        return tcr;
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Component comp = super.prepareRenderer(renderer, row, column);
        if (this.normalFont == null) {
            this.normalFont = comp.getFont();
            this.boldFont = this.normalFont.deriveFont(1);
        }
        if (column == 1 && this.isAttributeViewable(row, 1)) {
            comp.setFont(this.boldFont);
        } else {
            comp.setFont(this.normalFont);
        }
        return comp;
    }
}

