/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.io.OutputStream;
import java.util.Locale;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.ServiceUIFactory;
import javax.print.StreamPrintService;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.AttributeSetUtilities;
import javax.print.attribute.HashAttributeSet;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.PrintServiceAttribute;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.ColorSupported;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.CopiesSupported;
import javax.print.attribute.standard.Fidelity;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.RequestingUserName;
import javax.print.attribute.standard.SheetCollate;
import javax.print.attribute.standard.Sides;
import javax.print.event.PrintServiceAttributeListener;
import sun.print.PSPrinterJob;
import sun.print.PSStreamPrintJob;
import sun.print.PSStreamPrinterFactory;
import sun.print.SunPrinterJobService;

public class PSStreamPrintService
extends StreamPrintService
implements SunPrinterJobService {
    private static final Class[] suppAttrCats = new Class[]{Chromaticity.class, Copies.class, Fidelity.class, JobName.class, Media.class, MediaPrintableArea.class, OrientationRequested.class, PageRanges.class, RequestingUserName.class, SheetCollate.class, Sides.class};
    private static int MAXCOPIES = 1000;
    private static final MediaSizeName[] mediaSizes = new MediaSizeName[]{MediaSizeName.NA_LETTER, MediaSizeName.TABLOID, MediaSizeName.LEDGER, MediaSizeName.NA_LEGAL, MediaSizeName.EXECUTIVE, MediaSizeName.ISO_A3, MediaSizeName.ISO_A4, MediaSizeName.ISO_A5, MediaSizeName.ISO_B4, MediaSizeName.ISO_B5};

    public PSStreamPrintService(OutputStream out) {
        super(out);
    }

    @Override
    public String getOutputFormat() {
        return "application/postscript";
    }

    @Override
    public DocFlavor[] getSupportedDocFlavors() {
        return PSStreamPrinterFactory.getFlavors();
    }

    @Override
    public DocPrintJob createPrintJob() {
        return new PSStreamPrintJob(this);
    }

    @Override
    public boolean usesClass(Class c) {
        return c == PSPrinterJob.class;
    }

    @Override
    public String getName() {
        return "Postscript output";
    }

    @Override
    public void addPrintServiceAttributeListener(PrintServiceAttributeListener listener) {
    }

    @Override
    public void removePrintServiceAttributeListener(PrintServiceAttributeListener listener) {
    }

    @Override
    public <T extends PrintServiceAttribute> T getAttribute(Class<T> category) {
        if (category == null) {
            throw new NullPointerException("category");
        }
        if (!PrintServiceAttribute.class.isAssignableFrom(category)) {
            throw new IllegalArgumentException("Not a PrintServiceAttribute");
        }
        if (category == ColorSupported.class) {
            return (T)ColorSupported.SUPPORTED;
        }
        return null;
    }

    @Override
    public PrintServiceAttributeSet getAttributes() {
        HashPrintServiceAttributeSet attrs = new HashPrintServiceAttributeSet();
        attrs.add(ColorSupported.SUPPORTED);
        return AttributeSetUtilities.unmodifiableView(attrs);
    }

    @Override
    public boolean isDocFlavorSupported(DocFlavor flavor) {
        DocFlavor[] flavors = this.getSupportedDocFlavors();
        for (int f = 0; f < flavors.length; ++f) {
            if (!flavor.equals(flavors[f])) continue;
            return true;
        }
        return false;
    }

    @Override
    public Class<?>[] getSupportedAttributeCategories() {
        Class[] cats = new Class[suppAttrCats.length];
        System.arraycopy(suppAttrCats, 0, cats, 0, cats.length);
        return cats;
    }

    @Override
    public boolean isAttributeCategorySupported(Class<? extends Attribute> category) {
        if (category == null) {
            throw new NullPointerException("null category");
        }
        if (!Attribute.class.isAssignableFrom(category)) {
            throw new IllegalArgumentException(category + " is not an Attribute");
        }
        for (int i = 0; i < suppAttrCats.length; ++i) {
            if (category != suppAttrCats[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getDefaultAttributeValue(Class<? extends Attribute> category) {
        if (category == null) {
            throw new NullPointerException("null category");
        }
        if (!Attribute.class.isAssignableFrom(category)) {
            throw new IllegalArgumentException(category + " is not an Attribute");
        }
        if (!this.isAttributeCategorySupported(category)) {
            return null;
        }
        if (category == Copies.class) {
            return new Copies(1);
        }
        if (category == Chromaticity.class) {
            return Chromaticity.COLOR;
        }
        if (category == Fidelity.class) {
            return Fidelity.FIDELITY_FALSE;
        }
        if (category == Media.class) {
            String defaultCountry = Locale.getDefault().getCountry();
            if (defaultCountry != null && (defaultCountry.equals("") || defaultCountry.equals(Locale.US.getCountry()) || defaultCountry.equals(Locale.CANADA.getCountry()))) {
                return MediaSizeName.NA_LETTER;
            }
            return MediaSizeName.ISO_A4;
        }
        if (category == MediaPrintableArea.class) {
            float ih;
            float iw;
            String defaultCountry = Locale.getDefault().getCountry();
            float margin = 0.5f;
            if (defaultCountry != null && (defaultCountry.equals("") || defaultCountry.equals(Locale.US.getCountry()) || defaultCountry.equals(Locale.CANADA.getCountry()))) {
                iw = MediaSize.NA.LETTER.getX(25400) - 2.0f * margin;
                ih = MediaSize.NA.LETTER.getY(25400) - 2.0f * margin;
            } else {
                iw = MediaSize.ISO.A4.getX(25400) - 2.0f * margin;
                ih = MediaSize.ISO.A4.getY(25400) - 2.0f * margin;
            }
            return new MediaPrintableArea(margin, margin, iw, ih, 25400);
        }
        if (category == OrientationRequested.class) {
            return OrientationRequested.PORTRAIT;
        }
        if (category == PageRanges.class) {
            return new PageRanges(1, Integer.MAX_VALUE);
        }
        if (category == SheetCollate.class) {
            return SheetCollate.UNCOLLATED;
        }
        if (category == Sides.class) {
            return Sides.ONE_SIDED;
        }
        return null;
    }

    @Override
    public Object getSupportedAttributeValues(Class<? extends Attribute> category, DocFlavor flavor, AttributeSet attributes) {
        if (category == null) {
            throw new NullPointerException("null category");
        }
        if (!Attribute.class.isAssignableFrom(category)) {
            throw new IllegalArgumentException(category + " does not implement Attribute");
        }
        if (flavor != null && !this.isDocFlavorSupported(flavor)) {
            throw new IllegalArgumentException(flavor + " is an unsupported flavor");
        }
        if (!this.isAttributeCategorySupported(category)) {
            return null;
        }
        if (category == Chromaticity.class) {
            Chromaticity[] arr = new Chromaticity[]{Chromaticity.COLOR};
            return arr;
        }
        if (category == JobName.class) {
            return new JobName("", null);
        }
        if (category == RequestingUserName.class) {
            return new RequestingUserName("", null);
        }
        if (category == OrientationRequested.class) {
            if (flavor == null || flavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || flavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
                OrientationRequested[] arr = new OrientationRequested[]{OrientationRequested.PORTRAIT, OrientationRequested.LANDSCAPE, OrientationRequested.REVERSE_LANDSCAPE};
                return arr;
            }
            return null;
        }
        if (category == Copies.class || category == CopiesSupported.class) {
            return new CopiesSupported(1, MAXCOPIES);
        }
        if (category == Media.class) {
            Media[] arr = new Media[mediaSizes.length];
            System.arraycopy(mediaSizes, 0, arr, 0, mediaSizes.length);
            return arr;
        }
        if (category == Fidelity.class) {
            Fidelity[] arr = new Fidelity[]{Fidelity.FIDELITY_FALSE, Fidelity.FIDELITY_TRUE};
            return arr;
        }
        if (category == MediaPrintableArea.class) {
            Media media;
            if (attributes == null) {
                return null;
            }
            MediaSize mediaSize = (MediaSize)attributes.get(MediaSize.class);
            if (mediaSize == null && (media = (Media)attributes.get(Media.class)) != null && media instanceof MediaSizeName) {
                MediaSizeName msn = (MediaSizeName)media;
                mediaSize = MediaSize.getMediaSizeForName(msn);
            }
            if (mediaSize == null) {
                return null;
            }
            MediaPrintableArea[] arr = new MediaPrintableArea[1];
            float w = mediaSize.getX(25400);
            float h = mediaSize.getY(25400);
            float xmargin = 0.5f;
            float ymargin = 0.5f;
            if (w < 5.0f) {
                xmargin = w / 10.0f;
            }
            if (h < 5.0f) {
                ymargin = h / 10.0f;
            }
            arr[0] = new MediaPrintableArea(xmargin, ymargin, w - 2.0f * xmargin, h - 2.0f * ymargin, 25400);
            return arr;
        }
        if (category == PageRanges.class) {
            if (flavor == null || flavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || flavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
                PageRanges[] arr = new PageRanges[]{new PageRanges(1, Integer.MAX_VALUE)};
                return arr;
            }
            return null;
        }
        if (category == SheetCollate.class) {
            if (flavor == null || flavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || flavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
                SheetCollate[] arr = new SheetCollate[]{SheetCollate.UNCOLLATED, SheetCollate.COLLATED};
                return arr;
            }
            SheetCollate[] arr = new SheetCollate[]{SheetCollate.UNCOLLATED};
            return arr;
        }
        if (category == Sides.class) {
            if (flavor == null || flavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || flavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
                Sides[] arr = new Sides[]{Sides.ONE_SIDED, Sides.TWO_SIDED_LONG_EDGE, Sides.TWO_SIDED_SHORT_EDGE};
                return arr;
            }
            return null;
        }
        return null;
    }

    private boolean isSupportedCopies(Copies copies) {
        int numCopies = copies.getValue();
        return numCopies > 0 && numCopies < MAXCOPIES;
    }

    private boolean isSupportedMedia(MediaSizeName msn) {
        for (int i = 0; i < mediaSizes.length; ++i) {
            if (!msn.equals(mediaSizes[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAttributeValueSupported(Attribute attr, DocFlavor flavor, AttributeSet attributes) {
        if (attr == null) {
            throw new NullPointerException("null attribute");
        }
        if (flavor != null && !this.isDocFlavorSupported(flavor)) {
            throw new IllegalArgumentException(flavor + " is an unsupported flavor");
        }
        Class<? extends Attribute> category = attr.getCategory();
        if (!this.isAttributeCategorySupported(category)) {
            return false;
        }
        if (attr.getCategory() == Chromaticity.class) {
            return attr == Chromaticity.COLOR;
        }
        if (attr.getCategory() == Copies.class) {
            return this.isSupportedCopies((Copies)attr);
        }
        if (attr.getCategory() == Media.class && attr instanceof MediaSizeName) {
            return this.isSupportedMedia((MediaSizeName)attr);
        }
        return !(attr.getCategory() == OrientationRequested.class ? attr == OrientationRequested.REVERSE_PORTRAIT || flavor != null && !flavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) && !flavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE) : (attr.getCategory() == PageRanges.class ? flavor != null && !flavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) && !flavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE) : (attr.getCategory() == SheetCollate.class ? flavor != null && !flavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) && !flavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE) : attr.getCategory() == Sides.class && flavor != null && !flavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) && !flavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE))));
    }

    @Override
    public AttributeSet getUnsupportedAttributes(DocFlavor flavor, AttributeSet attributes) {
        if (flavor != null && !this.isDocFlavorSupported(flavor)) {
            throw new IllegalArgumentException("flavor " + flavor + "is not supported");
        }
        if (attributes == null) {
            return null;
        }
        HashAttributeSet unsupp = new HashAttributeSet();
        Attribute[] attrs = attributes.toArray();
        for (int i = 0; i < attrs.length; ++i) {
            try {
                Attribute attr = attrs[i];
                if (!this.isAttributeCategorySupported(attr.getCategory())) {
                    unsupp.add(attr);
                    continue;
                }
                if (this.isAttributeValueSupported(attr, flavor, attributes)) continue;
                unsupp.add(attr);
                continue;
            }
            catch (ClassCastException e) {
                // empty catch block
            }
        }
        if (unsupp.isEmpty()) {
            return null;
        }
        return unsupp;
    }

    @Override
    public ServiceUIFactory getServiceUIFactory() {
        return null;
    }

    public String toString() {
        return "PSStreamPrintService: " + this.getName();
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj instanceof PSStreamPrintService && ((PSStreamPrintService)obj).getName().equals(this.getName());
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode() + this.getName().hashCode();
    }
}

