/*
 * Decompiled with CFR 0.152.
 */
package sun.net.spi;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import sun.misc.REException;
import sun.misc.RegexpPool;
import sun.net.NetProperties;
import sun.net.SocksProxy;
import sun.security.action.LoadLibraryAction;

public class DefaultProxySelector
extends ProxySelector {
    static final String[][] props = new String[][]{{"http", "http.proxy", "proxy", "socksProxy"}, {"https", "https.proxy", "proxy", "socksProxy"}, {"ftp", "ftp.proxy", "ftpProxy", "proxy", "socksProxy"}, {"gopher", "gopherProxy", "socksProxy"}, {"socket", "socksProxy"}};
    private static final String SOCKS_PROXY_VERSION = "socksProxyVersion";
    private static boolean hasSystemProxies = false;

    @Override
    public List<Proxy> select(URI uri) {
        String auth;
        if (uri == null) {
            throw new IllegalArgumentException("URI can't be null.");
        }
        String protocol = uri.getScheme();
        String host = uri.getHost();
        if (host == null && (auth = uri.getAuthority()) != null) {
            int i = auth.indexOf(64);
            if (i >= 0) {
                auth = auth.substring(i + 1);
            }
            if ((i = auth.lastIndexOf(58)) >= 0) {
                auth = auth.substring(0, i);
            }
            host = auth;
        }
        if (protocol == null || host == null) {
            throw new IllegalArgumentException("protocol = " + protocol + " host = " + host);
        }
        ArrayList<Proxy> proxyl = new ArrayList<Proxy>(1);
        NonProxyInfo pinfo = null;
        if ("http".equalsIgnoreCase(protocol)) {
            pinfo = NonProxyInfo.httpNonProxyInfo;
        } else if ("https".equalsIgnoreCase(protocol)) {
            pinfo = NonProxyInfo.httpNonProxyInfo;
        } else if ("ftp".equalsIgnoreCase(protocol)) {
            pinfo = NonProxyInfo.ftpNonProxyInfo;
        }
        final String proto = protocol;
        final NonProxyInfo nprop = pinfo;
        final String urlhost = host.toLowerCase();
        Proxy p = AccessController.doPrivileged(new PrivilegedAction<Proxy>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Proxy run() {
                String phost = null;
                int pport = 0;
                String nphosts = null;
                InetSocketAddress saddr = null;
                for (int i = 0; i < props.length; ++i) {
                    int j;
                    if (!props[i][0].equalsIgnoreCase(proto)) continue;
                    for (j = 1; j < props[i].length && ((phost = NetProperties.get(props[i][j] + "Host")) == null || phost.length() == 0); ++j) {
                    }
                    if (phost == null || phost.length() == 0) {
                        String sproto;
                        Proxy sproxy;
                        if (hasSystemProxies && (sproxy = DefaultProxySelector.this.getSystemProxy(sproto = proto.equalsIgnoreCase("socket") ? "socks" : proto, urlhost)) != null) {
                            return sproxy;
                        }
                        return Proxy.NO_PROXY;
                    }
                    if (nprop != null) {
                        nphosts = NetProperties.get(nprop.property);
                        NonProxyInfo sproto = nprop;
                        synchronized (sproto) {
                            if (nphosts == null) {
                                if (nprop.defaultVal != null) {
                                    nphosts = nprop.defaultVal;
                                } else {
                                    nprop.hostsSource = null;
                                    nprop.hostsPool = null;
                                }
                            } else if (nphosts.length() != 0) {
                                nphosts = nphosts + "|localhost|127.*|[::1]|0.0.0.0|[::0]";
                            }
                            if (nphosts != null && !nphosts.equals(nprop.hostsSource)) {
                                RegexpPool pool = new RegexpPool();
                                StringTokenizer st = new StringTokenizer(nphosts, "|", false);
                                try {
                                    while (st.hasMoreTokens()) {
                                        pool.add(st.nextToken().toLowerCase(), Boolean.TRUE);
                                    }
                                }
                                catch (REException ex) {
                                    // empty catch block
                                }
                                nprop.hostsPool = pool;
                                nprop.hostsSource = nphosts;
                            }
                            if (nprop.hostsPool != null && nprop.hostsPool.match(urlhost) != null) {
                                return Proxy.NO_PROXY;
                            }
                        }
                    }
                    if ((pport = NetProperties.getInteger(props[i][j] + "Port", 0).intValue()) == 0 && j < props[i].length - 1) {
                        for (int k = 1; k < props[i].length - 1; ++k) {
                            if (k == j || pport != 0) continue;
                            pport = NetProperties.getInteger(props[i][k] + "Port", 0);
                        }
                    }
                    if (pport == 0) {
                        pport = j == props[i].length - 1 ? DefaultProxySelector.this.defaultPort("socket") : DefaultProxySelector.this.defaultPort(proto);
                    }
                    saddr = InetSocketAddress.createUnresolved(phost, pport);
                    if (j == props[i].length - 1) {
                        int version = NetProperties.getInteger(DefaultProxySelector.SOCKS_PROXY_VERSION, 5);
                        return SocksProxy.create(saddr, version);
                    }
                    return new Proxy(Proxy.Type.HTTP, saddr);
                }
                return Proxy.NO_PROXY;
            }
        });
        proxyl.add(p);
        return proxyl;
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        if (uri == null || sa == null || ioe == null) {
            throw new IllegalArgumentException("Arguments can't be null.");
        }
    }

    private int defaultPort(String protocol) {
        if ("http".equalsIgnoreCase(protocol)) {
            return 80;
        }
        if ("https".equalsIgnoreCase(protocol)) {
            return 443;
        }
        if ("ftp".equalsIgnoreCase(protocol)) {
            return 80;
        }
        if ("socket".equalsIgnoreCase(protocol)) {
            return 1080;
        }
        if ("gopher".equalsIgnoreCase(protocol)) {
            return 80;
        }
        return -1;
    }

    private static native boolean init();

    private native Proxy getSystemProxy(String var1, String var2);

    static {
        String key = "java.net.useSystemProxies";
        Boolean b = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return NetProperties.getBoolean("java.net.useSystemProxies");
            }
        });
        if (b != null && b.booleanValue()) {
            AccessController.doPrivileged(new LoadLibraryAction("net"));
            hasSystemProxies = DefaultProxySelector.init();
        }
    }

    static class NonProxyInfo {
        static final String defStringVal = "localhost|127.*|[::1]|0.0.0.0|[::0]";
        String hostsSource;
        RegexpPool hostsPool;
        final String property;
        final String defaultVal;
        static NonProxyInfo ftpNonProxyInfo = new NonProxyInfo("ftp.nonProxyHosts", null, null, "localhost|127.*|[::1]|0.0.0.0|[::0]");
        static NonProxyInfo httpNonProxyInfo = new NonProxyInfo("http.nonProxyHosts", null, null, "localhost|127.*|[::1]|0.0.0.0|[::0]");

        NonProxyInfo(String p, String s, RegexpPool pool, String d) {
            this.property = p;
            this.hostsSource = s;
            this.hostsPool = pool;
            this.defaultVal = d;
        }
    }
}

