/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote.rmi;

import com.sun.jmx.mbeanserver.Util;
import com.sun.jmx.remote.internal.ServerCommunicatorAdmin;
import com.sun.jmx.remote.internal.ServerNotifForwarder;
import com.sun.jmx.remote.security.JMXSubjectDomainCombiner;
import com.sun.jmx.remote.security.SubjectDelegator;
import com.sun.jmx.remote.util.ClassLoaderWithRepository;
import com.sun.jmx.remote.util.ClassLogger;
import com.sun.jmx.remote.util.EnvHelp;
import com.sun.jmx.remote.util.OrderClassLoaders;
import java.io.IOException;
import java.rmi.MarshalledObject;
import java.rmi.UnmarshalException;
import java.rmi.server.Unreferenced;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanPermission;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import javax.management.remote.JMXServerErrorException;
import javax.management.remote.NotificationResult;
import javax.management.remote.TargetedNotification;
import javax.management.remote.rmi.RMIConnection;
import javax.management.remote.rmi.RMIServerImpl;
import javax.security.auth.Subject;

public class RMIConnectionImpl
implements RMIConnection,
Unreferenced {
    private static final Object[] NO_OBJECTS = new Object[0];
    private static final String[] NO_STRINGS = new String[0];
    private final Subject subject;
    private final SubjectDelegator subjectDelegator;
    private final boolean removeCallerContext;
    private final AccessControlContext acc;
    private final RMIServerImpl rmiServer;
    private final MBeanServer mbeanServer;
    private final ClassLoader defaultClassLoader;
    private final ClassLoader defaultContextClassLoader;
    private final ClassLoaderWithRepository classLoaderWithRepository;
    private boolean terminated = false;
    private final String connectionId;
    private final ServerCommunicatorAdmin serverCommunicatorAdmin;
    private static final int ADD_NOTIFICATION_LISTENERS = 1;
    private static final int ADD_NOTIFICATION_LISTENER_OBJECTNAME = 2;
    private static final int CREATE_MBEAN = 3;
    private static final int CREATE_MBEAN_PARAMS = 4;
    private static final int CREATE_MBEAN_LOADER = 5;
    private static final int CREATE_MBEAN_LOADER_PARAMS = 6;
    private static final int GET_ATTRIBUTE = 7;
    private static final int GET_ATTRIBUTES = 8;
    private static final int GET_DEFAULT_DOMAIN = 9;
    private static final int GET_DOMAINS = 10;
    private static final int GET_MBEAN_COUNT = 11;
    private static final int GET_MBEAN_INFO = 12;
    private static final int GET_OBJECT_INSTANCE = 13;
    private static final int INVOKE = 14;
    private static final int IS_INSTANCE_OF = 15;
    private static final int IS_REGISTERED = 16;
    private static final int QUERY_MBEANS = 17;
    private static final int QUERY_NAMES = 18;
    private static final int REMOVE_NOTIFICATION_LISTENER = 19;
    private static final int REMOVE_NOTIFICATION_LISTENER_OBJECTNAME = 20;
    private static final int REMOVE_NOTIFICATION_LISTENER_OBJECTNAME_FILTER_HANDBACK = 21;
    private static final int SET_ATTRIBUTE = 22;
    private static final int SET_ATTRIBUTES = 23;
    private static final int UNREGISTER_MBEAN = 24;
    private ServerNotifForwarder serverNotifForwarder;
    private Map<String, ?> env;
    private static final ClassLogger logger = new ClassLogger("javax.management.remote.rmi", "RMIConnectionImpl");

    public RMIConnectionImpl(RMIServerImpl rmiServer, String connectionId, ClassLoader defaultClassLoader, Subject subject, Map<String, ?> env) {
        if (rmiServer == null || connectionId == null) {
            throw new NullPointerException("Illegal null argument");
        }
        if (env == null) {
            env = Collections.emptyMap();
        }
        this.rmiServer = rmiServer;
        this.connectionId = connectionId;
        this.defaultClassLoader = defaultClassLoader;
        this.subjectDelegator = new SubjectDelegator();
        this.subject = subject;
        if (subject == null) {
            this.acc = null;
            this.removeCallerContext = false;
        } else {
            this.removeCallerContext = SubjectDelegator.checkRemoveCallerContext(subject);
            this.acc = this.removeCallerContext ? JMXSubjectDomainCombiner.getDomainCombinerContext(subject) : JMXSubjectDomainCombiner.getContext(subject);
        }
        this.mbeanServer = rmiServer.getMBeanServer();
        final ClassLoader dcl = defaultClassLoader;
        this.classLoaderWithRepository = AccessController.doPrivileged(new PrivilegedAction<ClassLoaderWithRepository>(){

            @Override
            public ClassLoaderWithRepository run() {
                return new ClassLoaderWithRepository(RMIConnectionImpl.this.mbeanServer.getClassLoaderRepository(), dcl);
            }
        }, RMIConnectionImpl.withPermissions(new MBeanPermission("*", "getClassLoaderRepository"), new RuntimePermission("createClassLoader")));
        this.defaultContextClassLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return new CombinedClassLoader(Thread.currentThread().getContextClassLoader(), dcl);
            }
        });
        this.serverCommunicatorAdmin = new RMIServerCommunicatorAdmin(EnvHelp.getServerConnectionTimeout(env));
        this.env = env;
    }

    private static AccessControlContext withPermissions(Permission ... perms) {
        Permissions col = new Permissions();
        for (Permission thePerm : perms) {
            col.add(thePerm);
        }
        ProtectionDomain pd = new ProtectionDomain(null, col);
        return new AccessControlContext(new ProtectionDomain[]{pd});
    }

    private synchronized ServerNotifForwarder getServerNotifFwd() {
        if (this.serverNotifForwarder == null) {
            this.serverNotifForwarder = new ServerNotifForwarder(this.mbeanServer, this.env, this.rmiServer.getNotifBuffer(), this.connectionId);
        }
        return this.serverNotifForwarder;
    }

    @Override
    public String getConnectionId() throws IOException {
        return this.connectionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        boolean debug = logger.debugOn();
        String idstr = debug ? "[" + this.toString() + "]" : null;
        RMIConnectionImpl rMIConnectionImpl = this;
        synchronized (rMIConnectionImpl) {
            if (this.terminated) {
                if (debug) {
                    logger.debug("close", idstr + " already terminated.");
                }
                return;
            }
            if (debug) {
                logger.debug("close", idstr + " closing.");
            }
            this.terminated = true;
            if (this.serverCommunicatorAdmin != null) {
                this.serverCommunicatorAdmin.terminate();
            }
            if (this.serverNotifForwarder != null) {
                this.serverNotifForwarder.terminate();
            }
        }
        this.rmiServer.clientClosed(this);
        if (debug) {
            logger.debug("close", idstr + " closed.");
        }
    }

    @Override
    public void unreferenced() {
        logger.debug("unreferenced", "called");
        try {
            this.close();
            logger.debug("unreferenced", "done");
        }
        catch (IOException e) {
            logger.fine("unreferenced", e);
        }
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, Subject delegationSubject) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        try {
            Object[] params = new Object[]{className, name};
            if (logger.debugOn()) {
                logger.debug("createMBean(String,ObjectName)", "connectionId=" + this.connectionId + ", className=" + className + ", name=" + name);
            }
            return (ObjectInstance)this.doPrivilegedOperation(3, params, delegationSubject);
        }
        catch (PrivilegedActionException pe) {
            Exception e = RMIConnectionImpl.extractException(pe);
            if (e instanceof ReflectionException) {
                throw (ReflectionException)e;
            }
            if (e instanceof InstanceAlreadyExistsException) {
                throw (InstanceAlreadyExistsException)e;
            }
            if (e instanceof MBeanRegistrationException) {
                throw (MBeanRegistrationException)e;
            }
            if (e instanceof MBeanException) {
                throw (MBeanException)e;
            }
            if (e instanceof NotCompliantMBeanException) {
                throw (NotCompliantMBeanException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + e, e);
        }
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Subject delegationSubject) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        try {
            Object[] params = new Object[]{className, name, loaderName};
            if (logger.debugOn()) {
                logger.debug("createMBean(String,ObjectName,ObjectName)", "connectionId=" + this.connectionId + ", className=" + className + ", name=" + name + ", loaderName=" + loaderName);
            }
            return (ObjectInstance)this.doPrivilegedOperation(5, params, delegationSubject);
        }
        catch (PrivilegedActionException pe) {
            Exception e = RMIConnectionImpl.extractException(pe);
            if (e instanceof ReflectionException) {
                throw (ReflectionException)e;
            }
            if (e instanceof InstanceAlreadyExistsException) {
                throw (InstanceAlreadyExistsException)e;
            }
            if (e instanceof MBeanRegistrationException) {
                throw (MBeanRegistrationException)e;
            }
            if (e instanceof MBeanException) {
                throw (MBeanException)e;
            }
            if (e instanceof NotCompliantMBeanException) {
                throw (NotCompliantMBeanException)e;
            }
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + e, e);
        }
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, MarshalledObject params, String[] signature, Subject delegationSubject) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        boolean debug = logger.debugOn();
        if (debug) {
            logger.debug("createMBean(String,ObjectName,Object[],String[])", "connectionId=" + this.connectionId + ", unwrapping parameters using classLoaderWithRepository.");
        }
        Object[] values = RMIConnectionImpl.nullIsEmpty(RMIConnectionImpl.unwrap(params, this.classLoaderWithRepository, Object[].class));
        try {
            Object[] params2 = new Object[]{className, name, values, RMIConnectionImpl.nullIsEmpty(signature)};
            if (debug) {
                logger.debug("createMBean(String,ObjectName,Object[],String[])", "connectionId=" + this.connectionId + ", className=" + className + ", name=" + name + ", params=" + RMIConnectionImpl.objects(values) + ", signature=" + RMIConnectionImpl.strings(signature));
            }
            return (ObjectInstance)this.doPrivilegedOperation(4, params2, delegationSubject);
        }
        catch (PrivilegedActionException pe) {
            Exception e = RMIConnectionImpl.extractException(pe);
            if (e instanceof ReflectionException) {
                throw (ReflectionException)e;
            }
            if (e instanceof InstanceAlreadyExistsException) {
                throw (InstanceAlreadyExistsException)e;
            }
            if (e instanceof MBeanRegistrationException) {
                throw (MBeanRegistrationException)e;
            }
            if (e instanceof MBeanException) {
                throw (MBeanException)e;
            }
            if (e instanceof NotCompliantMBeanException) {
                throw (NotCompliantMBeanException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + e, e);
        }
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, MarshalledObject params, String[] signature, Subject delegationSubject) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        boolean debug = logger.debugOn();
        if (debug) {
            logger.debug("createMBean(String,ObjectName,ObjectName,Object[],String[])", "connectionId=" + this.connectionId + ", unwrapping params with MBean extended ClassLoader.");
        }
        Object[] values = RMIConnectionImpl.nullIsEmpty(RMIConnectionImpl.unwrap(params, this.getClassLoader(loaderName), this.defaultClassLoader, Object[].class));
        try {
            Object[] params2 = new Object[]{className, name, loaderName, values, RMIConnectionImpl.nullIsEmpty(signature)};
            if (debug) {
                logger.debug("createMBean(String,ObjectName,ObjectName,Object[],String[])", "connectionId=" + this.connectionId + ", className=" + className + ", name=" + name + ", loaderName=" + loaderName + ", params=" + RMIConnectionImpl.objects(values) + ", signature=" + RMIConnectionImpl.strings(signature));
            }
            return (ObjectInstance)this.doPrivilegedOperation(6, params2, delegationSubject);
        }
        catch (PrivilegedActionException pe) {
            Exception e = RMIConnectionImpl.extractException(pe);
            if (e instanceof ReflectionException) {
                throw (ReflectionException)e;
            }
            if (e instanceof InstanceAlreadyExistsException) {
                throw (InstanceAlreadyExistsException)e;
            }
            if (e instanceof MBeanRegistrationException) {
                throw (MBeanRegistrationException)e;
            }
            if (e instanceof MBeanException) {
                throw (MBeanException)e;
            }
            if (e instanceof NotCompliantMBeanException) {
                throw (NotCompliantMBeanException)e;
            }
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + e, e);
        }
    }

    @Override
    public void unregisterMBean(ObjectName name, Subject delegationSubject) throws InstanceNotFoundException, MBeanRegistrationException, IOException {
        try {
            Object[] params = new Object[]{name};
            if (logger.debugOn()) {
                logger.debug("unregisterMBean", "connectionId=" + this.connectionId + ", name=" + name);
            }
            this.doPrivilegedOperation(24, params, delegationSubject);
        }
        catch (PrivilegedActionException pe) {
            Exception e = RMIConnectionImpl.extractException(pe);
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            if (e instanceof MBeanRegistrationException) {
                throw (MBeanRegistrationException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + e, e);
        }
    }

    @Override
    public ObjectInstance getObjectInstance(ObjectName name, Subject delegationSubject) throws InstanceNotFoundException, IOException {
        RMIConnectionImpl.checkNonNull("ObjectName", name);
        try {
            Object[] params = new Object[]{name};
            if (logger.debugOn()) {
                logger.debug("getObjectInstance", "connectionId=" + this.connectionId + ", name=" + name);
            }
            return (ObjectInstance)this.doPrivilegedOperation(13, params, delegationSubject);
        }
        catch (PrivilegedActionException pe) {
            Exception e = RMIConnectionImpl.extractException(pe);
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + e, e);
        }
    }

    @Override
    public Set<ObjectInstance> queryMBeans(ObjectName name, MarshalledObject query, Subject delegationSubject) throws IOException {
        boolean debug = logger.debugOn();
        if (debug) {
            logger.debug("queryMBeans", "connectionId=" + this.connectionId + " unwrapping query with defaultClassLoader.");
        }
        QueryExp queryValue = RMIConnectionImpl.unwrap(query, this.defaultContextClassLoader, QueryExp.class);
        try {
            Object[] params = new Object[]{name, queryValue};
            if (debug) {
                logger.debug("queryMBeans", "connectionId=" + this.connectionId + ", name=" + name + ", query=" + query);
            }
            return (Set)Util.cast(this.doPrivilegedOperation(17, params, delegationSubject));
        }
        catch (PrivilegedActionException pe) {
            Exception e = RMIConnectionImpl.extractException(pe);
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + e, e);
        }
    }

    @Override
    public Set<ObjectName> queryNames(ObjectName name, MarshalledObject query, Subject delegationSubject) throws IOException {
        boolean debug = logger.debugOn();
        if (debug) {
            logger.debug("queryNames", "connectionId=" + this.connectionId + " unwrapping query with defaultClassLoader.");
        }
        QueryExp queryValue = RMIConnectionImpl.unwrap(query, this.defaultContextClassLoader, QueryExp.class);
        try {
            Object[] params = new Object[]{name, queryValue};
            if (debug) {
                logger.debug("queryNames", "connectionId=" + this.connectionId + ", name=" + name + ", query=" + query);
            }
            return (Set)Util.cast(this.doPrivilegedOperation(18, params, delegationSubject));
        }
        catch (PrivilegedActionException pe) {
            Exception e = RMIConnectionImpl.extractException(pe);
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + e, e);
        }
    }

    @Override
    public boolean isRegistered(ObjectName name, Subject delegationSubject) throws IOException {
        try {
            Object[] params = new Object[]{name};
            return (Boolean)this.doPrivilegedOperation(16, params, delegationSubject);
        }
        catch (PrivilegedActionException pe) {
            Exception e = RMIConnectionImpl.extractException(pe);
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + e, e);
        }
    }

    @Override
    public Integer getMBeanCount(Subject delegationSubject) throws IOException {
        try {
            Object[] params = new Object[]{};
            if (logger.debugOn()) {
                logger.debug("getMBeanCount", "connectionId=" + this.connectionId);
            }
            return (Integer)this.doPrivilegedOperation(11, params, delegationSubject);
        }
        catch (PrivilegedActionException pe) {
            Exception e = RMIConnectionImpl.extractException(pe);
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + e, e);
        }
    }

    @Override
    public Object getAttribute(ObjectName name, String attribute, Subject delegationSubject) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException {
        try {
            Object[] params = new Object[]{name, attribute};
            if (logger.debugOn()) {
                logger.debug("getAttribute", "connectionId=" + this.connectionId + ", name=" + name + ", attribute=" + attribute);
            }
            return this.doPrivilegedOperation(7, params, delegationSubject);
        }
        catch (PrivilegedActionException pe) {
            Exception e = RMIConnectionImpl.extractException(pe);
            if (e instanceof MBeanException) {
                throw (MBeanException)e;
            }
            if (e instanceof AttributeNotFoundException) {
                throw (AttributeNotFoundException)e;
            }
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            if (e instanceof ReflectionException) {
                throw (ReflectionException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + e, e);
        }
    }

    @Override
    public AttributeList getAttributes(ObjectName name, String[] attributes, Subject delegationSubject) throws InstanceNotFoundException, ReflectionException, IOException {
        try {
            Object[] params = new Object[]{name, attributes};
            if (logger.debugOn()) {
                logger.debug("getAttributes", "connectionId=" + this.connectionId + ", name=" + name + ", attributes=" + RMIConnectionImpl.strings(attributes));
            }
            return (AttributeList)this.doPrivilegedOperation(8, params, delegationSubject);
        }
        catch (PrivilegedActionException pe) {
            Exception e = RMIConnectionImpl.extractException(pe);
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            if (e instanceof ReflectionException) {
                throw (ReflectionException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + e, e);
        }
    }

    @Override
    public void setAttribute(ObjectName name, MarshalledObject attribute, Subject delegationSubject) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
        boolean debug = logger.debugOn();
        if (debug) {
            logger.debug("setAttribute", "connectionId=" + this.connectionId + " unwrapping attribute with MBean extended ClassLoader.");
        }
        Attribute attr = RMIConnectionImpl.unwrap(attribute, this.getClassLoaderFor(name), this.defaultClassLoader, Attribute.class);
        try {
            Object[] params = new Object[]{name, attr};
            if (debug) {
                logger.debug("setAttribute", "connectionId=" + this.connectionId + ", name=" + name + ", attribute=" + attr);
            }
            this.doPrivilegedOperation(22, params, delegationSubject);
        }
        catch (PrivilegedActionException pe) {
            Exception e = RMIConnectionImpl.extractException(pe);
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            if (e instanceof AttributeNotFoundException) {
                throw (AttributeNotFoundException)e;
            }
            if (e instanceof InvalidAttributeValueException) {
                throw (InvalidAttributeValueException)e;
            }
            if (e instanceof MBeanException) {
                throw (MBeanException)e;
            }
            if (e instanceof ReflectionException) {
                throw (ReflectionException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + e, e);
        }
    }

    @Override
    public AttributeList setAttributes(ObjectName name, MarshalledObject attributes, Subject delegationSubject) throws InstanceNotFoundException, ReflectionException, IOException {
        boolean debug = logger.debugOn();
        if (debug) {
            logger.debug("setAttributes", "connectionId=" + this.connectionId + " unwrapping attributes with MBean extended ClassLoader.");
        }
        AttributeList attrlist = RMIConnectionImpl.unwrap(attributes, this.getClassLoaderFor(name), this.defaultClassLoader, AttributeList.class);
        try {
            Object[] params = new Object[]{name, attrlist};
            if (debug) {
                logger.debug("setAttributes", "connectionId=" + this.connectionId + ", name=" + name + ", attributes=" + attrlist);
            }
            return (AttributeList)this.doPrivilegedOperation(23, params, delegationSubject);
        }
        catch (PrivilegedActionException pe) {
            Exception e = RMIConnectionImpl.extractException(pe);
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            if (e instanceof ReflectionException) {
                throw (ReflectionException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + e, e);
        }
    }

    @Override
    public Object invoke(ObjectName name, String operationName, MarshalledObject params, String[] signature, Subject delegationSubject) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        RMIConnectionImpl.checkNonNull("ObjectName", name);
        RMIConnectionImpl.checkNonNull("Operation name", operationName);
        boolean debug = logger.debugOn();
        if (debug) {
            logger.debug("invoke", "connectionId=" + this.connectionId + " unwrapping params with MBean extended ClassLoader.");
        }
        Object[] values = RMIConnectionImpl.nullIsEmpty(RMIConnectionImpl.unwrap(params, this.getClassLoaderFor(name), this.defaultClassLoader, Object[].class));
        try {
            Object[] params2 = new Object[]{name, operationName, values, RMIConnectionImpl.nullIsEmpty(signature)};
            if (debug) {
                logger.debug("invoke", "connectionId=" + this.connectionId + ", name=" + name + ", operationName=" + operationName + ", params=" + RMIConnectionImpl.objects(values) + ", signature=" + RMIConnectionImpl.strings(signature));
            }
            return this.doPrivilegedOperation(14, params2, delegationSubject);
        }
        catch (PrivilegedActionException pe) {
            Exception e = RMIConnectionImpl.extractException(pe);
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            if (e instanceof MBeanException) {
                throw (MBeanException)e;
            }
            if (e instanceof ReflectionException) {
                throw (ReflectionException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + e, e);
        }
    }

    @Override
    public String getDefaultDomain(Subject delegationSubject) throws IOException {
        try {
            Object[] params = new Object[]{};
            if (logger.debugOn()) {
                logger.debug("getDefaultDomain", "connectionId=" + this.connectionId);
            }
            return (String)this.doPrivilegedOperation(9, params, delegationSubject);
        }
        catch (PrivilegedActionException pe) {
            Exception e = RMIConnectionImpl.extractException(pe);
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + e, e);
        }
    }

    @Override
    public String[] getDomains(Subject delegationSubject) throws IOException {
        try {
            Object[] params = new Object[]{};
            if (logger.debugOn()) {
                logger.debug("getDomains", "connectionId=" + this.connectionId);
            }
            return (String[])this.doPrivilegedOperation(10, params, delegationSubject);
        }
        catch (PrivilegedActionException pe) {
            Exception e = RMIConnectionImpl.extractException(pe);
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + e, e);
        }
    }

    @Override
    public MBeanInfo getMBeanInfo(ObjectName name, Subject delegationSubject) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        RMIConnectionImpl.checkNonNull("ObjectName", name);
        try {
            Object[] params = new Object[]{name};
            if (logger.debugOn()) {
                logger.debug("getMBeanInfo", "connectionId=" + this.connectionId + ", name=" + name);
            }
            return (MBeanInfo)this.doPrivilegedOperation(12, params, delegationSubject);
        }
        catch (PrivilegedActionException pe) {
            Exception e = RMIConnectionImpl.extractException(pe);
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            if (e instanceof IntrospectionException) {
                throw (IntrospectionException)e;
            }
            if (e instanceof ReflectionException) {
                throw (ReflectionException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + e, e);
        }
    }

    @Override
    public boolean isInstanceOf(ObjectName name, String className, Subject delegationSubject) throws InstanceNotFoundException, IOException {
        RMIConnectionImpl.checkNonNull("ObjectName", name);
        try {
            Object[] params = new Object[]{name, className};
            if (logger.debugOn()) {
                logger.debug("isInstanceOf", "connectionId=" + this.connectionId + ", name=" + name + ", className=" + className);
            }
            return (Boolean)this.doPrivilegedOperation(15, params, delegationSubject);
        }
        catch (PrivilegedActionException pe) {
            Exception e = RMIConnectionImpl.extractException(pe);
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + e, e);
        }
    }

    @Override
    public Integer[] addNotificationListeners(ObjectName[] names, MarshalledObject[] filters, Subject[] delegationSubjects) throws InstanceNotFoundException, IOException {
        int i;
        Subject[] sbjs;
        if (names == null || filters == null) {
            throw new IllegalArgumentException("Got null arguments.");
        }
        Subject[] subjectArray = sbjs = delegationSubjects != null ? delegationSubjects : new Subject[names.length];
        if (names.length != filters.length || filters.length != sbjs.length) {
            String msg = "The value lengths of 3 parameters are not same.";
            throw new IllegalArgumentException("The value lengths of 3 parameters are not same.");
        }
        for (i = 0; i < names.length; ++i) {
            if (names[i] != null) continue;
            throw new IllegalArgumentException("Null Object name.");
        }
        NotificationFilter[] filterValues = new NotificationFilter[names.length];
        Integer[] ids = new Integer[names.length];
        boolean debug = logger.debugOn();
        try {
            for (i = 0; i < names.length; ++i) {
                ClassLoader targetCl = this.getClassLoaderFor(names[i]);
                if (debug) {
                    logger.debug("addNotificationListener(ObjectName,NotificationFilter)", "connectionId=" + this.connectionId + " unwrapping filter with target extended ClassLoader.");
                }
                filterValues[i] = RMIConnectionImpl.unwrap(filters[i], targetCl, this.defaultClassLoader, NotificationFilter.class);
                if (debug) {
                    logger.debug("addNotificationListener(ObjectName,NotificationFilter)", "connectionId=" + this.connectionId + ", name=" + names[i] + ", filter=" + filterValues[i]);
                }
                ids[i] = (Integer)this.doPrivilegedOperation(1, new Object[]{names[i], filterValues[i]}, sbjs[i]);
            }
            return ids;
        }
        catch (Exception e) {
            for (int j = 0; j < i; ++j) {
                try {
                    this.getServerNotifFwd().removeNotificationListener(names[j], ids[j]);
                    continue;
                }
                catch (Exception eee) {
                    // empty catch block
                }
            }
            if (e instanceof PrivilegedActionException) {
                e = RMIConnectionImpl.extractException(e);
            }
            if (e instanceof ClassCastException) {
                throw (ClassCastException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + e, e);
        }
    }

    @Override
    public void addNotificationListener(ObjectName name, ObjectName listener, MarshalledObject filter, MarshalledObject handback, Subject delegationSubject) throws InstanceNotFoundException, IOException {
        RMIConnectionImpl.checkNonNull("Target MBean name", name);
        RMIConnectionImpl.checkNonNull("Listener MBean name", listener);
        boolean debug = logger.debugOn();
        ClassLoader targetCl = this.getClassLoaderFor(name);
        if (debug) {
            logger.debug("addNotificationListener(ObjectName,ObjectName,NotificationFilter,Object)", "connectionId=" + this.connectionId + " unwrapping filter with target extended ClassLoader.");
        }
        NotificationFilter filterValue = RMIConnectionImpl.unwrap(filter, targetCl, this.defaultClassLoader, NotificationFilter.class);
        if (debug) {
            logger.debug("addNotificationListener(ObjectName,ObjectName,NotificationFilter,Object)", "connectionId=" + this.connectionId + " unwrapping handback with target extended ClassLoader.");
        }
        Object handbackValue = RMIConnectionImpl.unwrap(handback, targetCl, this.defaultClassLoader, Object.class);
        try {
            Object[] params = new Object[]{name, listener, filterValue, handbackValue};
            if (debug) {
                logger.debug("addNotificationListener(ObjectName,ObjectName,NotificationFilter,Object)", "connectionId=" + this.connectionId + ", name=" + name + ", listenerName=" + listener + ", filter=" + filterValue + ", handback=" + handbackValue);
            }
            this.doPrivilegedOperation(2, params, delegationSubject);
        }
        catch (PrivilegedActionException pe) {
            Exception e = RMIConnectionImpl.extractException(pe);
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + e, e);
        }
    }

    @Override
    public void removeNotificationListeners(ObjectName name, Integer[] listenerIDs, Subject delegationSubject) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        if (name == null || listenerIDs == null) {
            throw new IllegalArgumentException("Illegal null parameter");
        }
        for (int i = 0; i < listenerIDs.length; ++i) {
            if (listenerIDs[i] != null) continue;
            throw new IllegalArgumentException("Null listener ID");
        }
        try {
            Object[] params = new Object[]{name, listenerIDs};
            if (logger.debugOn()) {
                logger.debug("removeNotificationListener(ObjectName,Integer[])", "connectionId=" + this.connectionId + ", name=" + name + ", listenerIDs=" + RMIConnectionImpl.objects(listenerIDs));
            }
            this.doPrivilegedOperation(19, params, delegationSubject);
        }
        catch (PrivilegedActionException pe) {
            Exception e = RMIConnectionImpl.extractException(pe);
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            if (e instanceof ListenerNotFoundException) {
                throw (ListenerNotFoundException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + e, e);
        }
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener, Subject delegationSubject) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        RMIConnectionImpl.checkNonNull("Target MBean name", name);
        RMIConnectionImpl.checkNonNull("Listener MBean name", listener);
        try {
            Object[] params = new Object[]{name, listener};
            if (logger.debugOn()) {
                logger.debug("removeNotificationListener(ObjectName,ObjectName)", "connectionId=" + this.connectionId + ", name=" + name + ", listenerName=" + listener);
            }
            this.doPrivilegedOperation(20, params, delegationSubject);
        }
        catch (PrivilegedActionException pe) {
            Exception e = RMIConnectionImpl.extractException(pe);
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            if (e instanceof ListenerNotFoundException) {
                throw (ListenerNotFoundException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + e, e);
        }
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener, MarshalledObject filter, MarshalledObject handback, Subject delegationSubject) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        RMIConnectionImpl.checkNonNull("Target MBean name", name);
        RMIConnectionImpl.checkNonNull("Listener MBean name", listener);
        boolean debug = logger.debugOn();
        ClassLoader targetCl = this.getClassLoaderFor(name);
        if (debug) {
            logger.debug("removeNotificationListener(ObjectName,ObjectName,NotificationFilter,Object)", "connectionId=" + this.connectionId + " unwrapping filter with target extended ClassLoader.");
        }
        NotificationFilter filterValue = RMIConnectionImpl.unwrap(filter, targetCl, this.defaultClassLoader, NotificationFilter.class);
        if (debug) {
            logger.debug("removeNotificationListener(ObjectName,ObjectName,NotificationFilter,Object)", "connectionId=" + this.connectionId + " unwrapping handback with target extended ClassLoader.");
        }
        Object handbackValue = RMIConnectionImpl.unwrap(handback, targetCl, this.defaultClassLoader, Object.class);
        try {
            Object[] params = new Object[]{name, listener, filterValue, handbackValue};
            if (debug) {
                logger.debug("removeNotificationListener(ObjectName,ObjectName,NotificationFilter,Object)", "connectionId=" + this.connectionId + ", name=" + name + ", listenerName=" + listener + ", filter=" + filterValue + ", handback=" + handbackValue);
            }
            this.doPrivilegedOperation(21, params, delegationSubject);
        }
        catch (PrivilegedActionException pe) {
            Exception e = RMIConnectionImpl.extractException(pe);
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            if (e instanceof ListenerNotFoundException) {
                throw (ListenerNotFoundException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + e, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NotificationResult fetchNotifications(long clientSequenceNumber, int maxNotifications, long timeout) throws IOException {
        if (logger.debugOn()) {
            logger.debug("fetchNotifications", "connectionId=" + this.connectionId + ", timeout=" + timeout);
        }
        if (maxNotifications < 0 || timeout < 0L) {
            throw new IllegalArgumentException("Illegal negative argument");
        }
        boolean serverTerminated = this.serverCommunicatorAdmin.reqIncoming();
        try {
            if (serverTerminated) {
                NotificationResult notificationResult = new NotificationResult(0L, 0L, new TargetedNotification[0]);
                return notificationResult;
            }
            final long csn = clientSequenceNumber;
            final int mn = maxNotifications;
            final long t = timeout;
            PrivilegedAction<NotificationResult> action = new PrivilegedAction<NotificationResult>(){

                @Override
                public NotificationResult run() {
                    return RMIConnectionImpl.this.getServerNotifFwd().fetchNotifs(csn, t, mn);
                }
            };
            if (this.acc == null) {
                NotificationResult notificationResult = (NotificationResult)action.run();
                return notificationResult;
            }
            NotificationResult notificationResult = AccessController.doPrivileged(action, this.acc);
            return notificationResult;
        }
        finally {
            this.serverCommunicatorAdmin.rspOutgoing();
        }
    }

    public String toString() {
        return super.toString() + ": connectionId=" + this.connectionId;
    }

    private ClassLoader getClassLoader(final ObjectName name) throws InstanceNotFoundException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<ClassLoader>(){

                @Override
                public ClassLoader run() throws InstanceNotFoundException {
                    return RMIConnectionImpl.this.mbeanServer.getClassLoader(name);
                }
            }, RMIConnectionImpl.withPermissions(new MBeanPermission("*", "getClassLoader")));
        }
        catch (PrivilegedActionException pe) {
            throw (InstanceNotFoundException)RMIConnectionImpl.extractException(pe);
        }
    }

    private ClassLoader getClassLoaderFor(final ObjectName name) throws InstanceNotFoundException {
        try {
            return (ClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws InstanceNotFoundException {
                    return RMIConnectionImpl.this.mbeanServer.getClassLoaderFor(name);
                }
            }, RMIConnectionImpl.withPermissions(new MBeanPermission("*", "getClassLoaderFor")));
        }
        catch (PrivilegedActionException pe) {
            throw (InstanceNotFoundException)RMIConnectionImpl.extractException(pe);
        }
    }

    private Object doPrivilegedOperation(int operation, Object[] params, Subject delegationSubject) throws PrivilegedActionException, IOException {
        this.serverCommunicatorAdmin.reqIncoming();
        try {
            AccessControlContext reqACC;
            if (delegationSubject == null) {
                reqACC = this.acc;
            } else {
                if (this.subject == null) {
                    String msg = "Subject delegation cannot be enabled unless an authenticated subject is put in place";
                    throw new SecurityException("Subject delegation cannot be enabled unless an authenticated subject is put in place");
                }
                reqACC = this.subjectDelegator.delegatedContext(this.acc, delegationSubject, this.removeCallerContext);
            }
            PrivilegedOperation op = new PrivilegedOperation(operation, params);
            if (reqACC == null) {
                try {
                    Object object = op.run();
                    return object;
                }
                catch (Exception e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new PrivilegedActionException(e);
                }
            }
            Object object = AccessController.doPrivileged(op, reqACC);
            return object;
        }
        catch (Error e) {
            throw new JMXServerErrorException(e.toString(), e);
        }
        finally {
            this.serverCommunicatorAdmin.rspOutgoing();
        }
    }

    private Object doOperation(int operation, Object[] params) throws Exception {
        switch (operation) {
            case 3: {
                return this.mbeanServer.createMBean((String)params[0], (ObjectName)params[1]);
            }
            case 5: {
                return this.mbeanServer.createMBean((String)params[0], (ObjectName)params[1], (ObjectName)params[2]);
            }
            case 4: {
                return this.mbeanServer.createMBean((String)params[0], (ObjectName)params[1], (Object[])params[2], (String[])params[3]);
            }
            case 6: {
                return this.mbeanServer.createMBean((String)params[0], (ObjectName)params[1], (ObjectName)params[2], (Object[])params[3], (String[])params[4]);
            }
            case 7: {
                return this.mbeanServer.getAttribute((ObjectName)params[0], (String)params[1]);
            }
            case 8: {
                return this.mbeanServer.getAttributes((ObjectName)params[0], (String[])params[1]);
            }
            case 9: {
                return this.mbeanServer.getDefaultDomain();
            }
            case 10: {
                return this.mbeanServer.getDomains();
            }
            case 11: {
                return this.mbeanServer.getMBeanCount();
            }
            case 12: {
                return this.mbeanServer.getMBeanInfo((ObjectName)params[0]);
            }
            case 13: {
                return this.mbeanServer.getObjectInstance((ObjectName)params[0]);
            }
            case 14: {
                return this.mbeanServer.invoke((ObjectName)params[0], (String)params[1], (Object[])params[2], (String[])params[3]);
            }
            case 15: {
                return this.mbeanServer.isInstanceOf((ObjectName)params[0], (String)params[1]) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 16: {
                return this.mbeanServer.isRegistered((ObjectName)params[0]) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 17: {
                return this.mbeanServer.queryMBeans((ObjectName)params[0], (QueryExp)params[1]);
            }
            case 18: {
                return this.mbeanServer.queryNames((ObjectName)params[0], (QueryExp)params[1]);
            }
            case 22: {
                this.mbeanServer.setAttribute((ObjectName)params[0], (Attribute)params[1]);
                return null;
            }
            case 23: {
                return this.mbeanServer.setAttributes((ObjectName)params[0], (AttributeList)params[1]);
            }
            case 24: {
                this.mbeanServer.unregisterMBean((ObjectName)params[0]);
                return null;
            }
            case 1: {
                return this.getServerNotifFwd().addNotificationListener((ObjectName)params[0], (NotificationFilter)params[1]);
            }
            case 2: {
                this.mbeanServer.addNotificationListener((ObjectName)params[0], (ObjectName)params[1], (NotificationFilter)params[2], params[3]);
                return null;
            }
            case 19: {
                this.getServerNotifFwd().removeNotificationListener((ObjectName)params[0], (Integer[])params[1]);
                return null;
            }
            case 20: {
                this.mbeanServer.removeNotificationListener((ObjectName)params[0], (ObjectName)params[1]);
                return null;
            }
            case 21: {
                this.mbeanServer.removeNotificationListener((ObjectName)params[0], (ObjectName)params[1], (NotificationFilter)params[2], params[3]);
                return null;
            }
        }
        throw new IllegalArgumentException("Invalid operation");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> T unwrap(MarshalledObject<?> mo, ClassLoader cl, Class<T> wrappedClass) throws IOException {
        if (mo == null) {
            return null;
        }
        try {
            ClassLoader old = AccessController.doPrivileged(new SetCcl(cl));
            try {
                T t = wrappedClass.cast(mo.get());
                return t;
            }
            catch (ClassNotFoundException cnfe) {
                throw new UnmarshalException(cnfe.toString(), cnfe);
            }
            finally {
                AccessController.doPrivileged(new SetCcl(old));
            }
        }
        catch (PrivilegedActionException pe) {
            Exception e = RMIConnectionImpl.extractException(pe);
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof ClassNotFoundException) {
                throw new UnmarshalException(e.toString(), e);
            }
            logger.warning("unwrap", "Failed to unmarshall object: " + e);
            logger.debug("unwrap", e);
            return null;
        }
    }

    private static <T> T unwrap(MarshalledObject<?> mo, final ClassLoader cl1, final ClassLoader cl2, Class<T> wrappedClass) throws IOException {
        if (mo == null) {
            return null;
        }
        try {
            ClassLoader orderCL = AccessController.doPrivileged(new PrivilegedExceptionAction<ClassLoader>(){

                @Override
                public ClassLoader run() throws Exception {
                    return new CombinedClassLoader(Thread.currentThread().getContextClassLoader(), new OrderClassLoaders(cl1, cl2));
                }
            });
            return RMIConnectionImpl.unwrap(mo, orderCL, wrappedClass);
        }
        catch (PrivilegedActionException pe) {
            Exception e = RMIConnectionImpl.extractException(pe);
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof ClassNotFoundException) {
                throw new UnmarshalException(e.toString(), e);
            }
            logger.warning("unwrap", "Failed to unmarshall object: " + e);
            logger.debug("unwrap", e);
            return null;
        }
    }

    private static IOException newIOException(String message, Throwable cause) {
        IOException x = new IOException(message);
        return EnvHelp.initCause(x, cause);
    }

    private static Exception extractException(Exception e) {
        while (e instanceof PrivilegedActionException) {
            e = ((PrivilegedActionException)e).getException();
        }
        return e;
    }

    private static Object[] nullIsEmpty(Object[] array) {
        return array == null ? NO_OBJECTS : array;
    }

    private static String[] nullIsEmpty(String[] array) {
        return array == null ? NO_STRINGS : array;
    }

    private static void checkNonNull(String what, Object x) {
        if (x == null) {
            IllegalArgumentException wrapped = new IllegalArgumentException(what + " must not be null");
            throw new RuntimeOperationsException(wrapped);
        }
    }

    private static String objects(Object[] objs) {
        if (objs == null) {
            return "null";
        }
        return Arrays.asList(objs).toString();
    }

    private static String strings(String[] strs) {
        return RMIConnectionImpl.objects(strs);
    }

    private static final class CombinedClassLoader
    extends ClassLoader {
        final ClassLoaderWrapper defaultCL;

        private CombinedClassLoader(ClassLoader parent, ClassLoader defaultCL) {
            super(parent);
            this.defaultCL = new ClassLoaderWrapper(defaultCL);
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            try {
                super.loadClass(name, resolve);
            }
            catch (Exception e) {
                for (Throwable t = e; t != null; t = t.getCause()) {
                    if (!(t instanceof SecurityException)) continue;
                    throw t == e ? (SecurityException)t : new SecurityException(t.getMessage(), e);
                }
            }
            Class<?> cl = this.defaultCL.loadClass(name, resolve);
            return cl;
        }

        private static final class ClassLoaderWrapper
        extends ClassLoader {
            ClassLoaderWrapper(ClassLoader cl) {
                super(cl);
            }

            @Override
            protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                return super.loadClass(name, resolve);
            }
        }
    }

    private static class SetCcl
    implements PrivilegedExceptionAction<ClassLoader> {
        private final ClassLoader classLoader;

        SetCcl(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        @Override
        public ClassLoader run() {
            Thread currentThread = Thread.currentThread();
            ClassLoader old = currentThread.getContextClassLoader();
            currentThread.setContextClassLoader(this.classLoader);
            return old;
        }
    }

    private class RMIServerCommunicatorAdmin
    extends ServerCommunicatorAdmin {
        public RMIServerCommunicatorAdmin(long timeout) {
            super(timeout);
        }

        @Override
        protected void doStop() {
            try {
                RMIConnectionImpl.this.close();
            }
            catch (IOException ie) {
                logger.warning("RMIServerCommunicatorAdmin-doStop", "Failed to close: " + ie);
                logger.debug("RMIServerCommunicatorAdmin-doStop", ie);
            }
        }
    }

    private class PrivilegedOperation
    implements PrivilegedExceptionAction<Object> {
        private int operation;
        private Object[] params;

        public PrivilegedOperation(int operation, Object[] params) {
            this.operation = operation;
            this.params = params;
        }

        @Override
        public Object run() throws Exception {
            return RMIConnectionImpl.this.doOperation(this.operation, this.params);
        }
    }
}

