/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.BoundMethodHandle;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleNatives;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.WrongMethodTypeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import sun.invoke.util.ValueConversions;
import sun.invoke.util.VerifyType;
import sun.invoke.util.Wrapper;

class AdapterMethodHandle
extends BoundMethodHandle {
    private final int conversion;
    static final int MAX_ARG_ROTATION = 1;

    private AdapterMethodHandle(MethodHandle target, MethodType newType, long conv, Object convArg) {
        super(newType, convArg, newType.parameterSlotDepth(1 + AdapterMethodHandle.convArgPos(conv)));
        this.conversion = AdapterMethodHandle.convCode(conv);
        MethodHandleNatives.init(this, target, AdapterMethodHandle.convArgPos(conv));
    }

    AdapterMethodHandle(MethodHandle target, MethodType newType, long conv) {
        this(target, newType, conv, null);
    }

    int getConversion() {
        return this.conversion;
    }

    static boolean canPairwiseConvert(MethodType newType, MethodType oldType, int level) {
        int len = newType.parameterCount();
        if (len != oldType.parameterCount()) {
            return false;
        }
        Class<?> exp = newType.returnType();
        Class<?> ret = oldType.returnType();
        if (!VerifyType.isNullConversion(ret, exp)) {
            if (!AdapterMethodHandle.convOpSupported(10)) {
                return false;
            }
            if (!AdapterMethodHandle.canConvertArgument(ret, exp, level)) {
                return false;
            }
        }
        for (int i = 0; i < len; ++i) {
            Class<?> dst;
            Class<?> src = newType.parameterType(i);
            if (AdapterMethodHandle.canConvertArgument(src, dst = oldType.parameterType(i), level)) continue;
            return false;
        }
        return true;
    }

    static boolean canConvertArgument(Class<?> src, Class<?> dst, int level) {
        if (VerifyType.isNullConversion(src, dst)) {
            return true;
        }
        if (AdapterMethodHandle.convOpSupported(10)) {
            return true;
        }
        if (src.isPrimitive()) {
            if (dst.isPrimitive()) {
                return AdapterMethodHandle.canPrimCast(src, dst);
            }
            return AdapterMethodHandle.canBoxArgument(src, dst);
        }
        if (dst.isPrimitive()) {
            return AdapterMethodHandle.canUnboxArgument(src, dst, level);
        }
        return true;
    }

    static MethodHandle makePairwiseConvert(MethodType newType, MethodHandle target, int level) {
        MethodHandle adapter2;
        Class<?> dst;
        Class<?> src;
        int lastConv;
        MethodType oldType = target.type();
        if (newType == oldType) {
            return target;
        }
        if (!AdapterMethodHandle.canPairwiseConvert(newType, oldType, level)) {
            return null;
        }
        for (lastConv = newType.parameterCount() - 1; lastConv >= 0 && AdapterMethodHandle.isTrivialConversion(src = newType.parameterType(lastConv), dst = oldType.parameterType(lastConv), level); --lastConv) {
        }
        Class<?> needReturn = newType.returnType();
        Class<?> haveReturn = oldType.returnType();
        boolean retConv = !AdapterMethodHandle.isTrivialConversion(haveReturn, needReturn, level);
        MethodHandle adapter = target;
        MethodType midType = oldType;
        for (int i = 0; i <= lastConv; ++i) {
            Class<?> dst2;
            Class<?> src2 = newType.parameterType(i);
            if (AdapterMethodHandle.isTrivialConversion(src2, dst2 = midType.parameterType(i), level)) continue;
            midType = midType.changeParameterType(i, src2);
            if (i == lastConv) {
                MethodType lastMidType = newType;
                if (retConv) {
                    lastMidType = lastMidType.changeReturnType(haveReturn);
                }
                assert (VerifyType.isNullConversion(lastMidType, midType));
                midType = lastMidType;
            }
            adapter2 = src2.isPrimitive() ? (dst2.isPrimitive() ? AdapterMethodHandle.makePrimCast(midType, adapter, i, dst2) : AdapterMethodHandle.makeBoxArgument(midType, adapter, i, src2)) : (dst2.isPrimitive() ? AdapterMethodHandle.makeUnboxArgument(midType, adapter, i, dst2, level) : AdapterMethodHandle.makeCheckCast(midType, adapter, i, dst2));
            assert (adapter2 != null) : Arrays.asList(src2, dst2, midType, adapter, i, target, newType);
            assert (adapter2.type() == midType);
            adapter = adapter2;
        }
        if (retConv) {
            adapter2 = AdapterMethodHandle.makeReturnConversion(adapter, haveReturn, needReturn);
            assert (adapter2 != null);
            adapter = adapter2;
        }
        if (adapter.type() != newType) {
            adapter2 = AdapterMethodHandle.makeRetypeOnly(newType, adapter);
            assert (adapter2 != null);
            adapter = adapter2;
            assert (lastConv == -1 || retConv);
        }
        assert (adapter.type() == newType);
        return adapter;
    }

    private static boolean isTrivialConversion(Class<?> src, Class<?> dst, int level) {
        boolean dp;
        if (src == dst || dst == Void.TYPE) {
            return true;
        }
        if (!VerifyType.isNullConversion(src, dst)) {
            return false;
        }
        if (level > 1) {
            return true;
        }
        boolean sp = src.isPrimitive();
        if (sp != (dp = dst.isPrimitive())) {
            return false;
        }
        if (sp) {
            return Wrapper.forPrimitiveType(dst).isConvertibleFrom(Wrapper.forPrimitiveType(src));
        }
        return dst.isAssignableFrom(src);
    }

    private static MethodHandle makeReturnConversion(MethodHandle target, Class<?> haveReturn, Class<?> needReturn) {
        MethodHandle adjustReturn;
        if (haveReturn == Void.TYPE) {
            Object zero = Wrapper.forBasicType(needReturn).zero();
            adjustReturn = MethodHandles.constant(needReturn, zero);
        } else {
            MethodType needConversion = MethodType.methodType(needReturn, haveReturn);
            adjustReturn = MethodHandles.identity(needReturn).asType(needConversion);
        }
        if (!AdapterMethodHandle.canCollectArguments(adjustReturn.type(), target.type(), 0, false)) {
            assert (MethodHandleNatives.workaroundWithoutRicochetFrames());
            throw new InternalError("NYI");
        }
        return AdapterMethodHandle.makeCollectArguments(adjustReturn, target, 0, false);
    }

    static MethodHandle makePermutation(MethodType newType, MethodHandle target, int[] argumentMap) {
        MethodType oldType = target.type();
        boolean nullPermutation = true;
        for (int i = 0; i < argumentMap.length; ++i) {
            int pos = argumentMap[i];
            if (pos != i) {
                nullPermutation = false;
            }
            if (pos >= 0 && pos < newType.parameterCount()) continue;
            argumentMap = new int[]{};
            break;
        }
        if (argumentMap.length != oldType.parameterCount()) {
            throw MethodHandleStatics.newIllegalArgumentException("bad permutation: " + Arrays.toString(argumentMap));
        }
        if (nullPermutation) {
            MethodHandle res = AdapterMethodHandle.makePairwiseConvert(newType, target, 0);
            if (res == null) {
                throw MethodHandleStatics.newIllegalArgumentException("cannot convert pairwise: " + newType);
            }
            return res;
        }
        Class<?> exp = newType.returnType();
        Class<?> ret = oldType.returnType();
        if (!VerifyType.isNullConversion(ret, exp)) {
            throw MethodHandleStatics.newIllegalArgumentException("bad return conversion for " + newType);
        }
        for (int i = 0; i < argumentMap.length; ++i) {
            Class<?> dst;
            int j = argumentMap[i];
            Class<?> src = newType.parameterType(j);
            if (VerifyType.isNullConversion(src, dst = oldType.parameterType(i))) continue;
            throw MethodHandleStatics.newIllegalArgumentException("bad argument #" + j + " conversion for " + newType);
        }
        throw new UnsupportedOperationException("NYI");
    }

    private static byte basicType(Class<?> type) {
        if (type == null) {
            return 14;
        }
        switch (Wrapper.forBasicType(type)) {
            case BOOLEAN: {
                return 4;
            }
            case CHAR: {
                return 5;
            }
            case FLOAT: {
                return 6;
            }
            case DOUBLE: {
                return 7;
            }
            case BYTE: {
                return 8;
            }
            case SHORT: {
                return 9;
            }
            case INT: {
                return 10;
            }
            case LONG: {
                return 11;
            }
            case OBJECT: {
                return 12;
            }
            case VOID: {
                return 14;
            }
        }
        return 99;
    }

    private static int type2size(int type) {
        assert (type >= 4 && type <= 12);
        return type == 11 || type == 7 ? 2 : 1;
    }

    private static int type2size(Class<?> type) {
        return AdapterMethodHandle.type2size(AdapterMethodHandle.basicType(type));
    }

    private static long insertStackMove(int stackMove) {
        long spChange = stackMove * MethodHandleNatives.JVM_STACK_MOVE_UNIT;
        return (spChange & 0xFFFL) << 20;
    }

    static int extractStackMove(int convOp) {
        int spChange = convOp >> 20;
        return spChange / MethodHandleNatives.JVM_STACK_MOVE_UNIT;
    }

    static int extractStackMove(MethodHandle target) {
        if (target instanceof AdapterMethodHandle) {
            AdapterMethodHandle amh = (AdapterMethodHandle)target;
            return AdapterMethodHandle.extractStackMove(amh.getConversion());
        }
        return 0;
    }

    private static long makeConv(int convOp, int argnum, int src, int dest) {
        assert (src == (src & 0xF));
        assert (dest == (dest & 0xF));
        assert (convOp >= 2 && convOp <= 5 || convOp == 10);
        int stackMove = AdapterMethodHandle.type2size(dest) - AdapterMethodHandle.type2size(src);
        return (long)argnum << 32 | (long)convOp << 8 | (long)(src << 16) | (long)(dest << 12) | AdapterMethodHandle.insertStackMove(stackMove);
    }

    private static long makeDupConv(int convOp, int argnum, int stackMove) {
        assert (convOp == 8 || convOp == 9);
        int src = 0;
        int dest = 0;
        return (long)argnum << 32 | (long)convOp << 8 | (long)(src << 16) | (long)(dest << 12) | AdapterMethodHandle.insertStackMove(stackMove);
    }

    private static long makeSwapConv(int convOp, int srcArg, byte srcType, int destSlot, byte destType) {
        assert (convOp == 6 || convOp == 7);
        return (long)srcArg << 32 | (long)convOp << 8 | (long)(srcType << 16) | (long)(destType << 12) | (long)(destSlot << 0);
    }

    private static long makeSpreadConv(int convOp, int argnum, int src, int dest, int stackMove) {
        assert (convOp == 11 || convOp == 10 || convOp == 12);
        return (long)argnum << 32 | (long)convOp << 8 | (long)(src << 16) | (long)(dest << 12) | AdapterMethodHandle.insertStackMove(stackMove);
    }

    static long makeConv(int convOp) {
        assert (convOp == 0 || convOp == 1);
        return 0xFFFFFFFF00000000L | (long)(convOp << 8);
    }

    private static int convCode(long conv) {
        return (int)conv;
    }

    private static int convArgPos(long conv) {
        return (int)(conv >>> 32);
    }

    private static boolean convOpSupported(int convOp) {
        assert (convOp >= 0 && convOp <= 14);
        return (1 << convOp & MethodHandleNatives.CONV_OP_IMPLEMENTED_MASK) != 0;
    }

    int conversionOp() {
        return (this.conversion & 0xF00) >> 8;
    }

    private static int diffTypes(MethodType adapterType, MethodType targetType, boolean raw) {
        int diff = AdapterMethodHandle.diffReturnTypes(adapterType, targetType, raw);
        if (diff != 0) {
            return diff;
        }
        int nargs = adapterType.parameterCount();
        if (nargs != targetType.parameterCount()) {
            return -1;
        }
        diff = AdapterMethodHandle.diffParamTypes(adapterType, 0, targetType, 0, nargs, raw);
        return diff;
    }

    private static int diffReturnTypes(MethodType adapterType, MethodType targetType, boolean raw) {
        Class<?> src = targetType.returnType();
        Class<?> dst = adapterType.returnType();
        if ((!raw ? VerifyType.canPassUnchecked(src, dst) : VerifyType.canPassRaw(src, dst)) > 0) {
            return 0;
        }
        if (raw && !src.isPrimitive() && !dst.isPrimitive()) {
            return 0;
        }
        return -1;
    }

    private static int diffParamTypes(MethodType adapterType, int astart, MethodType targetType, int tstart, int nargs, boolean raw) {
        assert (nargs >= 0);
        int res = 0;
        for (int i = 0; i < nargs; ++i) {
            Class<?> src = adapterType.parameterType(astart + i);
            Class<?> dest = targetType.parameterType(tstart + i);
            if ((!raw ? VerifyType.canPassUnchecked(src, dest) : VerifyType.canPassRaw(src, dest)) > 0) continue;
            if (res != 0) {
                return -1 - res;
            }
            res = 1 + i;
        }
        return res;
    }

    static boolean canRetypeOnly(MethodType newType, MethodType targetType) {
        return AdapterMethodHandle.canRetype(newType, targetType, false);
    }

    static boolean canRetypeRaw(MethodType newType, MethodType targetType) {
        return AdapterMethodHandle.canRetype(newType, targetType, true);
    }

    static boolean canRetype(MethodType newType, MethodType targetType, boolean raw) {
        if (!AdapterMethodHandle.convOpSupported(raw ? 1 : 0)) {
            return false;
        }
        int diff = AdapterMethodHandle.diffTypes(newType, targetType, raw);
        assert (raw || diff == 0 == VerifyType.isNullConversion(newType, targetType));
        return diff == 0;
    }

    static MethodHandle makeRetypeOnly(MethodType newType, MethodHandle target) {
        return AdapterMethodHandle.makeRetype(newType, target, false);
    }

    static MethodHandle makeRetypeRaw(MethodType newType, MethodHandle target) {
        return AdapterMethodHandle.makeRetype(newType, target, true);
    }

    static MethodHandle makeRetype(MethodType newType, MethodHandle target, boolean raw) {
        MethodType oldType = target.type();
        if (oldType == newType) {
            return target;
        }
        if (!AdapterMethodHandle.canRetype(newType, oldType, raw)) {
            return null;
        }
        return new AdapterMethodHandle(target, newType, AdapterMethodHandle.makeConv(raw ? 1 : 0));
    }

    static MethodHandle makeVarargsCollector(MethodHandle target, Class<?> arrayType) {
        int last;
        MethodType type = target.type();
        if (type.parameterType(last = type.parameterCount() - 1) != arrayType) {
            target = target.asType(type.changeParameterType(last, arrayType));
        }
        target = target.asFixedArity();
        return new AsVarargsCollector(target, arrayType);
    }

    static boolean canCheckCast(MethodType newType, MethodType targetType, int arg, Class<?> castType) {
        if (!AdapterMethodHandle.convOpSupported(2)) {
            return false;
        }
        Class<?> src = newType.parameterType(arg);
        Class<?> dst = targetType.parameterType(arg);
        if (!AdapterMethodHandle.canCheckCast(src, castType) || !VerifyType.isNullConversion(castType, dst)) {
            return false;
        }
        int diff = AdapterMethodHandle.diffTypes(newType, targetType, false);
        return diff == arg + 1 || diff == 0;
    }

    static boolean canCheckCast(Class<?> src, Class<?> dst) {
        return !src.isPrimitive() && !dst.isPrimitive();
    }

    static MethodHandle makeCheckCast(MethodType newType, MethodHandle target, int arg, Class<?> castType) {
        if (!AdapterMethodHandle.canCheckCast(newType, target.type(), arg, castType)) {
            return null;
        }
        long conv = AdapterMethodHandle.makeConv(2, arg, 12, 12);
        return new AdapterMethodHandle(target, newType, conv, castType);
    }

    static boolean canPrimCast(MethodType newType, MethodType targetType, int arg, Class<?> convType) {
        if (!AdapterMethodHandle.convOpSupported(3)) {
            return false;
        }
        Class<?> src = newType.parameterType(arg);
        Class<?> dst = targetType.parameterType(arg);
        if (!AdapterMethodHandle.canPrimCast(src, convType) || !VerifyType.isNullConversion(convType, dst)) {
            return false;
        }
        int diff = AdapterMethodHandle.diffTypes(newType, targetType, false);
        return diff == arg + 1;
    }

    static boolean canPrimCast(Class<?> src, Class<?> dst) {
        boolean dflt;
        if (src == dst || !src.isPrimitive() || !dst.isPrimitive()) {
            return false;
        }
        boolean sflt = Wrapper.forPrimitiveType(src).isFloating();
        return !(sflt | (dflt = Wrapper.forPrimitiveType(dst).isFloating()));
    }

    static MethodHandle makePrimCast(MethodType newType, MethodHandle target, int arg, Class<?> convType) {
        boolean dflt;
        Class<?> src = newType.parameterType(arg);
        if (AdapterMethodHandle.canPrimCast(src, convType)) {
            return AdapterMethodHandle.makePrimCastOnly(newType, target, arg, convType);
        }
        Class<?> dst = convType;
        boolean sflt = Wrapper.forPrimitiveType(src).isFloating();
        if (sflt | (dflt = Wrapper.forPrimitiveType(dst).isFloating())) {
            MethodHandle convMethod = sflt ? (src == Double.TYPE ? ValueConversions.convertFromDouble(dst) : ValueConversions.convertFromFloat(dst)) : (dst == Double.TYPE ? ValueConversions.convertToDouble(src) : ValueConversions.convertToFloat(src));
            long conv = AdapterMethodHandle.makeConv(10, arg, AdapterMethodHandle.basicType(src), AdapterMethodHandle.basicType(dst));
            return new AdapterMethodHandle(target, newType, conv, convMethod);
        }
        throw new InternalError("makePrimCast");
    }

    static MethodHandle makePrimCastOnly(MethodType newType, MethodHandle target, int arg, Class<?> convType) {
        MethodType oldType = target.type();
        if (!AdapterMethodHandle.canPrimCast(newType, oldType, arg, convType)) {
            return null;
        }
        Class<?> src = newType.parameterType(arg);
        long conv = AdapterMethodHandle.makeConv(3, arg, AdapterMethodHandle.basicType(src), AdapterMethodHandle.basicType(convType));
        return new AdapterMethodHandle(target, newType, conv);
    }

    static boolean canUnboxArgument(MethodType newType, MethodType targetType, int arg, Class<?> convType, int level) {
        if (!AdapterMethodHandle.convOpSupported(4)) {
            return false;
        }
        Class<?> src = newType.parameterType(arg);
        Class<?> dst = targetType.parameterType(arg);
        Class<?> boxType = Wrapper.asWrapperType(convType);
        convType = Wrapper.asPrimitiveType(convType);
        if (!AdapterMethodHandle.canCheckCast(src, boxType) || boxType == convType || !VerifyType.isNullConversion(convType, dst)) {
            return false;
        }
        int diff = AdapterMethodHandle.diffTypes(newType, targetType, false);
        return diff == arg + 1;
    }

    static boolean canUnboxArgument(Class<?> src, Class<?> dst, int level) {
        assert (dst.isPrimitive());
        if (AdapterMethodHandle.convOpSupported(5)) {
            return true;
        }
        Wrapper dw = Wrapper.forPrimitiveType(dst);
        if (level == 0) {
            return !src.isPrimitive();
        }
        assert (level >= 0 && level <= 2);
        return dw.wrapperType() == src;
    }

    static MethodHandle makeUnboxArgument(MethodType newType, MethodHandle target, int arg, Class<?> convType, int level) {
        MethodType oldType = target.type();
        Class<?> src = newType.parameterType(arg);
        Class<?> dst = oldType.parameterType(arg);
        Class<?> boxType = Wrapper.asWrapperType(convType);
        Class<?> primType = Wrapper.asPrimitiveType(convType);
        if (!AdapterMethodHandle.canUnboxArgument(newType, oldType, arg, convType, level)) {
            return null;
        }
        MethodType castDone = newType;
        if (!VerifyType.isNullConversion(src, boxType)) {
            if (level != 0) {
                if (src == Object.class || !Wrapper.isWrapperType(src)) {
                    MethodHandle unboxMethod = level == 1 ? ValueConversions.unbox(dst) : ValueConversions.unboxCast(dst);
                    long conv = AdapterMethodHandle.makeConv(10, arg, AdapterMethodHandle.basicType(src), AdapterMethodHandle.basicType(dst));
                    return new AdapterMethodHandle(target, newType, conv, unboxMethod);
                }
                Class<?> srcPrim = Wrapper.forWrapperType(src).primitiveType();
                MethodType midType = newType.changeParameterType(arg, srcPrim);
                MethodHandle fixPrim = AdapterMethodHandle.canPrimCast(midType, oldType, arg, dst) ? AdapterMethodHandle.makePrimCast(midType, target, arg, dst) : target;
                return AdapterMethodHandle.makeUnboxArgument(newType, fixPrim, arg, srcPrim, 0);
            }
            castDone = newType.changeParameterType(arg, boxType);
        }
        long conv = AdapterMethodHandle.makeConv(4, arg, 12, AdapterMethodHandle.basicType(primType));
        AdapterMethodHandle adapter = new AdapterMethodHandle(target, castDone, conv, boxType);
        if (castDone == newType) {
            return adapter;
        }
        return AdapterMethodHandle.makeCheckCast(newType, adapter, arg, boxType);
    }

    static boolean canBoxArgument(MethodType newType, MethodType targetType, int arg, Class<?> convType) {
        if (!AdapterMethodHandle.convOpSupported(5)) {
            return false;
        }
        Class<?> src = newType.parameterType(arg);
        Class<?> dst = targetType.parameterType(arg);
        Class<?> boxType = Wrapper.asWrapperType(convType);
        convType = Wrapper.asPrimitiveType(convType);
        if (!AdapterMethodHandle.canCheckCast(boxType, dst) || boxType == convType || !VerifyType.isNullConversion(src, convType)) {
            return false;
        }
        int diff = AdapterMethodHandle.diffTypes(newType, targetType, false);
        return diff == arg + 1;
    }

    static boolean canBoxArgument(Class<?> src, Class<?> dst) {
        if (!AdapterMethodHandle.convOpSupported(5)) {
            return false;
        }
        return src.isPrimitive() && !dst.isPrimitive();
    }

    static MethodHandle makeBoxArgument(MethodType newType, MethodHandle target, int arg, Class<?> convType) {
        MethodType oldType = target.type();
        Class<?> src = newType.parameterType(arg);
        Class<?> dst = oldType.parameterType(arg);
        Class<?> boxType = Wrapper.asWrapperType(convType);
        Class<?> primType = Wrapper.asPrimitiveType(convType);
        if (!AdapterMethodHandle.canBoxArgument(newType, oldType, arg, convType)) {
            return null;
        }
        if (!VerifyType.isNullConversion(boxType, dst)) {
            target = AdapterMethodHandle.makeCheckCast(oldType.changeParameterType(arg, boxType), target, arg, dst);
        }
        MethodHandle boxerMethod = ValueConversions.box(Wrapper.forPrimitiveType(primType));
        long conv = AdapterMethodHandle.makeConv(5, arg, AdapterMethodHandle.basicType(primType), 12);
        return new AdapterMethodHandle(target, newType, conv, boxerMethod);
    }

    static boolean canDropArguments(MethodType newType, MethodType targetType, int dropArgPos, int dropArgCount) {
        if (dropArgCount == 0) {
            return AdapterMethodHandle.canRetypeOnly(newType, targetType);
        }
        if (!AdapterMethodHandle.convOpSupported(9)) {
            return false;
        }
        if (AdapterMethodHandle.diffReturnTypes(newType, targetType, false) != 0) {
            return false;
        }
        int nptypes = newType.parameterCount();
        if (dropArgPos != 0 && AdapterMethodHandle.diffParamTypes(newType, 0, targetType, 0, dropArgPos, false) != 0) {
            return false;
        }
        int afterPos = dropArgPos + dropArgCount;
        int afterCount = nptypes - afterPos;
        if (dropArgPos < 0 || dropArgPos >= nptypes || dropArgCount < 1 || afterPos > nptypes || targetType.parameterCount() != nptypes - dropArgCount) {
            return false;
        }
        return afterCount == 0 || AdapterMethodHandle.diffParamTypes(newType, afterPos, targetType, dropArgPos, afterCount, false) == 0;
    }

    static MethodHandle makeDropArguments(MethodType newType, MethodHandle target, int dropArgPos, int dropArgCount) {
        if (dropArgCount == 0) {
            return AdapterMethodHandle.makeRetypeOnly(newType, target);
        }
        if (!AdapterMethodHandle.canDropArguments(newType, target.type(), dropArgPos, dropArgCount)) {
            return null;
        }
        int keep2InPos = dropArgPos + dropArgCount;
        int dropSlot = newType.parameterSlotDepth(keep2InPos);
        int keep1InSlot = newType.parameterSlotDepth(dropArgPos);
        int slotCount = keep1InSlot - dropSlot;
        assert (slotCount >= dropArgCount);
        assert (target.type().parameterSlotCount() + slotCount == newType.parameterSlotCount());
        long conv = AdapterMethodHandle.makeDupConv(9, dropArgPos + dropArgCount - 1, -slotCount);
        return new AdapterMethodHandle(target, newType, conv);
    }

    static boolean canDupArguments(MethodType newType, MethodType targetType, int dupArgPos, int dupArgCount) {
        if (!AdapterMethodHandle.convOpSupported(8)) {
            return false;
        }
        if (AdapterMethodHandle.diffReturnTypes(newType, targetType, false) != 0) {
            return false;
        }
        int nptypes = newType.parameterCount();
        if (dupArgCount < 0 || dupArgPos + dupArgCount > nptypes) {
            return false;
        }
        if (targetType.parameterCount() != nptypes + dupArgCount) {
            return false;
        }
        if (AdapterMethodHandle.diffParamTypes(newType, 0, targetType, 0, nptypes, false) != 0) {
            return false;
        }
        return AdapterMethodHandle.diffParamTypes(newType, dupArgPos, targetType, nptypes, dupArgCount, false) == 0;
    }

    static MethodHandle makeDupArguments(MethodType newType, MethodHandle target, int dupArgPos, int dupArgCount) {
        if (!AdapterMethodHandle.canDupArguments(newType, target.type(), dupArgPos, dupArgCount)) {
            return null;
        }
        if (dupArgCount == 0) {
            return target;
        }
        int keep2InPos = dupArgPos + dupArgCount;
        int dupSlot = newType.parameterSlotDepth(keep2InPos);
        int keep1InSlot = newType.parameterSlotDepth(dupArgPos);
        int slotCount = keep1InSlot - dupSlot;
        assert (target.type().parameterSlotCount() - slotCount == newType.parameterSlotCount());
        long conv = AdapterMethodHandle.makeDupConv(8, dupArgPos + dupArgCount - 1, slotCount);
        return new AdapterMethodHandle(target, newType, conv);
    }

    static boolean canSwapArguments(MethodType newType, MethodType targetType, int swapArg1, int swapArg2) {
        if (!AdapterMethodHandle.convOpSupported(6)) {
            return false;
        }
        if (AdapterMethodHandle.diffReturnTypes(newType, targetType, false) != 0) {
            return false;
        }
        if (swapArg1 >= swapArg2) {
            return false;
        }
        int nptypes = newType.parameterCount();
        if (targetType.parameterCount() != nptypes) {
            return false;
        }
        if (swapArg1 < 0 || swapArg2 >= nptypes) {
            return false;
        }
        if (AdapterMethodHandle.diffParamTypes(newType, 0, targetType, 0, swapArg1, false) != 0) {
            return false;
        }
        if (AdapterMethodHandle.diffParamTypes(newType, swapArg1, targetType, swapArg2, 1, false) != 0) {
            return false;
        }
        if (AdapterMethodHandle.diffParamTypes(newType, swapArg1 + 1, targetType, swapArg1 + 1, swapArg2 - swapArg1 - 1, false) != 0) {
            return false;
        }
        if (AdapterMethodHandle.diffParamTypes(newType, swapArg2, targetType, swapArg1, 1, false) != 0) {
            return false;
        }
        return AdapterMethodHandle.diffParamTypes(newType, swapArg2 + 1, targetType, swapArg2 + 1, nptypes - swapArg2 - 1, false) == 0;
    }

    static MethodHandle makeSwapArguments(MethodType newType, MethodHandle target, int swapArg1, int swapArg2) {
        if (swapArg1 == swapArg2) {
            return target;
        }
        if (swapArg1 > swapArg2) {
            int t = swapArg1;
            swapArg1 = swapArg2;
            swapArg2 = t;
        }
        if (AdapterMethodHandle.type2size(newType.parameterType(swapArg1)) != AdapterMethodHandle.type2size(newType.parameterType(swapArg2))) {
            int argc = swapArg2 - swapArg1 + 1;
            boolean ROT = true;
            ArrayList rot1Params = new ArrayList(target.type().parameterList());
            Collections.rotate(rot1Params.subList(swapArg1, swapArg1 + argc), -1);
            MethodType rot1Type = MethodType.methodType(target.type().returnType(), rot1Params);
            MethodHandle rot1 = AdapterMethodHandle.makeRotateArguments(rot1Type, target, swapArg1, argc, 1);
            assert (rot1 != null);
            if (argc == 2) {
                return rot1;
            }
            MethodHandle rot2 = AdapterMethodHandle.makeRotateArguments(newType, rot1, swapArg1, argc - 1, -1);
            assert (rot2 != null);
            return rot2;
        }
        if (!AdapterMethodHandle.canSwapArguments(newType, target.type(), swapArg1, swapArg2)) {
            return null;
        }
        Class<?> type1 = newType.parameterType(swapArg1);
        Class<?> type2 = newType.parameterType(swapArg2);
        int swapSlot2 = newType.parameterSlotDepth(swapArg2 + 1);
        long conv = AdapterMethodHandle.makeSwapConv(6, swapArg1, AdapterMethodHandle.basicType(type1), swapSlot2, AdapterMethodHandle.basicType(type2));
        return new AdapterMethodHandle(target, newType, conv);
    }

    static int positiveRotation(int argCount, int rotateBy) {
        assert (argCount > 0);
        if (rotateBy >= 0) {
            if (rotateBy < argCount) {
                return rotateBy;
            }
            return rotateBy % argCount;
        }
        if (rotateBy >= -argCount) {
            return rotateBy + argCount;
        }
        return -1 - (-1 - rotateBy) % argCount + argCount;
    }

    static boolean canRotateArguments(MethodType newType, MethodType targetType, int firstArg, int argCount, int rotateBy) {
        if (!AdapterMethodHandle.convOpSupported(7)) {
            return false;
        }
        if ((rotateBy = AdapterMethodHandle.positiveRotation(argCount, rotateBy)) == 0) {
            return false;
        }
        if (rotateBy > 1 && rotateBy < argCount - 1) {
            return false;
        }
        if (AdapterMethodHandle.diffReturnTypes(newType, targetType, false) != 0) {
            return false;
        }
        int nptypes = newType.parameterCount();
        if (targetType.parameterCount() != nptypes) {
            return false;
        }
        if (firstArg < 0 || firstArg >= nptypes) {
            return false;
        }
        int argLimit = firstArg + argCount;
        if (argLimit > nptypes) {
            return false;
        }
        if (AdapterMethodHandle.diffParamTypes(newType, 0, targetType, 0, firstArg, false) != 0) {
            return false;
        }
        int newChunk1 = argCount - rotateBy;
        int newChunk2 = rotateBy;
        if (AdapterMethodHandle.diffParamTypes(newType, firstArg, targetType, argLimit - newChunk1, newChunk1, false) != 0) {
            return false;
        }
        return AdapterMethodHandle.diffParamTypes(newType, firstArg + newChunk1, targetType, firstArg, newChunk2, false) == 0;
    }

    static MethodHandle makeRotateArguments(MethodType newType, MethodHandle target, int firstArg, int argCount, int rotateBy) {
        int moveChunk;
        int dstSlot;
        int dstArg;
        int srcArg;
        rotateBy = AdapterMethodHandle.positiveRotation(argCount, rotateBy);
        if (!AdapterMethodHandle.canRotateArguments(newType, target.type(), firstArg, argCount, rotateBy)) {
            return null;
        }
        int limit = firstArg + argCount;
        int depth0 = newType.parameterSlotDepth(firstArg);
        int depth1 = newType.parameterSlotDepth(limit - rotateBy);
        int depth2 = newType.parameterSlotDepth(limit);
        int chunk1Slots = depth0 - depth1;
        assert (chunk1Slots > 0);
        int chunk2Slots = depth1 - depth2;
        assert (chunk2Slots > 0);
        if (rotateBy == 1) {
            srcArg = limit - 1;
            dstArg = firstArg;
            dstSlot = depth0 + MethodHandleNatives.OP_ROT_ARGS_DOWN_LIMIT_BIAS;
            moveChunk = chunk2Slots;
        } else {
            srcArg = firstArg;
            dstArg = limit - 1;
            dstSlot = depth2;
            moveChunk = chunk1Slots;
        }
        byte srcType = AdapterMethodHandle.basicType(newType.parameterType(srcArg));
        byte dstType = AdapterMethodHandle.basicType(newType.parameterType(dstArg));
        assert (moveChunk == AdapterMethodHandle.type2size(srcType));
        long conv = AdapterMethodHandle.makeSwapConv(7, srcArg, srcType, dstSlot, dstType);
        return new AdapterMethodHandle(target, newType, conv);
    }

    static boolean canSpreadArguments(MethodType newType, MethodType targetType, Class<?> spreadArgType, int spreadArgPos, int spreadArgCount) {
        if (!AdapterMethodHandle.convOpSupported(11)) {
            return false;
        }
        if (AdapterMethodHandle.diffReturnTypes(newType, targetType, false) != 0) {
            return false;
        }
        int nptypes = newType.parameterCount();
        if (spreadArgPos != 0 && AdapterMethodHandle.diffParamTypes(newType, 0, targetType, 0, spreadArgPos, false) != 0) {
            return false;
        }
        int afterPos = spreadArgPos + spreadArgCount;
        int afterCount = nptypes - (spreadArgPos + 1);
        if (spreadArgPos < 0 || spreadArgPos >= nptypes || spreadArgCount < 0 || targetType.parameterCount() != afterPos + afterCount) {
            return false;
        }
        if (afterCount != 0 && AdapterMethodHandle.diffParamTypes(newType, spreadArgPos + 1, targetType, afterPos, afterCount, false) != 0) {
            return false;
        }
        Class<?> rawSpreadArgType = newType.parameterType(spreadArgPos);
        if (rawSpreadArgType != spreadArgType && !AdapterMethodHandle.canCheckCast(rawSpreadArgType, spreadArgType)) {
            return false;
        }
        for (int i = 0; i < spreadArgCount; ++i) {
            Class<?> src = VerifyType.spreadArgElementType(spreadArgType, i);
            Class<?> dst = targetType.parameterType(spreadArgPos + i);
            if (src != null && AdapterMethodHandle.canConvertArgument(src, dst, 1)) continue;
            return false;
        }
        return true;
    }

    static MethodHandle makeSpreadArguments(MethodType newType, MethodHandle target, Class<?> spreadArgType, int spreadArgPos, int spreadArgCount) {
        MethodType targetType = target.type();
        assert (AdapterMethodHandle.canSpreadArguments(newType, targetType, spreadArgType, spreadArgPos, spreadArgCount)) : "[newType, targetType, spreadArgType, spreadArgPos, spreadArgCount] = " + Arrays.asList(newType, targetType, spreadArgType, spreadArgPos, spreadArgCount);
        int dest = 14;
        for (int i = 0; i < spreadArgCount; ++i) {
            Class<Object> arg = VerifyType.spreadArgElementType(spreadArgType, i);
            if (arg == null) {
                arg = Object.class;
            }
            int dest2 = AdapterMethodHandle.basicType(arg);
            if (dest == 14) {
                dest = dest2;
            } else if (dest != dest2) {
                dest = 14;
            }
            if (dest == 14) break;
            targetType = targetType.changeParameterType(spreadArgPos + i, arg);
        }
        target = target.asType(targetType);
        int arrayArgSize = 1;
        int keep2OutPos = spreadArgPos + spreadArgCount;
        int keep1OutSlot = targetType.parameterSlotDepth(spreadArgPos);
        int spreadSlot = targetType.parameterSlotDepth(keep2OutPos);
        assert (spreadSlot == newType.parameterSlotDepth(spreadArgPos + arrayArgSize));
        int slotCount = keep1OutSlot - spreadSlot;
        assert (slotCount >= spreadArgCount);
        int stackMove = -arrayArgSize + slotCount;
        long conv = AdapterMethodHandle.makeSpreadConv(11, spreadArgPos, 12, dest, stackMove);
        AdapterMethodHandle res = new AdapterMethodHandle(target, newType, conv, spreadArgType);
        assert (res.type().parameterType(spreadArgPos) == spreadArgType);
        return res;
    }

    static boolean canCollectArguments(MethodType targetType, MethodType collectorType, int collectArgPos, boolean retainOriginalArgs) {
        if (!AdapterMethodHandle.convOpSupported(retainOriginalArgs ? 12 : 10)) {
            return false;
        }
        int collectArgCount = collectorType.parameterCount();
        Class<?> rtype = collectorType.returnType();
        assert (rtype == Void.TYPE || targetType.parameterType(collectArgPos) == rtype) : Arrays.asList(targetType, collectorType, collectArgPos, collectArgCount);
        return true;
    }

    static MethodHandle makeCollectArguments(MethodHandle target, MethodHandle collector, int collectArgPos, boolean retainOriginalArgs) {
        assert (AdapterMethodHandle.canCollectArguments(target.type(), collector.type(), collectArgPos, retainOriginalArgs));
        MethodType targetType = target.type();
        MethodType collectorType = collector.type();
        int collectArgCount = collectorType.parameterCount();
        Class<?> collectValType = collectorType.returnType();
        int collectValCount = collectValType == Void.TYPE ? 0 : 1;
        int collectValSlots = collectorType.returnSlotCount();
        MethodType newType = targetType.dropParameterTypes(collectArgPos, collectArgPos + collectValCount);
        if (!retainOriginalArgs) {
            newType = newType.insertParameterTypes(collectArgPos, collectorType.parameterList());
        } else assert (AdapterMethodHandle.diffParamTypes(newType, collectArgPos, targetType, collectValCount, collectArgCount, false) == 0) : Arrays.asList(target, collector, collectArgPos, retainOriginalArgs);
        int keep2InPos = collectArgPos + collectArgCount;
        int keep1InSlot = newType.parameterSlotDepth(collectArgPos);
        int collectSlot = newType.parameterSlotDepth(keep2InPos);
        int slotCount = keep1InSlot - collectSlot;
        assert (slotCount >= collectArgCount);
        assert (collectSlot == targetType.parameterSlotDepth(collectArgPos + collectValCount + (retainOriginalArgs ? collectArgCount : 0)));
        byte dest = AdapterMethodHandle.basicType(collectValType);
        int src = 14;
        for (int i = 0; i < collectArgCount; ++i) {
            int src2 = AdapterMethodHandle.basicType(collectorType.parameterType(i));
            if (src == 14) {
                src = src2;
            } else if (src != src2) {
                src = 14;
            }
            if (src == 14) break;
        }
        int stackMove = collectValSlots;
        if (!retainOriginalArgs) {
            stackMove -= slotCount;
        }
        int lastCollectArg = keep2InPos - 1;
        long conv = AdapterMethodHandle.makeSpreadConv(retainOriginalArgs ? 12 : 10, lastCollectArg, src, dest, stackMove);
        AdapterMethodHandle res = new AdapterMethodHandle(target, newType, conv, collector);
        assert (res.type().parameterList().subList(collectArgPos, collectArgPos + collectArgCount).equals(collector.type().parameterList()));
        return res;
    }

    @Override
    String debugString() {
        return MethodHandleStatics.getNameString(AdapterMethodHandle.nonAdapter((MethodHandle)this.vmtarget), this);
    }

    private static MethodHandle nonAdapter(MethodHandle mh) {
        while (mh instanceof AdapterMethodHandle) {
            mh = (MethodHandle)mh.vmtarget;
        }
        return mh;
    }

    static class AsVarargsCollector
    extends AdapterMethodHandle {
        final MethodHandle target;
        final Class<?> arrayType;
        MethodHandle cache;

        AsVarargsCollector(MethodHandle target, Class<?> arrayType) {
            super(target, target.type(), AsVarargsCollector.makeConv(0));
            this.target = target;
            this.arrayType = arrayType;
            this.cache = target.asCollector(arrayType, 0);
        }

        @Override
        public boolean isVarargsCollector() {
            return true;
        }

        @Override
        public MethodHandle asFixedArity() {
            return this.target;
        }

        @Override
        public MethodHandle asType(MethodType newType) {
            MethodHandle collector;
            MethodType type = this.type();
            int collectArg = type.parameterCount() - 1;
            int newArity = newType.parameterCount();
            if (newArity == collectArg + 1 && type.parameterType(collectArg).isAssignableFrom(newType.parameterType(collectArg))) {
                return super.asType(newType);
            }
            if (this.cache.type().parameterCount() == newArity) {
                return this.cache.asType(newType);
            }
            int arrayLength = newArity - collectArg;
            try {
                collector = this.target.asCollector(this.arrayType, arrayLength);
            }
            catch (IllegalArgumentException ex) {
                throw new WrongMethodTypeException("cannot build collector");
            }
            this.cache = collector;
            return collector.asType(newType);
        }
    }
}

