/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.InputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.ref.SoftReference;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.URL;
import java.security.AccessController;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import sun.misc.Unsafe;
import sun.reflect.ConstantPool;
import sun.reflect.Reflection;
import sun.reflect.ReflectionFactory;
import sun.reflect.annotation.AnnotationParser;
import sun.reflect.annotation.AnnotationType;
import sun.reflect.generics.factory.CoreReflectionFactory;
import sun.reflect.generics.factory.GenericsFactory;
import sun.reflect.generics.repository.ClassRepository;
import sun.reflect.generics.repository.ConstructorRepository;
import sun.reflect.generics.repository.MethodRepository;
import sun.reflect.generics.scope.ClassScope;
import sun.security.util.SecurityConstants;

public final class Class<T>
implements Serializable,
GenericDeclaration,
Type,
AnnotatedElement {
    private static final int ANNOTATION = 8192;
    private static final int ENUM = 16384;
    private static final int SYNTHETIC = 4096;
    private volatile transient Constructor<T> cachedConstructor;
    private volatile transient Class<?> newInstanceCallerCache;
    private transient String name;
    private static ProtectionDomain allPermDomain;
    private static boolean useCaches;
    private volatile transient SoftReference<Field[]> declaredFields;
    private volatile transient SoftReference<Field[]> publicFields;
    private volatile transient SoftReference<Method[]> declaredMethods;
    private volatile transient SoftReference<Method[]> publicMethods;
    private volatile transient SoftReference<Constructor<T>[]> declaredConstructors;
    private volatile transient SoftReference<Constructor<T>[]> publicConstructors;
    private volatile transient SoftReference<Field[]> declaredPublicFields;
    private volatile transient SoftReference<Method[]> declaredPublicMethods;
    private volatile transient int classRedefinedCount = 0;
    private volatile transient int lastRedefinedCount = 0;
    private transient ClassRepository genericInfo;
    private static final long serialVersionUID = 3206093459760846163L;
    private static final ObjectStreamField[] serialPersistentFields;
    private static ReflectionFactory reflectionFactory;
    private static boolean initted;
    private volatile transient T[] enumConstants = null;
    private volatile transient Map<String, T> enumConstantDirectory = null;
    private transient Map<Class<? extends Annotation>, Annotation> annotations;
    private transient Map<Class<? extends Annotation>, Annotation> declaredAnnotations;
    private AnnotationType annotationType;
    transient ClassValue.ClassValueMap classValueMap;

    private static native void registerNatives();

    private Class() {
    }

    public String toString() {
        return (this.isInterface() ? "interface " : (this.isPrimitive() ? "" : "class ")) + this.getName();
    }

    public static Class<?> forName(String className) throws ClassNotFoundException {
        return Class.forName0(className, true, ClassLoader.getCallerClassLoader());
    }

    public static Class<?> forName(String name, boolean initialize, ClassLoader loader) throws ClassNotFoundException {
        ClassLoader ccl;
        SecurityManager sm;
        if (loader == null && (sm = System.getSecurityManager()) != null && (ccl = ClassLoader.getCallerClassLoader()) != null) {
            sm.checkPermission(SecurityConstants.GET_CLASSLOADER_PERMISSION);
        }
        return Class.forName0(name, initialize, loader);
    }

    private static native Class<?> forName0(String var0, boolean var1, ClassLoader var2) throws ClassNotFoundException;

    public T newInstance() throws InstantiationException, IllegalAccessException {
        if (System.getSecurityManager() != null) {
            this.checkMemberAccess(0, ClassLoader.getCallerClassLoader());
        }
        return this.newInstance0();
    }

    private T newInstance0() throws InstantiationException, IllegalAccessException {
        Class caller;
        Constructor<T> tmpConstructor;
        int modifiers;
        if (this.cachedConstructor == null) {
            if (this == Class.class) {
                throw new IllegalAccessException("Can not call newInstance() on the Class for java.lang.Class");
            }
            try {
                Class[] empty = new Class[]{};
                final Constructor<T> c = this.getConstructor0(empty, 1);
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        c.setAccessible(true);
                        return null;
                    }
                });
                this.cachedConstructor = c;
            }
            catch (NoSuchMethodException e) {
                throw new InstantiationException(this.getName());
            }
        }
        if (!Reflection.quickCheckMemberAccess(this, modifiers = (tmpConstructor = this.cachedConstructor).getModifiers()) && this.newInstanceCallerCache != (caller = Reflection.getCallerClass(3))) {
            Reflection.ensureMemberAccess(caller, this, null, modifiers);
            this.newInstanceCallerCache = caller;
        }
        try {
            return tmpConstructor.newInstance(null);
        }
        catch (InvocationTargetException e) {
            Unsafe.getUnsafe().throwException(e.getTargetException());
            return null;
        }
    }

    public native boolean isInstance(Object var1);

    public native boolean isAssignableFrom(Class<?> var1);

    public native boolean isInterface();

    public native boolean isArray();

    public native boolean isPrimitive();

    public boolean isAnnotation() {
        return (this.getModifiers() & 0x2000) != 0;
    }

    public boolean isSynthetic() {
        return (this.getModifiers() & 0x1000) != 0;
    }

    public String getName() {
        String name = this.name;
        if (name == null) {
            this.name = name = this.getName0();
        }
        return name;
    }

    private native String getName0();

    public ClassLoader getClassLoader() {
        ClassLoader ccl;
        ClassLoader cl = this.getClassLoader0();
        if (cl == null) {
            return null;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && (ccl = ClassLoader.getCallerClassLoader()) != null && ccl != cl && !cl.isAncestor(ccl)) {
            sm.checkPermission(SecurityConstants.GET_CLASSLOADER_PERMISSION);
        }
        return cl;
    }

    native ClassLoader getClassLoader0();

    public TypeVariable<Class<T>>[] getTypeParameters() {
        if (this.getGenericSignature() != null) {
            return this.getGenericInfo().getTypeParameters();
        }
        return new TypeVariable[0];
    }

    public native Class<? super T> getSuperclass();

    public Type getGenericSuperclass() {
        if (this.getGenericSignature() != null) {
            if (this.isInterface()) {
                return null;
            }
            return this.getGenericInfo().getSuperclass();
        }
        return this.getSuperclass();
    }

    public Package getPackage() {
        return Package.getPackage(this);
    }

    public native Class<?>[] getInterfaces();

    public Type[] getGenericInterfaces() {
        if (this.getGenericSignature() != null) {
            return this.getGenericInfo().getSuperInterfaces();
        }
        return this.getInterfaces();
    }

    public native Class<?> getComponentType();

    public native int getModifiers();

    public native Object[] getSigners();

    native void setSigners(Object[] var1);

    public Method getEnclosingMethod() {
        EnclosingMethodInfo enclosingInfo = this.getEnclosingMethodInfo();
        if (enclosingInfo == null) {
            return null;
        }
        if (!enclosingInfo.isMethod()) {
            return null;
        }
        MethodRepository typeInfo = MethodRepository.make(enclosingInfo.getDescriptor(), this.getFactory());
        Class<?> returnType = Class.toClass(typeInfo.getReturnType());
        Type[] parameterTypes = typeInfo.getParameterTypes();
        Class[] parameterClasses = new Class[parameterTypes.length];
        for (int i = 0; i < parameterClasses.length; ++i) {
            parameterClasses[i] = Class.toClass(parameterTypes[i]);
        }
        for (Method m : enclosingInfo.getEnclosingClass().getDeclaredMethods()) {
            Class<?>[] candidateParamClasses;
            if (!m.getName().equals(enclosingInfo.getName()) || (candidateParamClasses = m.getParameterTypes()).length != parameterClasses.length) continue;
            boolean matches = true;
            for (int i = 0; i < candidateParamClasses.length; ++i) {
                if (candidateParamClasses[i].equals(parameterClasses[i])) continue;
                matches = false;
                break;
            }
            if (!matches || !m.getReturnType().equals(returnType)) continue;
            return m;
        }
        throw new InternalError("Enclosing method not found");
    }

    private native Object[] getEnclosingMethod0();

    private EnclosingMethodInfo getEnclosingMethodInfo() {
        Object[] enclosingInfo = this.getEnclosingMethod0();
        if (enclosingInfo == null) {
            return null;
        }
        return new EnclosingMethodInfo(enclosingInfo);
    }

    private static Class<?> toClass(Type o) {
        if (o instanceof GenericArrayType) {
            return Array.newInstance(Class.toClass(((GenericArrayType)o).getGenericComponentType()), 0).getClass();
        }
        return (Class)o;
    }

    public Constructor<?> getEnclosingConstructor() {
        EnclosingMethodInfo enclosingInfo = this.getEnclosingMethodInfo();
        if (enclosingInfo == null) {
            return null;
        }
        if (!enclosingInfo.isConstructor()) {
            return null;
        }
        ConstructorRepository typeInfo = ConstructorRepository.make(enclosingInfo.getDescriptor(), this.getFactory());
        Type[] parameterTypes = typeInfo.getParameterTypes();
        Class[] parameterClasses = new Class[parameterTypes.length];
        for (int i = 0; i < parameterClasses.length; ++i) {
            parameterClasses[i] = Class.toClass(parameterTypes[i]);
        }
        for (Constructor<?> c : enclosingInfo.getEnclosingClass().getDeclaredConstructors()) {
            Class<?>[] candidateParamClasses = c.getParameterTypes();
            if (candidateParamClasses.length != parameterClasses.length) continue;
            boolean matches = true;
            for (int i = 0; i < candidateParamClasses.length; ++i) {
                if (candidateParamClasses[i].equals(parameterClasses[i])) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            return c;
        }
        throw new InternalError("Enclosing constructor not found");
    }

    public native Class<?> getDeclaringClass();

    public Class<?> getEnclosingClass() {
        EnclosingMethodInfo enclosingInfo = this.getEnclosingMethodInfo();
        if (enclosingInfo == null) {
            return this.getDeclaringClass();
        }
        Class<?> enclosingClass = enclosingInfo.getEnclosingClass();
        if (enclosingClass == this || enclosingClass == null) {
            throw new InternalError("Malformed enclosing method information");
        }
        return enclosingClass;
    }

    public String getSimpleName() {
        int index;
        if (this.isArray()) {
            return this.getComponentType().getSimpleName() + "[]";
        }
        String simpleName = this.getSimpleBinaryName();
        if (simpleName == null) {
            simpleName = this.getName();
            return simpleName.substring(simpleName.lastIndexOf(".") + 1);
        }
        int length = simpleName.length();
        if (length < 1 || simpleName.charAt(0) != '$') {
            throw new InternalError("Malformed class name");
        }
        for (index = 1; index < length && Class.isAsciiDigit(simpleName.charAt(index)); ++index) {
        }
        return simpleName.substring(index);
    }

    private static boolean isAsciiDigit(char c) {
        return '0' <= c && c <= '9';
    }

    public String getCanonicalName() {
        if (this.isArray()) {
            String canonicalName = this.getComponentType().getCanonicalName();
            if (canonicalName != null) {
                return canonicalName + "[]";
            }
            return null;
        }
        if (this.isLocalOrAnonymousClass()) {
            return null;
        }
        Class<?> enclosingClass = this.getEnclosingClass();
        if (enclosingClass == null) {
            return this.getName();
        }
        String enclosingName = enclosingClass.getCanonicalName();
        if (enclosingName == null) {
            return null;
        }
        return enclosingName + "." + this.getSimpleName();
    }

    public boolean isAnonymousClass() {
        return "".equals(this.getSimpleName());
    }

    public boolean isLocalClass() {
        return this.isLocalOrAnonymousClass() && !this.isAnonymousClass();
    }

    public boolean isMemberClass() {
        return this.getSimpleBinaryName() != null && !this.isLocalOrAnonymousClass();
    }

    private String getSimpleBinaryName() {
        Class<?> enclosingClass = this.getEnclosingClass();
        if (enclosingClass == null) {
            return null;
        }
        try {
            return this.getName().substring(enclosingClass.getName().length());
        }
        catch (IndexOutOfBoundsException ex) {
            throw new InternalError("Malformed class name");
        }
    }

    private boolean isLocalOrAnonymousClass() {
        return this.getEnclosingMethodInfo() != null;
    }

    public Class<?>[] getClasses() {
        this.checkMemberAccess(0, ClassLoader.getCallerClassLoader());
        return AccessController.doPrivileged(new PrivilegedAction<Class<?>[]>(){

            @Override
            public Class[] run() {
                ArrayList list = new ArrayList();
                for (Class currentClass = Class.this; currentClass != null; currentClass = currentClass.getSuperclass()) {
                    Class<?>[] members = currentClass.getDeclaredClasses();
                    for (int i = 0; i < members.length; ++i) {
                        if (!Modifier.isPublic(members[i].getModifiers())) continue;
                        list.add(members[i]);
                    }
                }
                return list.toArray(new Class[0]);
            }
        });
    }

    public Field[] getFields() throws SecurityException {
        this.checkMemberAccess(0, ClassLoader.getCallerClassLoader());
        return Class.copyFields(this.privateGetPublicFields(null));
    }

    public Method[] getMethods() throws SecurityException {
        this.checkMemberAccess(0, ClassLoader.getCallerClassLoader());
        return Class.copyMethods(this.privateGetPublicMethods());
    }

    public Constructor<?>[] getConstructors() throws SecurityException {
        this.checkMemberAccess(0, ClassLoader.getCallerClassLoader());
        return Class.copyConstructors(this.privateGetDeclaredConstructors(true));
    }

    public Field getField(String name) throws NoSuchFieldException, SecurityException {
        this.checkMemberAccess(0, ClassLoader.getCallerClassLoader());
        Field field = this.getField0(name);
        if (field == null) {
            throw new NoSuchFieldException(name);
        }
        return field;
    }

    public Method getMethod(String name, Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        this.checkMemberAccess(0, ClassLoader.getCallerClassLoader());
        Method method = this.getMethod0(name, parameterTypes);
        if (method == null) {
            throw new NoSuchMethodException(this.getName() + "." + name + Class.argumentTypesToString(parameterTypes));
        }
        return method;
    }

    public Constructor<T> getConstructor(Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        this.checkMemberAccess(0, ClassLoader.getCallerClassLoader());
        return this.getConstructor0(parameterTypes, 0);
    }

    public Class<?>[] getDeclaredClasses() throws SecurityException {
        this.checkMemberAccess(1, ClassLoader.getCallerClassLoader());
        return this.getDeclaredClasses0();
    }

    public Field[] getDeclaredFields() throws SecurityException {
        this.checkMemberAccess(1, ClassLoader.getCallerClassLoader());
        return Class.copyFields(this.privateGetDeclaredFields(false));
    }

    public Method[] getDeclaredMethods() throws SecurityException {
        this.checkMemberAccess(1, ClassLoader.getCallerClassLoader());
        return Class.copyMethods(this.privateGetDeclaredMethods(false));
    }

    public Constructor<?>[] getDeclaredConstructors() throws SecurityException {
        this.checkMemberAccess(1, ClassLoader.getCallerClassLoader());
        return Class.copyConstructors(this.privateGetDeclaredConstructors(false));
    }

    public Field getDeclaredField(String name) throws NoSuchFieldException, SecurityException {
        this.checkMemberAccess(1, ClassLoader.getCallerClassLoader());
        Field field = this.searchFields(this.privateGetDeclaredFields(false), name);
        if (field == null) {
            throw new NoSuchFieldException(name);
        }
        return field;
    }

    public Method getDeclaredMethod(String name, Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        this.checkMemberAccess(1, ClassLoader.getCallerClassLoader());
        Method method = Class.searchMethods(this.privateGetDeclaredMethods(false), name, parameterTypes);
        if (method == null) {
            throw new NoSuchMethodException(this.getName() + "." + name + Class.argumentTypesToString(parameterTypes));
        }
        return method;
    }

    public Constructor<T> getDeclaredConstructor(Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        this.checkMemberAccess(1, ClassLoader.getCallerClassLoader());
        return this.getConstructor0(parameterTypes, 1);
    }

    public InputStream getResourceAsStream(String name) {
        name = this.resolveName(name);
        ClassLoader cl = this.getClassLoader0();
        if (cl == null) {
            return ClassLoader.getSystemResourceAsStream(name);
        }
        return cl.getResourceAsStream(name);
    }

    public URL getResource(String name) {
        name = this.resolveName(name);
        ClassLoader cl = this.getClassLoader0();
        if (cl == null) {
            return ClassLoader.getSystemResource(name);
        }
        return cl.getResource(name);
    }

    public ProtectionDomain getProtectionDomain() {
        ProtectionDomain pd;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SecurityConstants.GET_PD_PERMISSION);
        }
        if ((pd = this.getProtectionDomain0()) == null) {
            if (allPermDomain == null) {
                Permissions perms = new Permissions();
                perms.add(SecurityConstants.ALL_PERMISSION);
                allPermDomain = new ProtectionDomain(null, perms);
            }
            pd = allPermDomain;
        }
        return pd;
    }

    private native ProtectionDomain getProtectionDomain0();

    native void setProtectionDomain0(ProtectionDomain var1);

    static native Class getPrimitiveClass(String var0);

    private void checkMemberAccess(int which, ClassLoader ccl) {
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            String name;
            int i;
            s.checkMemberAccess(this, which);
            ClassLoader cl = this.getClassLoader0();
            if (!(ccl == null || ccl == cl || cl != null && cl.isAncestor(ccl) || (i = (name = this.getName()).lastIndexOf(46)) == -1)) {
                s.checkPackageAccess(name.substring(0, i));
            }
        }
    }

    private String resolveName(String name) {
        if (name == null) {
            return name;
        }
        if (!name.startsWith("/")) {
            Class<?> c = this;
            while (c.isArray()) {
                c = c.getComponentType();
            }
            String baseName = c.getName();
            int index = baseName.lastIndexOf(46);
            if (index != -1) {
                name = baseName.substring(0, index).replace('.', '/') + "/" + name;
            }
        } else {
            name = name.substring(1);
        }
        return name;
    }

    private void clearCachesOnClassRedefinition() {
        if (this.lastRedefinedCount != this.classRedefinedCount) {
            this.declaredPublicFields = null;
            this.publicFields = null;
            this.declaredFields = null;
            this.declaredPublicMethods = null;
            this.publicMethods = null;
            this.declaredMethods = null;
            this.publicConstructors = null;
            this.declaredConstructors = null;
            this.declaredAnnotations = null;
            this.annotations = null;
            this.lastRedefinedCount = this.classRedefinedCount;
        }
    }

    private native String getGenericSignature();

    private GenericsFactory getFactory() {
        return CoreReflectionFactory.make(this, ClassScope.make(this));
    }

    private ClassRepository getGenericInfo() {
        if (this.genericInfo == null) {
            this.genericInfo = ClassRepository.make(this.getGenericSignature(), this.getFactory());
        }
        return this.genericInfo;
    }

    private native byte[] getRawAnnotations();

    native ConstantPool getConstantPool();

    private Field[] privateGetDeclaredFields(boolean publicOnly) {
        Class.checkInitted();
        Field[] res = null;
        if (useCaches) {
            this.clearCachesOnClassRedefinition();
            if (publicOnly) {
                if (this.declaredPublicFields != null) {
                    res = this.declaredPublicFields.get();
                }
            } else if (this.declaredFields != null) {
                res = this.declaredFields.get();
            }
            if (res != null) {
                return res;
            }
        }
        res = Reflection.filterFields(this, this.getDeclaredFields0(publicOnly));
        if (useCaches) {
            if (publicOnly) {
                this.declaredPublicFields = new SoftReference<Field[]>(res);
            } else {
                this.declaredFields = new SoftReference<Field[]>(res);
            }
        }
        return res;
    }

    private Field[] privateGetPublicFields(Set<Class<?>> traversedInterfaces) {
        Class<T> c;
        Class.checkInitted();
        Field[] res = null;
        if (useCaches) {
            this.clearCachesOnClassRedefinition();
            if (this.publicFields != null) {
                res = this.publicFields.get();
            }
            if (res != null) {
                return res;
            }
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        if (traversedInterfaces == null) {
            traversedInterfaces = new HashSet();
        }
        Field[] tmp = this.privateGetDeclaredFields(true);
        Class.addAll(fields, tmp);
        for (Class<?> c2 : this.getInterfaces()) {
            if (traversedInterfaces.contains(c2)) continue;
            traversedInterfaces.add(c2);
            Class.addAll(fields, super.privateGetPublicFields(traversedInterfaces));
        }
        if (!this.isInterface() && (c = this.getSuperclass()) != null) {
            Class.addAll(fields, super.privateGetPublicFields(traversedInterfaces));
        }
        res = new Field[fields.size()];
        fields.toArray(res);
        if (useCaches) {
            this.publicFields = new SoftReference<Field[]>(res);
        }
        return res;
    }

    private static void addAll(Collection<Field> c, Field[] o) {
        for (int i = 0; i < o.length; ++i) {
            c.add(o[i]);
        }
    }

    private Constructor<T>[] privateGetDeclaredConstructors(boolean publicOnly) {
        Class.checkInitted();
        Constructor[] res = null;
        if (useCaches) {
            this.clearCachesOnClassRedefinition();
            if (publicOnly) {
                if (this.publicConstructors != null) {
                    res = this.publicConstructors.get();
                }
            } else if (this.declaredConstructors != null) {
                res = this.declaredConstructors.get();
            }
            if (res != null) {
                return res;
            }
        }
        res = this.isInterface() ? new Constructor[]{} : this.getDeclaredConstructors0(publicOnly);
        if (useCaches) {
            if (publicOnly) {
                this.publicConstructors = new SoftReference<Constructor[]>(res);
            } else {
                this.declaredConstructors = new SoftReference<Constructor[]>(res);
            }
        }
        return res;
    }

    private Method[] privateGetDeclaredMethods(boolean publicOnly) {
        Class.checkInitted();
        Method[] res = null;
        if (useCaches) {
            this.clearCachesOnClassRedefinition();
            if (publicOnly) {
                if (this.declaredPublicMethods != null) {
                    res = this.declaredPublicMethods.get();
                }
            } else if (this.declaredMethods != null) {
                res = this.declaredMethods.get();
            }
            if (res != null) {
                return res;
            }
        }
        res = Reflection.filterMethods(this, this.getDeclaredMethods0(publicOnly));
        if (useCaches) {
            if (publicOnly) {
                this.declaredPublicMethods = new SoftReference<Method[]>(res);
            } else {
                this.declaredMethods = new SoftReference<Method[]>(res);
            }
        }
        return res;
    }

    private Method[] privateGetPublicMethods() {
        Class<T> c;
        int i;
        Class.checkInitted();
        Method[] res = null;
        if (useCaches) {
            this.clearCachesOnClassRedefinition();
            if (this.publicMethods != null) {
                res = this.publicMethods.get();
            }
            if (res != null) {
                return res;
            }
        }
        MethodArray methods = new MethodArray();
        Method[] tmp = this.privateGetDeclaredMethods(true);
        methods.addAll(tmp);
        MethodArray inheritedMethods = new MethodArray();
        Class<?>[] interfaces = this.getInterfaces();
        for (i = 0; i < interfaces.length; ++i) {
            inheritedMethods.addAll(super.privateGetPublicMethods());
        }
        if (!this.isInterface() && (c = this.getSuperclass()) != null) {
            MethodArray supers = new MethodArray();
            supers.addAll(super.privateGetPublicMethods());
            for (int i2 = 0; i2 < supers.length(); ++i2) {
                Method m = supers.get(i2);
                if (m == null || Modifier.isAbstract(m.getModifiers())) continue;
                inheritedMethods.removeByNameAndSignature(m);
            }
            supers.addAll(inheritedMethods);
            inheritedMethods = supers;
        }
        for (i = 0; i < methods.length(); ++i) {
            Method m = methods.get(i);
            inheritedMethods.removeByNameAndSignature(m);
        }
        methods.addAllIfNotPresent(inheritedMethods);
        methods.compactAndTrim();
        res = methods.getArray();
        if (useCaches) {
            this.publicMethods = new SoftReference<Method[]>(res);
        }
        return res;
    }

    private Field searchFields(Field[] fields, String name) {
        String internedName = name.intern();
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i].getName() != internedName) continue;
            return Class.getReflectionFactory().copyField(fields[i]);
        }
        return null;
    }

    private Field getField0(String name) throws NoSuchFieldException {
        Class<T> c;
        Field res = null;
        res = this.searchFields(this.privateGetDeclaredFields(true), name);
        if (res != null) {
            return res;
        }
        Class<?>[] interfaces = this.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> c2 = interfaces[i];
            res = super.getField0(name);
            if (res == null) continue;
            return res;
        }
        if (!this.isInterface() && (c = this.getSuperclass()) != null && (res = super.getField0(name)) != null) {
            return res;
        }
        return null;
    }

    private static Method searchMethods(Method[] methods, String name, Class<?>[] parameterTypes) {
        Method res = null;
        String internedName = name.intern();
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            if (m.getName() != internedName || !Class.arrayContentsEq(parameterTypes, m.getParameterTypes()) || res != null && !res.getReturnType().isAssignableFrom(m.getReturnType())) continue;
            res = m;
        }
        return res == null ? res : Class.getReflectionFactory().copyMethod(res);
    }

    private Method getMethod0(String name, Class<?>[] parameterTypes) {
        Class<T> c;
        Method res = null;
        res = Class.searchMethods(this.privateGetDeclaredMethods(true), name, parameterTypes);
        if (res != null) {
            return res;
        }
        if (!this.isInterface() && (c = this.getSuperclass()) != null && (res = super.getMethod0(name, parameterTypes)) != null) {
            return res;
        }
        Class<?>[] interfaces = this.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> c2 = interfaces[i];
            res = super.getMethod0(name, parameterTypes);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    private Constructor<T> getConstructor0(Class<?>[] parameterTypes, int which) throws NoSuchMethodException {
        Constructor<T>[] constructors;
        for (Constructor<T> constructor : constructors = this.privateGetDeclaredConstructors(which == 0)) {
            if (!Class.arrayContentsEq(parameterTypes, constructor.getParameterTypes())) continue;
            return Class.getReflectionFactory().copyConstructor(constructor);
        }
        throw new NoSuchMethodException(this.getName() + ".<init>" + Class.argumentTypesToString(parameterTypes));
    }

    private static boolean arrayContentsEq(Object[] a1, Object[] a2) {
        if (a1 == null) {
            return a2 == null || a2.length == 0;
        }
        if (a2 == null) {
            return a1.length == 0;
        }
        if (a1.length != a2.length) {
            return false;
        }
        for (int i = 0; i < a1.length; ++i) {
            if (a1[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    private static Field[] copyFields(Field[] arg) {
        Field[] out = new Field[arg.length];
        ReflectionFactory fact = Class.getReflectionFactory();
        for (int i = 0; i < arg.length; ++i) {
            out[i] = fact.copyField(arg[i]);
        }
        return out;
    }

    private static Method[] copyMethods(Method[] arg) {
        Method[] out = new Method[arg.length];
        ReflectionFactory fact = Class.getReflectionFactory();
        for (int i = 0; i < arg.length; ++i) {
            out[i] = fact.copyMethod(arg[i]);
        }
        return out;
    }

    private static <U> Constructor<U>[] copyConstructors(Constructor<U>[] arg) {
        Constructor[] out = (Constructor[])arg.clone();
        ReflectionFactory fact = Class.getReflectionFactory();
        for (int i = 0; i < out.length; ++i) {
            out[i] = fact.copyConstructor(out[i]);
        }
        return out;
    }

    private native Field[] getDeclaredFields0(boolean var1);

    private native Method[] getDeclaredMethods0(boolean var1);

    private native Constructor<T>[] getDeclaredConstructors0(boolean var1);

    private native Class<?>[] getDeclaredClasses0();

    private static String argumentTypesToString(Class<?>[] argTypes) {
        StringBuilder buf = new StringBuilder();
        buf.append("(");
        if (argTypes != null) {
            for (int i = 0; i < argTypes.length; ++i) {
                Class<?> c;
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append((c = argTypes[i]) == null ? "null" : c.getName());
            }
        }
        buf.append(")");
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean desiredAssertionStatus() {
        ClassLoader loader = this.getClassLoader();
        if (loader == null) {
            return Class.desiredAssertionStatus0(this);
        }
        Object object = loader.assertionLock;
        synchronized (object) {
            if (loader.classAssertionStatus != null) {
                return loader.desiredAssertionStatus(this.getName());
            }
        }
        return Class.desiredAssertionStatus0(this);
    }

    private static native boolean desiredAssertionStatus0(Class<?> var0);

    public boolean isEnum() {
        return (this.getModifiers() & 0x4000) != 0 && this.getSuperclass() == Enum.class;
    }

    private static ReflectionFactory getReflectionFactory() {
        if (reflectionFactory == null) {
            reflectionFactory = AccessController.doPrivileged(new ReflectionFactory.GetReflectionFactoryAction());
        }
        return reflectionFactory;
    }

    private static void checkInitted() {
        if (initted) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                if (System.out == null) {
                    return null;
                }
                String val = System.getProperty("sun.reflect.noCaches");
                if (val != null && val.equals("true")) {
                    useCaches = false;
                }
                initted = true;
                return null;
            }
        });
    }

    public T[] getEnumConstants() {
        T[] values = this.getEnumConstantsShared();
        return values != null ? (Object[])values.clone() : null;
    }

    T[] getEnumConstantsShared() {
        if (this.enumConstants == null) {
            if (!this.isEnum()) {
                return null;
            }
            try {
                final Method values = this.getMethod("values", new Class[0]);
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        values.setAccessible(true);
                        return null;
                    }
                });
                this.enumConstants = (Object[])values.invoke(null, new Object[0]);
            }
            catch (InvocationTargetException ex) {
                return null;
            }
            catch (NoSuchMethodException ex) {
                return null;
            }
            catch (IllegalAccessException ex) {
                return null;
            }
        }
        return this.enumConstants;
    }

    Map<String, T> enumConstantDirectory() {
        if (this.enumConstantDirectory == null) {
            T[] universe = this.getEnumConstantsShared();
            if (universe == null) {
                throw new IllegalArgumentException(this.getName() + " is not an enum type");
            }
            HashMap<String, T> m = new HashMap<String, T>(2 * universe.length);
            for (T constant : universe) {
                m.put(((Enum)constant).name(), constant);
            }
            this.enumConstantDirectory = m;
        }
        return this.enumConstantDirectory;
    }

    public T cast(Object obj) {
        if (obj != null && !this.isInstance(obj)) {
            throw new ClassCastException(this.cannotCastMsg(obj));
        }
        return (T)obj;
    }

    private String cannotCastMsg(Object obj) {
        return "Cannot cast " + obj.getClass().getName() + " to " + this.getName();
    }

    public <U> Class<? extends U> asSubclass(Class<U> clazz) {
        if (clazz.isAssignableFrom(this)) {
            return this;
        }
        throw new ClassCastException(this.toString());
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        if (annotationClass == null) {
            throw new NullPointerException();
        }
        this.initAnnotationsIfNecessary();
        return (A)this.annotations.get(annotationClass);
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        if (annotationClass == null) {
            throw new NullPointerException();
        }
        return this.getAnnotation((Class)annotationClass) != null;
    }

    @Override
    public Annotation[] getAnnotations() {
        this.initAnnotationsIfNecessary();
        return AnnotationParser.toArray(this.annotations);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        this.initAnnotationsIfNecessary();
        return AnnotationParser.toArray(this.declaredAnnotations);
    }

    private synchronized void initAnnotationsIfNecessary() {
        this.clearCachesOnClassRedefinition();
        if (this.annotations != null) {
            return;
        }
        this.declaredAnnotations = AnnotationParser.parseAnnotations(this.getRawAnnotations(), this.getConstantPool(), this);
        Class<T> superClass = this.getSuperclass();
        if (superClass == null) {
            this.annotations = this.declaredAnnotations;
        } else {
            this.annotations = new HashMap<Class<? extends Annotation>, Annotation>();
            super.initAnnotationsIfNecessary();
            for (Map.Entry<Class<? extends Annotation>, Annotation> e : superClass.annotations.entrySet()) {
                Class<? extends Annotation> annotationClass = e.getKey();
                if (!AnnotationType.getInstance(annotationClass).isInherited()) continue;
                this.annotations.put(annotationClass, e.getValue());
            }
            this.annotations.putAll(this.declaredAnnotations);
        }
    }

    void setAnnotationType(AnnotationType type) {
        this.annotationType = type;
    }

    AnnotationType getAnnotationType() {
        return this.annotationType;
    }

    static {
        Class.registerNatives();
        useCaches = true;
        serialPersistentFields = new ObjectStreamField[0];
        initted = false;
    }

    static class MethodArray {
        private Method[] methods = new Method[20];
        private int length = 0;

        MethodArray() {
        }

        void add(Method m) {
            if (this.length == this.methods.length) {
                this.methods = Arrays.copyOf(this.methods, 2 * this.methods.length);
            }
            this.methods[this.length++] = m;
        }

        void addAll(Method[] ma) {
            for (int i = 0; i < ma.length; ++i) {
                this.add(ma[i]);
            }
        }

        void addAll(MethodArray ma) {
            for (int i = 0; i < ma.length(); ++i) {
                this.add(ma.get(i));
            }
        }

        void addIfNotPresent(Method newMethod) {
            for (int i = 0; i < this.length; ++i) {
                Method m = this.methods[i];
                if (m != newMethod && (m == null || !m.equals(newMethod))) continue;
                return;
            }
            this.add(newMethod);
        }

        void addAllIfNotPresent(MethodArray newMethods) {
            for (int i = 0; i < newMethods.length(); ++i) {
                Method m = newMethods.get(i);
                if (m == null) continue;
                this.addIfNotPresent(m);
            }
        }

        int length() {
            return this.length;
        }

        Method get(int i) {
            return this.methods[i];
        }

        void removeByNameAndSignature(Method toRemove) {
            for (int i = 0; i < this.length; ++i) {
                Method m = this.methods[i];
                if (m == null || m.getReturnType() != toRemove.getReturnType() || m.getName() != toRemove.getName() || !Class.arrayContentsEq(m.getParameterTypes(), toRemove.getParameterTypes())) continue;
                this.methods[i] = null;
            }
        }

        void compactAndTrim() {
            int newPos = 0;
            for (int pos = 0; pos < this.length; ++pos) {
                Method m = this.methods[pos];
                if (m == null) continue;
                if (pos != newPos) {
                    this.methods[newPos] = m;
                }
                ++newPos;
            }
            if (newPos != this.methods.length) {
                this.methods = Arrays.copyOf(this.methods, newPos);
            }
        }

        Method[] getArray() {
            return this.methods;
        }
    }

    private static final class EnclosingMethodInfo {
        private Class<?> enclosingClass;
        private String name;
        private String descriptor;

        private EnclosingMethodInfo(Object[] enclosingInfo) {
            if (enclosingInfo.length != 3) {
                throw new InternalError("Malformed enclosing method information");
            }
            try {
                this.enclosingClass = (Class)enclosingInfo[0];
                assert (this.enclosingClass != null);
                this.name = (String)enclosingInfo[1];
                this.descriptor = (String)enclosingInfo[2];
                assert (this.name != null && this.descriptor != null || this.name == this.descriptor);
            }
            catch (ClassCastException cce) {
                throw new InternalError("Invalid type in enclosing method information");
            }
        }

        boolean isPartial() {
            return this.enclosingClass == null || this.name == null || this.descriptor == null;
        }

        boolean isConstructor() {
            return !this.isPartial() && "<init>".equals(this.name);
        }

        boolean isMethod() {
            return !this.isPartial() && !this.isConstructor() && !"<clinit>".equals(this.name);
        }

        Class<?> getEnclosingClass() {
            return this.enclosingClass;
        }

        String getName() {
            return this.name;
        }

        String getDescriptor() {
            return this.descriptor;
        }
    }
}

