/*
 * Decompiled with CFR 0.152.
 */
package java.awt.event;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;

public class InvocationEvent
extends AWTEvent
implements ActiveEvent {
    public static final int INVOCATION_FIRST = 1200;
    public static final int INVOCATION_DEFAULT = 1200;
    public static final int INVOCATION_LAST = 1200;
    protected Runnable runnable;
    protected Object notifier;
    private volatile boolean dispatched = false;
    protected boolean catchExceptions;
    private Exception exception = null;
    private Throwable throwable = null;
    private long when;
    private static final long serialVersionUID = 436056344909459450L;

    public InvocationEvent(Object source, Runnable runnable) {
        this(source, runnable, null, false);
    }

    public InvocationEvent(Object source, Runnable runnable, Object notifier, boolean catchThrowables) {
        this(source, 1200, runnable, notifier, catchThrowables);
    }

    protected InvocationEvent(Object source, int id, Runnable runnable, Object notifier, boolean catchThrowables) {
        super(source, id);
        this.runnable = runnable;
        this.notifier = notifier;
        this.catchExceptions = catchThrowables;
        this.when = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatch() {
        try {
            if (this.catchExceptions) {
                try {
                    this.runnable.run();
                }
                catch (Throwable t) {
                    if (t instanceof Exception) {
                        this.exception = (Exception)t;
                    }
                    this.throwable = t;
                }
            } else {
                this.runnable.run();
            }
        }
        finally {
            this.dispatched = true;
            if (this.notifier != null) {
                Object object = this.notifier;
                synchronized (object) {
                    this.notifier.notifyAll();
                }
            }
        }
    }

    public Exception getException() {
        return this.catchExceptions ? this.exception : null;
    }

    public Throwable getThrowable() {
        return this.catchExceptions ? this.throwable : null;
    }

    public long getWhen() {
        return this.when;
    }

    public boolean isDispatched() {
        return this.dispatched;
    }

    @Override
    public String paramString() {
        String typeStr;
        switch (this.id) {
            case 1200: {
                typeStr = "INVOCATION_DEFAULT";
                break;
            }
            default: {
                typeStr = "unknown type";
            }
        }
        return typeStr + ",runnable=" + this.runnable + ",notifier=" + this.notifier + ",catchExceptions=" + this.catchExceptions + ",when=" + this.when;
    }
}

