/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.transforms;

import com.sun.org.apache.xml.internal.security.Init;
import com.sun.org.apache.xml.internal.security.c14n.CanonicalizationException;
import com.sun.org.apache.xml.internal.security.c14n.InvalidCanonicalizerException;
import com.sun.org.apache.xml.internal.security.exceptions.AlgorithmAlreadyRegisteredException;
import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.transforms.InvalidTransformException;
import com.sun.org.apache.xml.internal.security.transforms.TransformSpi;
import com.sun.org.apache.xml.internal.security.transforms.TransformationException;
import com.sun.org.apache.xml.internal.security.utils.HelperNodeList;
import com.sun.org.apache.xml.internal.security.utils.SignatureElementProxy;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class Transform
extends SignatureElementProxy {
    static Logger log = Logger.getLogger(Transform.class.getName());
    private static boolean alreadyInitialized = false;
    private static HashMap transformClassHash = null;
    private static HashMap transformSpiHash = new HashMap();
    private TransformSpi transformSpi = null;

    public Transform(Document doc, String algorithmURI, NodeList contextNodes) throws InvalidTransformException {
        super(doc);
        this._constructionElement.setAttributeNS(null, "Algorithm", algorithmURI);
        this.transformSpi = Transform.getTransformSpi(algorithmURI);
        if (this.transformSpi == null) {
            Object[] exArgs = new Object[]{algorithmURI};
            throw new InvalidTransformException("signature.Transform.UnknownTransform", exArgs);
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Create URI \"" + algorithmURI + "\" class \"" + this.transformSpi.getClass() + "\"");
            log.log(Level.FINE, "The NodeList is " + contextNodes);
        }
        if (contextNodes != null) {
            for (int i = 0; i < contextNodes.getLength(); ++i) {
                this._constructionElement.appendChild(contextNodes.item(i).cloneNode(true));
            }
        }
    }

    public Transform(Element element, String BaseURI) throws InvalidTransformException, TransformationException, XMLSecurityException {
        super(element, BaseURI);
        String algorithmURI = element.getAttributeNS(null, "Algorithm");
        if (algorithmURI == null || algorithmURI.length() == 0) {
            Object[] exArgs = new Object[]{"Algorithm", "Transform"};
            throw new TransformationException("xml.WrongContent", exArgs);
        }
        this.transformSpi = Transform.getTransformSpi(algorithmURI);
        if (this.transformSpi == null) {
            Object[] exArgs = new Object[]{algorithmURI};
            throw new InvalidTransformException("signature.Transform.UnknownTransform", exArgs);
        }
    }

    public static Transform getInstance(Document doc, String algorithmURI) throws InvalidTransformException {
        return Transform.getInstance(doc, algorithmURI, (NodeList)null);
    }

    public static Transform getInstance(Document doc, String algorithmURI, Element contextChild) throws InvalidTransformException {
        HelperNodeList contextNodes = new HelperNodeList();
        XMLUtils.addReturnToElement(doc, contextNodes);
        contextNodes.appendChild(contextChild);
        XMLUtils.addReturnToElement(doc, contextNodes);
        return Transform.getInstance(doc, algorithmURI, contextNodes);
    }

    public static Transform getInstance(Document doc, String algorithmURI, NodeList contextNodes) throws InvalidTransformException {
        return new Transform(doc, algorithmURI, contextNodes);
    }

    public static void init() {
        if (!alreadyInitialized) {
            transformClassHash = new HashMap(10);
            Init.init();
            alreadyInitialized = true;
        }
    }

    public static void register(String algorithmURI, String implementingClass) throws AlgorithmAlreadyRegisteredException {
        Class registeredClass = Transform.getImplementingClass(algorithmURI);
        if (registeredClass != null) {
            Object[] exArgs = new Object[]{algorithmURI, registeredClass};
            throw new AlgorithmAlreadyRegisteredException("algorithm.alreadyRegistered", exArgs);
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            transformClassHash.put(algorithmURI, Class.forName(implementingClass, true, cl));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public String getURI() {
        return this._constructionElement.getAttributeNS(null, "Algorithm");
    }

    public XMLSignatureInput performTransform(XMLSignatureInput input) throws IOException, CanonicalizationException, InvalidCanonicalizerException, TransformationException {
        XMLSignatureInput result = null;
        try {
            result = this.transformSpi.enginePerformTransform(input, this);
        }
        catch (ParserConfigurationException ex) {
            Object[] exArgs = new Object[]{this.getURI(), "ParserConfigurationException"};
            throw new CanonicalizationException("signature.Transform.ErrorDuringTransform", exArgs, ex);
        }
        catch (SAXException ex) {
            Object[] exArgs = new Object[]{this.getURI(), "SAXException"};
            throw new CanonicalizationException("signature.Transform.ErrorDuringTransform", exArgs, ex);
        }
        return result;
    }

    public XMLSignatureInput performTransform(XMLSignatureInput input, OutputStream os) throws IOException, CanonicalizationException, InvalidCanonicalizerException, TransformationException {
        XMLSignatureInput result = null;
        try {
            result = this.transformSpi.enginePerformTransform(input, os, this);
        }
        catch (ParserConfigurationException ex) {
            Object[] exArgs = new Object[]{this.getURI(), "ParserConfigurationException"};
            throw new CanonicalizationException("signature.Transform.ErrorDuringTransform", exArgs, ex);
        }
        catch (SAXException ex) {
            Object[] exArgs = new Object[]{this.getURI(), "SAXException"};
            throw new CanonicalizationException("signature.Transform.ErrorDuringTransform", exArgs, ex);
        }
        return result;
    }

    private static Class getImplementingClass(String URI2) {
        return (Class)transformClassHash.get(URI2);
    }

    private static TransformSpi getTransformSpi(String URI2) throws InvalidTransformException {
        try {
            Object value = transformSpiHash.get(URI2);
            if (value != null) {
                return (TransformSpi)value;
            }
            Class cl = (Class)transformClassHash.get(URI2);
            if (cl != null) {
                TransformSpi tr = (TransformSpi)cl.newInstance();
                transformSpiHash.put(URI2, tr);
                return tr;
            }
        }
        catch (InstantiationException ex) {
            Object[] exArgs = new Object[]{URI2};
            throw new InvalidTransformException("signature.Transform.UnknownTransform", exArgs, ex);
        }
        catch (IllegalAccessException ex) {
            Object[] exArgs = new Object[]{URI2};
            throw new InvalidTransformException("signature.Transform.UnknownTransform", exArgs, ex);
        }
        return null;
    }

    @Override
    public String getBaseLocalName() {
        return "Transform";
    }
}

