/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class RIFFReader
extends InputStream {
    private RIFFReader root;
    private long filepointer = 0L;
    private String fourcc;
    private String riff_type = null;
    private long ckSize = 0L;
    private InputStream stream;
    private long avail;
    private RIFFReader lastiterator = null;

    public RIFFReader(InputStream stream) throws IOException {
        int b;
        this.root = stream instanceof RIFFReader ? ((RIFFReader)stream).root : this;
        this.stream = stream;
        this.avail = Integer.MAX_VALUE;
        this.ckSize = Integer.MAX_VALUE;
        do {
            if ((b = this.read()) != -1) continue;
            this.fourcc = "";
            this.riff_type = null;
            this.avail = 0L;
            return;
        } while (b == 0);
        byte[] fourcc = new byte[4];
        fourcc[0] = (byte)b;
        this.readFully(fourcc, 1, 3);
        this.fourcc = new String(fourcc, "ascii");
        this.avail = this.ckSize = this.readUnsignedInt();
        if (this.getFormat().equals("RIFF") || this.getFormat().equals("LIST")) {
            byte[] format = new byte[4];
            this.readFully(format);
            this.riff_type = new String(format, "ascii");
        }
    }

    public long getFilePointer() throws IOException {
        return this.root.filepointer;
    }

    public boolean hasNextChunk() throws IOException {
        if (this.lastiterator != null) {
            this.lastiterator.finish();
        }
        return this.avail != 0L;
    }

    public RIFFReader nextChunk() throws IOException {
        if (this.lastiterator != null) {
            this.lastiterator.finish();
        }
        if (this.avail == 0L) {
            return null;
        }
        this.lastiterator = new RIFFReader(this);
        return this.lastiterator;
    }

    public String getFormat() {
        return this.fourcc;
    }

    public String getType() {
        return this.riff_type;
    }

    public long getSize() {
        return this.ckSize;
    }

    @Override
    public int read() throws IOException {
        if (this.avail == 0L) {
            return -1;
        }
        int b = this.stream.read();
        if (b == -1) {
            return -1;
        }
        --this.avail;
        ++this.filepointer;
        return b;
    }

    @Override
    public int read(byte[] b, int offset, int len) throws IOException {
        if (this.avail == 0L) {
            return -1;
        }
        if ((long)len > this.avail) {
            int rlen = this.stream.read(b, offset, (int)this.avail);
            if (rlen != -1) {
                this.filepointer += (long)rlen;
            }
            this.avail = 0L;
            return rlen;
        }
        int ret = this.stream.read(b, offset, len);
        if (ret == -1) {
            return -1;
        }
        this.avail -= (long)ret;
        this.filepointer += (long)ret;
        return ret;
    }

    public final void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    public final void readFully(byte[] b, int off, int len) throws IOException {
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        while (len > 0) {
            int s = this.read(b, off, len);
            if (s < 0) {
                throw new EOFException();
            }
            if (s == 0) {
                Thread.yield();
            }
            off += s;
            len -= s;
        }
    }

    public final long skipBytes(long n) throws IOException {
        long skipped;
        long s;
        if (n < 0L) {
            return 0L;
        }
        for (skipped = 0L; skipped != n && (s = this.skip(n - skipped)) >= 0L; skipped += s) {
            if (s != 0L) continue;
            Thread.yield();
        }
        return skipped;
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.avail == 0L) {
            return -1L;
        }
        if (n > this.avail) {
            long len = this.stream.skip(this.avail);
            if (len != -1L) {
                this.filepointer += len;
            }
            this.avail = 0L;
            return len;
        }
        long ret = this.stream.skip(n);
        if (ret == -1L) {
            return -1L;
        }
        this.avail -= ret;
        this.filepointer += ret;
        return ret;
    }

    @Override
    public int available() {
        return (int)this.avail;
    }

    public void finish() throws IOException {
        if (this.avail != 0L) {
            this.skipBytes(this.avail);
        }
    }

    public String readString(int len) throws IOException {
        byte[] buff = new byte[len];
        this.readFully(buff);
        for (int i = 0; i < buff.length; ++i) {
            if (buff[i] != 0) continue;
            return new String(buff, 0, i, "ascii");
        }
        return new String(buff, "ascii");
    }

    public byte readByte() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return (byte)ch;
    }

    public short readShort() throws IOException {
        int ch1 = this.read();
        int ch2 = this.read();
        if (ch1 < 0) {
            throw new EOFException();
        }
        if (ch2 < 0) {
            throw new EOFException();
        }
        return (short)(ch1 | ch2 << 8);
    }

    public int readInt() throws IOException {
        int ch1 = this.read();
        int ch2 = this.read();
        int ch3 = this.read();
        int ch4 = this.read();
        if (ch1 < 0) {
            throw new EOFException();
        }
        if (ch2 < 0) {
            throw new EOFException();
        }
        if (ch3 < 0) {
            throw new EOFException();
        }
        if (ch4 < 0) {
            throw new EOFException();
        }
        return ch1 + (ch2 << 8) | ch3 << 16 | ch4 << 24;
    }

    public long readLong() throws IOException {
        long ch1 = this.read();
        long ch2 = this.read();
        long ch3 = this.read();
        long ch4 = this.read();
        long ch5 = this.read();
        long ch6 = this.read();
        long ch7 = this.read();
        long ch8 = this.read();
        if (ch1 < 0L) {
            throw new EOFException();
        }
        if (ch2 < 0L) {
            throw new EOFException();
        }
        if (ch3 < 0L) {
            throw new EOFException();
        }
        if (ch4 < 0L) {
            throw new EOFException();
        }
        if (ch5 < 0L) {
            throw new EOFException();
        }
        if (ch6 < 0L) {
            throw new EOFException();
        }
        if (ch7 < 0L) {
            throw new EOFException();
        }
        if (ch8 < 0L) {
            throw new EOFException();
        }
        return ch1 | ch2 << 8 | ch3 << 16 | ch4 << 24 | ch5 << 32 | ch6 << 40 | ch7 << 48 | ch8 << 56;
    }

    public int readUnsignedByte() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch;
    }

    public int readUnsignedShort() throws IOException {
        int ch1 = this.read();
        int ch2 = this.read();
        if (ch1 < 0) {
            throw new EOFException();
        }
        if (ch2 < 0) {
            throw new EOFException();
        }
        return ch1 | ch2 << 8;
    }

    public long readUnsignedInt() throws IOException {
        long ch1 = this.read();
        long ch2 = this.read();
        long ch3 = this.read();
        long ch4 = this.read();
        if (ch1 < 0L) {
            throw new EOFException();
        }
        if (ch2 < 0L) {
            throw new EOFException();
        }
        if (ch3 < 0L) {
            throw new EOFException();
        }
        if (ch4 < 0L) {
            throw new EOFException();
        }
        return ch1 + (ch2 << 8) | ch3 << 16 | ch4 << 24;
    }

    @Override
    public void close() throws IOException {
        this.finish();
        if (this == this.root) {
            this.stream.close();
        }
        this.stream = null;
    }
}

