/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.motif;

import com.sun.java.swing.plaf.motif.MotifBorders;
import com.sun.java.swing.plaf.motif.MotifIconFactory;
import com.sun.java.swing.plaf.motif.MotifTreeCellRenderer;
import com.sun.java.swing.plaf.motif.MotifTreeUI;
import java.awt.Color;
import javax.swing.UIDefaults;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.basic.BasicLookAndFeel;
import sun.awt.OSInfo;
import sun.swing.SwingUtilities2;

public class MotifLookAndFeel
extends BasicLookAndFeel {
    @Override
    public String getName() {
        return "CDE/Motif";
    }

    @Override
    public String getID() {
        return "Motif";
    }

    @Override
    public String getDescription() {
        return "The CDE/Motif Look and Feel";
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return OSInfo.getOSType() == OSInfo.OSType.SOLARIS;
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return true;
    }

    @Override
    protected void initSystemColorDefaults(UIDefaults table) {
        String[] defaultSystemColors = new String[]{"desktop", "#005C5C", "activeCaption", "#000080", "activeCaptionText", "#FFFFFF", "activeCaptionBorder", "#B24D7A", "inactiveCaption", "#AEB2C3", "inactiveCaptionText", "#000000", "inactiveCaptionBorder", "#AEB2C3", "window", "#AEB2C3", "windowBorder", "#AEB2C3", "windowText", "#000000", "menu", "#AEB2C3", "menuText", "#000000", "text", "#FFF7E9", "textText", "#000000", "textHighlight", "#000000", "textHighlightText", "#FFF7E9", "textInactiveText", "#808080", "control", "#AEB2C3", "controlText", "#000000", "controlHighlight", "#DCDEE5", "controlLtHighlight", "#DCDEE5", "controlShadow", "#63656F", "controlLightShadow", "#9397A5", "controlDkShadow", "#000000", "scrollbar", "#AEB2C3", "info", "#FFF7E9", "infoText", "#000000"};
        this.loadSystemColors(table, defaultSystemColors, false);
    }

    @Override
    protected void initClassDefaults(UIDefaults table) {
        super.initClassDefaults(table);
        String motifPackageName = "com.sun.java.swing.plaf.motif.";
        Object[] uiDefaults = new Object[]{"ButtonUI", motifPackageName + "MotifButtonUI", "CheckBoxUI", motifPackageName + "MotifCheckBoxUI", "DirectoryPaneUI", motifPackageName + "MotifDirectoryPaneUI", "FileChooserUI", motifPackageName + "MotifFileChooserUI", "LabelUI", motifPackageName + "MotifLabelUI", "MenuBarUI", motifPackageName + "MotifMenuBarUI", "MenuUI", motifPackageName + "MotifMenuUI", "MenuItemUI", motifPackageName + "MotifMenuItemUI", "CheckBoxMenuItemUI", motifPackageName + "MotifCheckBoxMenuItemUI", "RadioButtonMenuItemUI", motifPackageName + "MotifRadioButtonMenuItemUI", "RadioButtonUI", motifPackageName + "MotifRadioButtonUI", "ToggleButtonUI", motifPackageName + "MotifToggleButtonUI", "PopupMenuUI", motifPackageName + "MotifPopupMenuUI", "ProgressBarUI", motifPackageName + "MotifProgressBarUI", "ScrollBarUI", motifPackageName + "MotifScrollBarUI", "ScrollPaneUI", motifPackageName + "MotifScrollPaneUI", "SliderUI", motifPackageName + "MotifSliderUI", "SplitPaneUI", motifPackageName + "MotifSplitPaneUI", "TabbedPaneUI", motifPackageName + "MotifTabbedPaneUI", "TextAreaUI", motifPackageName + "MotifTextAreaUI", "TextFieldUI", motifPackageName + "MotifTextFieldUI", "PasswordFieldUI", motifPackageName + "MotifPasswordFieldUI", "TextPaneUI", motifPackageName + "MotifTextPaneUI", "EditorPaneUI", motifPackageName + "MotifEditorPaneUI", "TreeUI", motifPackageName + "MotifTreeUI", "InternalFrameUI", motifPackageName + "MotifInternalFrameUI", "DesktopPaneUI", motifPackageName + "MotifDesktopPaneUI", "SeparatorUI", motifPackageName + "MotifSeparatorUI", "PopupMenuSeparatorUI", motifPackageName + "MotifPopupMenuSeparatorUI", "OptionPaneUI", motifPackageName + "MotifOptionPaneUI", "ComboBoxUI", motifPackageName + "MotifComboBoxUI", "DesktopIconUI", motifPackageName + "MotifDesktopIconUI"};
        table.putDefaults(uiDefaults);
    }

    private void initResourceBundle(UIDefaults table) {
        table.addResourceBundle("com.sun.java.swing.plaf.motif.resources.motif");
    }

    @Override
    protected void initComponentDefaults(UIDefaults table) {
        ColorUIResource controlDarker;
        super.initComponentDefaults(table);
        this.initResourceBundle(table);
        FontUIResource dialogPlain12 = new FontUIResource("Dialog", 0, 12);
        FontUIResource serifPlain12 = new FontUIResource("Serif", 0, 12);
        FontUIResource sansSerifPlain12 = new FontUIResource("SansSerif", 0, 12);
        FontUIResource monospacedPlain12 = new FontUIResource("Monospaced", 0, 12);
        ColorUIResource red = new ColorUIResource(Color.red);
        ColorUIResource black = new ColorUIResource(Color.black);
        ColorUIResource white = new ColorUIResource(Color.white);
        ColorUIResource lightGray = new ColorUIResource(Color.lightGray);
        ColorUIResource scrollBarTrack = controlDarker = new ColorUIResource(147, 151, 165);
        ColorUIResource menuItemPressedBackground = new ColorUIResource(165, 165, 165);
        ColorUIResource menuItemPressedForeground = new ColorUIResource(0, 0, 0);
        MotifBorders.BevelBorder loweredBevelBorder = new MotifBorders.BevelBorder(false, table.getColor("controlShadow"), table.getColor("controlLtHighlight"));
        MotifBorders.BevelBorder raisedBevelBorder = new MotifBorders.BevelBorder(true, table.getColor("controlShadow"), table.getColor("controlLtHighlight"));
        BasicBorders.MarginBorder marginBorder = new BasicBorders.MarginBorder();
        MotifBorders.FocusBorder focusBorder = new MotifBorders.FocusBorder(table.getColor("control"), table.getColor("activeCaptionBorder"));
        BorderUIResource.CompoundBorderUIResource focusBevelBorder = new BorderUIResource.CompoundBorderUIResource(focusBorder, loweredBevelBorder);
        BorderUIResource.CompoundBorderUIResource comboBoxBorder = new BorderUIResource.CompoundBorderUIResource(focusBorder, raisedBevelBorder);
        BorderUIResource.CompoundBorderUIResource buttonBorder = new BorderUIResource.CompoundBorderUIResource(new MotifBorders.ButtonBorder(table.getColor("Button.shadow"), table.getColor("Button.highlight"), table.getColor("Button.darkShadow"), table.getColor("activeCaptionBorder")), marginBorder);
        BorderUIResource.CompoundBorderUIResource toggleButtonBorder = new BorderUIResource.CompoundBorderUIResource(new MotifBorders.ToggleButtonBorder(table.getColor("ToggleButton.shadow"), table.getColor("ToggleButton.highlight"), table.getColor("ToggleButton.darkShadow"), table.getColor("activeCaptionBorder")), marginBorder);
        BorderUIResource.CompoundBorderUIResource textFieldBorder = new BorderUIResource.CompoundBorderUIResource(focusBevelBorder, marginBorder);
        BorderUIResource.CompoundBorderUIResource popupMenuBorder = new BorderUIResource.CompoundBorderUIResource(raisedBevelBorder, new MotifBorders.MotifPopupMenuBorder(table.getFont("PopupMenu.font"), table.getColor("PopupMenu.background"), table.getColor("PopupMenu.foreground"), table.getColor("controlShadow"), table.getColor("controlLtHighlight")));
        UIDefaults.LazyValue menuItemCheckIcon = new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return MotifIconFactory.getMenuItemCheckIcon();
            }
        };
        UIDefaults.LazyValue menuItemArrowIcon = new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return MotifIconFactory.getMenuItemArrowIcon();
            }
        };
        UIDefaults.LazyValue menuArrowIcon = new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return MotifIconFactory.getMenuArrowIcon();
            }
        };
        UIDefaults.LazyValue checkBoxIcon = new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return MotifIconFactory.getCheckBoxIcon();
            }
        };
        UIDefaults.LazyValue radioButtonIcon = new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return MotifIconFactory.getRadioButtonIcon();
            }
        };
        UIDefaults.LazyValue unselectedTabBackground = new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                Color c = table.getColor("control");
                return new ColorUIResource(Math.max((int)((double)c.getRed() * 0.85), 0), Math.max((int)((double)c.getGreen() * 0.85), 0), Math.max((int)((double)c.getBlue() * 0.85), 0));
            }
        };
        UIDefaults.LazyValue unselectedTabForeground = new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                Color c = table.getColor("controlText");
                return new ColorUIResource(Math.max((int)((double)c.getRed() * 0.85), 0), Math.max((int)((double)c.getGreen() * 0.85), 0), Math.max((int)((double)c.getBlue() * 0.85), 0));
            }
        };
        UIDefaults.LazyValue unselectedTabShadow = new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                Color c = table.getColor("control");
                Color base = new Color(Math.max((int)((double)c.getRed() * 0.85), 0), Math.max((int)((double)c.getGreen() * 0.85), 0), Math.max((int)((double)c.getBlue() * 0.85), 0));
                return new ColorUIResource(base.darker());
            }
        };
        UIDefaults.LazyValue unselectedTabHighlight = new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                Color c = table.getColor("control");
                Color base = new Color(Math.max((int)((double)c.getRed() * 0.85), 0), Math.max((int)((double)c.getGreen() * 0.85), 0), Math.max((int)((double)c.getBlue() * 0.85), 0));
                return new ColorUIResource(base.brighter());
            }
        };
        UIDefaults.LazyInputMap fieldInputMap = new UIDefaults.LazyInputMap(new Object[]{"COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "control INSERT", "copy-to-clipboard", "shift INSERT", "paste-from-clipboard", "shift DELETE", "cut-to-clipboard", "control F", "caret-forward", "control B", "caret-backward", "control D", "delete-next", "BACK_SPACE", "delete-previous", "shift BACK_SPACE", "delete-previous", "ctrl H", "delete-previous", "DELETE", "delete-next", "ctrl DELETE", "delete-next-word", "ctrl BACK_SPACE", "delete-previous-word", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "shift LEFT", "selection-backward", "shift RIGHT", "selection-forward", "control LEFT", "caret-previous-word", "control RIGHT", "caret-next-word", "control shift LEFT", "selection-previous-word", "control shift RIGHT", "selection-next-word", "control SLASH", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "control BACK_SLASH", "unselect", "ENTER", "notify-field-accept", "control shift O", "toggle-componentOrientation"});
        UIDefaults.LazyInputMap passwordInputMap = new UIDefaults.LazyInputMap(new Object[]{"COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "control INSERT", "copy-to-clipboard", "shift INSERT", "paste-from-clipboard", "shift DELETE", "cut-to-clipboard", "control F", "caret-forward", "control B", "caret-backward", "control D", "delete-next", "BACK_SPACE", "delete-previous", "shift BACK_SPACE", "delete-previous", "ctrl H", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "shift LEFT", "selection-backward", "shift RIGHT", "selection-forward", "control LEFT", "caret-begin-line", "control RIGHT", "caret-end-line", "control shift LEFT", "selection-begin-line", "control shift RIGHT", "selection-end-line", "control SLASH", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "control BACK_SLASH", "unselect", "ENTER", "notify-field-accept", "control shift O", "toggle-componentOrientation"});
        UIDefaults.LazyInputMap multilineInputMap = new UIDefaults.LazyInputMap(new Object[]{"COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "control INSERT", "copy-to-clipboard", "shift INSERT", "paste-from-clipboard", "shift DELETE", "cut-to-clipboard", "control F", "caret-forward", "control B", "caret-backward", "control D", "delete-next", "BACK_SPACE", "delete-previous", "shift BACK_SPACE", "delete-previous", "ctrl H", "delete-previous", "DELETE", "delete-next", "ctrl DELETE", "delete-next-word", "ctrl BACK_SPACE", "delete-previous-word", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "shift LEFT", "selection-backward", "shift RIGHT", "selection-forward", "control LEFT", "caret-previous-word", "control RIGHT", "caret-next-word", "control shift LEFT", "selection-previous-word", "control shift RIGHT", "selection-next-word", "control SLASH", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "control N", "caret-down", "control P", "caret-up", "UP", "caret-up", "DOWN", "caret-down", "PAGE_UP", "page-up", "PAGE_DOWN", "page-down", "shift PAGE_UP", "selection-page-up", "shift PAGE_DOWN", "selection-page-down", "ctrl shift PAGE_UP", "selection-page-left", "ctrl shift PAGE_DOWN", "selection-page-right", "shift UP", "selection-up", "shift DOWN", "selection-down", "ENTER", "insert-break", "TAB", "insert-tab", "control BACK_SLASH", "unselect", "control HOME", "caret-begin", "control END", "caret-end", "control shift HOME", "selection-begin", "control shift END", "selection-end", "control T", "next-link-action", "control shift T", "previous-link-action", "control SPACE", "activate-link-action", "control shift O", "toggle-componentOrientation"});
        Object treeOpenIcon = SwingUtilities2.makeIcon(this.getClass(), MotifLookAndFeel.class, "icons/TreeOpen.gif");
        Object treeClosedIcon = SwingUtilities2.makeIcon(this.getClass(), MotifLookAndFeel.class, "icons/TreeClosed.gif");
        UIDefaults.LazyValue treeLeafIcon = new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return MotifTreeCellRenderer.loadLeafIcon();
            }
        };
        UIDefaults.LazyValue treeExpandedIcon = new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return MotifTreeUI.MotifExpandedIcon.createExpandedIcon();
            }
        };
        UIDefaults.LazyValue treeCollapsedIcon = new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return MotifTreeUI.MotifCollapsedIcon.createCollapsedIcon();
            }
        };
        MotifBorders.MenuBarBorder menuBarBorder = new MotifBorders.MenuBarBorder(table.getColor("MenuBar.shadow"), table.getColor("MenuBar.highlight"), table.getColor("MenuBar.darkShadow"), table.getColor("activeCaptionBorder"));
        BorderUIResource.CompoundBorderUIResource menuMarginBorder = new BorderUIResource.CompoundBorderUIResource(loweredBevelBorder, marginBorder);
        BorderUIResource.LineBorderUIResource focusCellHighlightBorder = new BorderUIResource.LineBorderUIResource(table.getColor("activeCaptionBorder"));
        InsetsUIResource sliderFocusInsets = new InsetsUIResource(0, 0, 0, 0);
        InsetsUIResource tabbedPaneTabInsets = new InsetsUIResource(3, 4, 3, 4);
        InsetsUIResource tabbedPaneTabPadInsets = new InsetsUIResource(3, 0, 1, 0);
        InsetsUIResource tabbedPaneTabAreaInsets = new InsetsUIResource(4, 2, 0, 8);
        InsetsUIResource tabbedPaneContentBorderInsets = new InsetsUIResource(2, 2, 2, 2);
        BorderUIResource.EmptyBorderUIResource optionPaneBorder = new BorderUIResource.EmptyBorderUIResource(10, 0, 0, 0);
        BorderUIResource.EmptyBorderUIResource optionPaneButtonAreaBorder = new BorderUIResource.EmptyBorderUIResource(10, 10, 10, 10);
        BorderUIResource.EmptyBorderUIResource optionPaneMessageAreaBorder = new BorderUIResource.EmptyBorderUIResource(10, 10, 12, 10);
        Object[] defaults = new Object[]{"Desktop.background", table.get("desktop"), "Desktop.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl F5", "restore", "ctrl F4", "close", "ctrl F7", "move", "ctrl F8", "resize", "RIGHT", "right", "KP_RIGHT", "right", "shift RIGHT", "shrinkRight", "shift KP_RIGHT", "shrinkRight", "LEFT", "left", "KP_LEFT", "left", "shift LEFT", "shrinkLeft", "shift KP_LEFT", "shrinkLeft", "UP", "up", "KP_UP", "up", "shift UP", "shrinkUp", "shift KP_UP", "shrinkUp", "DOWN", "down", "KP_DOWN", "down", "shift DOWN", "shrinkDown", "shift KP_DOWN", "shrinkDown", "ESCAPE", "escape", "ctrl F9", "minimize", "ctrl F10", "maximize", "ctrl F6", "selectNextFrame", "ctrl TAB", "selectNextFrame", "ctrl alt F6", "selectNextFrame", "shift ctrl alt F6", "selectPreviousFrame", "ctrl F12", "navigateNext", "shift ctrl F12", "navigatePrevious"}), "Panel.background", table.get("control"), "Panel.foreground", table.get("textText"), "Panel.font", dialogPlain12, "ProgressBar.font", dialogPlain12, "ProgressBar.foreground", controlDarker, "ProgressBar.background", table.get("control"), "ProgressBar.selectionForeground", table.get("control"), "ProgressBar.selectionBackground", table.get("controlText"), "ProgressBar.border", loweredBevelBorder, "ProgressBar.cellLength", new Integer(6), "ProgressBar.cellSpacing", 0, "Button.margin", new InsetsUIResource(2, 4, 2, 4), "Button.border", buttonBorder, "Button.background", table.get("control"), "Button.foreground", table.get("controlText"), "Button.select", table.get("controlLightShadow"), "Button.font", dialogPlain12, "Button.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released"}), "CheckBox.textIconGap", new Integer(8), "CheckBox.margin", new InsetsUIResource(4, 2, 4, 2), "CheckBox.icon", checkBoxIcon, "CheckBox.focus", table.get("activeCaptionBorder"), "CheckBox.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released"}), "RadioButton.margin", new InsetsUIResource(4, 2, 4, 2), "RadioButton.textIconGap", new Integer(8), "RadioButton.background", table.get("control"), "RadioButton.foreground", table.get("controlText"), "RadioButton.icon", radioButtonIcon, "RadioButton.focus", table.get("activeCaptionBorder"), "RadioButton.icon", radioButtonIcon, "RadioButton.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released"}), "ToggleButton.border", toggleButtonBorder, "ToggleButton.background", table.get("control"), "ToggleButton.foreground", table.get("controlText"), "ToggleButton.focus", table.get("controlText"), "ToggleButton.select", table.get("controlLightShadow"), "ToggleButton.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released"}), "Menu.border", menuMarginBorder, "Menu.font", dialogPlain12, "Menu.acceleratorFont", dialogPlain12, "Menu.acceleratorSelectionForeground", menuItemPressedForeground, "Menu.foreground", table.get("menuText"), "Menu.background", table.get("menu"), "Menu.selectionForeground", menuItemPressedForeground, "Menu.selectionBackground", menuItemPressedBackground, "Menu.checkIcon", menuItemCheckIcon, "Menu.arrowIcon", menuArrowIcon, "Menu.menuPopupOffsetX", new Integer(0), "Menu.menuPopupOffsetY", new Integer(0), "Menu.submenuPopupOffsetX", new Integer(-2), "Menu.submenuPopupOffsetY", new Integer(3), "Menu.shortcutKeys", new int[]{8, 4}, "Menu.cancelMode", "hideMenuTree", "MenuBar.border", menuBarBorder, "MenuBar.background", table.get("menu"), "MenuBar.foreground", table.get("menuText"), "MenuBar.font", dialogPlain12, "MenuBar.windowBindings", new Object[]{"F10", "takeFocus"}, "MenuItem.border", menuMarginBorder, "MenuItem.font", dialogPlain12, "MenuItem.acceleratorFont", dialogPlain12, "MenuItem.acceleratorSelectionForeground", menuItemPressedForeground, "MenuItem.foreground", table.get("menuText"), "MenuItem.background", table.get("menu"), "MenuItem.selectionForeground", menuItemPressedForeground, "MenuItem.selectionBackground", menuItemPressedBackground, "MenuItem.checkIcon", menuItemCheckIcon, "MenuItem.arrowIcon", menuItemArrowIcon, "RadioButtonMenuItem.border", menuMarginBorder, "RadioButtonMenuItem.font", dialogPlain12, "RadioButtonMenuItem.acceleratorFont", dialogPlain12, "RadioButtonMenuItem.acceleratorSelectionForeground", menuItemPressedForeground, "RadioButtonMenuItem.foreground", table.get("menuText"), "RadioButtonMenuItem.background", table.get("menu"), "RadioButtonMenuItem.selectionForeground", menuItemPressedForeground, "RadioButtonMenuItem.selectionBackground", menuItemPressedBackground, "RadioButtonMenuItem.checkIcon", radioButtonIcon, "RadioButtonMenuItem.arrowIcon", menuItemArrowIcon, "CheckBoxMenuItem.border", menuMarginBorder, "CheckBoxMenuItem.font", dialogPlain12, "CheckBoxMenuItem.acceleratorFont", dialogPlain12, "CheckBoxMenuItem.acceleratorSelectionForeground", menuItemPressedForeground, "CheckBoxMenuItem.foreground", table.get("menuText"), "CheckBoxMenuItem.background", table.get("menu"), "CheckBoxMenuItem.selectionForeground", menuItemPressedForeground, "CheckBoxMenuItem.selectionBackground", menuItemPressedBackground, "CheckBoxMenuItem.checkIcon", checkBoxIcon, "CheckBoxMenuItem.arrowIcon", menuItemArrowIcon, "PopupMenu.background", table.get("menu"), "PopupMenu.border", popupMenuBorder, "PopupMenu.foreground", table.get("menuText"), "PopupMenu.font", dialogPlain12, "PopupMenu.consumeEventOnClose", Boolean.TRUE, "Label.font", dialogPlain12, "Label.background", table.get("control"), "Label.foreground", table.get("controlText"), "Separator.shadow", table.get("controlShadow"), "Separator.highlight", table.get("controlLtHighlight"), "Separator.background", table.get("controlLtHighlight"), "Separator.foreground", table.get("controlShadow"), "List.focusCellHighlightBorder", focusCellHighlightBorder, "List.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"COPY", "copy", "PASTE", "paste", "CUT", "cut", "control INSERT", "copy", "shift INSERT", "paste", "shift DELETE", "cut", "UP", "selectPreviousRow", "KP_UP", "selectPreviousRow", "shift UP", "selectPreviousRowExtendSelection", "shift KP_UP", "selectPreviousRowExtendSelection", "ctrl shift UP", "selectPreviousRowExtendSelection", "ctrl shift KP_UP", "selectPreviousRowExtendSelection", "ctrl UP", "selectPreviousRowChangeLead", "ctrl KP_UP", "selectPreviousRowChangeLead", "DOWN", "selectNextRow", "KP_DOWN", "selectNextRow", "shift DOWN", "selectNextRowExtendSelection", "shift KP_DOWN", "selectNextRowExtendSelection", "ctrl shift DOWN", "selectNextRowExtendSelection", "ctrl shift KP_DOWN", "selectNextRowExtendSelection", "ctrl DOWN", "selectNextRowChangeLead", "ctrl KP_DOWN", "selectNextRowChangeLead", "LEFT", "selectPreviousColumn", "KP_LEFT", "selectPreviousColumn", "shift LEFT", "selectPreviousColumnExtendSelection", "shift KP_LEFT", "selectPreviousColumnExtendSelection", "ctrl shift LEFT", "selectPreviousColumnExtendSelection", "ctrl shift KP_LEFT", "selectPreviousColumnExtendSelection", "ctrl LEFT", "selectPreviousColumnChangeLead", "ctrl KP_LEFT", "selectPreviousColumnChangeLead", "RIGHT", "selectNextColumn", "KP_RIGHT", "selectNextColumn", "shift RIGHT", "selectNextColumnExtendSelection", "shift KP_RIGHT", "selectNextColumnExtendSelection", "ctrl shift RIGHT", "selectNextColumnExtendSelection", "ctrl shift KP_RIGHT", "selectNextColumnExtendSelection", "ctrl RIGHT", "selectNextColumnChangeLead", "ctrl KP_RIGHT", "selectNextColumnChangeLead", "HOME", "selectFirstRow", "shift HOME", "selectFirstRowExtendSelection", "ctrl shift HOME", "selectFirstRowExtendSelection", "ctrl HOME", "selectFirstRowChangeLead", "END", "selectLastRow", "shift END", "selectLastRowExtendSelection", "ctrl shift END", "selectLastRowExtendSelection", "ctrl END", "selectLastRowChangeLead", "PAGE_UP", "scrollUp", "shift PAGE_UP", "scrollUpExtendSelection", "ctrl shift PAGE_UP", "scrollUpExtendSelection", "ctrl PAGE_UP", "scrollUpChangeLead", "PAGE_DOWN", "scrollDown", "shift PAGE_DOWN", "scrollDownExtendSelection", "ctrl shift PAGE_DOWN", "scrollDownExtendSelection", "ctrl PAGE_DOWN", "scrollDownChangeLead", "ctrl A", "selectAll", "ctrl SLASH", "selectAll", "ctrl BACK_SLASH", "clearSelection", "SPACE", "addToSelection", "ctrl SPACE", "toggleAndAnchor", "shift SPACE", "extendTo", "ctrl shift SPACE", "moveSelectionTo"}), "DesktopIcon.icon", SwingUtilities2.makeIcon(this.getClass(), MotifLookAndFeel.class, "icons/DesktopIcon.gif"), "DesktopIcon.border", null, "DesktopIcon.windowBindings", new Object[]{"ESCAPE", "hideSystemMenu"}, "InternalFrame.activeTitleBackground", table.get("activeCaptionBorder"), "InternalFrame.inactiveTitleBackground", table.get("inactiveCaptionBorder"), "InternalFrame.windowBindings", new Object[]{"shift ESCAPE", "showSystemMenu", "ctrl SPACE", "showSystemMenu", "ESCAPE", "hideSystemMenu"}, "ScrollBar.background", scrollBarTrack, "ScrollBar.foreground", table.get("control"), "ScrollBar.track", scrollBarTrack, "ScrollBar.trackHighlight", table.get("controlDkShadow"), "ScrollBar.thumb", table.get("control"), "ScrollBar.thumbHighlight", table.get("controlHighlight"), "ScrollBar.thumbDarkShadow", table.get("controlDkShadow"), "ScrollBar.thumbShadow", table.get("controlShadow"), "ScrollBar.border", loweredBevelBorder, "ScrollBar.allowsAbsolutePositioning", Boolean.TRUE, "ScrollBar.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "positiveUnitIncrement", "KP_RIGHT", "positiveUnitIncrement", "DOWN", "positiveUnitIncrement", "KP_DOWN", "positiveUnitIncrement", "PAGE_DOWN", "positiveBlockIncrement", "ctrl PAGE_DOWN", "positiveBlockIncrement", "LEFT", "negativeUnitIncrement", "KP_LEFT", "negativeUnitIncrement", "UP", "negativeUnitIncrement", "KP_UP", "negativeUnitIncrement", "PAGE_UP", "negativeBlockIncrement", "ctrl PAGE_UP", "negativeBlockIncrement", "HOME", "minScroll", "END", "maxScroll"}), "ScrollPane.font", dialogPlain12, "ScrollPane.background", table.get("control"), "ScrollPane.foreground", table.get("controlText"), "ScrollPane.border", null, "ScrollPane.viewportBorder", loweredBevelBorder, "ScrollPane.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "unitScrollRight", "KP_RIGHT", "unitScrollRight", "DOWN", "unitScrollDown", "KP_DOWN", "unitScrollDown", "LEFT", "unitScrollLeft", "KP_LEFT", "unitScrollLeft", "UP", "unitScrollUp", "KP_UP", "unitScrollUp", "PAGE_UP", "scrollUp", "PAGE_DOWN", "scrollDown", "ctrl PAGE_UP", "scrollLeft", "ctrl PAGE_DOWN", "scrollRight", "ctrl HOME", "scrollHome", "ctrl END", "scrollEnd"}), "Slider.font", dialogPlain12, "Slider.border", focusBevelBorder, "Slider.foreground", table.get("control"), "Slider.background", controlDarker, "Slider.highlight", table.get("controlHighlight"), "Slider.shadow", table.get("controlShadow"), "Slider.focus", table.get("controlDkShadow"), "Slider.focusInsets", sliderFocusInsets, "Slider.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "positiveUnitIncrement", "KP_RIGHT", "positiveUnitIncrement", "DOWN", "negativeUnitIncrement", "KP_DOWN", "negativeUnitIncrement", "ctrl PAGE_DOWN", "negativeBlockIncrement", "LEFT", "negativeUnitIncrement", "KP_LEFT", "negativeUnitIncrement", "UP", "positiveUnitIncrement", "KP_UP", "positiveUnitIncrement", "ctrl PAGE_UP", "positiveBlockIncrement", "HOME", "minScroll", "END", "maxScroll"}), "Spinner.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"UP", "increment", "KP_UP", "increment", "DOWN", "decrement", "KP_DOWN", "decrement"}), "Spinner.border", textFieldBorder, "SplitPane.background", table.get("control"), "SplitPane.highlight", table.get("controlHighlight"), "SplitPane.shadow", table.get("controlShadow"), "SplitPane.dividerSize", 20, "SplitPane.activeThumb", table.get("activeCaptionBorder"), "SplitPane.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"UP", "negativeIncrement", "DOWN", "positiveIncrement", "LEFT", "negativeIncrement", "RIGHT", "positiveIncrement", "KP_UP", "negativeIncrement", "KP_DOWN", "positiveIncrement", "KP_LEFT", "negativeIncrement", "KP_RIGHT", "positiveIncrement", "HOME", "selectMin", "END", "selectMax", "F8", "startResize", "F6", "toggleFocus", "ctrl TAB", "focusOutForward", "ctrl shift TAB", "focusOutBackward"}), "TabbedPane.font", dialogPlain12, "TabbedPane.background", table.get("control"), "TabbedPane.foreground", table.get("controlText"), "TabbedPane.light", table.get("controlHighlight"), "TabbedPane.highlight", table.get("controlLtHighlight"), "TabbedPane.shadow", table.get("controlShadow"), "TabbedPane.darkShadow", table.get("controlShadow"), "TabbedPane.unselectedTabBackground", unselectedTabBackground, "TabbedPane.unselectedTabForeground", unselectedTabForeground, "TabbedPane.unselectedTabHighlight", unselectedTabHighlight, "TabbedPane.unselectedTabShadow", unselectedTabShadow, "TabbedPane.focus", table.get("activeCaptionBorder"), "TabbedPane.tabInsets", tabbedPaneTabInsets, "TabbedPane.selectedTabPadInsets", tabbedPaneTabPadInsets, "TabbedPane.tabAreaInsets", tabbedPaneTabAreaInsets, "TabbedPane.contentBorderInsets", tabbedPaneContentBorderInsets, "TabbedPane.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "navigateRight", "KP_RIGHT", "navigateRight", "LEFT", "navigateLeft", "KP_LEFT", "navigateLeft", "UP", "navigateUp", "KP_UP", "navigateUp", "DOWN", "navigateDown", "KP_DOWN", "navigateDown", "ctrl DOWN", "requestFocusForVisibleComponent", "ctrl KP_DOWN", "requestFocusForVisibleComponent"}), "TabbedPane.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl PAGE_DOWN", "navigatePageDown", "ctrl PAGE_UP", "navigatePageUp", "ctrl UP", "requestFocus", "ctrl KP_UP", "requestFocus"}), "Tree.background", controlDarker, "Tree.hash", table.get("controlDkShadow"), "Tree.iconShadow", table.get("controlShadow"), "Tree.iconHighlight", table.get("controlHighlight"), "Tree.iconBackground", table.get("control"), "Tree.iconForeground", table.get("controlShadow"), "Tree.textBackground", controlDarker, "Tree.textForeground", table.get("textText"), "Tree.selectionBackground", table.get("text"), "Tree.selectionForeground", table.get("textText"), "Tree.selectionBorderColor", table.get("activeCaptionBorder"), "Tree.openIcon", treeOpenIcon, "Tree.closedIcon", treeClosedIcon, "Tree.leafIcon", treeLeafIcon, "Tree.expandedIcon", treeExpandedIcon, "Tree.collapsedIcon", treeCollapsedIcon, "Tree.editorBorder", focusBorder, "Tree.editorBorderSelectionColor", table.get("activeCaptionBorder"), "Tree.rowHeight", new Integer(18), "Tree.drawsFocusBorderAroundIcon", Boolean.TRUE, "Tree.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"COPY", "copy", "PASTE", "paste", "CUT", "cut", "control INSERT", "copy", "shift INSERT", "paste", "shift DELETE", "cut", "UP", "selectPrevious", "KP_UP", "selectPrevious", "shift UP", "selectPreviousExtendSelection", "shift KP_UP", "selectPreviousExtendSelection", "ctrl shift UP", "selectPreviousExtendSelection", "ctrl shift KP_UP", "selectPreviousExtendSelection", "ctrl UP", "selectPreviousChangeLead", "ctrl KP_UP", "selectPreviousChangeLead", "DOWN", "selectNext", "KP_DOWN", "selectNext", "shift DOWN", "selectNextExtendSelection", "shift KP_DOWN", "selectNextExtendSelection", "ctrl shift DOWN", "selectNextExtendSelection", "ctrl shift KP_DOWN", "selectNextExtendSelection", "ctrl DOWN", "selectNextChangeLead", "ctrl KP_DOWN", "selectNextChangeLead", "RIGHT", "selectChild", "KP_RIGHT", "selectChild", "LEFT", "selectParent", "KP_LEFT", "selectParent", "PAGE_UP", "scrollUpChangeSelection", "shift PAGE_UP", "scrollUpExtendSelection", "ctrl shift PAGE_UP", "scrollUpExtendSelection", "ctrl PAGE_UP", "scrollUpChangeLead", "PAGE_DOWN", "scrollDownChangeSelection", "shift PAGE_DOWN", "scrollDownExtendSelection", "ctrl shift PAGE_DOWN", "scrollDownExtendSelection", "ctrl PAGE_DOWN", "scrollDownChangeLead", "HOME", "selectFirst", "shift HOME", "selectFirstExtendSelection", "ctrl shift HOME", "selectFirstExtendSelection", "ctrl HOME", "selectFirstChangeLead", "END", "selectLast", "shift END", "selectLastExtendSelection", "ctrl shift END", "selectLastExtendSelection", "ctrl END", "selectLastChangeLead", "F2", "startEditing", "ctrl A", "selectAll", "ctrl SLASH", "selectAll", "ctrl BACK_SLASH", "clearSelection", "ctrl LEFT", "scrollLeft", "ctrl KP_LEFT", "scrollLeft", "ctrl RIGHT", "scrollRight", "ctrl KP_RIGHT", "scrollRight", "SPACE", "addToSelection", "ctrl SPACE", "toggleAndAnchor", "shift SPACE", "extendTo", "ctrl shift SPACE", "moveSelectionTo"}), "Tree.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "cancel"}), "Table.focusCellHighlightBorder", focusCellHighlightBorder, "Table.scrollPaneBorder", null, "Table.dropLineShortColor", table.get("activeCaptionBorder"), "Table.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"COPY", "copy", "PASTE", "paste", "CUT", "cut", "control INSERT", "copy", "shift INSERT", "paste", "shift DELETE", "cut", "RIGHT", "selectNextColumn", "KP_RIGHT", "selectNextColumn", "shift RIGHT", "selectNextColumnExtendSelection", "shift KP_RIGHT", "selectNextColumnExtendSelection", "ctrl shift RIGHT", "selectNextColumnExtendSelection", "ctrl shift KP_RIGHT", "selectNextColumnExtendSelection", "ctrl RIGHT", "selectNextColumnChangeLead", "ctrl KP_RIGHT", "selectNextColumnChangeLead", "LEFT", "selectPreviousColumn", "KP_LEFT", "selectPreviousColumn", "shift LEFT", "selectPreviousColumnExtendSelection", "shift KP_LEFT", "selectPreviousColumnExtendSelection", "ctrl shift LEFT", "selectPreviousColumnExtendSelection", "ctrl shift KP_LEFT", "selectPreviousColumnExtendSelection", "ctrl LEFT", "selectPreviousColumnChangeLead", "ctrl KP_LEFT", "selectPreviousColumnChangeLead", "DOWN", "selectNextRow", "KP_DOWN", "selectNextRow", "shift DOWN", "selectNextRowExtendSelection", "shift KP_DOWN", "selectNextRowExtendSelection", "ctrl shift DOWN", "selectNextRowExtendSelection", "ctrl shift KP_DOWN", "selectNextRowExtendSelection", "ctrl DOWN", "selectNextRowChangeLead", "ctrl KP_DOWN", "selectNextRowChangeLead", "UP", "selectPreviousRow", "KP_UP", "selectPreviousRow", "shift UP", "selectPreviousRowExtendSelection", "shift KP_UP", "selectPreviousRowExtendSelection", "ctrl shift UP", "selectPreviousRowExtendSelection", "ctrl shift KP_UP", "selectPreviousRowExtendSelection", "ctrl UP", "selectPreviousRowChangeLead", "ctrl KP_UP", "selectPreviousRowChangeLead", "HOME", "selectFirstColumn", "shift HOME", "selectFirstColumnExtendSelection", "ctrl shift HOME", "selectFirstRowExtendSelection", "ctrl HOME", "selectFirstRow", "END", "selectLastColumn", "shift END", "selectLastColumnExtendSelection", "ctrl shift END", "selectLastRowExtendSelection", "ctrl END", "selectLastRow", "PAGE_UP", "scrollUpChangeSelection", "shift PAGE_UP", "scrollUpExtendSelection", "ctrl shift PAGE_UP", "scrollLeftExtendSelection", "ctrl PAGE_UP", "scrollLeftChangeSelection", "PAGE_DOWN", "scrollDownChangeSelection", "shift PAGE_DOWN", "scrollDownExtendSelection", "ctrl shift PAGE_DOWN", "scrollRightExtendSelection", "ctrl PAGE_DOWN", "scrollRightChangeSelection", "TAB", "selectNextColumnCell", "shift TAB", "selectPreviousColumnCell", "ENTER", "selectNextRowCell", "shift ENTER", "selectPreviousRowCell", "ctrl A", "selectAll", "ctrl SLASH", "selectAll", "ctrl BACK_SLASH", "clearSelection", "ESCAPE", "cancel", "F2", "startEditing", "SPACE", "addToSelection", "ctrl SPACE", "toggleAndAnchor", "shift SPACE", "extendTo", "ctrl shift SPACE", "moveSelectionTo", "F8", "focusHeader"}), "FormattedTextField.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "BACK_SPACE", "delete-previous", "shift BACK_SPACE", "delete-previous", "ctrl H", "delete-previous", "DELETE", "delete-next", "ctrl DELETE", "delete-next-word", "ctrl BACK_SPACE", "delete-previous-word", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "ENTER", "notify-field-accept", "ctrl BACK_SLASH", "unselect", "control shift O", "toggle-componentOrientation", "ESCAPE", "reset-field-edit", "UP", "increment", "KP_UP", "increment", "DOWN", "decrement", "KP_DOWN", "decrement"}), "ToolBar.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"UP", "navigateUp", "KP_UP", "navigateUp", "DOWN", "navigateDown", "KP_DOWN", "navigateDown", "LEFT", "navigateLeft", "KP_LEFT", "navigateLeft", "RIGHT", "navigateRight", "KP_RIGHT", "navigateRight"}), "ComboBox.control", table.get("control"), "ComboBox.controlForeground", black, "ComboBox.background", table.get("window"), "ComboBox.foreground", black, "ComboBox.border", comboBoxBorder, "ComboBox.selectionBackground", black, "ComboBox.selectionForeground", table.get("text"), "ComboBox.disabledBackground", table.get("control"), "ComboBox.disabledForeground", table.get("textInactiveText"), "ComboBox.font", dialogPlain12, "ComboBox.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "hidePopup", "PAGE_UP", "pageUpPassThrough", "PAGE_DOWN", "pageDownPassThrough", "HOME", "homePassThrough", "END", "endPassThrough", "DOWN", "selectNext", "KP_DOWN", "selectNext", "UP", "selectPrevious", "KP_UP", "selectPrevious", "SPACE", "spacePopup", "ENTER", "enterPressed"}), "TextField.caretForeground", black, "TextField.caretBlinkRate", 500, "TextField.inactiveForeground", table.get("textInactiveText"), "TextField.selectionBackground", table.get("textHighlight"), "TextField.selectionForeground", table.get("textHighlightText"), "TextField.background", table.get("window"), "TextField.foreground", table.get("textText"), "TextField.font", sansSerifPlain12, "TextField.border", textFieldBorder, "TextField.focusInputMap", fieldInputMap, "PasswordField.caretForeground", black, "PasswordField.caretBlinkRate", 500, "PasswordField.inactiveForeground", table.get("textInactiveText"), "PasswordField.selectionBackground", table.get("textHighlight"), "PasswordField.selectionForeground", table.get("textHighlightText"), "PasswordField.background", table.get("window"), "PasswordField.foreground", table.get("textText"), "PasswordField.font", monospacedPlain12, "PasswordField.border", textFieldBorder, "PasswordField.focusInputMap", passwordInputMap, "TextArea.caretForeground", black, "TextArea.caretBlinkRate", 500, "TextArea.inactiveForeground", table.get("textInactiveText"), "TextArea.selectionBackground", table.get("textHighlight"), "TextArea.selectionForeground", table.get("textHighlightText"), "TextArea.background", table.get("window"), "TextArea.foreground", table.get("textText"), "TextArea.font", monospacedPlain12, "TextArea.border", marginBorder, "TextArea.focusInputMap", multilineInputMap, "TextPane.caretForeground", black, "TextPane.caretBlinkRate", 500, "TextPane.inactiveForeground", table.get("textInactiveText"), "TextPane.selectionBackground", lightGray, "TextPane.selectionForeground", table.get("textHighlightText"), "TextPane.background", white, "TextPane.foreground", table.get("textText"), "TextPane.font", serifPlain12, "TextPane.border", marginBorder, "TextPane.focusInputMap", multilineInputMap, "EditorPane.caretForeground", red, "EditorPane.caretBlinkRate", 500, "EditorPane.inactiveForeground", table.get("textInactiveText"), "EditorPane.selectionBackground", lightGray, "EditorPane.selectionForeground", table.get("textHighlightText"), "EditorPane.background", white, "EditorPane.foreground", table.get("textText"), "EditorPane.font", serifPlain12, "EditorPane.border", marginBorder, "EditorPane.focusInputMap", multilineInputMap, "FileChooser.pathLabelMnemonic", new Integer(80), "FileChooser.filterLabelMnemonic", new Integer(82), "FileChooser.foldersLabelMnemonic", new Integer(76), "FileChooser.filesLabelMnemonic", new Integer(73), "FileChooser.enterFileNameLabelMnemonic", new Integer(78), "FileChooser.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "cancelSelection"}), "ToolTip.border", raisedBevelBorder, "ToolTip.background", table.get("info"), "ToolTip.foreground", table.get("infoText"), "PopupMenu.selectedWindowInputMapBindings", new Object[]{"ESCAPE", "cancel", "TAB", "cancel", "shift TAB", "cancel", "DOWN", "selectNext", "KP_DOWN", "selectNext", "UP", "selectPrevious", "KP_UP", "selectPrevious", "LEFT", "selectParent", "KP_LEFT", "selectParent", "RIGHT", "selectChild", "KP_RIGHT", "selectChild", "ENTER", "return", "SPACE", "return"}, "OptionPane.border", optionPaneBorder, "OptionPane.messageAreaBorder", optionPaneMessageAreaBorder, "OptionPane.buttonAreaBorder", optionPaneButtonAreaBorder, "OptionPane.errorIcon", SwingUtilities2.makeIcon(this.getClass(), MotifLookAndFeel.class, "icons/Error.gif"), "OptionPane.informationIcon", SwingUtilities2.makeIcon(this.getClass(), MotifLookAndFeel.class, "icons/Inform.gif"), "OptionPane.warningIcon", SwingUtilities2.makeIcon(this.getClass(), MotifLookAndFeel.class, "icons/Warn.gif"), "OptionPane.questionIcon", SwingUtilities2.makeIcon(this.getClass(), MotifLookAndFeel.class, "icons/Question.gif"), "OptionPane.windowBindings", new Object[]{"ESCAPE", "close"}, "RootPane.defaultButtonWindowKeyBindings", new Object[]{"ENTER", "press", "released ENTER", "release", "ctrl ENTER", "press", "ctrl released ENTER", "release"}};
        table.putDefaults(defaults);
    }
}

