/*
 * Decompiled with CFR 0.152.
 */
package org.classpath.icedtea.pulseaudio;

import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import org.classpath.icedtea.pulseaudio.Debug;
import org.classpath.icedtea.pulseaudio.Operation;
import org.classpath.icedtea.pulseaudio.PulseAudioDataLine;
import org.classpath.icedtea.pulseaudio.PulseAudioMixer;
import org.classpath.icedtea.pulseaudio.PulseAudioPlaybackLine;
import org.classpath.icedtea.pulseaudio.PulseAudioVolumeControl;
import org.classpath.icedtea.pulseaudio.Stream;
import org.classpath.icedtea.pulseaudio.StreamBufferAttributes;

public final class PulseAudioClip
extends PulseAudioDataLine
implements Clip,
PulseAudioPlaybackLine {
    private byte[] data = null;
    private int currentFrame = 0;
    private int frameCount = 0;
    private int startFrame = 0;
    private int endFrame = 0;
    public static final String DEFAULT_CLIP_NAME = "Audio Clip";
    private Object clipLock = new Object();
    private int loopsLeft = 0;
    private ClipThread clipThread;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFrames(int startingFrame, int lastFrame) {
        Stream.WriteListener writeListener = new Stream.WriteListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void update() {
                Object object = PulseAudioClip.this.eventLoop.threadLock;
                synchronized (object) {
                    PulseAudioClip.this.eventLoop.threadLock.notifyAll();
                }
            }
        };
        this.stream.addWriteListener(writeListener);
        Debug.println(Debug.DebugLevel.Verbose, "PulseAudioClip$ClipThread.writeFrames(): Writing");
        int remainingFrames = lastFrame - startingFrame - 1;
        while (remainingFrames > 0) {
            Object object = this.eventLoop.threadLock;
            synchronized (object) {
                int availableSize;
                do {
                    if ((availableSize = this.stream.getWritableSize()) < 0) {
                        Thread.currentThread().interrupt();
                        this.stream.removeWriteListener(writeListener);
                        return;
                    }
                    if (availableSize != 0) continue;
                    try {
                        this.eventLoop.threadLock.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        this.stream.removeWriteListener(writeListener);
                        return;
                    }
                } while (availableSize == 0);
                int framesToWrite = Math.min(remainingFrames, availableSize / this.getFormat().getFrameSize());
                this.stream.write(this.data, this.currentFrame * this.getFormat().getFrameSize(), framesToWrite * this.getFormat().getFrameSize());
                remainingFrames -= framesToWrite;
                this.currentFrame += framesToWrite;
                this.framesSinceOpen += (long)framesToWrite;
                if (Thread.interrupted()) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
        this.stream.removeWriteListener(writeListener);
    }

    PulseAudioClip(AudioFormat[] formats, AudioFormat defaultFormat) {
        this.supportedFormats = formats;
        this.defaultFormat = defaultFormat;
        this.currentFormat = defaultFormat;
        this.streamName = DEFAULT_CLIP_NAME;
        this.clipThread = new ClipThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void connectLine(int bufferSize, Stream masterStream) throws LineUnavailableException {
        StreamBufferAttributes bufferAttributes = new StreamBufferAttributes(bufferSize, bufferSize / 4, bufferSize / 8, bufferSize / 10 > 100 ? bufferSize / 10 : 100, 0);
        if (masterStream != null) {
            Object object = this.eventLoop.threadLock;
            synchronized (object) {
                this.stream.connectForPlayback(Stream.DEFAULT_DEVICE, bufferAttributes, masterStream.getStreamPointer());
            }
        }
        Object object = this.eventLoop.threadLock;
        synchronized (object) {
            this.stream.connectForPlayback(Stream.DEFAULT_DEVICE, bufferAttributes, null);
        }
    }

    @Override
    public int available() {
        return 0;
    }

    @Override
    public void close() {
        if (!this.isOpen) {
            throw new IllegalStateException("line already closed");
        }
        this.clipThread.interrupt();
        try {
            this.clipThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.currentFrame = 0;
        this.framesSinceOpen = 0L;
        PulseAudioMixer mixer = PulseAudioMixer.getInstance();
        mixer.removeSourceLine(this);
        super.close();
        Debug.println(Debug.DebugLevel.Verbose, "PulseAudioClip.close(): Clip closed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drain() {
        Operation operation;
        if (!this.isOpen) {
            throw new IllegalStateException("line not open");
        }
        while (this.clipThread != null && this.clipThread.isAlive()) {
            try {
                this.clipThread.join();
            }
            catch (InterruptedException e) {}
        }
        Object object = this.eventLoop.threadLock;
        synchronized (object) {
            operation = this.stream.drain();
        }
        operation.waitForCompletion();
        operation.releaseReference();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        Operation operation;
        if (!this.isOpen) {
            throw new IllegalStateException("line not open");
        }
        Object object = this.eventLoop.threadLock;
        synchronized (object) {
            operation = this.stream.flush();
            operation.waitForCompletion();
        }
        operation.releaseReference();
    }

    @Override
    public int getFrameLength() {
        if (!this.isOpen) {
            return -1;
        }
        return this.frameCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFramePosition() {
        if (!this.isOpen) {
            throw new IllegalStateException("Line not open");
        }
        Object object = this.clipLock;
        synchronized (object) {
            return (int)this.framesSinceOpen;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLongFramePosition() {
        if (!this.isOpen) {
            throw new IllegalStateException("Line not open");
        }
        Object object = this.clipLock;
        synchronized (object) {
            return this.framesSinceOpen;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMicrosecondLength() {
        if (!this.isOpen) {
            return -1L;
        }
        Object object = this.clipLock;
        synchronized (object) {
            return (long)((float)this.frameCount / this.currentFormat.getFrameRate() * 1000000.0f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMicrosecondPosition() {
        if (!this.isOpen) {
            throw new IllegalStateException("Line not open");
        }
        Object object = this.clipLock;
        synchronized (object) {
            return (long)((float)this.framesSinceOpen / this.currentFormat.getFrameRate() * 1000000.0f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loop(int count) {
        if (!this.isOpen) {
            throw new IllegalStateException("Line not open");
        }
        if (count < 0 && count != -1) {
            throw new IllegalArgumentException("invalid value for count:" + count);
        }
        if (this.clipThread.isAlive() && count != 0) {
            return;
        }
        super.start();
        Object object = this.clipLock;
        synchronized (object) {
            this.loopsLeft = this.currentFrame > this.endFrame ? 0 : count;
        }
        if (!this.clipThread.isAlive()) {
            this.clipThread = new ClipThread();
            this.clipThread.start();
        }
    }

    @Override
    public void open() throws LineUnavailableException {
        throw new IllegalArgumentException("open() on a Clip is not allowed");
    }

    @Override
    public void open(AudioFormat format, byte[] data, int offset, int bufferSize) throws LineUnavailableException {
        super.open(format);
        this.data = new byte[bufferSize];
        System.arraycopy(data, offset, this.data, 0, bufferSize);
        this.frameCount = bufferSize / format.getFrameSize();
        this.currentFrame = 0;
        this.framesSinceOpen = 0L;
        this.startFrame = 0;
        this.endFrame = this.frameCount - 1;
        this.loopsLeft = 0;
        PulseAudioVolumeControl volumeControl = new PulseAudioVolumeControl(this, this.eventLoop);
        this.controls.add(volumeControl);
        PulseAudioMixer mixer = PulseAudioMixer.getInstance();
        mixer.addSourceLine(this);
        this.isOpen = true;
        Debug.println(Debug.DebugLevel.Verbose, "PulseAudioClip.open(): Clip opened");
    }

    @Override
    public byte[] native_set_volume(float value) {
        return this.stream.native_set_volume(value);
    }

    @Override
    public byte[] native_update_volume() {
        return this.stream.native_update_volume();
    }

    @Override
    public float getCachedVolume() {
        return this.stream.getCachedVolume();
    }

    @Override
    public void setCachedVolume(float value) {
        this.stream.setCachedVolume(value);
    }

    @Override
    public void open(AudioInputStream stream) throws LineUnavailableException, IOException {
        byte[] buffer = new byte[(int)(stream.getFrameLength() * (long)stream.getFormat().getFrameSize())];
        stream.read(buffer, 0, buffer.length);
        this.open(stream.getFormat(), buffer, 0, buffer.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFramePosition(int frames) {
        if (!this.isOpen) {
            throw new IllegalStateException("Line not open");
        }
        if (frames < 0 || frames > this.frameCount) {
            throw new IllegalArgumentException("incorreft frame value");
        }
        Object object = this.clipLock;
        synchronized (object) {
            this.currentFrame = frames;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLoopPoints(int start, int end) {
        if (!this.isOpen) {
            throw new IllegalStateException("Line not open");
        }
        if (end == -1) {
            end = this.frameCount - 1;
        }
        if (end < start) {
            throw new IllegalArgumentException("ending point must be greater than or equal to the starting point");
        }
        if (start < 0) {
            throw new IllegalArgumentException("starting point must be greater than or equal to 0");
        }
        Object object = this.clipLock;
        synchronized (object) {
            this.startFrame = start;
            this.endFrame = end;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMicrosecondPosition(long microseconds) {
        float frameIndex;
        if (!this.isOpen) {
            throw new IllegalStateException("Line not open");
        }
        for (frameIndex = (float)microseconds * this.currentFormat.getFrameRate() / 1000000.0f; frameIndex < 0.0f; frameIndex += (float)this.frameCount) {
        }
        frameIndex %= (float)this.frameCount;
        Object object = this.clipLock;
        synchronized (object) {
            this.currentFrame = (int)frameIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (this.isStarted) {
            return;
        }
        super.start();
        if (!this.clipThread.isAlive()) {
            Object object = this.clipLock;
            synchronized (object) {
                this.loopsLeft = 0;
            }
            this.clipThread = new ClipThread();
            this.clipThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (!this.isOpen) {
            throw new IllegalStateException("Line not open");
        }
        if (!this.isStarted) {
            return;
        }
        if (this.clipThread.isAlive()) {
            this.clipThread.interrupt();
        }
        try {
            this.clipThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Object object = this.clipLock;
        synchronized (object) {
            this.loopsLeft = 0;
        }
        super.stop();
    }

    @Override
    public Line.Info getLineInfo() {
        return new DataLine.Info(Clip.class, this.supportedFormats, 0, 1000000);
    }

    private final class ClipThread
    extends Thread {
        private ClipThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Operation operation;
            while (true) {
                PulseAudioClip.this.writeFrames(PulseAudioClip.this.currentFrame, PulseAudioClip.this.endFrame + 1);
                if (Thread.interrupted()) break;
                if (PulseAudioClip.this.loopsLeft == 0) {
                    PulseAudioClip.this.writeFrames(PulseAudioClip.this.endFrame, PulseAudioClip.this.getFrameLength());
                    break;
                }
                Object object = PulseAudioClip.this.clipLock;
                synchronized (object) {
                    PulseAudioClip.this.currentFrame = PulseAudioClip.this.startFrame;
                    if (PulseAudioClip.this.loopsLeft != Integer.MIN_VALUE) {
                        PulseAudioClip.this.loopsLeft--;
                    }
                }
            }
            Object object = PulseAudioClip.this.eventLoop.threadLock;
            synchronized (object) {
                operation = PulseAudioClip.this.stream.drain();
            }
            operation.waitForCompletion();
            operation.releaseReference();
        }
    }
}

