/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.text.View;
import sun.tools.jconsole.VMPanel;

public final class SheetDialog {
    private static Rectangle iconR = new Rectangle();
    private static Rectangle textR = new Rectangle();
    private static Rectangle viewR = new Rectangle();
    private static Insets viewInsets = new Insets(0, 0, 0, 0);

    private SheetDialog() {
    }

    static JOptionPane showOptionDialog(VMPanel vmPanel, Object message, int optionType, int messageType, Icon icon, Object[] options, Object initialValue) {
        JRootPane rootPane = SwingUtilities.getRootPane(vmPanel);
        JPanel glassPane = (JPanel)rootPane.getGlassPane();
        if (!(glassPane instanceof SlideAndFadeGlassPane)) {
            glassPane = new SlideAndFadeGlassPane();
            glassPane.setName(rootPane.getName() + ".glassPane");
            rootPane.setGlassPane(glassPane);
            rootPane.revalidate();
        }
        final SlideAndFadeGlassPane safGlassPane = (SlideAndFadeGlassPane)glassPane;
        message = SheetDialog.fixWrapping(message, rootPane.getWidth() - 75);
        final SheetOptionPane optionPane = new SheetOptionPane(message, messageType, optionType, icon, options, initialValue);
        optionPane.setComponentOrientation(vmPanel.getComponentOrientation());
        optionPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (event.getPropertyName().equals("value") && event.getNewValue() != null && event.getNewValue() != JOptionPane.UNINITIALIZED_VALUE) {
                    ((SlideAndFadeGlassPane)optionPane.getParent()).hide(optionPane);
                }
            }
        });
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                safGlassPane.show(optionPane);
            }
        });
        return optionPane;
    }

    private static Object fixWrapping(Object message, final int maxWidth) {
        if (message instanceof Object[]) {
            Object[] arr = (Object[])message;
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = SheetDialog.fixWrapping(arr[i], maxWidth);
            }
        } else if (message instanceof String && ((String)message).startsWith("<html>")) {
            message = new JLabel((String)message){

                @Override
                public Dimension getPreferredSize() {
                    String text = this.getText();
                    Insets insets = this.getInsets(viewInsets);
                    FontMetrics fm = this.getFontMetrics(this.getFont());
                    Dimension pref = super.getPreferredSize();
                    Dimension min = this.getMinimumSize();
                    iconR.height = 0;
                    iconR.width = 0;
                    iconR.y = 0;
                    iconR.x = 0;
                    textR.height = 0;
                    textR.width = 0;
                    textR.y = 0;
                    textR.x = 0;
                    int dx = insets.left + insets.right;
                    int dy = insets.top + insets.bottom;
                    viewR.x = dx;
                    viewR.y = dy;
                    viewR.height = Short.MAX_VALUE;
                    viewR.width = Short.MAX_VALUE;
                    View v = (View)this.getClientProperty("html");
                    if (v != null) {
                        int w = Math.min(maxWidth, Math.min(pref.width, Math.max(min.width, 300)));
                        v.setSize(w, 0.0f);
                        SwingUtilities.layoutCompoundLabel(this, fm, text, null, this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getVerticalTextPosition(), this.getHorizontalTextPosition(), viewR, iconR, textR, this.getIconTextGap());
                        return new Dimension(textR.width + dx, textR.height + dy);
                    }
                    return pref;
                }
            };
        }
        return message;
    }

    static class SheetOptionPane
    extends JOptionPane {
        private static Composite comp = AlphaComposite.getInstance(3, 0.8f);
        private static Color bgColor = new Color(241, 239, 239);

        SheetOptionPane(Object message, int messageType, int optionType, Icon icon, Object[] options, Object initialValue) {
            super(message, messageType, optionType, icon, options, initialValue);
            this.setBorder(new CompoundBorder(new LineBorder(new Color(204, 204, 204), 1), new EmptyBorder(4, 4, 4, 4)));
        }

        @Override
        public void setVisible(boolean visible) {
            SlideAndFadeGlassPane glassPane = (SlideAndFadeGlassPane)this.getParent();
            if (glassPane != null) {
                if (visible) {
                    glassPane.show(this);
                } else {
                    glassPane.hide(this);
                }
            }
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            Composite oldComp = g2d.getComposite();
            g2d.setComposite(comp);
            Color oldColor = g2d.getColor();
            g2d.setColor(bgColor);
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
            g2d.setColor(oldColor);
            g2d.setComposite(oldComp);
            super.paint(g);
        }
    }

    private static class SlideAndFadeGlassPane
    extends JPanel {
        SheetOptionPane optionPane;
        int fade = 20;
        boolean slideIn = true;

        SlideAndFadeGlassPane() {
            super(null);
            this.setVisible(false);
            this.setOpaque(false);
            this.addMouseListener(new MouseAdapter(){});
        }

        public void show(SheetOptionPane optionPane) {
            this.optionPane = optionPane;
            this.removeAll();
            this.add(optionPane);
            this.setVisible(true);
            this.slideIn = true;
            this.revalidate();
            this.repaint();
            this.doSlide();
        }

        public void hide(SheetOptionPane optionPane) {
            if (optionPane != this.optionPane) {
                return;
            }
            this.slideIn = false;
            this.revalidate();
            this.repaint();
            this.doSlide();
        }

        private void doSlide() {
            int glassPaneWidth;
            if (this.optionPane.getParent() == null) {
                return;
            }
            if (this.optionPane.getWidth() == 0) {
                this.optionPane.setSize(this.optionPane.getPreferredSize());
            }
            if ((glassPaneWidth = this.getWidth()) == 0 && this.getParent() != null) {
                glassPaneWidth = this.getParent().getWidth();
            }
            int x = (glassPaneWidth - this.optionPane.getWidth()) / 2;
            if (!this.slideIn) {
                this.remove(this.optionPane);
                this.setVisible(false);
                return;
            }
            this.optionPane.setLocation(x, 0);
            this.setGrayLevel(this.fade);
        }

        public void setGrayLevel(int gray) {
            gray = gray * 255 / 100;
            this.setBackground(new Color(0, 0, 0, gray));
        }

        @Override
        public void paint(Graphics g) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            super.paint(g);
        }
    }
}

