/*
 * Decompiled with CFR 0.152.
 */
package sun.swing.text;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.BorderFactory;
import javax.swing.CellRendererPane;
import javax.swing.JEditorPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import sun.font.FontDesignMetrics;
import sun.swing.text.CompoundPrintable;
import sun.swing.text.CountingPrintable;
import sun.swing.text.html.FrameEditorPaneTag;

public class TextComponentPrintable
implements CountingPrintable {
    private static final int LIST_SIZE = 1000;
    private boolean isLayouted = false;
    private final JTextComponent textComponentToPrint;
    private final AtomicReference<FontRenderContext> frc = new AtomicReference<Object>(null);
    private final JTextComponent printShell;
    private final MessageFormat headerFormat;
    private final MessageFormat footerFormat;
    private static final float HEADER_FONT_SIZE = 18.0f;
    private static final float FOOTER_FONT_SIZE = 12.0f;
    private final Font headerFont;
    private final Font footerFont;
    private final List<IntegerSegment> rowsMetrics;
    private final List<IntegerSegment> pagesMetrics;
    private boolean needReadLock = false;

    public static Printable getPrintable(JTextComponent textComponent, MessageFormat headerFormat, MessageFormat footerFormat) {
        if (textComponent instanceof JEditorPane && TextComponentPrintable.isFrameSetDocument(textComponent.getDocument())) {
            List<JEditorPane> frames = TextComponentPrintable.getFrames((JEditorPane)textComponent);
            ArrayList<CountingPrintable> printables = new ArrayList<CountingPrintable>();
            for (JEditorPane frame : frames) {
                printables.add((CountingPrintable)TextComponentPrintable.getPrintable(frame, headerFormat, footerFormat));
            }
            return new CompoundPrintable(printables);
        }
        return new TextComponentPrintable(textComponent, headerFormat, footerFormat);
    }

    private static boolean isFrameSetDocument(Document document) {
        HTMLDocument htmlDocument;
        boolean ret = false;
        if (document instanceof HTMLDocument && (htmlDocument = (HTMLDocument)document).getIterator(HTML.Tag.FRAME).isValid()) {
            ret = true;
        }
        return ret;
    }

    private static List<JEditorPane> getFrames(JEditorPane editor) {
        ArrayList<JEditorPane> list = new ArrayList<JEditorPane>();
        TextComponentPrintable.getFrames(editor, list);
        if (list.size() == 0) {
            TextComponentPrintable.createFrames(editor);
            TextComponentPrintable.getFrames(editor, list);
        }
        return list;
    }

    private static void getFrames(Container container, List<JEditorPane> list) {
        for (Component c : container.getComponents()) {
            if (c instanceof FrameEditorPaneTag && c instanceof JEditorPane) {
                list.add((JEditorPane)c);
                continue;
            }
            if (!(c instanceof Container)) continue;
            TextComponentPrintable.getFrames((Container)c, list);
        }
    }

    private static void createFrames(final JEditorPane editor) {
        Runnable doCreateFrames = new Runnable(){

            @Override
            public void run() {
                int WIDTH = 500;
                int HEIGHT = 500;
                CellRendererPane rendererPane = new CellRendererPane();
                rendererPane.add(editor);
                rendererPane.setSize(500, 500);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            doCreateFrames.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(doCreateFrames);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }
    }

    private TextComponentPrintable(JTextComponent textComponent, MessageFormat headerFormat, MessageFormat footerFormat) {
        this.textComponentToPrint = textComponent;
        this.headerFormat = headerFormat;
        this.footerFormat = footerFormat;
        this.headerFont = textComponent.getFont().deriveFont(1, 18.0f);
        this.footerFont = textComponent.getFont().deriveFont(0, 12.0f);
        this.pagesMetrics = Collections.synchronizedList(new ArrayList());
        this.rowsMetrics = new ArrayList<IntegerSegment>(1000);
        this.printShell = this.createPrintShell(textComponent);
    }

    private JTextComponent createPrintShell(final JTextComponent textComponent) {
        if (SwingUtilities.isEventDispatchThread()) {
            return this.createPrintShellOnEDT(textComponent);
        }
        FutureTask<JTextComponent> futureCreateShell = new FutureTask<JTextComponent>(new Callable<JTextComponent>(){

            @Override
            public JTextComponent call() throws Exception {
                return TextComponentPrintable.this.createPrintShellOnEDT(textComponent);
            }
        });
        SwingUtilities.invokeLater(futureCreateShell);
        try {
            return futureCreateShell.get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new AssertionError((Object)cause);
        }
    }

    private JTextComponent createPrintShellOnEDT(final JTextComponent textComponent) {
        assert (SwingUtilities.isEventDispatchThread());
        JTextComponent ret = null;
        if (textComponent instanceof JTextField) {
            ret = new JTextField(){
                {
                    this.setHorizontalAlignment(((JTextField)textComponent).getHorizontalAlignment());
                }

                @Override
                public FontMetrics getFontMetrics(Font font) {
                    return TextComponentPrintable.this.frc.get() == null ? super.getFontMetrics(font) : FontDesignMetrics.getMetrics(font, (FontRenderContext)TextComponentPrintable.this.frc.get());
                }
            };
        } else if (textComponent instanceof JTextArea) {
            ret = new JTextArea(){
                {
                    JTextArea textArea = (JTextArea)textComponent;
                    this.setLineWrap(textArea.getLineWrap());
                    this.setWrapStyleWord(textArea.getWrapStyleWord());
                    this.setTabSize(textArea.getTabSize());
                }

                @Override
                public FontMetrics getFontMetrics(Font font) {
                    return TextComponentPrintable.this.frc.get() == null ? super.getFontMetrics(font) : FontDesignMetrics.getMetrics(font, (FontRenderContext)TextComponentPrintable.this.frc.get());
                }
            };
        } else if (textComponent instanceof JTextPane) {
            ret = new JTextPane(){

                @Override
                public FontMetrics getFontMetrics(Font font) {
                    return TextComponentPrintable.this.frc.get() == null ? super.getFontMetrics(font) : FontDesignMetrics.getMetrics(font, (FontRenderContext)TextComponentPrintable.this.frc.get());
                }

                @Override
                public EditorKit getEditorKit() {
                    if (this.getDocument() == textComponent.getDocument()) {
                        return ((JTextPane)textComponent).getEditorKit();
                    }
                    return super.getEditorKit();
                }
            };
        } else if (textComponent instanceof JEditorPane) {
            ret = new JEditorPane(){

                @Override
                public FontMetrics getFontMetrics(Font font) {
                    return TextComponentPrintable.this.frc.get() == null ? super.getFontMetrics(font) : FontDesignMetrics.getMetrics(font, (FontRenderContext)TextComponentPrintable.this.frc.get());
                }

                @Override
                public EditorKit getEditorKit() {
                    if (this.getDocument() == textComponent.getDocument()) {
                        return ((JEditorPane)textComponent).getEditorKit();
                    }
                    return super.getEditorKit();
                }
            };
        }
        ret.setBorder(null);
        ret.setOpaque(textComponent.isOpaque());
        ret.setEditable(textComponent.isEditable());
        ret.setEnabled(textComponent.isEnabled());
        ret.setFont(textComponent.getFont());
        ret.setBackground(textComponent.getBackground());
        ret.setForeground(textComponent.getForeground());
        ret.setComponentOrientation(textComponent.getComponentOrientation());
        if (ret instanceof JEditorPane) {
            ret.putClientProperty("JEditorPane.honorDisplayProperties", textComponent.getClientProperty("JEditorPane.honorDisplayProperties"));
            ret.putClientProperty("JEditorPane.w3cLengthUnits", textComponent.getClientProperty("JEditorPane.w3cLengthUnits"));
            ret.putClientProperty("charset", textComponent.getClientProperty("charset"));
        }
        ret.setDocument(textComponent.getDocument());
        return ret;
    }

    @Override
    public int getNumberOfPages() {
        return this.pagesMetrics.size();
    }

    @Override
    public int print(final Graphics graphics, final PageFormat pf, final int pageIndex) throws PrinterException {
        int ret;
        if (!this.isLayouted) {
            if (graphics instanceof Graphics2D) {
                this.frc.set(((Graphics2D)graphics).getFontRenderContext());
            }
            this.layout((int)Math.floor(pf.getImageableWidth()));
            this.calculateRowsMetrics();
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            Callable<Integer> doPrintOnEDT = new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return TextComponentPrintable.this.printOnEDT(graphics, pf, pageIndex);
                }
            };
            FutureTask<Integer> futurePrintOnEDT = new FutureTask<Integer>(doPrintOnEDT);
            SwingUtilities.invokeLater(futurePrintOnEDT);
            try {
                ret = futurePrintOnEDT.get();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof PrinterException) {
                    throw (PrinterException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                throw new RuntimeException(cause);
            }
        } else {
            ret = this.printOnEDT(graphics, pf, pageIndex);
        }
        return ret;
    }

    private int printOnEDT(Graphics graphics, PageFormat pf, int pageIndex) throws PrinterException {
        assert (SwingUtilities.isEventDispatchThread());
        Border border = BorderFactory.createEmptyBorder();
        if (this.headerFormat != null || this.footerFormat != null) {
            Object[] formatArg = new Object[]{pageIndex + 1};
            if (this.headerFormat != null) {
                border = new TitledBorder(border, this.headerFormat.format(formatArg), 2, 1, this.headerFont, this.printShell.getForeground());
            }
            if (this.footerFormat != null) {
                border = new TitledBorder(border, this.footerFormat.format(formatArg), 2, 6, this.footerFont, this.printShell.getForeground());
            }
        }
        Insets borderInsets = border.getBorderInsets(this.printShell);
        this.updatePagesMetrics(pageIndex, (int)Math.floor(pf.getImageableHeight()) - borderInsets.top - borderInsets.bottom);
        if (this.pagesMetrics.size() <= pageIndex) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)graphics.create();
        g2d.translate(pf.getImageableX(), pf.getImageableY());
        border.paintBorder(this.printShell, g2d, 0, 0, (int)Math.floor(pf.getImageableWidth()), (int)Math.floor(pf.getImageableHeight()));
        g2d.translate(0, borderInsets.top);
        Rectangle clip = new Rectangle(0, 0, (int)pf.getWidth(), this.pagesMetrics.get((int)pageIndex).end - this.pagesMetrics.get((int)pageIndex).start + 1);
        g2d.clip(clip);
        int xStart = 0;
        if (ComponentOrientation.RIGHT_TO_LEFT == this.printShell.getComponentOrientation()) {
            xStart = (int)pf.getImageableWidth() - this.printShell.getWidth();
        }
        g2d.translate(xStart, -this.pagesMetrics.get((int)pageIndex).start);
        this.printShell.print(g2d);
        g2d.dispose();
        return 0;
    }

    private void releaseReadLock() {
        assert (!SwingUtilities.isEventDispatchThread());
        Document document = this.textComponentToPrint.getDocument();
        if (document instanceof AbstractDocument) {
            try {
                ((AbstractDocument)document).readUnlock();
                this.needReadLock = true;
            }
            catch (Error error) {
                // empty catch block
            }
        }
    }

    private void acquireReadLock() {
        assert (!SwingUtilities.isEventDispatchThread());
        if (this.needReadLock) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                    }
                });
            }
            catch (InterruptedException ignore) {
            }
            catch (InvocationTargetException ignore) {
                // empty catch block
            }
            Document document = this.textComponentToPrint.getDocument();
            ((AbstractDocument)document).readLock();
            this.needReadLock = false;
        }
    }

    private void layout(final int width) {
        if (!SwingUtilities.isEventDispatchThread()) {
            Callable<Object> doLayoutOnEDT = new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    TextComponentPrintable.this.layoutOnEDT(width);
                    return null;
                }
            };
            FutureTask<Object> futureLayoutOnEDT = new FutureTask<Object>(doLayoutOnEDT);
            this.releaseReadLock();
            SwingUtilities.invokeLater(futureLayoutOnEDT);
            try {
                futureLayoutOnEDT.get();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                throw new RuntimeException(cause);
            }
            finally {
                this.acquireReadLock();
            }
        } else {
            this.layoutOnEDT(width);
        }
        this.isLayouted = true;
    }

    private void layoutOnEDT(int width) {
        assert (SwingUtilities.isEventDispatchThread());
        int HUGE_INTEGER = 2147482647;
        CellRendererPane rendererPane = new CellRendererPane();
        JViewport viewport = new JViewport();
        viewport.setBorder(null);
        Dimension size = new Dimension(width, 2147482647);
        if (this.printShell instanceof JTextField) {
            size = new Dimension(size.width, this.printShell.getPreferredSize().height);
        }
        this.printShell.setSize(size);
        viewport.setComponentOrientation(this.printShell.getComponentOrientation());
        viewport.setSize(size);
        viewport.add(this.printShell);
        rendererPane.add(viewport);
    }

    private void updatePagesMetrics(int pageIndex, int pageHeight) {
        while (pageIndex >= this.pagesMetrics.size() && !this.rowsMetrics.isEmpty()) {
            int rowIndex;
            int lastPage = this.pagesMetrics.size() - 1;
            int pageStart = lastPage >= 0 ? this.pagesMetrics.get((int)lastPage).end + 1 : 0;
            for (rowIndex = 0; rowIndex < this.rowsMetrics.size() && this.rowsMetrics.get((int)rowIndex).end - pageStart + 1 <= pageHeight; ++rowIndex) {
            }
            if (rowIndex == 0) {
                this.pagesMetrics.add(new IntegerSegment(pageStart, pageStart + pageHeight - 1));
                continue;
            }
            this.pagesMetrics.add(new IntegerSegment(pageStart, this.rowsMetrics.get((int)(--rowIndex)).end));
            for (int i = 0; i <= rowIndex; ++i) {
                this.rowsMetrics.remove(0);
            }
        }
    }

    private void calculateRowsMetrics() {
        int documentLength = this.printShell.getDocument().getLength();
        ArrayList<IntegerSegment> documentMetrics = new ArrayList<IntegerSegment>(1000);
        int previousY = -1;
        int previousHeight = -1;
        for (int i = 0; i < documentLength; ++i) {
            try {
                Rectangle rect = this.printShell.modelToView(i);
                if (rect == null) continue;
                int y = (int)rect.getY();
                int height = (int)rect.getHeight();
                if (height == 0 || y == previousY && height == previousHeight) continue;
                previousY = y;
                previousHeight = height;
                documentMetrics.add(new IntegerSegment(y, y + height - 1));
                continue;
            }
            catch (BadLocationException e) {
                assert (false);
                continue;
            }
        }
        Collections.sort(documentMetrics);
        int yStart = Integer.MIN_VALUE;
        int yEnd = Integer.MIN_VALUE;
        for (IntegerSegment segment : documentMetrics) {
            if (yEnd < segment.start) {
                if (yEnd != Integer.MIN_VALUE) {
                    this.rowsMetrics.add(new IntegerSegment(yStart, yEnd));
                }
                yStart = segment.start;
                yEnd = segment.end;
                continue;
            }
            yEnd = segment.end;
        }
        if (yEnd != Integer.MIN_VALUE) {
            this.rowsMetrics.add(new IntegerSegment(yStart, yEnd));
        }
    }

    private static class IntegerSegment
    implements Comparable<IntegerSegment> {
        final int start;
        final int end;

        IntegerSegment(int start, int end) {
            this.start = start;
            this.end = end;
        }

        @Override
        public int compareTo(IntegerSegment object) {
            int startsDelta = this.start - object.start;
            return startsDelta != 0 ? startsDelta : this.end - object.end;
        }

        public boolean equals(Object obj) {
            if (obj instanceof IntegerSegment) {
                return this.compareTo((IntegerSegment)obj) == 0;
            }
            return false;
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + this.start;
            result = 37 * result + this.end;
            return result;
        }

        public String toString() {
            return "IntegerSegment [" + this.start + ", " + this.end + "]";
        }
    }
}

