/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Vector;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.EncryptedData;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.Realm;
import sun.security.krb5.RealmException;
import sun.security.krb5.internal.HostAddresses;
import sun.security.krb5.internal.KDCOptions;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.Ticket;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class KDCReqBody {
    public KDCOptions kdcOptions;
    public PrincipalName cname;
    public Realm crealm;
    public PrincipalName sname;
    public KerberosTime from;
    public KerberosTime till;
    public KerberosTime rtime;
    public HostAddresses addresses;
    private int nonce;
    private int[] eType = null;
    private EncryptedData encAuthorizationData;
    private Ticket[] additionalTickets;

    public KDCReqBody(KDCOptions new_kdcOptions, PrincipalName new_cname, Realm new_crealm, PrincipalName new_sname, KerberosTime new_from, KerberosTime new_till, KerberosTime new_rtime, int new_nonce, int[] new_eType, HostAddresses new_addresses, EncryptedData new_encAuthorizationData, Ticket[] new_additionalTickets) throws IOException {
        this.kdcOptions = new_kdcOptions;
        this.cname = new_cname;
        this.crealm = new_crealm;
        this.sname = new_sname;
        this.from = new_from;
        this.till = new_till;
        this.rtime = new_rtime;
        this.nonce = new_nonce;
        if (new_eType != null) {
            this.eType = (int[])new_eType.clone();
        }
        this.addresses = new_addresses;
        this.encAuthorizationData = new_encAuthorizationData;
        if (new_additionalTickets != null) {
            this.additionalTickets = new Ticket[new_additionalTickets.length];
            for (int i = 0; i < new_additionalTickets.length; ++i) {
                if (new_additionalTickets[i] == null) {
                    throw new IOException("Cannot create a KDCReqBody");
                }
                this.additionalTickets[i] = (Ticket)new_additionalTickets[i].clone();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public KDCReqBody(DerValue encoding, int msgType) throws Asn1Exception, RealmException, KrbException, IOException {
        this.addresses = null;
        this.encAuthorizationData = null;
        this.additionalTickets = null;
        if (encoding.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        this.kdcOptions = KDCOptions.parse(encoding.getData(), (byte)0, false);
        this.cname = PrincipalName.parse(encoding.getData(), (byte)1, true);
        if (msgType != 10 && this.cname != null) {
            throw new Asn1Exception(906);
        }
        this.crealm = Realm.parse(encoding.getData(), (byte)2, false);
        this.sname = PrincipalName.parse(encoding.getData(), (byte)3, true);
        this.from = KerberosTime.parse(encoding.getData(), (byte)4, true);
        this.till = KerberosTime.parse(encoding.getData(), (byte)5, false);
        this.rtime = KerberosTime.parse(encoding.getData(), (byte)6, true);
        DerValue der = encoding.getData().getDerValue();
        if ((der.getTag() & 0x1F) != 7) {
            throw new Asn1Exception(906);
        }
        this.nonce = der.getData().getBigInteger().intValue();
        der = encoding.getData().getDerValue();
        Vector<Integer> v = new Vector<Integer>();
        if ((der.getTag() & 0x1F) != 8) throw new Asn1Exception(906);
        DerValue subDer = der.getData().getDerValue();
        if (subDer.getTag() != 48) throw new Asn1Exception(906);
        while (subDer.getData().available() > 0) {
            v.addElement(subDer.getData().getBigInteger().intValue());
        }
        this.eType = new int[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            this.eType[i] = (Integer)v.elementAt(i);
        }
        if (encoding.getData().available() > 0) {
            this.addresses = HostAddresses.parse(encoding.getData(), (byte)9, true);
        }
        if (encoding.getData().available() > 0) {
            this.encAuthorizationData = EncryptedData.parse(encoding.getData(), (byte)10, true);
        }
        if (encoding.getData().available() > 0) {
            Vector<Ticket> tempTickets = new Vector<Ticket>();
            der = encoding.getData().getDerValue();
            if ((der.getTag() & 0x1F) != 11) throw new Asn1Exception(906);
            subDer = der.getData().getDerValue();
            if (subDer.getTag() != 48) throw new Asn1Exception(906);
            while (subDer.getData().available() > 0) {
                tempTickets.addElement(new Ticket(subDer.getData().getDerValue()));
            }
            if (tempTickets.size() > 0) {
                this.additionalTickets = new Ticket[tempTickets.size()];
                tempTickets.copyInto(this.additionalTickets);
            }
        }
        if (encoding.getData().available() <= 0) return;
        throw new Asn1Exception(906);
    }

    public byte[] asn1Encode(int msgType) throws Asn1Exception, IOException {
        Vector<DerValue> v = new Vector<DerValue>();
        v.addElement(new DerValue(DerValue.createTag((byte)-128, true, (byte)0), this.kdcOptions.asn1Encode()));
        if (msgType == 10 && this.cname != null) {
            v.addElement(new DerValue(DerValue.createTag((byte)-128, true, (byte)1), this.cname.asn1Encode()));
        }
        v.addElement(new DerValue(DerValue.createTag((byte)-128, true, (byte)2), this.crealm.asn1Encode()));
        if (this.sname != null) {
            v.addElement(new DerValue(DerValue.createTag((byte)-128, true, (byte)3), this.sname.asn1Encode()));
        }
        if (this.from != null) {
            v.addElement(new DerValue(DerValue.createTag((byte)-128, true, (byte)4), this.from.asn1Encode()));
        }
        v.addElement(new DerValue(DerValue.createTag((byte)-128, true, (byte)5), this.till.asn1Encode()));
        if (this.rtime != null) {
            v.addElement(new DerValue(DerValue.createTag((byte)-128, true, (byte)6), this.rtime.asn1Encode()));
        }
        DerOutputStream temp = new DerOutputStream();
        temp.putInteger(BigInteger.valueOf(this.nonce));
        v.addElement(new DerValue(DerValue.createTag((byte)-128, true, (byte)7), temp.toByteArray()));
        temp = new DerOutputStream();
        for (int i = 0; i < this.eType.length; ++i) {
            temp.putInteger(BigInteger.valueOf(this.eType[i]));
        }
        DerOutputStream eTypetemp = new DerOutputStream();
        eTypetemp.write((byte)48, temp);
        v.addElement(new DerValue(DerValue.createTag((byte)-128, true, (byte)8), eTypetemp.toByteArray()));
        if (this.addresses != null) {
            v.addElement(new DerValue(DerValue.createTag((byte)-128, true, (byte)9), this.addresses.asn1Encode()));
        }
        if (this.encAuthorizationData != null) {
            v.addElement(new DerValue(DerValue.createTag((byte)-128, true, (byte)10), this.encAuthorizationData.asn1Encode()));
        }
        if (this.additionalTickets != null && this.additionalTickets.length > 0) {
            temp = new DerOutputStream();
            for (int i = 0; i < this.additionalTickets.length; ++i) {
                temp.write(this.additionalTickets[i].asn1Encode());
            }
            DerOutputStream ticketsTemp = new DerOutputStream();
            ticketsTemp.write((byte)48, temp);
            v.addElement(new DerValue(DerValue.createTag((byte)-128, true, (byte)11), ticketsTemp.toByteArray()));
        }
        Object[] der = new DerValue[v.size()];
        v.copyInto(der);
        temp = new DerOutputStream();
        temp.putSequence((DerValue[])der);
        return temp.toByteArray();
    }

    public int getNonce() {
        return this.nonce;
    }
}

