/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect.misc;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedExceptionAction;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Map;
import sun.misc.IOUtils;
import sun.reflect.misc.ReflectUtil;

public final class MethodUtil
extends SecureClassLoader {
    private static String MISC_PKG = "sun.reflect.misc.";
    private static String TRAMPOLINE = MISC_PKG + "Trampoline";
    private static Method bounce = MethodUtil.getTrampoline();

    private MethodUtil() {
    }

    public static Method getMethod(Class<?> cls, String name, Class[] args) throws NoSuchMethodException {
        ReflectUtil.checkPackageAccess(cls);
        return cls.getMethod(name, args);
    }

    public static Method[] getMethods(Class cls) {
        ReflectUtil.checkPackageAccess(cls);
        return cls.getMethods();
    }

    public static Method[] getPublicMethods(Class cls) {
        boolean done;
        if (System.getSecurityManager() == null) {
            return cls.getMethods();
        }
        HashMap<Signature, Method> sigs = new HashMap<Signature, Method>();
        while (cls != null && !(done = MethodUtil.getInternalPublicMethods(cls, sigs))) {
            MethodUtil.getInterfaceMethods(cls, sigs);
            cls = cls.getSuperclass();
        }
        return sigs.values().toArray(new Method[sigs.size()]);
    }

    private static void getInterfaceMethods(Class cls, Map<Signature, Method> sigs) {
        Class<?>[] intfs = cls.getInterfaces();
        for (int i = 0; i < intfs.length; ++i) {
            Class<?> intf = intfs[i];
            boolean done = MethodUtil.getInternalPublicMethods(intf, sigs);
            if (done) continue;
            MethodUtil.getInterfaceMethods(intf, sigs);
        }
    }

    private static boolean getInternalPublicMethods(Class cls, Map<Signature, Method> sigs) {
        Class<?> dc;
        int i;
        Method[] methods = null;
        try {
            if (!Modifier.isPublic(cls.getModifiers())) {
                return false;
            }
            if (!ReflectUtil.isPackageAccessible(cls)) {
                return false;
            }
            methods = cls.getMethods();
        }
        catch (SecurityException se) {
            return false;
        }
        boolean done = true;
        for (i = 0; i < methods.length; ++i) {
            dc = methods[i].getDeclaringClass();
            if (Modifier.isPublic(dc.getModifiers())) continue;
            done = false;
            break;
        }
        if (done) {
            for (i = 0; i < methods.length; ++i) {
                MethodUtil.addMethod(sigs, methods[i]);
            }
        } else {
            for (i = 0; i < methods.length; ++i) {
                dc = methods[i].getDeclaringClass();
                if (!cls.equals(dc)) continue;
                MethodUtil.addMethod(sigs, methods[i]);
            }
        }
        return done;
    }

    private static void addMethod(Map<Signature, Method> sigs, Method method) {
        Method old;
        Signature signature = new Signature(method);
        if (!sigs.containsKey(signature)) {
            sigs.put(signature, method);
        } else if (!method.getDeclaringClass().isInterface() && (old = sigs.get(signature)).getDeclaringClass().isInterface()) {
            sigs.put(signature, method);
        }
    }

    public static Object invoke(Method m, Object obj, Object[] params) throws InvocationTargetException, IllegalAccessException {
        try {
            return bounce.invoke(null, m, obj, params);
        }
        catch (InvocationTargetException ie) {
            Throwable t = ie.getCause();
            if (t instanceof InvocationTargetException) {
                throw (InvocationTargetException)t;
            }
            if (t instanceof IllegalAccessException) {
                throw (IllegalAccessException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new Error("Unexpected invocation error", t);
        }
        catch (IllegalAccessException iae) {
            throw new Error("Unexpected invocation error", iae);
        }
    }

    private static Method getTrampoline() {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public Method run() throws Exception {
                    Class t = MethodUtil.getTrampolineClass();
                    Class[] types = new Class[]{Method.class, Object.class, Object[].class};
                    Method b = t.getDeclaredMethod("invoke", types);
                    b.setAccessible(true);
                    return b;
                }
            });
        }
        catch (Exception e) {
            throw new InternalError("bouncer cannot be found");
        }
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        ReflectUtil.checkPackageAccess(name);
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            try {
                c = this.findClass(name);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            if (c == null) {
                c = this.getParent().loadClass(name);
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        if (!name.startsWith(MISC_PKG)) {
            throw new ClassNotFoundException(name);
        }
        String path = name.replace('.', '/').concat(".class");
        URL res = this.getResource(path);
        if (res != null) {
            try {
                return this.defineClass(name, res);
            }
            catch (IOException e) {
                throw new ClassNotFoundException(name, e);
            }
        }
        throw new ClassNotFoundException(name);
    }

    private Class defineClass(String name, URL url) throws IOException {
        byte[] b = MethodUtil.getBytes(url);
        CodeSource cs = new CodeSource(null, (Certificate[])null);
        if (!name.equals(TRAMPOLINE)) {
            throw new IOException("MethodUtil: bad name " + name);
        }
        return this.defineClass(name, b, 0, b.length, cs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getBytes(URL url) throws IOException {
        byte[] b;
        HttpURLConnection huc;
        int code;
        URLConnection uc = url.openConnection();
        if (uc instanceof HttpURLConnection && (code = (huc = (HttpURLConnection)uc).getResponseCode()) >= 400) {
            throw new IOException("open HTTP connection failed.");
        }
        int len = uc.getContentLength();
        try (BufferedInputStream in = new BufferedInputStream(uc.getInputStream());){
            b = IOUtils.readFully(in, len, true);
        }
        return b;
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codesource) {
        PermissionCollection perms = super.getPermissions(codesource);
        perms.add(new AllPermission());
        return perms;
    }

    private static Class getTrampolineClass() {
        try {
            return Class.forName(TRAMPOLINE, true, new MethodUtil());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static class Signature {
        private String methodName;
        private Class[] argClasses;
        private volatile int hashCode = 0;

        Signature(Method m) {
            this.methodName = m.getName();
            this.argClasses = m.getParameterTypes();
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            Signature that = (Signature)o2;
            if (!this.methodName.equals(that.methodName)) {
                return false;
            }
            if (this.argClasses.length != that.argClasses.length) {
                return false;
            }
            for (int i = 0; i < this.argClasses.length; ++i) {
                if (this.argClasses[i] == that.argClasses[i]) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int result = 17;
                result = 37 * result + this.methodName.hashCode();
                if (this.argClasses != null) {
                    for (int i = 0; i < this.argClasses.length; ++i) {
                        result = 37 * result + (this.argClasses[i] == null ? 0 : this.argClasses[i].hashCode());
                    }
                }
                this.hashCode = result;
            }
            return this.hashCode;
        }
    }
}

