/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import sun.awt.image.ImageDecoder;
import sun.awt.image.InputStreamImageSource;

public class URLImageSource
extends InputStreamImageSource {
    URL url;
    URLConnection conn;
    String actualHost;
    int actualPort;

    public URLImageSource(URL u) {
        block7: {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                try {
                    Permission perm = u.openConnection().getPermission();
                    if (perm == null) break block7;
                    try {
                        sm.checkPermission(perm);
                    }
                    catch (SecurityException se) {
                        if (perm instanceof FilePermission && perm.getActions().indexOf("read") != -1) {
                            sm.checkRead(perm.getName());
                            break block7;
                        }
                        if (perm instanceof SocketPermission && perm.getActions().indexOf("connect") != -1) {
                            sm.checkConnect(u.getHost(), u.getPort());
                            break block7;
                        }
                        throw se;
                    }
                }
                catch (IOException ioe) {
                    sm.checkConnect(u.getHost(), u.getPort());
                }
            }
        }
        this.url = u;
    }

    public URLImageSource(String href) throws MalformedURLException {
        this(new URL(null, href));
    }

    public URLImageSource(URL u, URLConnection uc) {
        this(u);
        this.conn = uc;
    }

    public URLImageSource(URLConnection uc) {
        this(uc.getURL(), uc);
    }

    @Override
    final boolean checkSecurity(Object context, boolean quiet) {
        if (this.actualHost != null) {
            try {
                SecurityManager security = System.getSecurityManager();
                if (security != null) {
                    security.checkConnect(this.actualHost, this.actualPort, context);
                }
            }
            catch (SecurityException e) {
                if (!quiet) {
                    throw e;
                }
                return false;
            }
        }
        return true;
    }

    private synchronized URLConnection getConnection() throws IOException {
        URLConnection c;
        if (this.conn != null) {
            c = this.conn;
            this.conn = null;
        } else {
            c = this.url.openConnection();
        }
        return c;
    }

    @Override
    protected ImageDecoder getDecoder() {
        InputStream is = null;
        String type = null;
        URLConnection c = null;
        try {
            c = this.getConnection();
            is = c.getInputStream();
            type = c.getContentType();
            URL u = c.getURL();
            if (!(u == this.url || u.getHost().equals(this.url.getHost()) && u.getPort() == this.url.getPort())) {
                if (!(this.actualHost == null || this.actualHost.equals(u.getHost()) && this.actualPort == u.getPort())) {
                    throw new SecurityException("image moved!");
                }
                this.actualHost = u.getHost();
                this.actualPort = u.getPort();
            }
        }
        catch (IOException e) {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e2) {}
            } else if (c instanceof HttpURLConnection) {
                ((HttpURLConnection)c).disconnect();
            }
            return null;
        }
        ImageDecoder id = this.decoderForType(is, type);
        if (id == null) {
            id = this.getDecoder(is);
        }
        if (id == null) {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            } else if (c instanceof HttpURLConnection) {
                ((HttpURLConnection)c).disconnect();
            }
        }
        return id;
    }
}

