/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.mbeanserver.DescriptorCache;
import com.sun.jmx.mbeanserver.Introspector;
import com.sun.jmx.mbeanserver.MBeanSupport;
import com.sun.jmx.mbeanserver.MXBeanSupport;
import com.sun.jmx.mbeanserver.StandardMBeanSupport;
import com.sun.jmx.mbeanserver.Util;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.Descriptor;
import javax.management.DynamicMBean;
import javax.management.ImmutableDescriptor;
import javax.management.InvalidAttributeValueException;
import javax.management.JMX;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.StandardEmitterMBean;
import javax.management.openmbean.OpenMBeanAttributeInfo;
import javax.management.openmbean.OpenMBeanAttributeInfoSupport;
import javax.management.openmbean.OpenMBeanConstructorInfo;
import javax.management.openmbean.OpenMBeanConstructorInfoSupport;
import javax.management.openmbean.OpenMBeanOperationInfo;
import javax.management.openmbean.OpenMBeanOperationInfoSupport;
import javax.management.openmbean.OpenMBeanParameterInfo;
import javax.management.openmbean.OpenMBeanParameterInfoSupport;

public class StandardMBean
implements DynamicMBean,
MBeanRegistration {
    private static final DescriptorCache descriptors = DescriptorCache.getInstance(JMX.proof);
    private volatile MBeanSupport<?> mbean;
    private volatile MBeanInfo cachedMBeanInfo;
    private static final Map<Class<?>, Boolean> mbeanInfoSafeMap = new WeakHashMap();

    private <T> void construct(T implementation, Class<T> mbeanInterface, boolean nullImplementationAllowed, boolean isMXBean) throws NotCompliantMBeanException {
        if (implementation == null) {
            if (nullImplementationAllowed) {
                implementation = Util.cast(this);
            } else {
                throw new IllegalArgumentException("implementation is null");
            }
        }
        if (isMXBean) {
            if (mbeanInterface == null) {
                mbeanInterface = (Class)Util.cast(Introspector.getMXBeanInterface(implementation.getClass()));
            }
            this.mbean = new MXBeanSupport(implementation, mbeanInterface);
        } else {
            if (mbeanInterface == null) {
                mbeanInterface = (Class)Util.cast(Introspector.getStandardMBeanInterface(implementation.getClass()));
            }
            this.mbean = new StandardMBeanSupport(implementation, mbeanInterface);
        }
    }

    public <T> StandardMBean(T implementation, Class<T> mbeanInterface) throws NotCompliantMBeanException {
        this.construct(implementation, mbeanInterface, false, false);
    }

    protected StandardMBean(Class<?> mbeanInterface) throws NotCompliantMBeanException {
        this.construct(null, mbeanInterface, true, false);
    }

    public <T> StandardMBean(T implementation, Class<T> mbeanInterface, boolean isMXBean) {
        try {
            this.construct(implementation, mbeanInterface, false, isMXBean);
        }
        catch (NotCompliantMBeanException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected StandardMBean(Class<?> mbeanInterface, boolean isMXBean) {
        try {
            this.construct(null, mbeanInterface, true, isMXBean);
        }
        catch (NotCompliantMBeanException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void setImplementation(Object implementation) throws NotCompliantMBeanException {
        if (implementation == null) {
            throw new IllegalArgumentException("implementation is null");
        }
        this.mbean = this.isMXBean() ? new MXBeanSupport(implementation, (Class)Util.cast(this.getMBeanInterface())) : new StandardMBeanSupport(implementation, (Class)Util.cast(this.getMBeanInterface()));
    }

    public Object getImplementation() {
        return this.mbean.getResource();
    }

    public final Class<?> getMBeanInterface() {
        return this.mbean.getMBeanInterface();
    }

    public Class<?> getImplementationClass() {
        return this.mbean.getResource().getClass();
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        return this.mbean.getAttribute(attribute);
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.mbean.setAttribute(attribute);
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        return this.mbean.getAttributes(attributes);
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        return this.mbean.setAttributes(attributes);
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        return this.mbean.invoke(actionName, params, signature);
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        MBeanInfo nmbi;
        block7: {
            block6: {
                try {
                    MBeanInfo cached = this.getCachedMBeanInfo();
                    if (cached != null) {
                        return cached;
                    }
                }
                catch (RuntimeException x) {
                    if (!JmxProperties.MISC_LOGGER.isLoggable(Level.FINEST)) break block6;
                    JmxProperties.MISC_LOGGER.logp(Level.FINEST, MBeanServerFactory.class.getName(), "getMBeanInfo", "Failed to get cached MBeanInfo", x);
                }
            }
            if (JmxProperties.MISC_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.MISC_LOGGER.logp(Level.FINER, MBeanServerFactory.class.getName(), "getMBeanInfo", "Building MBeanInfo for " + this.getImplementationClass().getName());
            }
            MBeanSupport<?> msupport = this.mbean;
            MBeanInfo bi = msupport.getMBeanInfo();
            Object impl = msupport.getResource();
            boolean immutableInfo = StandardMBean.immutableInfo(this.getClass());
            String cname = this.getClassName(bi);
            String text = this.getDescription(bi);
            MBeanConstructorInfo[] ctors = this.getConstructors(bi, impl);
            MBeanAttributeInfo[] attrs = this.getAttributes(bi);
            MBeanOperationInfo[] ops = this.getOperations(bi);
            MBeanNotificationInfo[] ntfs = this.getNotifications(bi);
            Descriptor desc = this.getDescriptor(bi, immutableInfo);
            nmbi = new MBeanInfo(cname, text, attrs, ctors, ops, ntfs, desc);
            try {
                this.cacheMBeanInfo(nmbi);
            }
            catch (RuntimeException x) {
                if (!JmxProperties.MISC_LOGGER.isLoggable(Level.FINEST)) break block7;
                JmxProperties.MISC_LOGGER.logp(Level.FINEST, MBeanServerFactory.class.getName(), "getMBeanInfo", "Failed to cache MBeanInfo", x);
            }
        }
        return nmbi;
    }

    protected String getClassName(MBeanInfo info) {
        if (info == null) {
            return this.getImplementationClass().getName();
        }
        return info.getClassName();
    }

    protected String getDescription(MBeanInfo info) {
        if (info == null) {
            return null;
        }
        return info.getDescription();
    }

    protected String getDescription(MBeanFeatureInfo info) {
        if (info == null) {
            return null;
        }
        return info.getDescription();
    }

    protected String getDescription(MBeanAttributeInfo info) {
        return this.getDescription((MBeanFeatureInfo)info);
    }

    protected String getDescription(MBeanConstructorInfo info) {
        return this.getDescription((MBeanFeatureInfo)info);
    }

    protected String getDescription(MBeanConstructorInfo ctor, MBeanParameterInfo param, int sequence) {
        if (param == null) {
            return null;
        }
        return param.getDescription();
    }

    protected String getParameterName(MBeanConstructorInfo ctor, MBeanParameterInfo param, int sequence) {
        if (param == null) {
            return null;
        }
        return param.getName();
    }

    protected String getDescription(MBeanOperationInfo info) {
        return this.getDescription((MBeanFeatureInfo)info);
    }

    protected int getImpact(MBeanOperationInfo info) {
        if (info == null) {
            return 3;
        }
        return info.getImpact();
    }

    protected String getParameterName(MBeanOperationInfo op, MBeanParameterInfo param, int sequence) {
        if (param == null) {
            return null;
        }
        return param.getName();
    }

    protected String getDescription(MBeanOperationInfo op, MBeanParameterInfo param, int sequence) {
        if (param == null) {
            return null;
        }
        return param.getDescription();
    }

    protected MBeanConstructorInfo[] getConstructors(MBeanConstructorInfo[] ctors, Object impl) {
        if (ctors == null) {
            return null;
        }
        if (impl != null && impl != this) {
            return null;
        }
        return ctors;
    }

    MBeanNotificationInfo[] getNotifications(MBeanInfo info) {
        return null;
    }

    Descriptor getDescriptor(MBeanInfo info, boolean immutableInfo) {
        ImmutableDescriptor desc;
        if (info == null || info.getDescriptor() == null || info.getDescriptor().getFieldNames().length == 0) {
            String interfaceClassNameS = "interfaceClassName=" + this.getMBeanInterface().getName();
            String immutableInfoS = "immutableInfo=" + immutableInfo;
            desc = new ImmutableDescriptor(interfaceClassNameS, immutableInfoS);
            desc = descriptors.get(desc);
        } else {
            Descriptor d = info.getDescriptor();
            HashMap<String, Object> fields = new HashMap<String, Object>();
            for (String fieldName : d.getFieldNames()) {
                if (fieldName.equals("immutableInfo")) {
                    fields.put(fieldName, Boolean.toString(immutableInfo));
                    continue;
                }
                fields.put(fieldName, d.getFieldValue(fieldName));
            }
            desc = new ImmutableDescriptor(fields);
        }
        return desc;
    }

    protected MBeanInfo getCachedMBeanInfo() {
        return this.cachedMBeanInfo;
    }

    protected void cacheMBeanInfo(MBeanInfo info) {
        this.cachedMBeanInfo = info;
    }

    private boolean isMXBean() {
        return this.mbean.isMXBean();
    }

    private static <T> boolean identicalArrays(T[] a, T[] b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null || a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    private static <T> boolean equal(T a, T b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    private static MBeanParameterInfo customize(MBeanParameterInfo pi, String name, String description) {
        if (StandardMBean.equal(name, pi.getName()) && StandardMBean.equal(description, pi.getDescription())) {
            return pi;
        }
        if (pi instanceof OpenMBeanParameterInfo) {
            OpenMBeanParameterInfo opi = (OpenMBeanParameterInfo)((Object)pi);
            return new OpenMBeanParameterInfoSupport(name, description, opi.getOpenType(), pi.getDescriptor());
        }
        return new MBeanParameterInfo(name, pi.getType(), description, pi.getDescriptor());
    }

    private static MBeanConstructorInfo customize(MBeanConstructorInfo ci, String description, MBeanParameterInfo[] signature) {
        if (StandardMBean.equal(description, ci.getDescription()) && StandardMBean.identicalArrays(signature, ci.getSignature())) {
            return ci;
        }
        if (ci instanceof OpenMBeanConstructorInfo) {
            OpenMBeanParameterInfo[] oparams = StandardMBean.paramsToOpenParams(signature);
            return new OpenMBeanConstructorInfoSupport(ci.getName(), description, oparams, ci.getDescriptor());
        }
        return new MBeanConstructorInfo(ci.getName(), description, signature, ci.getDescriptor());
    }

    private static MBeanOperationInfo customize(MBeanOperationInfo oi, String description, MBeanParameterInfo[] signature, int impact) {
        if (StandardMBean.equal(description, oi.getDescription()) && StandardMBean.identicalArrays(signature, oi.getSignature()) && impact == oi.getImpact()) {
            return oi;
        }
        if (oi instanceof OpenMBeanOperationInfo) {
            OpenMBeanOperationInfo ooi = (OpenMBeanOperationInfo)((Object)oi);
            OpenMBeanParameterInfo[] oparams = StandardMBean.paramsToOpenParams(signature);
            return new OpenMBeanOperationInfoSupport(oi.getName(), description, oparams, ooi.getReturnOpenType(), impact, oi.getDescriptor());
        }
        return new MBeanOperationInfo(oi.getName(), description, signature, oi.getReturnType(), impact, oi.getDescriptor());
    }

    private static MBeanAttributeInfo customize(MBeanAttributeInfo ai, String description) {
        if (StandardMBean.equal(description, ai.getDescription())) {
            return ai;
        }
        if (ai instanceof OpenMBeanAttributeInfo) {
            OpenMBeanAttributeInfo oai = (OpenMBeanAttributeInfo)((Object)ai);
            return new OpenMBeanAttributeInfoSupport(ai.getName(), description, oai.getOpenType(), ai.isReadable(), ai.isWritable(), ai.isIs(), ai.getDescriptor());
        }
        return new MBeanAttributeInfo(ai.getName(), ai.getType(), description, ai.isReadable(), ai.isWritable(), ai.isIs(), ai.getDescriptor());
    }

    private static OpenMBeanParameterInfo[] paramsToOpenParams(MBeanParameterInfo[] params) {
        if (params instanceof OpenMBeanParameterInfo[]) {
            return (OpenMBeanParameterInfo[])params;
        }
        OpenMBeanParameterInfo[] oparams = new OpenMBeanParameterInfoSupport[params.length];
        System.arraycopy(params, 0, oparams, 0, params.length);
        return oparams;
    }

    private MBeanConstructorInfo[] getConstructors(MBeanInfo info, Object impl) {
        MBeanConstructorInfo[] ctors = this.getConstructors(info.getConstructors(), impl);
        if (ctors == null) {
            return null;
        }
        int ctorlen = ctors.length;
        MBeanConstructorInfo[] nctors = new MBeanConstructorInfo[ctorlen];
        for (int i = 0; i < ctorlen; ++i) {
            MBeanParameterInfo[] nps;
            MBeanConstructorInfo c = ctors[i];
            MBeanParameterInfo[] params = c.getSignature();
            if (params != null) {
                int plen = params.length;
                nps = new MBeanParameterInfo[plen];
                for (int ii = 0; ii < plen; ++ii) {
                    MBeanParameterInfo p = params[ii];
                    nps[ii] = StandardMBean.customize(p, this.getParameterName(c, p, ii), this.getDescription(c, p, ii));
                }
            } else {
                nps = null;
            }
            nctors[i] = StandardMBean.customize(c, this.getDescription(c), nps);
        }
        return nctors;
    }

    private MBeanOperationInfo[] getOperations(MBeanInfo info) {
        MBeanOperationInfo[] ops = info.getOperations();
        if (ops == null) {
            return null;
        }
        int oplen = ops.length;
        MBeanOperationInfo[] nops = new MBeanOperationInfo[oplen];
        for (int i = 0; i < oplen; ++i) {
            MBeanParameterInfo[] nps;
            MBeanOperationInfo o = ops[i];
            MBeanParameterInfo[] params = o.getSignature();
            if (params != null) {
                int plen = params.length;
                nps = new MBeanParameterInfo[plen];
                for (int ii = 0; ii < plen; ++ii) {
                    MBeanParameterInfo p = params[ii];
                    nps[ii] = StandardMBean.customize(p, this.getParameterName(o, p, ii), this.getDescription(o, p, ii));
                }
            } else {
                nps = null;
            }
            nops[i] = StandardMBean.customize(o, this.getDescription(o), nps, this.getImpact(o));
        }
        return nops;
    }

    private MBeanAttributeInfo[] getAttributes(MBeanInfo info) {
        MBeanAttributeInfo[] atts = info.getAttributes();
        if (atts == null) {
            return null;
        }
        int attlen = atts.length;
        MBeanAttributeInfo[] natts = new MBeanAttributeInfo[attlen];
        for (int i = 0; i < attlen; ++i) {
            MBeanAttributeInfo a = atts[i];
            natts[i] = StandardMBean.customize(a, this.getDescription(a));
        }
        return natts;
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.mbean.register(server, name);
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
        if (!registrationDone.booleanValue()) {
            this.mbean.unregister();
        }
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
        this.mbean.unregister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean immutableInfo(Class<? extends StandardMBean> subclass) {
        if (subclass == StandardMBean.class || subclass == StandardEmitterMBean.class) {
            return true;
        }
        Map<Class<?>, Boolean> map = mbeanInfoSafeMap;
        synchronized (map) {
            Boolean safe = mbeanInfoSafeMap.get(subclass);
            if (safe == null) {
                try {
                    MBeanInfoSafeAction action = new MBeanInfoSafeAction(subclass);
                    safe = AccessController.doPrivileged(action);
                }
                catch (Exception e) {
                    safe = false;
                }
                mbeanInfoSafeMap.put(subclass, safe);
            }
            return safe;
        }
    }

    static boolean overrides(Class<?> subclass, Class<?> superclass, String name, Class<?> ... params) {
        for (Class<?> c = subclass; c != superclass; c = c.getSuperclass()) {
            try {
                c.getDeclaredMethod(name, params);
                return true;
            }
            catch (NoSuchMethodException e) {
                continue;
            }
        }
        return false;
    }

    private static class MBeanInfoSafeAction
    implements PrivilegedAction<Boolean> {
        private final Class<?> subclass;

        MBeanInfoSafeAction(Class<?> subclass) {
            this.subclass = subclass;
        }

        @Override
        public Boolean run() {
            if (StandardMBean.overrides(this.subclass, StandardMBean.class, "cacheMBeanInfo", MBeanInfo.class)) {
                return false;
            }
            if (StandardMBean.overrides(this.subclass, StandardMBean.class, "getCachedMBeanInfo", null)) {
                return false;
            }
            if (StandardMBean.overrides(this.subclass, StandardMBean.class, "getMBeanInfo", null)) {
                return false;
            }
            if (StandardEmitterMBean.class.isAssignableFrom(this.subclass) && StandardMBean.overrides(this.subclass, StandardEmitterMBean.class, "getNotificationInfo", null)) {
                return false;
            }
            return true;
        }
    }
}

