/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.mbeanserver.GetPropertyAction;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.management.JMException;
import javax.management.JMRuntimeException;
import javax.management.MBeanServer;
import javax.management.MBeanServerBuilder;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerPermission;
import javax.management.loading.ClassLoaderRepository;
import sun.reflect.misc.ReflectUtil;

public class MBeanServerFactory {
    private static MBeanServerBuilder builder = null;
    private static final ArrayList<MBeanServer> mBeanServerList = new ArrayList();

    private MBeanServerFactory() {
    }

    public static void releaseMBeanServer(MBeanServer mbeanServer) {
        MBeanServerFactory.checkPermission("releaseMBeanServer");
        MBeanServerFactory.removeMBeanServer(mbeanServer);
    }

    public static MBeanServer createMBeanServer() {
        return MBeanServerFactory.createMBeanServer(null);
    }

    public static MBeanServer createMBeanServer(String domain) {
        MBeanServerFactory.checkPermission("createMBeanServer");
        MBeanServer mBeanServer = MBeanServerFactory.newMBeanServer(domain);
        MBeanServerFactory.addMBeanServer(mBeanServer);
        return mBeanServer;
    }

    public static MBeanServer newMBeanServer() {
        return MBeanServerFactory.newMBeanServer(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MBeanServer newMBeanServer(String domain) {
        MBeanServerBuilder mbsBuilder;
        MBeanServerFactory.checkPermission("newMBeanServer");
        MBeanServerBuilder mBeanServerBuilder = mbsBuilder = MBeanServerFactory.getNewMBeanServerBuilder();
        synchronized (mBeanServerBuilder) {
            MBeanServerDelegate delegate = mbsBuilder.newMBeanServerDelegate();
            if (delegate == null) {
                String msg = "MBeanServerBuilder.newMBeanServerDelegate() returned null";
                throw new JMRuntimeException("MBeanServerBuilder.newMBeanServerDelegate() returned null");
            }
            MBeanServer mbeanServer = mbsBuilder.newMBeanServer(domain, null, delegate);
            if (mbeanServer == null) {
                String msg = "MBeanServerBuilder.newMBeanServer() returned null";
                throw new JMRuntimeException("MBeanServerBuilder.newMBeanServer() returned null");
            }
            return mbeanServer;
        }
    }

    public static synchronized ArrayList<MBeanServer> findMBeanServer(String agentId) {
        MBeanServerFactory.checkPermission("findMBeanServer");
        if (agentId == null) {
            return new ArrayList<MBeanServer>(mBeanServerList);
        }
        ArrayList<MBeanServer> result = new ArrayList<MBeanServer>();
        for (MBeanServer mbs : mBeanServerList) {
            String name = MBeanServerFactory.mBeanServerId(mbs);
            if (!agentId.equals(name)) continue;
            result.add(mbs);
        }
        return result;
    }

    public static ClassLoaderRepository getClassLoaderRepository(MBeanServer server) {
        return server.getClassLoaderRepository();
    }

    private static String mBeanServerId(MBeanServer mbs) {
        try {
            return (String)mbs.getAttribute(MBeanServerDelegate.DELEGATE_NAME, "MBeanServerId");
        }
        catch (JMException e) {
            JmxProperties.MISC_LOGGER.finest("Ignoring exception while getting MBeanServerId: " + e);
            return null;
        }
    }

    private static void checkPermission(String action) throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            MBeanServerPermission perm = new MBeanServerPermission(action);
            sm.checkPermission(perm);
        }
    }

    private static synchronized void addMBeanServer(MBeanServer mbs) {
        mBeanServerList.add(mbs);
    }

    private static synchronized void removeMBeanServer(MBeanServer mbs) {
        boolean removed = mBeanServerList.remove(mbs);
        if (!removed) {
            JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINER, MBeanServerFactory.class.getName(), "removeMBeanServer(MBeanServer)", "MBeanServer was not in list!");
            throw new IllegalArgumentException("MBeanServer was not in list!");
        }
    }

    private static Class<?> loadBuilderClass(String builderClassName) throws ClassNotFoundException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader != null) {
            return loader.loadClass(builderClassName);
        }
        return ReflectUtil.forName(builderClassName);
    }

    private static MBeanServerBuilder newBuilder(Class<?> builderClass) {
        try {
            Object abuilder = builderClass.newInstance();
            return (MBeanServerBuilder)abuilder;
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            String msg = "Failed to instantiate a MBeanServerBuilder from " + builderClass + ": " + x;
            throw new JMRuntimeException(msg, x);
        }
    }

    private static synchronized void checkMBeanServerBuilder() {
        try {
            GetPropertyAction act = new GetPropertyAction("javax.management.builder.initial");
            String builderClassName = AccessController.doPrivileged(act);
            try {
                Class<?> builderClass;
                Class newBuilderClass = builderClassName == null || builderClassName.length() == 0 ? MBeanServerBuilder.class : MBeanServerFactory.loadBuilderClass(builderClassName);
                if (builder != null && newBuilderClass == (builderClass = builder.getClass())) {
                    return;
                }
                builder = MBeanServerFactory.newBuilder(newBuilderClass);
            }
            catch (ClassNotFoundException x) {
                String msg = "Failed to load MBeanServerBuilder class " + builderClassName + ": " + x;
                throw new JMRuntimeException(msg, x);
            }
        }
        catch (RuntimeException x) {
            if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINEST)) {
                StringBuilder strb = new StringBuilder().append("Failed to instantiate MBeanServerBuilder: ").append(x).append("\n\t\tCheck the value of the ").append("javax.management.builder.initial").append(" property.");
                JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINEST, MBeanServerFactory.class.getName(), "checkMBeanServerBuilder", strb.toString());
            }
            throw x;
        }
    }

    private static synchronized MBeanServerBuilder getNewMBeanServerBuilder() {
        MBeanServerFactory.checkMBeanServerBuilder();
        return builder;
    }
}

