/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.Future;
import java.util.concurrent.RecursiveAction;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import sun.misc.Unsafe;

public class ForkJoinPool
extends AbstractExecutorService {
    public static final ForkJoinWorkerThreadFactory defaultForkJoinWorkerThreadFactory;
    private static final RuntimePermission modifyThreadPermission;
    private static final AtomicInteger poolNumberGenerator;
    static final Random workerSeedGenerator;
    ForkJoinWorkerThread[] workers;
    private static final int INITIAL_QUEUE_CAPACITY = 8;
    private static final int MAXIMUM_QUEUE_CAPACITY = 0x1000000;
    private ForkJoinTask<?>[] submissionQueue;
    private final ReentrantLock submissionLock;
    private final Condition termination;
    private final ForkJoinWorkerThreadFactory factory;
    final Thread.UncaughtExceptionHandler ueh;
    private final String workerNamePrefix;
    private volatile long stealCount;
    volatile long ctl;
    private static final int AC_SHIFT = 48;
    private static final int TC_SHIFT = 32;
    private static final int ST_SHIFT = 31;
    private static final int EC_SHIFT = 16;
    private static final int MAX_ID = Short.MAX_VALUE;
    private static final int SMASK = 65535;
    private static final int SHORT_SIGN = 32768;
    private static final int INT_SIGN = Integer.MIN_VALUE;
    private static final long STOP_BIT = 0x80000000L;
    private static final long AC_MASK = -281474976710656L;
    private static final long TC_MASK = 0xFFFF00000000L;
    private static final long TC_UNIT = 0x100000000L;
    private static final long AC_UNIT = 0x1000000000000L;
    private static final int UAC_SHIFT = 16;
    private static final int UTC_SHIFT = 0;
    private static final int UAC_MASK = -65536;
    private static final int UTC_MASK = 65535;
    private static final int UAC_UNIT = 65536;
    private static final int UTC_UNIT = 1;
    private static final int E_MASK = Integer.MAX_VALUE;
    private static final int EC_UNIT = 65536;
    final int parallelism;
    volatile int queueBase;
    int queueTop;
    volatile boolean shutdown;
    final boolean locallyFifo;
    volatile int quiescerCount;
    volatile int blockedCount;
    private volatile int nextWorkerNumber;
    private int nextWorkerIndex;
    volatile int scanGuard;
    private static final int SG_UNIT = 65536;
    private static final long SHRINK_RATE = 4000000000L;
    private static final Unsafe UNSAFE;
    private static final long ctlOffset;
    private static final long stealCountOffset;
    private static final long blockedCountOffset;
    private static final long quiescerCountOffset;
    private static final long scanGuardOffset;
    private static final long nextWorkerNumberOffset;
    private static final long ABASE;
    private static final int ASHIFT;

    private static void checkPermission() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(modifyThreadPermission);
        }
    }

    final void work(ForkJoinWorkerThread w) {
        long c;
        boolean swept = false;
        while (!w.terminate && (int)(c = this.ctl) >= 0) {
            int a;
            if (!swept && (a = (int)(c >> 48)) <= 0) {
                swept = this.scan(w, a);
                continue;
            }
            if (!this.tryAwaitWork(w, c)) continue;
            swept = false;
        }
    }

    final void signalWork() {
        int u;
        long c;
        int e;
        while ((((e = (int)(c = this.ctl)) | (u = (int)(c >>> 32))) & 0x80008000) == -2147450880 && e >= 0) {
            if (e > 0) {
                ForkJoinWorkerThread w;
                int i;
                ForkJoinWorkerThread[] ws = this.workers;
                if (this.workers == null || (i = ~e & 0xFFFF) >= ws.length || (w = ws[i]) == null) break;
                long nc = (long)(w.nextWait & Integer.MAX_VALUE) | (long)(u + 65536) << 32;
                if (w.eventCount != e || !UNSAFE.compareAndSwapLong(this, ctlOffset, c, nc)) continue;
                w.eventCount = e + 65536 & Integer.MAX_VALUE;
                if (!w.parked) break;
                UNSAFE.unpark(w);
                break;
            }
            if (!UNSAFE.compareAndSwapLong(this, ctlOffset, c, (long)(u + 1 & 0xFFFF | u + 65536 & 0xFFFF0000) << 32)) continue;
            this.addWorker();
            break;
        }
    }

    private boolean tryReleaseWaiter() {
        long c = this.ctl;
        int e = (int)c;
        if (e > 0 && (int)(c >> 48) < 0) {
            ForkJoinWorkerThread w;
            int i;
            ForkJoinWorkerThread[] ws = this.workers;
            if (this.workers != null && (i = ~e & 0xFFFF) < ws.length && (w = ws[i]) != null) {
                long nc = (long)(w.nextWait & Integer.MAX_VALUE) | c + 0x1000000000000L & 0xFFFFFFFF00000000L;
                if (w.eventCount != e || !UNSAFE.compareAndSwapLong(this, ctlOffset, c, nc)) {
                    return false;
                }
                w.eventCount = e + 65536 & Integer.MAX_VALUE;
                if (w.parked) {
                    UNSAFE.unpark(w);
                }
            }
        }
        return true;
    }

    private boolean scan(ForkJoinWorkerThread w, int a) {
        int r;
        int g = this.scanGuard;
        int m = this.parallelism == 1 - a && this.blockedCount == 0 ? 0 : g & 0xFFFF;
        ForkJoinWorkerThread[] ws = this.workers;
        if (ws == null || ws.length <= m) {
            return false;
        }
        int k = r = w.seed;
        for (int j = -(m + m); j <= m + m; ++j) {
            int b;
            ForkJoinWorkerThread v = ws[k & m];
            if (v != null && (b = v.queueBase) != v.queueTop) {
                int i;
                ForkJoinTask<?>[] q = v.queue;
                if (v.queue != null && (i = q.length - 1 & b) >= 0) {
                    long u = (long)(i << ASHIFT) + ABASE;
                    ForkJoinTask<?> t = q[i];
                    if (t != null && v.queueBase == b && UNSAFE.compareAndSwapObject(q, u, t, null)) {
                        v.queueBase = b + 1;
                        int d = v.queueBase - v.queueTop;
                        v.stealHint = w.poolIndex;
                        if (d != 0) {
                            this.signalWork();
                        }
                        w.execTask(t);
                    }
                    r ^= r << 13;
                    r ^= r >>> 17;
                    w.seed = r ^ r << 5;
                    return false;
                }
            }
            if (j < 0) {
                r ^= r << 13;
                r ^= r >>> 17;
                r ^= r << 5;
                k = r;
                continue;
            }
            ++k;
        }
        if (this.scanGuard != g) {
            return false;
        }
        int b = this.queueBase;
        if (b != this.queueTop) {
            int i;
            ForkJoinTask<?>[] q = this.submissionQueue;
            if (this.submissionQueue != null && (i = q.length - 1 & b) >= 0) {
                long u = (long)(i << ASHIFT) + ABASE;
                ForkJoinTask<?> t = q[i];
                if (t != null && this.queueBase == b && UNSAFE.compareAndSwapObject(q, u, t, null)) {
                    this.queueBase = b + 1;
                    w.execTask(t);
                }
                return false;
            }
        }
        return true;
    }

    private boolean tryAwaitWork(ForkJoinWorkerThread w, long c) {
        int v = w.eventCount;
        w.nextWait = (int)c;
        long nc = (long)(v & Integer.MAX_VALUE) | c - 0x1000000000000L & 0xFFFFFFFF00000000L;
        if (this.ctl != c || !UNSAFE.compareAndSwapLong(this, ctlOffset, c, nc)) {
            long d = this.ctl;
            return (int)d != (int)c && (d - c & 0xFFFF000000000000L) >= 0L;
        }
        int sc = w.stealCount;
        while (sc != 0) {
            long s = this.stealCount;
            if (UNSAFE.compareAndSwapLong(this, stealCountOffset, s, s + (long)sc)) {
                w.stealCount = 0;
                sc = 0;
                continue;
            }
            if (w.eventCount == v) continue;
            return true;
        }
        if (!(this.shutdown && this.tryTerminate(false) || (int)c == 0 || this.parallelism + (int)(nc >> 48) != 0 || this.blockedCount != 0 || this.quiescerCount != 0)) {
            this.idleAwaitWork(w, nc, c, v);
        }
        boolean rescanned = false;
        while (w.eventCount == v) {
            if (!rescanned) {
                int g = this.scanGuard;
                int m = g & 0xFFFF;
                ForkJoinWorkerThread[] ws = this.workers;
                if (ws != null && m < ws.length) {
                    rescanned = true;
                    for (int i = 0; i <= m; ++i) {
                        ForkJoinWorkerThread u = ws[i];
                        if (u == null) continue;
                        if (u.queueBase != u.queueTop && !this.tryReleaseWaiter()) {
                            rescanned = false;
                        }
                        if (w.eventCount == v) continue;
                        return true;
                    }
                }
                if (this.scanGuard != g || this.queueBase != this.queueTop && !this.tryReleaseWaiter()) {
                    rescanned = false;
                }
                if (!rescanned) {
                    Thread.yield();
                    continue;
                }
                Thread.interrupted();
                continue;
            }
            w.parked = true;
            if (w.eventCount != v) {
                w.parked = false;
                return true;
            }
            LockSupport.park(this);
            w.parked = false;
            rescanned = false;
        }
        return true;
    }

    private void idleAwaitWork(ForkJoinWorkerThread w, long currentCtl, long prevCtl, int v) {
        if (w.eventCount == v) {
            if (this.shutdown) {
                this.tryTerminate(false);
            }
            ForkJoinTask.helpExpungeStaleExceptions();
            while (this.ctl == currentCtl) {
                long startTime = System.nanoTime();
                w.parked = true;
                if (w.eventCount == v) {
                    LockSupport.parkNanos(this, 4000000000L);
                }
                w.parked = false;
                if (w.eventCount != v) break;
                if (System.nanoTime() - startTime < 3600000000L) {
                    Thread.interrupted();
                    continue;
                }
                if (!UNSAFE.compareAndSwapLong(this, ctlOffset, currentCtl, prevCtl)) continue;
                w.terminate = true;
                w.eventCount = (int)currentCtl + 65536 & Integer.MAX_VALUE;
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSubmission(ForkJoinTask<?> t) {
        ReentrantLock lock = this.submissionLock;
        lock.lock();
        try {
            ForkJoinTask<?>[] q = this.submissionQueue;
            if (this.submissionQueue != null) {
                int s = this.queueTop;
                int m = q.length - 1;
                long u = (long)((s & m) << ASHIFT) + ABASE;
                UNSAFE.putOrderedObject(q, u, t);
                this.queueTop = s + 1;
                if (s - this.queueBase == m) {
                    this.growSubmissionQueue();
                }
            }
        }
        finally {
            lock.unlock();
        }
        this.signalWork();
    }

    private void growSubmissionQueue() {
        int oldMask;
        int size;
        ForkJoinTask<?>[] oldQ = this.submissionQueue;
        int n = size = oldQ != null ? oldQ.length << 1 : 8;
        if (size > 0x1000000) {
            throw new RejectedExecutionException("Queue capacity exceeded");
        }
        if (size < 8) {
            size = 8;
        }
        this.submissionQueue = new ForkJoinTask[size];
        ForkJoinTask[] q = this.submissionQueue;
        int mask = size - 1;
        int top = this.queueTop;
        if (oldQ != null && (oldMask = oldQ.length - 1) >= 0) {
            for (int b = this.queueBase; b != top; ++b) {
                long u = (long)((b & oldMask) << ASHIFT) + ABASE;
                Object x = UNSAFE.getObjectVolatile(oldQ, u);
                if (x == null || !UNSAFE.compareAndSwapObject(oldQ, u, x, null)) continue;
                UNSAFE.putObjectVolatile(q, (long)((b & mask) << ASHIFT) + ABASE, x);
            }
        }
    }

    private boolean tryPreBlock() {
        int b = this.blockedCount;
        if (UNSAFE.compareAndSwapInt(this, blockedCountOffset, b, b + 1)) {
            int pc = this.parallelism;
            do {
                short tc;
                long nc;
                long c = this.ctl;
                int u = (int)(c >>> 32);
                int e = (int)c;
                if (e < 0) continue;
                int ac = u >> 16;
                if (ac <= 0 && e != 0) {
                    ForkJoinWorkerThread w;
                    int i;
                    ForkJoinWorkerThread[] ws = this.workers;
                    if (this.workers != null && (i = ~e & 0xFFFF) < ws.length && (w = ws[i]) != null) {
                        nc = (long)(w.nextWait & Integer.MAX_VALUE) | c & 0xFFFFFFFF00000000L;
                        if (w.eventCount != e || !UNSAFE.compareAndSwapLong(this, ctlOffset, c, nc)) continue;
                        w.eventCount = e + 65536 & Integer.MAX_VALUE;
                        if (w.parked) {
                            UNSAFE.unpark(w);
                        }
                        return true;
                    }
                }
                if ((tc = (short)(u >>> 0)) >= 0 && ac + pc > 1) {
                    nc = c - 0x1000000000000L & 0xFFFF000000000000L | c & 0xFFFFFFFFFFFFL;
                    if (!UNSAFE.compareAndSwapLong(this, ctlOffset, c, nc)) continue;
                    return true;
                }
                if (tc + pc >= Short.MAX_VALUE || !UNSAFE.compareAndSwapLong(this, ctlOffset, c, nc = c + 0x100000000L & 0xFFFF00000000L | c & 0xFFFF0000FFFFFFFFL)) continue;
                this.addWorker();
                return true;
            } while (!UNSAFE.compareAndSwapInt(this, blockedCountOffset, b = this.blockedCount, b - 1));
        }
        return false;
    }

    private void postBlock() {
        int b;
        long c;
        while (!UNSAFE.compareAndSwapLong(this, ctlOffset, c = this.ctl, c + 0x1000000000000L)) {
        }
        while (!UNSAFE.compareAndSwapInt(this, blockedCountOffset, b = this.blockedCount, b - 1)) {
        }
    }

    final void tryAwaitJoin(ForkJoinTask<?> joinMe) {
        Thread.interrupted();
        if (joinMe.status >= 0) {
            if (this.tryPreBlock()) {
                joinMe.tryAwaitDone(0L);
                this.postBlock();
            } else if ((this.ctl & 0x80000000L) != 0L) {
                joinMe.cancelIgnoringExceptions();
            }
        }
    }

    final void timedAwaitJoin(ForkJoinTask<?> joinMe, long nanos) {
        while (joinMe.status >= 0) {
            long millis;
            Thread.interrupted();
            if ((this.ctl & 0x80000000L) != 0L) {
                joinMe.cancelIgnoringExceptions();
                break;
            }
            if (!this.tryPreBlock()) continue;
            long last = System.nanoTime();
            while (joinMe.status >= 0 && (millis = TimeUnit.NANOSECONDS.toMillis(nanos)) > 0L) {
                joinMe.tryAwaitDone(millis);
                if (joinMe.status < 0) break;
                if ((this.ctl & 0x80000000L) != 0L) {
                    joinMe.cancelIgnoringExceptions();
                    break;
                }
                long now = System.nanoTime();
                nanos -= now - last;
                last = now;
            }
            this.postBlock();
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void awaitBlocker(ManagedBlocker blocker) throws InterruptedException {
        while (!blocker.isReleasable()) {
            if (!this.tryPreBlock()) continue;
            try {
                while (!blocker.isReleasable() && !blocker.block()) {
                }
                break;
            }
            finally {
                this.postBlock();
            }
        }
    }

    private void addWorker() {
        Throwable ex = null;
        ForkJoinWorkerThread t = null;
        try {
            t = this.factory.newThread(this);
        }
        catch (Throwable e) {
            ex = e;
        }
        if (t == null) {
            long c;
            while (!UNSAFE.compareAndSwapLong(this, ctlOffset, c = this.ctl, c - 0x1000000000000L & 0xFFFF000000000000L | c - 0x100000000L & 0xFFFF00000000L | c & 0xFFFFFFFFL)) {
            }
            if (!this.tryTerminate(false) && ex != null && !(Thread.currentThread() instanceof ForkJoinWorkerThread)) {
                UNSAFE.throwException(ex);
            }
        } else {
            t.start();
        }
    }

    final String nextWorkerName() {
        int n;
        do {
            n = this.nextWorkerNumber;
        } while (!UNSAFE.compareAndSwapInt(this, nextWorkerNumberOffset, n, ++n));
        return this.workerNamePrefix + n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    final int registerWorker(ForkJoinWorkerThread w) {
        block3: while (true) {
            if (((g = this.scanGuard) & 65536) == 0 && ForkJoinPool.UNSAFE.compareAndSwapInt(this, ForkJoinPool.scanGuardOffset, g, g | 65536)) {
                k = this.nextWorkerIndex;
                try {
                    ws = this.workers;
                    if (this.workers != null) {
                        n = ws.length;
                        if (k < 0 || k >= n || ws[k] != null) {
                            for (k = 0; k < n && ws[k] != null; ++k) {
                            }
                            if (k == n) {
                                ws = this.workers = Arrays.copyOf(ws, n << 1);
                            }
                        }
                        ws[k] = w;
                        this.nextWorkerIndex = k + 1;
                        m = g & 65535;
                        g = k > m ? (m << 1) + 1 & 65535 : g + 131072;
                    }
                }
                finally {
                    this.scanGuard = g;
                }
                return k;
            }
            ws = this.workers;
            if (this.workers == null) continue;
            arr$ = ws;
            len$ = arr$.length;
            i$ = 0;
            while (true) {
                if (!(i$ >= len$ || (u = arr$[i$]) != null && u.queueBase != u.queueTop && this.tryReleaseWaiter())) ** break;
                continue block3;
                ++i$;
            }
            break;
        }
    }

    final void deregisterWorker(ForkJoinWorkerThread w, Throwable ex) {
        int idx = w.poolIndex;
        int sc = w.stealCount;
        int steps = 0;
        do {
            long s;
            long c;
            int g;
            if (steps == 0 && ((g = this.scanGuard) & 0x10000) == 0 && UNSAFE.compareAndSwapInt(this, scanGuardOffset, g, g |= 0x10000)) {
                ForkJoinWorkerThread[] ws = this.workers;
                if (ws != null && idx >= 0 && idx < ws.length && ws[idx] == w) {
                    ws[idx] = null;
                }
                this.nextWorkerIndex = idx;
                this.scanGuard = g + 65536;
                steps = 1;
            }
            if (steps == 1 && UNSAFE.compareAndSwapLong(this, ctlOffset, c = this.ctl, c - 0x1000000000000L & 0xFFFF000000000000L | c - 0x100000000L & 0xFFFF00000000L | c & 0xFFFFFFFFL)) {
                steps = 2;
            }
            if (sc == 0 || !UNSAFE.compareAndSwapLong(this, stealCountOffset, s = this.stealCount, s + (long)sc)) continue;
            sc = 0;
        } while (steps != 2 || sc != 0);
        if (!this.tryTerminate(false)) {
            if (ex != null) {
                this.signalWork();
            } else {
                this.tryReleaseWaiter();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryTerminate(boolean now) {
        long c;
        while (((c = this.ctl) & 0x80000000L) == 0L) {
            if (!now) {
                if ((int)(c >> 48) != -this.parallelism) {
                    return false;
                }
                if (!this.shutdown || this.blockedCount != 0 || this.quiescerCount != 0 || this.queueBase != this.queueTop) {
                    if (this.ctl != c) continue;
                    return false;
                }
            }
            if (!UNSAFE.compareAndSwapLong(this, ctlOffset, c, c | 0x80000000L)) continue;
            this.startTerminating();
        }
        if ((short)(c >>> 32) == -this.parallelism) {
            ReentrantLock lock = this.submissionLock;
            lock.lock();
            try {
                this.termination.signalAll();
            }
            finally {
                lock.unlock();
            }
        }
        return true;
    }

    private void startTerminating() {
        this.cancelSubmissions();
        for (int pass = 0; pass < 3; ++pass) {
            ForkJoinWorkerThread[] ws = this.workers;
            if (ws == null) continue;
            for (ForkJoinWorkerThread w : ws) {
                if (w == null) continue;
                w.terminate = true;
                if (pass <= 0) continue;
                w.cancelTasks();
                if (pass <= 1 || w.isInterrupted()) continue;
                try {
                    w.interrupt();
                }
                catch (SecurityException ignore) {
                    // empty catch block
                }
            }
            this.terminateWaiters();
        }
    }

    private void cancelSubmissions() {
        while (this.queueBase != this.queueTop) {
            ForkJoinTask<?> task = this.pollSubmission();
            if (task == null) continue;
            try {
                task.cancel(false);
            }
            catch (Throwable throwable) {}
        }
    }

    private void terminateWaiters() {
        ForkJoinWorkerThread[] ws = this.workers;
        if (ws != null) {
            ForkJoinWorkerThread w;
            long c;
            int e;
            int i;
            int n = ws.length;
            while ((i = ~(e = (int)(c = this.ctl)) & 0xFFFF) < n && (w = ws[i]) != null && w.eventCount == (e & Integer.MAX_VALUE)) {
                if (!UNSAFE.compareAndSwapLong(this, ctlOffset, c, (long)(w.nextWait & Integer.MAX_VALUE) | c + 0x1000000000000L & 0xFFFF000000000000L | c & 0xFFFF80000000L)) continue;
                w.terminate = true;
                w.eventCount = e + 65536;
                if (!w.parked) continue;
                UNSAFE.unpark(w);
            }
        }
    }

    final void addQuiescerCount(int delta) {
        int c;
        while (!UNSAFE.compareAndSwapInt(this, quiescerCountOffset, c = this.quiescerCount, c + delta)) {
        }
    }

    final void addActiveCount(int delta) {
        long c;
        long d;
        long l = d = delta < 0 ? -281474976710656L : 0x1000000000000L;
        while (!UNSAFE.compareAndSwapLong(this, ctlOffset, c = this.ctl, c + d & 0xFFFF000000000000L | c & 0xFFFFFFFFFFFFL)) {
        }
    }

    final int idlePerActive() {
        int p = this.parallelism;
        int a = p + (int)(this.ctl >> 48);
        return a > (p >>>= 1) ? 0 : (a > (p >>>= 1) ? 1 : (a > (p >>>= 1) ? 2 : (a > (p >>>= 1) ? 4 : 8)));
    }

    public ForkJoinPool() {
        this(Runtime.getRuntime().availableProcessors(), defaultForkJoinWorkerThreadFactory, null, false);
    }

    public ForkJoinPool(int parallelism) {
        this(parallelism, defaultForkJoinWorkerThreadFactory, null, false);
    }

    public ForkJoinPool(int parallelism, ForkJoinWorkerThreadFactory factory, Thread.UncaughtExceptionHandler handler, boolean asyncMode) {
        ForkJoinPool.checkPermission();
        if (factory == null) {
            throw new NullPointerException();
        }
        if (parallelism <= 0 || parallelism > Short.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        this.parallelism = parallelism;
        this.factory = factory;
        this.ueh = handler;
        this.locallyFifo = asyncMode;
        long np = -parallelism;
        this.ctl = np << 48 & 0xFFFF000000000000L | np << 32 & 0xFFFF00000000L;
        this.submissionQueue = new ForkJoinTask[8];
        int n = parallelism << 1;
        if (n >= Short.MAX_VALUE) {
            n = Short.MAX_VALUE;
        } else {
            n |= n >>> 1;
            n |= n >>> 2;
            n |= n >>> 4;
            n |= n >>> 8;
        }
        this.workers = new ForkJoinWorkerThread[n + 1];
        this.submissionLock = new ReentrantLock();
        this.termination = this.submissionLock.newCondition();
        StringBuilder sb = new StringBuilder("ForkJoinPool-");
        sb.append(poolNumberGenerator.incrementAndGet());
        sb.append("-worker-");
        this.workerNamePrefix = sb.toString();
    }

    public <T> T invoke(ForkJoinTask<T> task) {
        Thread t = Thread.currentThread();
        if (task == null) {
            throw new NullPointerException();
        }
        if (this.shutdown) {
            throw new RejectedExecutionException();
        }
        if (t instanceof ForkJoinWorkerThread && ((ForkJoinWorkerThread)t).pool == this) {
            return task.invoke();
        }
        this.addSubmission(task);
        return task.join();
    }

    /*
     * Enabled aggressive block sorting
     */
    private <T> void forkOrSubmit(ForkJoinTask<T> task) {
        Thread t = Thread.currentThread();
        if (this.shutdown) {
            throw new RejectedExecutionException();
        }
        if (t instanceof ForkJoinWorkerThread) {
            ForkJoinWorkerThread w = (ForkJoinWorkerThread)t;
            if (w.pool == this) {
                w.pushTask(task);
                return;
            }
        }
        this.addSubmission(task);
    }

    public void execute(ForkJoinTask<?> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        this.forkOrSubmit(task);
    }

    @Override
    public void execute(Runnable task) {
        if (task == null) {
            throw new NullPointerException();
        }
        ForkJoinTask<Object> job = task instanceof ForkJoinTask ? (ForkJoinTask<Object>)((Object)task) : ForkJoinTask.adapt(task, null);
        this.forkOrSubmit(job);
    }

    public <T> ForkJoinTask<T> submit(ForkJoinTask<T> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        this.forkOrSubmit(task);
        return task;
    }

    public <T> ForkJoinTask<T> submit(Callable<T> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        ForkJoinTask<T> job = ForkJoinTask.adapt(task);
        this.forkOrSubmit(job);
        return job;
    }

    public <T> ForkJoinTask<T> submit(Runnable task, T result) {
        if (task == null) {
            throw new NullPointerException();
        }
        ForkJoinTask<T> job = ForkJoinTask.adapt(task, result);
        this.forkOrSubmit(job);
        return job;
    }

    public ForkJoinTask<?> submit(Runnable task) {
        if (task == null) {
            throw new NullPointerException();
        }
        ForkJoinTask<Object> job = task instanceof ForkJoinTask ? (ForkJoinTask<Object>)((Object)task) : ForkJoinTask.adapt(task, null);
        this.forkOrSubmit(job);
        return job;
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) {
        ArrayList<Future<T>> forkJoinTasks = new ArrayList<Future<T>>(tasks.size());
        for (Callable<T> task : tasks) {
            forkJoinTasks.add(ForkJoinTask.adapt(task));
        }
        this.invoke(new InvokeAll(forkJoinTasks));
        ArrayList<Future<T>> futures = forkJoinTasks;
        return futures;
    }

    public ForkJoinWorkerThreadFactory getFactory() {
        return this.factory;
    }

    public Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.ueh;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public int getPoolSize() {
        return this.parallelism + (short)(this.ctl >>> 32);
    }

    public boolean getAsyncMode() {
        return this.locallyFifo;
    }

    public int getRunningThreadCount() {
        int r = this.parallelism + (int)(this.ctl >> 48);
        return r <= 0 ? 0 : r;
    }

    public int getActiveThreadCount() {
        int r = this.parallelism + (int)(this.ctl >> 48) + this.blockedCount;
        return r <= 0 ? 0 : r;
    }

    public boolean isQuiescent() {
        return this.parallelism + (int)(this.ctl >> 48) + this.blockedCount == 0;
    }

    public long getStealCount() {
        return this.stealCount;
    }

    public long getQueuedTaskCount() {
        long count = 0L;
        if ((short)(this.ctl >>> 32) > -this.parallelism) {
            ForkJoinWorkerThread[] ws = this.workers;
            if (this.workers != null) {
                for (ForkJoinWorkerThread w : ws) {
                    if (w == null) continue;
                    count -= (long)(w.queueBase - w.queueTop);
                }
            }
        }
        return count;
    }

    public int getQueuedSubmissionCount() {
        return -this.queueBase + this.queueTop;
    }

    public boolean hasQueuedSubmissions() {
        return this.queueBase != this.queueTop;
    }

    protected ForkJoinTask<?> pollSubmission() {
        int b;
        while ((b = this.queueBase) != this.queueTop) {
            int i;
            ForkJoinTask<?>[] q = this.submissionQueue;
            if (this.submissionQueue == null || (i = q.length - 1 & b) < 0) break;
            long u = (long)(i << ASHIFT) + ABASE;
            ForkJoinTask<?> t = q[i];
            if (t == null || this.queueBase != b || !UNSAFE.compareAndSwapObject(q, u, t, null)) continue;
            this.queueBase = b + 1;
            return t;
        }
        return null;
    }

    protected int drainTasksTo(Collection<? super ForkJoinTask<?>> c) {
        int count = 0;
        while (this.queueBase != this.queueTop) {
            ForkJoinTask<?> t = this.pollSubmission();
            if (t == null) continue;
            c.add(t);
            ++count;
        }
        if ((short)(this.ctl >>> 32) > -this.parallelism) {
            ForkJoinWorkerThread[] ws = this.workers;
            if (this.workers != null) {
                for (ForkJoinWorkerThread w : ws) {
                    if (w == null) continue;
                    count += w.drainTasksTo(c);
                }
            }
        }
        return count;
    }

    public String toString() {
        long st = this.getStealCount();
        long qt = this.getQueuedTaskCount();
        long qs = this.getQueuedSubmissionCount();
        int pc = this.parallelism;
        long c = this.ctl;
        int tc = pc + (short)(c >>> 32);
        int rc = pc + (int)(c >> 48);
        if (rc < 0) {
            rc = 0;
        }
        int ac = rc + this.blockedCount;
        String level = (c & 0x80000000L) != 0L ? (tc == 0 ? "Terminated" : "Terminating") : (this.shutdown ? "Shutting down" : "Running");
        return super.toString() + "[" + level + ", parallelism = " + pc + ", size = " + tc + ", active = " + ac + ", running = " + rc + ", steals = " + st + ", tasks = " + qt + ", submissions = " + qs + "]";
    }

    @Override
    public void shutdown() {
        ForkJoinPool.checkPermission();
        this.shutdown = true;
        this.tryTerminate(false);
    }

    @Override
    public List<Runnable> shutdownNow() {
        ForkJoinPool.checkPermission();
        this.shutdown = true;
        this.tryTerminate(true);
        return Collections.emptyList();
    }

    @Override
    public boolean isTerminated() {
        long c = this.ctl;
        return (c & 0x80000000L) != 0L && (short)(c >>> 32) == -this.parallelism;
    }

    public boolean isTerminating() {
        long c = this.ctl;
        return (c & 0x80000000L) != 0L && (short)(c >>> 32) != -this.parallelism;
    }

    final boolean isAtLeastTerminating() {
        return (this.ctl & 0x80000000L) != 0L;
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        ReentrantLock lock = this.submissionLock;
        lock.lock();
        try {
            while (true) {
                if (this.isTerminated()) {
                    boolean bl = true;
                    return bl;
                }
                if (nanos <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                nanos = this.termination.awaitNanos(nanos);
            }
        }
        finally {
            lock.unlock();
        }
    }

    public static void managedBlock(ManagedBlocker blocker) throws InterruptedException {
        Thread t = Thread.currentThread();
        if (t instanceof ForkJoinWorkerThread) {
            ForkJoinWorkerThread w = (ForkJoinWorkerThread)t;
            w.pool.awaitBlocker(blocker);
        } else {
            while (!blocker.isReleasable() && !blocker.block()) {
            }
        }
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        return (RunnableFuture)((Object)ForkJoinTask.adapt(runnable, value));
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return (RunnableFuture)((Object)ForkJoinTask.adapt(callable));
    }

    static {
        int s;
        poolNumberGenerator = new AtomicInteger();
        workerSeedGenerator = new Random();
        modifyThreadPermission = new RuntimePermission("modifyThread");
        defaultForkJoinWorkerThreadFactory = new DefaultForkJoinWorkerThreadFactory();
        try {
            UNSAFE = Unsafe.getUnsafe();
            Class<ForkJoinPool> k = ForkJoinPool.class;
            ctlOffset = UNSAFE.objectFieldOffset(k.getDeclaredField("ctl"));
            stealCountOffset = UNSAFE.objectFieldOffset(k.getDeclaredField("stealCount"));
            blockedCountOffset = UNSAFE.objectFieldOffset(k.getDeclaredField("blockedCount"));
            quiescerCountOffset = UNSAFE.objectFieldOffset(k.getDeclaredField("quiescerCount"));
            scanGuardOffset = UNSAFE.objectFieldOffset(k.getDeclaredField("scanGuard"));
            nextWorkerNumberOffset = UNSAFE.objectFieldOffset(k.getDeclaredField("nextWorkerNumber"));
            Class<ForkJoinTask[]> a = ForkJoinTask[].class;
            ABASE = UNSAFE.arrayBaseOffset(a);
            s = UNSAFE.arrayIndexScale(a);
        }
        catch (Exception e) {
            throw new Error(e);
        }
        if ((s & s - 1) != 0) {
            throw new Error("data type scale not a power of two");
        }
        ASHIFT = 31 - Integer.numberOfLeadingZeros(s);
    }

    public static interface ManagedBlocker {
        public boolean block() throws InterruptedException;

        public boolean isReleasable();
    }

    static final class InvokeAll<T>
    extends RecursiveAction {
        final ArrayList<ForkJoinTask<T>> tasks;
        private static final long serialVersionUID = -7914297376763021607L;

        InvokeAll(ArrayList<ForkJoinTask<T>> tasks) {
            this.tasks = tasks;
        }

        @Override
        public void compute() {
            try {
                InvokeAll.invokeAll(this.tasks);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static class DefaultForkJoinWorkerThreadFactory
    implements ForkJoinWorkerThreadFactory {
        DefaultForkJoinWorkerThreadFactory() {
        }

        @Override
        public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
            return new ForkJoinWorkerThread(pool);
        }
    }

    public static interface ForkJoinWorkerThreadFactory {
        public ForkJoinWorkerThread newThread(ForkJoinPool var1);
    }
}

