/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.Serializable;
import java.security.Certificate;
import java.security.IdentityScope;
import java.security.Key;
import java.security.KeyManagementException;
import java.security.Principal;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Vector;

@Deprecated
public abstract class Identity
implements Principal,
Serializable {
    private static final long serialVersionUID = 3609922007826600659L;
    private String name;
    private PublicKey publicKey;
    String info = "No further information available.";
    IdentityScope scope;
    Vector<Certificate> certificates;

    protected Identity() {
        this("restoring...");
    }

    public Identity(String name, IdentityScope scope) throws KeyManagementException {
        this(name);
        if (scope != null) {
            scope.addIdentity(this);
        }
        this.scope = scope;
    }

    public Identity(String name) {
        this.name = name;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public final IdentityScope getScope() {
        return this.scope;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(PublicKey key) throws KeyManagementException {
        Identity.check("setIdentityPublicKey");
        this.publicKey = key;
        this.certificates = new Vector();
    }

    public void setInfo(String info) {
        Identity.check("setIdentityInfo");
        this.info = info;
    }

    public String getInfo() {
        return this.info;
    }

    public void addCertificate(Certificate certificate) throws KeyManagementException {
        Identity.check("addIdentityCertificate");
        if (this.certificates == null) {
            this.certificates = new Vector();
        }
        if (this.publicKey != null) {
            if (!this.keyEquals(this.publicKey, certificate.getPublicKey())) {
                throw new KeyManagementException("public key different from cert public key");
            }
        } else {
            this.publicKey = certificate.getPublicKey();
        }
        this.certificates.addElement(certificate);
    }

    private boolean keyEquals(Key aKey, Key anotherKey) {
        String anotherKeyFormat;
        String aKeyFormat = aKey.getFormat();
        if (aKeyFormat == null ^ (anotherKeyFormat = anotherKey.getFormat()) == null) {
            return false;
        }
        if (aKeyFormat != null && anotherKeyFormat != null && !aKeyFormat.equalsIgnoreCase(anotherKeyFormat)) {
            return false;
        }
        return Arrays.equals(aKey.getEncoded(), anotherKey.getEncoded());
    }

    public void removeCertificate(Certificate certificate) throws KeyManagementException {
        Identity.check("removeIdentityCertificate");
        if (this.certificates != null) {
            this.certificates.removeElement(certificate);
        }
    }

    public Certificate[] certificates() {
        if (this.certificates == null) {
            return new Certificate[0];
        }
        int len = this.certificates.size();
        Object[] certs = new Certificate[len];
        this.certificates.copyInto(certs);
        return certs;
    }

    @Override
    public final boolean equals(Object identity) {
        if (identity == this) {
            return true;
        }
        if (identity instanceof Identity) {
            Identity i = (Identity)identity;
            if (this.fullName().equals(i.fullName())) {
                return true;
            }
            return this.identityEquals(i);
        }
        return false;
    }

    protected boolean identityEquals(Identity identity) {
        if (!this.name.equalsIgnoreCase(identity.name)) {
            return false;
        }
        if (this.publicKey == null ^ identity.publicKey == null) {
            return false;
        }
        return this.publicKey == null || identity.publicKey == null || this.publicKey.equals(identity.publicKey);
    }

    String fullName() {
        String parsable = this.name;
        if (this.scope != null) {
            parsable = parsable + "." + this.scope.getName();
        }
        return parsable;
    }

    @Override
    public String toString() {
        Identity.check("printIdentity");
        String printable = this.name;
        if (this.scope != null) {
            printable = printable + "[" + this.scope.getName() + "]";
        }
        return printable;
    }

    public String toString(boolean detailed) {
        String out = this.toString();
        if (detailed) {
            out = out + "\n";
            out = out + this.printKeys();
            out = out + "\n" + this.printCertificates();
            out = this.info != null ? out + "\n\t" + this.info : out + "\n\tno additional information available.";
        }
        return out;
    }

    String printKeys() {
        String key = "";
        key = this.publicKey != null ? "\tpublic key initialized" : "\tno public key";
        return key;
    }

    String printCertificates() {
        String out = "";
        if (this.certificates == null) {
            return "\tno certificates";
        }
        out = out + "\tcertificates: \n";
        int i = 1;
        for (Certificate cert : this.certificates) {
            out = out + "\tcertificate " + i++ + "\tfor  : " + cert.getPrincipal() + "\n";
            out = out + "\t\t\tfrom : " + cert.getGuarantor() + "\n";
        }
        return out;
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }

    private static void check(String directive) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkSecurityAccess(directive);
        }
    }
}

